<?php
namespace App\Validation;
use App\Libraries\Upload;


class CustomRules{

  // Rule is to validate mobile number digits
  public function mobileValidation(string $str, string $fields, array $data){
    
    /*Checking: Number must start from 5-9{Rest Numbers}*/
    if(preg_match( '/^[5-9]{1}[0-9]+/', $data['mobile'])){
      
      /*Checking: Mobile number must be of 10 digits*/
      $bool = preg_match('/^[0-9]{10}+$/', $data['mobile']);
      return $bool == 0 ? false : true; 
      
    }else{
      
      return false;
    }
  }



  public function checkmail_forgot($str)
  {
     
     $this->db = db_connect();
     $this->session = session();
     $this->form_validation =  \Config\Services::validation();

    $this->builder = $this->db->table('uusers');
    $this->builder->select('*');
    $this->builder->where('email',$str);
    $query = $this->builder->get();


    if ($query->getNumRows()>0) {
      return true;
    } else {
      $this->form_validation->setError('checkmail', lang('language_lang.forgot_email_error'));
            return false;
      
    }
    
  }

  public function checkusername_forgot($str)
  {
     
     $this->db = db_connect();
     $this->session = session();
     $this->form_validation =  \Config\Services::validation();

    $this->builder = $this->db->table('uusers');
    $this->builder->select('*');
    $this->builder->where('email',$str);
    $query = $this->builder->get();


    if ($query->getNumRows()>0) {
      return true;
    } else {
      $this->form_validation->setError('checkusername', lang('language_lang.forgot_email_error'));
            return false;
      
    }
    
  }

  public function edit_unique_username($str,$id)
  {
    $this->db = db_connect();
    $this->form_validation = \Config\Services::validation();
    $builder = $this->db->table('admin');
    $builder->select('username');
    $builder->where('id !='.$id);
    $builder->where('username',$str);

    $query = $builder->get();
    if ($query->getNumRows()>0) {
      $this->form_validation->setMessage('username', '<p><em class="text-danger">'.lang('language_lang.sub_admin_username_invalid').'</em></p>');
      return false;
    } else {
      return true;
    }
    
  }
  /* validate email value */
  public function edit_unique_email($str,$id)
  {
    $this->db = db_connect();
    $this->form_validation = \Config\Services::validation();
    $builder = $this->db->table('admin');
    $builder->select('email');
    $builder->where('id !='.$id);
    $builder->where('email',$str);

    $query = $builder->get();
    if ($query->getNumRows()>0) {
      $this->form_validation->setMessage('email', '<p><em class="text-danger">'.lang('language_lang.user_emailid_invalid').'</em></p>');
      return false;
    } else {
      return true;
    }
    
  }
  public function checkmail($str)
  {
    $this->db = db_connect();
    $this->form_validation = \Config\Services::validation();
    $builder = $this->db->table('uusers');
    $builder->select('email');
    //$builder->from('uusers');
    $builder->where('email',$str);
    $query = $builder->get();

    if ($query->getNumRows()>0) {
    return true;
    } else {
    $this->form_validation->setMessage('checkmail', lang('language_lang.forgot_email_error'));
    return false;

    }
  }

  


  public function edit_uniques($str,$ipid)
  {
    $builder = $this->db->table('ip_controls');

    $builder->select('ip_address');
    $builder->where('ip_id !='.$ipid);
    $builder->where('ip_address',$str);

    $query = $builder->get();
    if ($query->getNumRows()>0) {
      $validation->setMessage('username', '<label class="validation-error-label">This invalid details of %s</label>');
      return false;
    }
    else{
      return true;
    }
  }

  function edit_uniques_user($str,$uusersid)
  {
    $this->db = db_connect();
    // echo $uusersid;exit;
    $builder = $this->db->table('uusers');

    $builder->select('username');
    $builder->where('uusersid !='.$uusersid);
    $builder->where('username',$str);

    $query = $builder->get();
    // echo $this->db->last_query();
    if ($query->getNumRows()>0) {
      $validation->setMessage('username', '<label class="validation-error-label">This invalid details of %s</label>');
      return false;
    }
    else{
      return true;
    }
  }

  function edit_uniques_email($str,$uusersid)
  {
    $builder =  $this->db->table('uusers');
  
    $builder->select('email');
    $builder->where('uusersid !='.$uusersid);
    $builder->where('email',$str);

    $query = $builder->get();
    if ($query->getNumRows()>0) {
    // $validation->setMessage('edit_uniques_email', '<label class="validation-error-label">This invalid details of %s</label>');
     $validation->set_message('edit_uniques_email', '<label class="validation-error-label">This invalid details of %s</label>');
      return false;
    }
    else{
      return true;
    }
  }
  public function username_check($str)
  {
    $validation =  \Config\Services::validation();
    $this->db = db_connect();
    $builder = $this->db->table('admin');
    $builder->select('username');
    $builder->where('username',$str);
    $query = $builder->get();
    if ($query->getNumRows()>0)
      return true;
    else
    {
      $validator->set_message('username_check', '<label class="validation-error-label">This invalid details of %s</label>');
      return false;
    }
  }

  function min_check($str, $max){
$validation = \Config\Services::validation();
    $currency_info = defaultcurrency();
    if(preg_match("/^[0-9.]+$/", $str)) {
      if($str < $max) {
        return true;
      } else {
        $validation->setMessage('min_check', '<p><em class="text-danger">'.lang("language_lang.withdraw_min_amnt_lessthan").'</em></p>');
        return false;
      }
    } else {
      $validation->setMessage('min_check', '<p><em class="text-danger">'.lang("language_lang.amount_check").'</em></p>');
      return false;
    }
  }

  function max_check($str, $min){
$validation = \Config\Services::validation();


    $currency_info = defaultcurrency();
    if(preg_match("/^[0-9.]+$/", $str)) {
      if($str > $min) {
        return true;
      } else {
        $validation->setMessage('max_check', '<p><em class="text-danger">'.lang("language_lang.withdraw_max_amnt_graterthan").'</em></p>');
        return false;
      }
    } else {
      $validation->setMessage('max_check', '<p><em class="text-danger">'.lang("language_lang.amount_check").'</em></p>');
      return false;
    }
  }
  
  function amount_check($str)
  {
$validation = \Config\Services::validation();

    $currency_info = defaultcurrency();
    if(preg_match("/^[0-9.]+$/", $str)) {
      return true;
    } else {
      $validation->setMessage('amount_check', '<p><em class="text-danger">'.lang("language_lang.amount_check").'</em></p>');
      return false;
    }
  }

//   public function validate_image($str)
//   {

//     $config['upload_path'] = './content/profile/';
//     $config['allowed_types'] = 'gif|jpg|png|jpeg';
//     $config['max_width']  = '250';
//         $config['max_height']  = '250';
//     $config['encrypt_name'] = TRUE;
//     // $this->load->library('upload', $config);
//     $this->upload = new CI_Upload($config);
//     if (!$this->upload->do_upload('profile_pic')) {
//       echo"<pre>";
//       print_r($this->upload->do_upload('profile_pic'));
//       echo"</pre>";
//       die;
// $validation =  \Config\Services::validation();

//       $validation->setError('validate_image', '<p><em class="text-danger">'.$this->upload->display_errors().'</em></p>');
//       return false;
//     } else {
//       echo"<pre>";
//       print_r("bye");
//       echo"</pre>";
//       die;
//       return true;
//     }
    
//   }
}