<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		helper('form');

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
		<div class="page-header">
			<div class="page-header-content">
				<div class="page-title">
					<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.login_page_title'); ?></span></h4>

				
					<ul class="breadcrumb breadcrumb-caret position-right">
						<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
						    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
						<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
					</ul>
				</div>
				<?php echo view('admin/'.$module_name.'_header'); ?>
				<!-- <div class="heading-elements">
					<div class="heading-btn-group">
						<a href="#" class="btn btn-link btn-float has-text"><i class="icon-bars-alt text-primary"></i><span>Statistics</span></a>
						<a href="#" class="btn btn-link btn-float has-text"><i class="icon-calculator text-primary"></i> <span>Invoices</span></a>
						<a href="#" class="btn btn-link btn-float has-text"><i class="icon-calendar5 text-primary"></i> <span>Schedule</span></a>
					</div>
				</div> -->
			</div>
		</div>	
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.login_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>

					<div class="panel-body">
						<form class="form-horizontal form-login" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
							<?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>

								<div class="form-group ">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Allow_user_login'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="log_allow_user" <?php if($log_allow_user==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>
								<div class="form-group ">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Allow_user_registration'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="log_reg_allow_user" <?php if($log_reg_allow_user==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>
								<div class="form-group " style="display:none;">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Allow_captcha_code'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="log_captcha_status" <?php if($log_captcha_status==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>

								<div class="form-group " style="display:none;">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Transaction_pin_for_login'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="log_transaction_pin" <?php if($log_transaction_pin==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>


								<div class="form-group " style="display:none;">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.account_activate_mailoption'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="log_account_activation" <?php if($log_account_activation==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>
								<div class="form-group" style="display:none;">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Email_confirmation_code'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="log_email_verify" <?php if($log_email_verify==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>
                            
		                        <div class="form-group  has-feedback <?php if($validation->getError('log_auth_limit')) echo "has-error";?>" >
									<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_authentication_limit'); ?>  <span class="text-danger">*</span></label>
								    <div class="col-lg-3">
									    <div style="width:100%;" class="input-group">
										    <input type="text" name="log_auth_limit" class="form-control"  placeholder="<?php echo lang('language_lang.plac_login_auth_limit'); ?>" value="<?php echo set_value('log_auth_limit',isset($this->data['log_auth_limit']) ? $this->data['log_auth_limit'] : ''); ?>">
									    </div>
									    <?php echo $validation->getError('log_auth_limit', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								    </div>
								</div>

								  <div class="form-group  has-feedback <?php if($validation->getError('factor_title')) echo "has-error";?>" style="display:none;">
									<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_two_title'); ?>  <span class="text-danger">*</span></label>
								    <div class="col-lg-3">
									    <div style="width:100%;" class="input-group">
										    <input type="text" name="factor_title" class="form-control"  value="<?php echo set_value('factor_title',isset($this->data['factor_title']) ? $this->data['factor_title'] : ''); ?>">
									    </div>
									    <?php echo $validation->getError('factor_title', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								    </div>
								</div>

								 <div class="form-group  has-feedback <?php if($validation->getError('factor_website')) echo "has-error";?>" style="display:none;" >
									<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_two_Website'); ?>  <span class="text-danger">*</span></label>
								    <div class="col-lg-3">
									    <div style="width:100%;" class="input-group">
										    <input type="text" name="factor_website" class="form-control"  value="<?php echo set_value('factor_website',isset($this->data['factor_website']) ? $this->data['factor_website'] : ''); ?>">
									    </div>
									    <?php echo $validation->getError('factor_website', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								    </div>
								</div>

								<div class="text-right col-lg-6">
									<button style=" padding-right: 14px;" type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
								</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">

	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.form-login').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            // valid: 'glyphicon glyphicon-ok',
		            // invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            log_auth_limit: {
		                message: '<?php echo lang("language_lang.login_auth_validate"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.login_auth_limit"); ?>'
		                    },
		                    digits: {
 		                        message: '<?php echo lang("language_lang.login_auth_consist"); ?>'
		                    }
		                    // ,
		                    // regexp: {
		                    //     regexp: /^[1-9][0-9]{0,1}$/,
		                    //     message: '<?php echo lang("language_lang.login_auth_limit_exceed"); ?>'
		                    // }
		                }
		            }
		            
		            
		        }
		    })
		});
	    $('#icon-bck').on('click',function() {
			window.history.back();
		});
	    
	    $(".switch").bootstrapSwitch();

	});
	})(jQuery);


	
	</script>

</body>
</html>
