import { HttpProvider } from './lib/providers/index.js';
import type { Providers } from './lib/providers/index.js';
import utils from './utils/index.js';
import { BigNumber } from 'bignumber.js';
import EventEmitter from 'eventemitter3';
import { TransactionBuilder } from './lib/TransactionBuilder/TransactionBuilder.js';
import { Trx } from './lib/trx.js';
import { Contract } from './lib/contract/index.js';
import { Plugin } from './lib/plugin.js';
import { Event } from './lib/event.js';
import { DefaultAddress, NodeProvider, TronWebOptions, IBigNumber } from './types/TronWeb.js';
import { ContractAbiInterface } from './types/ABI.js';
import { Address } from './types/Trx.js';
export declare class TronWeb extends EventEmitter {
    providers: Providers;
    BigNumber: typeof BigNumber;
    transactionBuilder: TransactionBuilder;
    trx: Trx;
    plugin: Plugin;
    event: Event;
    version: typeof TronWeb.version;
    static version: string;
    utils: typeof utils;
    defaultBlock: number | false | 'earliest' | 'latest';
    defaultPrivateKey: string | false;
    defaultAddress: DefaultAddress;
    fullnodeVersion: string;
    feeLimit: number;
    fullNode: HttpProvider;
    solidityNode: HttpProvider;
    eventServer?: HttpProvider;
    constructor(options: TronWebOptions);
    constructor(fullNode: NodeProvider, solidityNode: NodeProvider, eventServer?: NodeProvider, privateKey?: string);
    constructor(fullNode: NodeProvider, solidityNode: NodeProvider, eventServer: NodeProvider, privateKey?: string);
    getFullnodeVersion(): Promise<void>;
    setDefaultBlock(blockID?: false | 'latest' | 'earliest' | number): number | false | "earliest" | "latest";
    setPrivateKey(privateKey: string): void;
    setAddress(address: string): void;
    fullnodeSatisfies(version: string): boolean;
    isValidProvider(provider: unknown): boolean;
    setFullNode(fullNode: HttpProvider | string): void;
    setSolidityNode(solidityNode: HttpProvider | string): void;
    setEventServer(eventServer: NodeProvider, healthcheck?: string): void;
    setHeader(headers?: {}): void;
    setFullNodeHeader(headers?: {}): void;
    setEventHeader(headers?: {}): void;
    currentProviders(): {
        fullNode: HttpProvider;
        solidityNode: HttpProvider;
        eventServer: HttpProvider | undefined;
    };
    currentProvider(): {
        fullNode: HttpProvider;
        solidityNode: HttpProvider;
        eventServer: HttpProvider | undefined;
    };
    getEventResult(...params: Parameters<Event['getEventsByContractAddress']>): ReturnType<Event['getEventsByContractAddress']>;
    getEventByTransactionID(...params: Parameters<Event['getEventsByTransactionID']>): ReturnType<Event['getEventsByTransactionID']>;
    contract(abi?: ContractAbiInterface, address?: Address): Contract;
    address: typeof TronWeb.address;
    static get address(): {
        fromHex(address: string): string;
        toHex(address: string): string;
        toChecksumAddress(address: string): string;
        isChecksumAddress(address: string): boolean;
        fromPrivateKey(privateKey: string, strict?: boolean): string | false;
    };
    sha3: typeof TronWeb.sha3;
    static sha3(string: string, prefix?: boolean): string;
    toHex: typeof TronWeb.toHex;
    static toHex(val: string | number | boolean | Record<string | number | symbol, unknown> | unknown[] | IBigNumber): string;
    toUtf8: typeof TronWeb.toUtf8;
    static toUtf8(hex: string): string;
    fromUtf8: typeof TronWeb.fromUtf8;
    static fromUtf8(string: string): string;
    toAscii: typeof TronWeb.toAscii;
    static toAscii(hex: string): string;
    fromAscii: typeof TronWeb.fromAscii;
    static fromAscii(string: string, padding?: number): string;
    toDecimal: typeof TronWeb.toDecimal;
    static toDecimal(value: string | number | IBigNumber): number;
    fromDecimal: typeof TronWeb.fromDecimal;
    static fromDecimal(value: number | IBigNumber): string;
    fromSun: typeof TronWeb.fromSun;
    static fromSun(sun: number): string | IBigNumber;
    toSun: typeof TronWeb.toSun;
    static toSun(trx: number): string | IBigNumber;
    toBigNumber: typeof TronWeb.toBigNumber;
    static toBigNumber(amount?: string | number | IBigNumber): IBigNumber;
    isAddress: typeof TronWeb.isAddress;
    static isAddress(address?: unknown): boolean;
    createAccount: typeof TronWeb.createAccount;
    static createAccount(): Promise<{
        privateKey: string;
        publicKey: string;
        address: {
            base58: string;
            hex: string;
        };
    }>;
    createRandom: typeof TronWeb.createRandom;
    static createRandom(...params: Parameters<(typeof utils)['accounts']['generateRandom']>): ReturnType<(typeof utils)['accounts']['generateRandom']>;
    fromMnemonic: typeof TronWeb.fromMnemonic;
    static fromMnemonic(...params: Parameters<(typeof utils)['accounts']['generateAccountWithMnemonic']>): ReturnType<(typeof utils)['accounts']['generateAccountWithMnemonic']>;
    isConnected(): Promise<{
        fullNode: boolean | 0;
        solidityNode: boolean | 0;
        eventServer: boolean | 0 | undefined;
    }>;
}
export default TronWeb;
