import * as accounts from './accounts.js';
import * as address from './address.js';
import * as base58 from './base58.js';
import * as bytes from './bytes.js';
import * as crypto from './crypto.js';
import * as code from './code.js';
import * as abi from './abi.js';
import * as message from './message.js';
import * as ethersUtils from './ethersUtils.js';
import { TypedDataEncoder as _TypedDataEncoder } from './typedData.js';
import * as transaction from './transaction.js';
declare const utils: {
    address: typeof address;
    code: typeof code;
    accounts: typeof accounts;
    base58: typeof base58;
    bytes: typeof bytes;
    crypto: typeof crypto;
    abi: typeof abi;
    message: typeof message;
    _TypedDataEncoder: typeof _TypedDataEncoder;
    transaction: typeof transaction;
    ethersUtils: typeof ethersUtils;
    isValidURL(url: string): boolean;
    isObject(obj: unknown): obj is Record<number | string | symbol, unknown>;
    isArray(array: unknown): array is unknown[];
    isJson(string: string): boolean;
    isBoolean(bool: unknown): bool is boolean;
    isBigNumber(number: unknown): number is import("../types/TronWeb.js").IBigNumber;
    isString(string: unknown): string is string;
    isFunction(obj: unknown): obj is (...args: unknown[]) => unknown;
    isHex(string: string): string is string;
    isInteger(number: unknown): number is number;
    hasProperty(obj: object, property: string | number | symbol): boolean;
    hasProperties(obj: object, ...properties: (string | number | symbol)[]): boolean | 0;
    mapEvent(event: import("../types/UtilsTypes.js").EventQueryDataType): import("../types/UtilsTypes.js").MapEventQueryDataType;
    parseEvent(event: import("../types/UtilsTypes.js").EventQueryDataType, { inputs: abi }: {
        inputs: ReadonlyArray<import("../types/ABI.js").AbiParamsCommon>;
    }): import("../types/UtilsTypes.js").EventQueryDataType;
    padLeft(input: string | number, padding: string, amount: number): string;
    isNotNullOrUndefined(val: unknown): boolean;
    sleep(millis?: number): Promise<any>;
};
export default utils;
export * from './accounts.js';
export * from './address.js';
export * from './base58.js';
export * from './bytes.js';
export * from './crypto.js';
export * from './code.js';
export * from './abi.js';
export * from './message.js';
export * from './ethersUtils.js';
export * from './typedData.js';
export * from './transaction.js';
export * from './validations.js';
