import utils from './utils/index.js';
export { utils };
import { BigNumber } from 'bignumber.js';
export { BigNumber };
import { providers } from './lib/providers/index.js';
export { providers };
import { TransactionBuilder } from './lib/TransactionBuilder/TransactionBuilder.js';
export { TransactionBuilder };
import { Trx } from './lib/trx.js';
export { Trx };
import { Contract } from './lib/contract/index.js';
export { Contract };
import { Event } from './lib/event.js';
export { Event };
import { Plugin } from './lib/plugin.js';
export { Plugin };
import { TronWeb } from './tronweb.js';
export { TronWeb };
import * as Types from './types/index.js';
export { Types };
declare const _default: {
    utils: {
        address: typeof import("./utils/address.js");
        code: typeof import("./utils/code.js");
        accounts: typeof import("./utils/accounts.js");
        base58: typeof import("./utils/base58.js");
        bytes: typeof import("./utils/bytes.js");
        crypto: typeof import("./utils/crypto.js");
        abi: typeof import("./utils/abi.js");
        message: typeof import("./utils/message.js");
        _TypedDataEncoder: typeof import("./utils/typedData.js").TypedDataEncoder;
        transaction: typeof import("./utils/transaction.js");
        ethersUtils: typeof import("./utils/ethersUtils.js");
        isValidURL(url: string): boolean;
        isObject(obj: unknown): obj is Record<number | string | symbol, unknown>;
        isArray(array: unknown): array is unknown[];
        isJson(string: string): boolean;
        isBoolean(bool: unknown): bool is boolean;
        isBigNumber(number: unknown): number is Types.IBigNumber;
        isString(string: unknown): string is string;
        isFunction(obj: unknown): obj is (...args: unknown[]) => unknown;
        isHex(string: string): string is string;
        isInteger(number: unknown): number is number;
        hasProperty(obj: object, property: string | number | symbol): boolean;
        hasProperties(obj: object, ...properties: (string | number | symbol)[]): boolean | 0;
        mapEvent(event: Types.EventQueryDataType): Types.MapEventQueryDataType;
        parseEvent(event: Types.EventQueryDataType, { inputs: abi }: {
            inputs: ReadonlyArray<Types.AbiParamsCommon>;
        }): Types.EventQueryDataType;
        padLeft(input: string | number, padding: string, amount: number): string;
        isNotNullOrUndefined(val: unknown): boolean;
        sleep(millis?: number): Promise<any>;
    };
    BigNumber: typeof BigNumber;
    providers: import("./lib/providers/index.js").Providers;
    TransactionBuilder: typeof TransactionBuilder;
    Trx: typeof Trx;
    Contract: typeof Contract;
    Event: typeof Event;
    Plugin: typeof Plugin;
    TronWeb: typeof TronWeb;
    Types: typeof Types;
};
export default _default;
