<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;
use App\Libraries\PHPMailer;
use App\Libraries\Commission;

class History extends BaseController {

	/**
	* 
	* Start 
	* Create Date: 15 July, 2016
	* This controller to manage all transactions.
	* Created saravanan.
	* @see http://zhyip.com/
	* Last Updated: 18 November, 2016
	* End
	* 
	*/

	public function __construct() {
        $this->session = session();
		// admin login only
		if($this->session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');
            $this->finance_model = model('finance_model');
            $this->packages_model = model('packages_model');

			// $this->load->model('finance_model');
			// $this->load->model('packages_model');

			helper('inflector');
			$this->isSubadmin();
			
			
		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}

	}

	private function isSubadmin() {
		$this->router = service('router');
        $this->session = session();
        $this->form_validation = \Config\Services::validation();
		if($this->session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($this->session->get('permission'));
		
			/*if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}*/
		}
	}

	// 
	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

	public function index()
	{
		return redirect()->to('admin');
	}

	public function deposit()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = lang('language_lang.deposit_history_page_title');
		$this->data['type'] = false;
		$this->data['type1'] = "deposit";
		$this->data['module_name'] = 'finance';
		$admin_login=$session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();


		$user_group = $get_admin->user_group;

		$this->data['admin_group']=$user_group;

		if($this->request->getPost())
		{
			$uusersid = $this->request->getPost('user_type');
			$fromdate='';
			$enddate='';
			$flag=0;
			$flag1=0;
			if(!empty($this->request->getPost('start_date')))
			{
				$flag=1;
				$fromdate = date('Y-m-d 00:00:00',strtotime($this->request->getPost('start_date')));
			}
			if(!empty($this->request->getPost('end_date')))
			{
				$flag1=1;
				$enddate = date('Y-m-d 23:59:59',strtotime($this->request->getPost('end_date')));
			}

		
			if($flag=='0' && $flag1=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/deposit');

			}
			else if($flag1=='0' && $flag=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/deposit');

			}
			
			
			$condition = "history.type IN ('deposit', 'reinvest') AND history.is_delete = '0'";
			
			$this->data['fromdate']=$this->request->getPost('start_date');
			
	        $this->data['enddate']=$this->request->getPost('end_date');
	        $this->data['userid']=$this->request->getPost('user_type');
			$this->data['usergroup']=$this->request->getPost('user_group');

			if ($uusersid) 
			{
				$condition .= " AND history.uusersid = '{$uusersid}'";
			}
	
			if ($fromdate && $enddate) {
			$condition .= " AND history.date BETWEEN '{$fromdate}' AND '{$enddate}'";
			} elseif ($fromdate) {
			$condition .= " AND history.date >= '{$fromdate}'";
			} elseif ($enddate) {
			$condition .= " AND history.date <= '{$enddate}'";
			}
			$this->data['history'] = $this->finance_model->GetTransactions($condition);


		}
		else
		{
		    $this->data['userid']='';
		    $this->data['fromdate']='';
		    $this->data['enddate']='';
			$this->data['usergroup']='';
			$condition = "history.type = 'deposit' || history.type = 'reinvest' AND history.is_delete = '0'";
			// $condition = "history.type = 'withdrawal' || history.type = 'withdraw_request'";
			$this->data['history'] = $this->finance_model->GetTransactions($condition);
		}
		echo view('admin/finance/history-deposit',$this->data);
	}
	public function expiredeposit()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = lang('language_lang.exp_deplabel');
		$this->data['type'] = false;
		$this->data['module_name'] = 'finance';
		$condition = "deposit.status = 'matured'";
		$this->data['history'] = $this->finance_model->GetExpiredeposit($condition);
		echo view('admin/finance/expirehistory',$this->data);
	}

	/*public function payouts()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->finance_model = model('finance_model');
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = lang('language_lang.payouts_history_page_title');
		$this->data['type'] = false;
		$this->data['type1'] = "withdrawal";
		$this->data['module_name'] = 'finance';
		$condition = "history.type = 'withdrawal'";
		$this->data['history'] = $this->finance_model->GetTransactions($condition);
		echo view('admin/finance/history',$this->data);
	}*/


	public function payouts()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = "Payout History";
		$this->data['type'] = false;
		$this->data['type1'] = "withdraw";
		$this->data['module_name'] = 'finance';
		$admin_login=$session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();
		$user_group = $get_admin->user_group;
		$this->data['admin_group']=$user_group;
	
		if($this->request->getPost())
		{
			$uusersid = $this->request->getPost('user_type');
			$fromdate='';
			$enddate='';
			$flag=0;
			$flag1=0;
			if(!empty($this->request->getPost('start_date')))
			{
				$flag=1;
				$fromdate = date('Y-m-d 00:00:00',strtotime($this->request->getPost('start_date')));
			}
			if(!empty($this->request->getPost('end_date')))
			{
				$flag1=1;
				$enddate = date('Y-m-d 23:59:59',strtotime($this->request->getPost('end_date')));
			}

		
			if($flag=='0' && $flag1=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/payouts');

			}
			else if($flag1=='0' && $flag=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/payouts');

			}
			
			$condition = "history.type IN ('withdrawal') AND history.is_delete = '0'";
			
			$this->data['fromdate']=$this->request->getPost('start_date');
			
	        $this->data['enddate']=$this->request->getPost('end_date');
	        $this->data['userid']=$this->request->getPost('user_type');
			$this->data['usergroup']=$this->request->getPost('user_group');
			
			if ($uusersid) {
			$condition .= " AND history.uusersid = '{$uusersid}'";
			}
	
			if ($fromdate && $enddate) 
			{
				$condition .= " AND history.date BETWEEN '{$fromdate}' AND '{$enddate}'";
			} 
			elseif ($fromdate) 
			{
				$condition .= " AND history.date >= '{$fromdate}'";
			} 
			elseif ($enddate) 
			{
				$condition .= " AND history.date <= '{$enddate}'";
			}
			$this->data['history'] = $this->finance_model->GetTransactions($condition);


		}
		else
		{
		    $this->data['userid']='';
		    $this->data['fromdate']='';
		    $this->data['enddate']='';
			$this->data['usergroup']='';
			
			$condition = "history.type = 'withdrawal' AND history.is_delete = '0'";
			// $condition = "history.type = 'withdrawal' || history.type = 'withdraw_request'";
			$this->data['history'] = $this->finance_model->GetTransactions($condition);
		}
		echo view('admin/finance/history-payouts',$this->data);
	}


	public function transfer()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = "Fund Transfer History";
		$this->data['type'] = false;
		$this->data['type1'] = "transfer";
		$this->data['module_name'] = 'finance';
		$admin_login=$session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();
		$user_group = $get_admin->user_group;
		$this->data['admin_group']=$user_group;
	
		if($this->request->getPost())
		{
			$uusersid = $this->request->getPost('user_type');
			$fromdate='';
			$enddate='';
			$flag=0;
			$flag1=0;
			if(!empty($this->request->getPost('start_date')))
			{
				$flag=1;
				$fromdate = date('Y-m-d 00:00:00',strtotime($this->request->getPost('start_date')));
			}
			if(!empty($this->request->getPost('end_date')))
			{
				$flag1=1;
				$enddate = date('Y-m-d 23:59:59',strtotime($this->request->getPost('end_date')));
			}

		
			if($flag=='0' && $flag1=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/transfer');

			}
			else if($flag1=='0' && $flag=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/transfer');

			}
			$transfer_type=$this->request->getPost('transfer_type');

			if($transfer_type=='')
				$condition = "history.type IN ('transfer_gaswallet','deducted_gaswallet') AND history.is_delete = '0'";
			else if($transfer_type=='fund_send')
				$condition = "history.type IN ('fund_send') AND history.is_delete = '0'";
			else if($transfer_type=='fund_received')
				$condition = "history.type IN ('fund_received') AND history.is_delete = '0'";
			else if($transfer_type=='transfer_gaswallet')
				$condition = "history.type IN ('transfer_gaswallet') AND history.is_delete = '0'";
			else if($transfer_type=='deducted_gaswallet')
				$condition = "history.type IN ('deducted_gaswallet') AND history.is_delete = '0'";
			
			$this->data['fromdate']=$this->request->getPost('start_date');
			
	        $this->data['enddate']=$this->request->getPost('end_date');
	        $this->data['userid']=$this->request->getPost('user_type');
			$this->data['usergroup']=$this->request->getPost('user_group');
			$this->data['transfer_type']=$this->request->getPost('transfer_type');
		
			
			if ($uusersid) {
			$condition .= " AND history.uusersid = '{$uusersid}'";
			}
	
			if ($fromdate && $enddate) 
			{
				$condition .= " AND history.date BETWEEN '{$fromdate}' AND '{$enddate}'";
			} 
			elseif ($fromdate) 
			{
				$condition .= " AND history.date >= '{$fromdate}'";
			} 
			elseif ($enddate) 
			{
				$condition .= " AND history.date <= '{$enddate}'";
			}
			$this->data['history'] = $this->finance_model->GetTransactions($condition);


		}
		else
		{
		    $this->data['userid']='';
		    $this->data['fromdate']='';
		    $this->data['enddate']='';
			$this->data['usergroup']='';
			$this->data['transfer_type']='';
			//$condition = "history.type = 'withdrawal' AND history.is_delete = '0'";
			$condition = "history.type IN ('transfer_gaswallet','deducted_gaswallet') AND history.is_delete = '0'";
			// $condition = "history.type = 'withdrawal' || history.type = 'withdraw_request'";
			
			$today = date('Y-m-d 00:00:00',strtotime('today'));
			$condition .= " AND history.date >= '{$today}'";
			
			$this->data['history'] = $this->finance_model->GetTransactions($condition);
		}
		echo view('admin/finance/history-funds',$this->data);
	}


	public function trade_history()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);
		$this->data['page_title'] = lang('language_lang.payouts_history_page_title');
		$this->data['type'] = false;
		$this->data['module_name'] = 'finance';

		$condition = "status ='1'";		
		$this->data['trade_history'] = $this->common_model->GetResults('trade_history',$condition);

		echo view('admin/finance/trade_history',$this->data);

	}



	public function buybacklist()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_finance')
		);
		$this->data['page_title'] = lang('language_lang.lbl_buylist1');
		$this->data['type'] = true;
		$this->data['module_name'] = 'finance';
		$condition="exchange_mode = '1'";
		$this->data['history'] = $this->common_model->GetResults('exchange',$condition);
		echo view('admin/finance/buybacks',$this->data);
	}



	public function fundtransfer()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = lang('language_lang.fundtransfer_history_page_title');
		$this->data['type'] = false;
		$this->data['module_name'] = 'finance';
		$condition = "history.type = 'fund_received' order by history.historyid desc";
		$this->data['history'] = $this->finance_model->GetTransactions($condition);
		echo view('admin/finance/history',$this->data);
	}

	public function bonus()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = "Add/Deduct Points History";
		$this->data['type'] = false;
		$this->data['type1'] = "transfer";
		$this->data['module_name'] = 'finance';
		$admin_login=$session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();
		$user_group = $get_admin->user_group;
		$this->data['admin_group']=$user_group;
	
		if($this->request->getPost())
		{
			$uusersid = $this->request->getPost('user_type');
			$fromdate='';
			$enddate='';
			$flag=0;
			$flag1=0;
			if(!empty($this->request->getPost('start_date')))
			{
				$flag=1;
				$fromdate = date('Y-m-d 00:00:00',strtotime($this->request->getPost('start_date')));
			}
			if(!empty($this->request->getPost('end_date')))
			{
				$flag1=1;
				$enddate = date('Y-m-d 23:59:59',strtotime($this->request->getPost('end_date')));
			}

		
			if($flag=='0' && $flag1=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/bonus');

			}
			else if($flag1=='0' && $flag=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/bonus');

			}
			$transfer_type=$this->request->getPost('transfer_type');

			if($transfer_type=='')
				$condition = "history.type IN ('bonus','penalty') AND history.is_delete = '0'";
			else if($transfer_type=='penalty')
				$condition = "history.type IN ('penalty') AND history.is_delete = '0'";
			else if($transfer_type=='bonus')
				$condition = "history.type IN ('bonus') AND history.is_delete = '0'";
			
			$this->data['fromdate']=$this->request->getPost('start_date');
			
	        $this->data['enddate']=$this->request->getPost('end_date');
	        $this->data['userid']=$this->request->getPost('user_type');
			$this->data['usergroup']=$this->request->getPost('user_group');
			$this->data['transfer_type']=$this->request->getPost('transfer_type');
			
			if ($uusersid) {
			$condition .= " AND history.uusersid = '{$uusersid}'";
			}
	
			if ($fromdate && $enddate) 
			{
				$condition .= " AND history.date BETWEEN '{$fromdate}' AND '{$enddate}'";
			} 
			elseif ($fromdate) 
			{
				$condition .= " AND history.date >= '{$fromdate}'";
			} 
			elseif ($enddate) 
			{
				$condition .= " AND history.date <= '{$enddate}'";
			}
			$this->data['history'] = $this->finance_model->GetTransactions($condition);


		}
		else
		{
		    $this->data['userid']='';
		    $this->data['fromdate']='';
		    $this->data['enddate']='';
			$this->data['usergroup']='';
			$this->data['transfer_type']='';
			//$condition = "history.type = 'withdrawal' AND history.is_delete = '0'";
			$condition = "history.type IN ('bonus','penalty') AND history.is_delete = '0'";
			// $condition = "history.type = 'withdrawal' || history.type = 'withdraw_request'";
			$this->data['history'] = $this->finance_model->GetTransactions($condition);
		}
		echo view('admin/finance/history-points',$this->data);
	}


	public function token()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.menu_token_label')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);
		
		$this->data['page_title'] = lang('language_lang.menu_token_label')." ".lang('language_lang.text_history');
		$this->data['type'] = true;
		$this->data['module_name'] = 'finance';
		$condition = "history.type = 'token' AND history.is_delete = '0'";
		$this->data['history'] = $this->finance_model->GetTransactions($condition);
		echo view('admin/finance/history',$this->data);
	}

	public function earnings()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = "User Earnings History";
		$this->data['type'] = false;
		$this->data['type1'] = "withdraw";
		$this->data['module_name'] = 'finance';
		$admin_login=$session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();
		$user_group = $get_admin->user_group;
		$this->data['admin_group']=$user_group;
	
		if($this->request->getPost())
		{
			$uusersid = $this->request->getPost('user_type');
			$fromdate='';
			$enddate='';
			$flag=0;
			$flag1=0;
			if(!empty($this->request->getPost('start_date')))
			{
				$flag=1;
				$fromdate = date('Y-m-d 00:00:00',strtotime($this->request->getPost('start_date')));
			}
			if(!empty($this->request->getPost('end_date')))
			{
				$flag1=1;
				$enddate = date('Y-m-d 23:59:59',strtotime($this->request->getPost('end_date')));
			}

		
			if($flag=='0' && $flag1=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/earnings');

			}
			else if($flag1=='0' && $flag=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/earnings');

			}
			
			$condition = "history.type IN ('commissions') AND history.is_delete = '0'";
			
			$this->data['fromdate']=$this->request->getPost('start_date');
			
	        $this->data['enddate']=$this->request->getPost('end_date');
	        $this->data['userid']=$this->request->getPost('user_type');
			$this->data['usergroup']=$this->request->getPost('user_group');
			
			if ($uusersid) {
			$condition .= " AND history.uusersid = '{$uusersid}'";
			}
	
			if ($fromdate && $enddate) 
			{
				$condition .= " AND history.date BETWEEN '{$fromdate}' AND '{$enddate}'";
			} 
			elseif ($fromdate) 
			{
				$condition .= " AND history.date >= '{$fromdate}'";
			} 
			elseif ($enddate) 
			{
				$condition .= " AND history.date <= '{$enddate}'";
			}
			$this->data['history'] = $this->finance_model->GetTransactions($condition);


		}
		else
		{
		    $this->data['userid']='';
		    $this->data['fromdate']='';
		    $this->data['enddate']='';
			$this->data['usergroup']='';
			
			$condition = "history.type = 'commissions' AND history.is_delete = '0'";
			// $condition = "history.type = 'withdrawal' || history.type = 'withdraw_request'";
			$this->data['history'] = $this->finance_model->GetTransactions($condition);
		}
		echo view('admin/finance/history-earnings',$this->data);
	}

	public function adminearnings()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = "Admin Earning History";
		$this->data['type'] = false;
		$this->data['type1'] = "transfer";
		$this->data['module_name'] = 'finance';
		$admin_login=$session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();
		$user_group = $get_admin->user_group;
		$this->data['admin_group']=$user_group;
	
		if($this->request->getPost())
		{
			$uusersid = $this->request->getPost('user_type');
			$fromdate='';
			$enddate='';
			$flag=0;
			$flag1=0;
			if(!empty($this->request->getPost('start_date')))
			{
				$flag=1;
				$fromdate = date('Y-m-d 00:00:00',strtotime($this->request->getPost('start_date')));
			}
			if(!empty($this->request->getPost('end_date')))
			{
				$flag1=1;
				$enddate = date('Y-m-d 23:59:59',strtotime($this->request->getPost('end_date')));
			}

		
			if($flag=='0' && $flag1=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/adminearnings');

			}
			else if($flag1=='0' && $flag=='1')
			{
				$session = \Config\Services::session();
				$session->setFlashData('error_message', "Please select from and to date. some one is not selected");
				return redirect()->to('admin/history/adminearnings');

			}
			$transfer_type=$this->request->getPost('transfer_type');

			if($transfer_type=='')
				$condition = "history.type IN ('transfer_fee','deducted_gaswallet','withdraw_fee') AND history.is_delete = '0'";
			else if($transfer_type=='transfer_fee')
				$condition = "history.type IN ('transfer_fee') AND history.is_delete = '0'";
			else if($transfer_type=='withdraw_fee')
				$condition = "history.type IN ('withdraw_fee') AND history.is_delete = '0'";
			else if($transfer_type=='deducted_gaswallet')
				$condition = "history.type IN ('deducted_gaswallet') AND history.is_delete = '0'";
			
			$this->data['fromdate']=$this->request->getPost('start_date');
			
	        $this->data['enddate']=$this->request->getPost('end_date');
	        $this->data['userid']=$this->request->getPost('user_type');
			$this->data['usergroup']=$this->request->getPost('user_group');
			$this->data['transfer_type']=$this->request->getPost('transfer_type');
			
			if ($uusersid) {
			$condition .= " AND history.uusersid = '{$uusersid}'";
			}
	
			if ($fromdate && $enddate) 
			{
				$condition .= " AND history.date BETWEEN '{$fromdate}' AND '{$enddate}'";
			} 
			elseif ($fromdate) 
			{
				$condition .= " AND history.date >= '{$fromdate}'";
			} 
			elseif ($enddate) 
			{
				$condition .= " AND history.date <= '{$enddate}'";
			}
			$this->data['history'] = $this->finance_model->GetTransactions($condition);


		}
		else
		{
		    $this->data['userid']='';
		    $this->data['fromdate']='';
		    $this->data['enddate']='';
			$this->data['usergroup']='';
			$this->data['transfer_type']='';
			//$condition = "history.type = 'withdrawal' AND history.is_delete = '0'";
			$condition = "history.type IN ('transfer_fee','deducted_gaswallet','withdraw_fee') AND history.is_delete = '0'";
			// $condition = "history.type = 'withdrawal' || history.type = 'withdraw_request'";
			$this->data['history'] = $this->finance_model->GetTransactions($condition);
		}
		echo view('admin/finance/history-admin-earnings',$this->data);
	}

	public function adminexchange()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = lang('language_lang.adminexchange_history_page_title');
		$this->data['type'] = true;
		$this->data['module_name'] = 'finance';
		$condition = "history.type = 'withdraw_fee' || history.type = 'transfer_fee' AND history.is_delete = '0'";
		$this->data['history'] = $this->common_model->GetResults('admin_price');
		echo view('admin/finance/exchange',$this->data);
	}



	public function adminexchanges()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->common_model = model('CommonModel');
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);
		$this->data['page_title'] = lang('language_lang.adminexchanges_history_page_title');
		$this->data['type'] = true;
		$this->data['module_name'] = 'finance';
		$this->data['history'] = $this->common_model->GetResults('exchange');
		echo view('admin/finance/exchangehistory',$this->data);
	}

	public function pendingpayout()
	{
		
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_transaction')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_history')
		);

		$this->data['page_title'] = lang('language_lang.payouts_history_page_title');
		$this->data['type'] = false;
		$this->data['module_name'] = 'finance';
		$condition = "history.type = 'withdraw_request' AND history.is_delete = '0'";
		$this->data['history'] = $this->finance_model->GetTransactions($condition);
		echo view('admin/finance/history1',$this->data);

		if($this->input->post()){

			$payouts = $this->input->post('payouts');
			$accountNumber = 'P33860849';
			$apiId = '212991180';
			$apiKey = 'MonD0NmEJ8IvqJdN';

			$this->load->library('CPayeer');
			$payeer = new CPayeer($accountNumber,$apiId,$apiKey);

			foreach ($payouts as $key => $value) {
				
				$condition = 'historyid = '.$value;
				$history = $this->common_model->GetRow('history', $condition);
				$uusersid = $history->uusersid;
				$amount  = $history->amount;
				// $user = $this->common_model->GetUser($uusersid);
				// $user = $this->common_model->GetUser($uusersid);
				$condition = "uusersid = '".$uusersid."' AND payment_name = 'payeer'";
				$payment_data = $this->common_model->GetRow('uusers_payment', $condition);
				$payment_data->contents;
				if ($payeer->isAuth()) {

					$initOutput = $payeer->initOutput(array(
						'ps' => $payment_data->contents,
						'sumIn' => $amount,
						'curIn' => 'USD',
						'sumOut' => $amount,
						'curOut' => 'USD',
						'param_ACCOUNT_NUMBER' => $accountNumber
					));

					if ($initOutput)
					{
						$historyId = $payeer->output();
						if ($historyId > 0)
						{
							// payout success
							$data1	=	array(
								'type'	=>	'withdrawal',
								'description' => 'payout from payeer'
							);
							$this->db->where('uusersid',$xa);
							$result = $this->db->update('history', $data1);
						}
						else
						{
							$data = array(
								'payment' => 'payeer',
								'post_content' => 'failure'.json_encode($payeer->getErrors()),
								'datetime' => date('Y-m-d H:i:s')
							);
							$this->db->insert('ipn_process', $data);
							
						}
					}
					else
					{
						$data = array(
							'payment' => 'payeer',
							'post_content' => 'Not Auth'.json_encode($payeer->getErrors()),
							'datetime' => date('Y-m-d H:i:s')
						);
						$this->db->insert('ipn_process', $data);
					}
				}
				else {

					$data = array(
						'payment' => 'payeer',
						'post_content' => 'Not Auth2'.json_encode($payeer->getErrors()),
						'datetime' => date('Y-m-d H:i:s')
					);
					$this->db->insert('ipn_process', $data);
				}
				
			}
		}
	}

}

