<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Slider extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 30 July, 2016
	 * This controller to manage user side home page banner slider.
	 * Created saravanan.
	 * @see http://zhyip.com/
	 * Last Updated: 30 July, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();
		// admin login only
		if($this->session->userdata('admin_login')) {
			// form validation library
			$this->load->library('form_validation');

			$this->load->library('upload');

			// custom encryption
			$this->load->library('MyEncrypt');
			$myencrypt = new MyEncrypt;
			$this->isSubadmin();

		} else {
			redirect('admin/login');
		}

	}

	private function isSubadmin() {

		if($this->session->userdata('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($this->session->userdata('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				redirect('admin');
			}
		}
	}

	public function index()
	{
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_extra')
		
		);
		$this->data['module_name'] = 'settings';
		$this->data['slider_data'] = $this->common_model->GetResults('slider_controls');
		$this->data['languages'] = $this->common_model->GetResults('language_controls');        
		$this->load->view('admin/slider/slider',$this->data);

	}
	public function add($id='') {

		$this->data['breadcrumbs'] = array();
		$this->data['languages'] = $this->common_model->GetResults('language_controls');
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('slider_text'),
			'href' => base_url().'admin/slider'
		);
		
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  base_url().'admin/slider/add';
        $this->data['user_list'] = $this->common_model->GetResults('uusers');


		if($id) {
			$myencrypt = new MyEncrypt;
			$slider_id = $myencrypt->decode($id);
			$condition = "slider_id = '".$slider_id."'";
			$this->data['slider_data'] = $this->common_model->GetRow('slider_controls', $condition);
		}

		if($this->input->post()) {
			

			// $this->form_validation->set_rules('title', $this->lang->line("lbl_slider_title"), 'trim|required');
			if($this->input->post('slider_id')=='')
			{
			   $this->form_validation->set_rules('image', $this->lang->line("lbl_slider_image"), 'trim|required');
			 }
			// $this->form_validation->set_rules('description', $this->lang->line("lbl_slider_description"), 'trim|required');
			$logo=$_FILES['image']['tmp_name'];
			if($logo!='') {
				$this->form_validation->set_rules('image', $this->lang->line("lbl_slider_image"), 'trim|callback_validate_image');
			}
            
            // $a = 1;
            
			// check form validate
			if($this->form_validation->run() == TRUE) {

				if($this->input->post('slider_id')){

					$slider_id = $this->input->post('slider_id');

	              


	                $logo=$_FILES['image']['tmp_name'];
					if($logo!='') {
						$slider_image_file = $this->upload->data();
						$slider_data['image'] = $slider_image_file['file_name'];
					}




					foreach ($this->data['languages'] as $lang)
					{
						$lang_id = $lang->language_id;

						$slider_data = array(
						"title"			=>	$this->input->post('title'.$lang_id),
						"description"	=>	$this->input->post('description'.$lang_id),
						"status"		=>	($this->input->post('status')) ? '1' : '0',
						);

						$condition =  'pre_slider_id ='.$slider_id.'and language_id ='.$lang_id;
						$this->db->where($condition);
						$query_status = $this->db->update('slider_controls',$slider_data);
					}				  

				} else {




					$logo=$_FILES['image']['tmp_name'];
					if($logo!='')
					{
						$slider_image_file = $this->upload->data();
						$slider_data['image'] = $slider_image_file['file_name'];
					}

					$i='0';
					$ade = "";					
					foreach ($this->data['languages'] as $lang)
					{
						$i++;
						$lang_id = $lang->language_id;
						$slider_data = array(
							"title"			=>	$this->input->post('title_'.$lang_id),
							"description"	=>	$this->input->post('description_'.$lang_id),
							"status"		=>	($this->input->post('status')) ? '1' : '0',
							"language_id"      => $lang_id
						);
						$query_status = $this->db->insert('slider_controls',$slider_data);
						$lastuserid = $this->db->insert_id();
						if($i==1)						
						{
							
							// $lastuserid = $this->db->insert_id();
							$data_last = $lastuserid;

							$pre_data = array(
								"pre_slider_id" => $data_last
							);
							$this->db->where('slider_id',$lastuserid);
							$query_status = $this->db->update('slider_controls',$pre_data);
						 	$ade =  $this->session->set_userdata('userdatd',$data_last);

						}
						else
						{
							$ade =  $this->session->userdata('userdatd');
							$pre_data = array(
								"pre_slider_id" => $ade
							);

							$this->db->where('slider_id',$lastuserid);
							$query_status = $this->db->update('slider_controls',$pre_data);
						}
					}	

				}
				
			 	

				if($query_status) {
					$this->session->set_flashdata('success_slider', $this->lang->line('slider_success_message'));
					redirect('admin/slider');
				} else {
					$this->session->set_flashdata('error_slider', $this->lang->line('slider_error_message'));
					redirect('admin/slider');
				}
				
			} 
			
		}
		$this->load->view('admin/slider/addslider',$this->data);
	}

	public function delete($id) {
		$myencrypt = new MyEncrypt;
		$slider_id = $myencrypt->decode($id);
		if(isset($slider_id)){

			$condition = "slider_id = '".$slider_id."'";
			$slider_data = $this->common_model->GetRow('slider_controls',$condition);

			if(file_exists('content/slider/'.$slider_data->image)) {
				unlink('content/slider/'.$slider_data->image);		
			}
			
			$this->db->where('slider_id',$slider_id);
			$delete_status = $this->db->delete('slider_controls');


			if($delete_status) {
				$this->session->set_flashdata('success_slider', $this->lang->line('slider_delete_success_slider'));
				redirect('admin/slider');
			} else {
				$this->session->set_flashdata('error_slider', $this->lang->line('slider_delete_error_slider'));
				redirect('admin/slider');
			}	
			
		} else {
			redirect('admin/slider');
		}
	}

	public function changeStatus($id) {
		
			$myencrypt = new MyEncrypt;
			$slider_id = $myencrypt->decode($id);
		
			$cur_up_data = array(
				"status" => '0'
			);
			$this->db->where('slider_id',$slider_id);
			$update_status = $this->db->update('slider_controls',$cur_up_data);

			if($update_status){
				$this->session->set_flashdata('success_slider', $this->lang->line('slider_default_success'));
                redirect('admin/slider');
			} else {
				$this->session->set_flashdata('error_slider', $this->lang->line('slider_default_error'));
				redirect('admin/slider');
			}

		
	}
	public function changeActiveStatus($id) {

			$myencrypt = new MyEncrypt;
			$slider_id = $myencrypt->decode($id);
			
			$cur_up_data = array(
				"status" => '1'
			);
			$this->db->where('slider_id',$slider_id);
			$update_status = $this->db->update('slider_controls',$cur_up_data);

			if($update_status){
				$this->session->set_flashdata('success_slider', $this->lang->line('slider_default_success'));
				redirect('admin/slider');
			} else {
				$this->session->set_flashdata('error_slider', $this->lang->line('slider_default_error'));
			    redirect('admin/slider');
			}

		
	}

	/* validate image value */
	public function validate_image($str)
	{
		
		$config['upload_path'] = './content/slider/';
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		$config['encrypt_name'] = TRUE;
		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('image')) {
			$this->form_validation->set_message('validate_image', '<p><em class="text-danger">'.$this->upload->display_errors().'</em></p>');
			return false;
		} else {
			
			return true;
		}
		
	}

	

}

