<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php 
		helper('url');
		echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js')?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js')?>"></script>
	<!-- /theme JS files -->
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js')?>"></script>

    <!-- file upload JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/boots/js/fileinput.min.js')?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js')?>"></script>
	<style>
		.kv-file-content img.file-preview-image {
	    	width: 150px !important;
	    }
	</style>
</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php

		helper('form');



		 echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
		<div class="page-header">
			<div class="page-header-content">
				<div class="page-title">
					<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.admin_profile_title'); ?></span></h4>

					<!-- <ul class="breadcrumb breadcrumb-caret position-right">
						<?php foreach ($breadcrumbs as $breadcrumb) { ?>
						    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
						<?php } ?>
					</ul> -->
					<ul class="breadcrumb breadcrumb-caret position-right">
						<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
						    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
						<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
					</ul>
				</div>
				<?php echo view('admin/'.$module_name.'_header'); ?>
				<!-- <div class="heading-elements">
					<div class="heading-btn-group">
						<a href="#" class="btn btn-link btn-float has-text"><i class="icon-bars-alt text-primary"></i><span>Statistics</span></a>
						<a href="#" class="btn btn-link btn-float has-text"><i class="icon-calculator text-primary"></i> <span>Invoices</span></a>
						<a href="#" class="btn btn-link btn-float has-text"><i class="icon-calendar5 text-primary"></i> <span>Schedule</span></a>
					</div>
				</div> -->
			</div>
		</div>	
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.admin_profile_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>

					<div class="panel-body">
						<form class="form-horizontal form-profile" action="<?php site_url($action); ?>" method="post" enctype="multipart/form-data">
							<?php 
							$validation =  \Config\Services::validation();
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>
                            <div class="form-group  has-feedback <?php if($validation->getError('username')) echo "has-error";?>">
								<label class="control-label col-lg-2 text-semibold"><?php echo lang('language_lang.admin_username_lbl'); ?>  <span class="text-danger">*</span></label>
							    <div class="col-lg-3">
								    <div style="width:100%;" class="input-group">
									    <input type="text" name="username" class="form-control"  placeholder="<?php echo lang('language_lang.admin_plc_username_lbl'); ?>" value="<?php echo set_value('username',isset($admin->username) ? $admin->username : ''); ?>">
								    </div>
								    <?php echo $validation->getError('username', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
							    </div>
							</div>

							<div class="form-group  has-feedback <?php if($validation->getError('email')) echo "has-error";?>">
								<label class="control-label col-lg-2 text-semibold"><?php echo lang('language_lang.admin_email_lbl'); ?>  <span class="text-danger">*</span></label>
							    <div class="col-lg-3">
								    <div style="width:100%;" class="input-group">
									    <input type="text" name="email" class="form-control"  placeholder="<?php echo lang('language_lang.admin_plc_email_lbl'); ?>" value="<?php echo set_value('email',isset($admin->email) ? $admin->email : ''); ?>">
								    </div>
								    <?php echo $validation->getError('email', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
							    </div>
							</div>

							<div class="form-group  has-feedback <?php if($validation->getError('contact_email')) echo "has-error";?>">
								<label class="control-label col-lg-2 text-semibold"><?php echo lang('language_lang.admin_contact_lbl'); ?>  <span class="text-danger">*</span></label>
							    <div class="col-lg-3">
								    <div style="width:100%;" class="input-group">
									    <input type="text" name="contact_email" class="form-control"  placeholder="<?php echo lang('language_lang.admin_plc_contemail_lbl'); ?>" value="<?php echo set_value('contact_email',isset($admin->contact_email) ? $admin->contact_email : ''); ?>">
								    </div>
								    <?php echo $validation->getError('contact_email', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
							    </div>
							</div>

							<div class="form-group  has-feedback <?php if($validation->getError('contact_num')) echo "has-error";?>">
								<label class="control-label col-lg-2 text-semibold"><?php echo lang('language_lang.admin_contactnum_lbl'); ?>  <span class="text-danger">*</span></label>
							    <div class="col-lg-3">
								    <div style="width:100%;" class="input-group">
									    <input type="text" name="contact_num" class="form-control"  placeholder="<?php echo lang('language_lang.admin_plc_contnum_lbl'); ?>" value="<?php echo set_value('contact_num',isset($admin->contact_num) ? $admin->contact_num : ''); ?>">
								    </div>
								    <?php echo $validation->getError('contact_num', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
							    </div>
							</div>

							<div class="form-group  <?php if($validation->getError('profile_pic')) echo "has-error";?>">
								<label class="control-label col-lg-2 text-semibold"><?php echo lang('language_lang.admin_profile_pic'); ?> <span class="text-danger">*</span></label>
								
								<div class="col-lg-3" style="width:auto;">
									<div>
										<input type="file" name="profile_pic" class="file-input-extensions" value="<?php echo set_value('profile_pic', site_url('content/profile'.$admin->profile_pic)); ?>">
									</div>
									<span class="help-block"><?php echo lang('language_lang.profile_pic_extension');?></span>
									<?php echo $validation->getError('profile_pic', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<div class="text-right col-lg-5" style=" width: 45.667%;">
								<button style=" padding-right: 14px;" type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">

	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if(session()->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo session()->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if(session()->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo session()->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.form-profile').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            // valid: 'glyphicon glyphicon-ok',
		            // invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            username: {
		               message: '<?php echo lang("language_lang.admin_username_invalid");?>',
                            validators: {
                                notEmpty: {
                                    message: '<?php echo lang("language_lang.admin_username_valid");?>'
                                },
                                regexp: {
                                    regexp: /^[a-z]+$/i,
                                    message: '<?php echo lang("language_lang.admin_username_invalid");?>'
                                },
                                stringLength: {
                                min: 5,
                                message: '<?php echo lang("language_lang.user_name_char");?>'
                                }
                            }
		            },
		            email: {
		                 validators: {
                                notEmpty: {
                                    message: '<?php echo lang("language_lang.contact_email_required");?>'
                                },
                                regexp: {
                                    regexp: /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/,
                                    message: '<?php echo lang("language_lang.contact_email_valid"); ?>'
                                }
                            }
		            },
		            contact_email: {
		                 validators: {
                                notEmpty: {
                                    message: '<?php echo lang("language_lang.cont_email_required");?>'
                                },
                                regexp: {
                                    regexp: /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/,
                                    message: '<?php echo lang("language_lang.cont_email_valid"); ?>'
                                }
                            }
		            },
		            contact_num: {
		            	 validators: {
                                notEmpty: {
                                    message: '<?php echo lang("language_lang.admin_contact_num_empty");?>'
                                },
                                digits: {
                                    message: '<?php echo lang("language_lang.admin_contact_num_num");?>'
                                },
                                stringLength: {
                                min: 6,
                                message: '<?php echo lang("language_lang.admin_contact_num_max_limit");?>'
                                }
                                 
                            }
		            },
		            profile_pic: {
			            validators: {
			                file: {
			                    extension: 'jpg,jpeg,png,gif',
			                    type: 'image/jpg,image/jpeg,image/png, image/png',
			                    message: '<?php echo lang("language_lang.admin_profile_must");?>'
			                }
			            }
			        }
		            

		           
		            
		        }
		    })
		});
	    
	    
	    // $(".switch").bootstrapSwitch();
	    $(".file-input-extensions").fileinput({
		    uploadUrl: "http://localhost/file-upload-single/1", // server upload action
		    uploadAsync: false,
		    minFileCount: 1,
		    maxFileCount: 1,
		    overwriteInitial: true,
		    showUpload: false,
		    <?php if(isset($admin->profile_pic)) { ?>
		    	initialPreview: ["<?php echo site_url("content/profile/".$admin->profile_pic);?>"],
		    	initialPreviewAsData: true, // identify if you are sending preview data only and not the raw markup
		    	initialPreviewFileType: 'image', // image is the default and can be overridden in config below
		    <?php } ?>
		    allowedFileExtensions: ["jpg", "gif", "png", "jpeg"],
		    uploadExtraData: {
		        img_key: "1000"
		    }
		});


	    $('#icon-bck').on('click',function() {
			window.history.back();
		});

	});
	})(jQuery);


	
	</script>

</body>
</html>
