<!DOCTYPE html>
<html lang="en">
<head>
	
	<!-- header -->
		<?php 
		$session = session();
		$validation = \Config\Services::validation();
		helper('form');
		use App\Libraries\MyEncrypt;

		echo view('admin/common_header'); ?>
	<!-- /header -->
	
	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>
	
	<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

    <!-- ckeditor JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/ckeditor/ckeditor.js');?>"></script>
	<script src="<?php echo base_url('assets/boots/js/jquery.js');?>"></script>

	<!-- select box JS files 
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/form_bootstrap_select.js"></script>-->
	<!-- /select box JS files -->

   
</head>

<body class="navbar-top-md-md">
	<!-- <div class="pre_loader"></div> -->
	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.mail_temp_edit_title'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
			
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title">
						<?php 
							if(isset($this->data['gateway_name'])) { 
								$gate_name = $this->data['gateway_name'];
								echo lang($language_lang.gate_name.'_gateway');
							}
						?>
						</h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>

                	<?php //echo "<pre>"; print_r($this->data);?>
                	
					<div class="panel-body">
						<form class="form-horizontal mailtemplate" action="<?=site_url($action);?>" method="post">
							<?php 
								if($validation->listErrors()) { 
									
									$form_err_data = strtolower(str_replace('<p>', '', $validation->listErrors()));
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = ucfirst(str_replace('.', '', $form_err_data));
								}
							?>
							

							<div class="form-group  <?php if($validation->getError('email')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.lbl_mail_from'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div style="width:100%" class="input-group">
										<input type="email" name="email" id="email" class="form-control" placeholder="<?php echo lang('language_lang.place_mail_from'); ?>" value="<?php echo set_value('email',isset($mail_temp_data->from_mail) ? $mail_temp_data->from_mail : ''); ?>">
									</div>
									<?php echo $validation->getError('email', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>


							<div class="form-group  <?php if($validation->getError('name')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.lbl_mail_fromname'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div style="width:100%" class="input-group">
										<input type="text" name="name" id="name" class="form-control" placeholder="<?php echo lang('language_lang.place_mail_fromname'); ?>" value="<?php echo set_value('name',isset($mail_temp_data->from_name) ? $mail_temp_data->from_name : ''); ?>">
									</div>
									<?php echo $validation->getError('name', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<div class="form-group  has-feedback <?php if($validation->getError('subject')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.lbl_mail_subject'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<select id="subject" name="subject" class="bootstrap-select form-control" style="height:200px;">
										<option value=""><?php echo lang('language_lang.lbl_select_mailtemplate');?></option>
										<?php foreach ($mailtemp_list as $list) { ?>
											<option <?php if(isset($mail_temp_data->subject)) { if($mail_temp_data->subject==$list->mailid) { echo 'selected'; } } ?> value="<?php echo $list->mailid;?>"><?php echo $list->template_name;?></option>
											
										<?php } ?>
									</select>
									<?php echo $validation->getError('subject', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<!-- <div class="form-group  <?php if($validation->getError('subject')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.lbl_mail_subject'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-6">
									<div style="width:100%" class="input-group">
										<input type="text" name="subject" id="name" class="form-control" placeholder="<?php echo lang('language_lang.place_mail_subject'); ?>" value="<?php echo set_value('name',isset($mail_temp_data->subject) ? $mail_temp_data->subject : ''); ?>">
									</div>
									<?php echo $validation->getError('subject', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div> -->

							<div class="form-group   <?php if($validation->getError('message')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.lbl_mail_message'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-8">
									<div style="width:100%" class="input-group">
							        	<textarea class="ckeditor" name="message" id="editor-readonly" rows="4" cols="4" placeholder="<?php echo lang('language_lang.place_mail_message'); ?>"><?php echo set_value('message',isset($mail_temp_data->message) ? $mail_temp_data->message : ''); ?></textarea>
									</div>
									<?php echo $validation->getError('message', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<?php 
								if(isset($mail_temp_data->status)) { 
									$template_status = $mail_temp_data->status;
								} else {
									$template_status = '';
								}
							?>
							
							<div class="form-group <?php if($validation->getError('page_status')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.lbl_mail_status'); ?> </label>
								<div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" <?php if($template_status=='1'){ echo 'checked="checked"'; }   ?> name="status" data-on-color="success" data-off-color="danger" data-on-text="<?php echo lang('language_lang.On');?>" data-off-text="<?php echo lang('language_lang.Off');?>" class="switchery">
										</label>
									</div>
									<?php echo $validation->getError('status', '<label class="validation-error-label">', '</label>'); ?>
								</div>
							</div>
							

							<?php 
								$myencrypt = new MyEncrypt;
								if(isset($mail_temp_data->templateid)) { 
							?>
							<input type="hidden" name="mail_id" value="<?php echo $myencrypt->encode($mail_temp_data->templateid); ?>"/>
							
							<?php } ?>

							<div class="text-right col-lg-9">
								<button type="submit" class="btn btn-primary"><?php  echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->
		

		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		jQuery.noConflict();
		(function( $ ) {
		$(function() {

			$(document).ready(function() {

				$('.bootstrap-select').selectpicker({size: 4});

				$.jGrowl.defaults.closer = false;

				<?php if(isset($form_err_data)) { ?>
					$.jGrowl('<?php echo trim($form_err_data);?>', {
			            header: '<?php echo lang("language_lang.error");?>',
			            theme: 'bg-danger'
			        });
				<?php } ?>

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
			            header: '<?php echo lang("language_lang.error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

			    $('.mailtemplate').formValidation({
			    	framework: 'bootstrap',
			    	excluded: [':disabled'],
			        icon: {
			            // valid: 'glyphicon glyphicon-ok',
			            // invalid: 'glyphicon glyphicon-remove',
			            validating: 'glyphicon glyphicon-refresh'
			        },
			        fields: {
			            name: {
			                message: '<?php echo lang("language_lang.valid_mail_fromname");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo lang("language_lang.required_mail_fromname");?>'
			                    },
			                    regexp: {
			                        regexp: /^[a-z\d\-\s]+$/i,
			                        message: '<?php echo lang("language_lang.valid_mail_fromname");?>'
			                    }
			                }
			            },
			            email: {
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo lang("language_lang.required_mail_fromaddress"); ?>'
			                    },
			                    emailAddress: {
			                        message: '<?php echo lang("language_lang.valid_mail_fromaddress"); ?>'
			                    }
			                }
			            },
			            subject: {
			                message: '<?php echo lang("language_lang.valid_mail_subject");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo lang("language_lang.required_mail_subject");?>'
			                    },
			                    regexp: {
			                        regexp: /^[a-z\d\-\s]+$/i,
			                        message: '<?php echo lang("language_lang.valid_mail_subject");?>'
			                    }
			                }
			            },
			            message: {
			                message: '<?php echo lang("language_lang.required_mail_message");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo lang("language_lang.required_mail_message");?>'
			                    },
			                    stringLength: {
				                	min: 20,
				                	message: '<?php echo lang("language_lang.exceeds_mail_message");?>'
				                }
			                }
			                
			            }
			            
			        }
			    })
				.find('[name="message"]')
					.ckeditor()
		            .editor
	                .on('change', function() {
	                    $('.cms').formValidation('revalidateField', 'message');
	                });

			});

			
		    
		 	$('#icon-bck').on('click',function() {
				window.history.back();
			});
			
		    $(".switchery").bootstrapSwitch();
		   

		});
		})(jQuery);
	
	</script>

</body>
</html>
