<!DOCTYPE html>
<html lang="en">
<head>
<!-- header -->
<?php

helper('form');
$session = \Config\Services::session();
$validation = \Config\Services::validation();

echo view('admin/common_header'); ?>
<!-- /header -->

<!-- file upload JS files -->
<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/uploaders/fileinput.min.js');?>"></script>


<!-- Bootsrap form validation JS files -->
<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>


<!-- Theme JS files -->
<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
<!-- /theme JS files -->

<!-- select box theme JS files -->
<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>

<!-- bootsrap switch checkbox JS files -->
<script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

<!-- notify JS files -->
<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

<!-- select box JS files -->
<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
<!-- /select box JS files -->

</head>

<body class="navbar-top-md-md">

<!-- Fixed navbars wrapper -->
<div class="navbar-fixed-top">

<!-- Main navbar -->
<?php echo view('admin/mainnav'); ?>
<!-- /main navbar -->


<!-- Second navbar -->
<?php echo view('admin/secondnav'); ?>
<!-- /second navbar -->

</div>
<!-- /fixed navbars wrapper -->


<!-- Page header -->
<div class="page-header">
<div class="page-header-content">
<div class="page-title">
<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold">Investment Package Settings</span></h4>

<ul class="breadcrumb breadcrumb-caret position-right">
<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
</ul>
</div>

<?php echo view('admin/'.$module_name.'_header'); ?>
</div>
</div>	
<!-- /page header -->


<!-- Page container -->
<div class="page-container">

<!-- Page content -->
<div class="page-content">

<!-- Main content -->
<div class="content-wrapper">

<!-- Horizontal form -->
<div class="panel panel-flat">
<div class="panel-heading">
<h5 class="panel-title">Edit Investment Package Settings</h5>
<div class="heading-elements">
<ul class="icons-list">
<li><a data-action="collapse"></a></li>
<li><a data-action="close"></a></li>
</ul>
</div>
</div>

<?php $currency_info = defaultcurrency();?>
<div class="panel-body">
<form class="form-horizontal form-withdraw" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
<?php 
if($validation->listErrors()) { 
$form_err_data = str_replace('<p>', '', $validation->listErrors());
$form_err_data = str_replace('</p>', '', $form_err_data);
$form_err_data = str_replace('.', '', $form_err_data);
?>

<script type="text/javascript">

(function( $ ) {
$.jGrowl.defaults.closer = false;
var from_daa = '<?php $form_err_data;?>';
$.jGrowl(from_daa, {
header: '<?php echo lang("language_lang.error");?>',
theme: 'bg-danger'
});

})(jQuery);


</script>
<?php
}
?>

<div  class="form-group  has-feedback <?php if($validation->getError('package_name')) echo "has-error";?>" >
<label class="control-label col-lg-3 text-semibold">Package Name <span class="text-danger">*</span></label>
<div class="col-lg-4">
<div style="width:100%;" class="input-group">
<input type="text" name="package_name" class="form-control"  placeholder="Enter Package Name" value="<?php echo $package->package_name;?>">
</div>
<?php echo $validation->getError('package_name', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
</div>
</div>



<div  class="form-group  has-feedback <?php if($validation->getError('min_amt')) echo "has-error";?>" >
<label class="control-label col-lg-3 text-semibold">Minimum Amount (USDT)  <span class="text-danger">*</span></label>
<div class="col-lg-4">
<div style="width:100%;" class="input-group">
<input type="text" name="min_amt" class="form-control"  placeholder="Enter Minimum Amount" value="<?php echo $package->min_amt; ?>">
</div>
<?php echo $validation->getError('min_amt', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
</div>
</div>

<div  class="form-group  has-feedback <?php if($validation->getError('max_amt')) echo "has-error";?>" style='display:block;'>
<label class="control-label col-lg-3 text-semibold">Maximum Amount (USDT) <span class="text-danger"> *</span></label>
<div class="col-lg-4">
<div  style="width:100%;" class="input-group">
<input type="text" name="max_amt" class="form-control"  placeholder="Enter Maximum Amount" value="<?php echo $package->max_amt; ?>" id="max_amt">
</div>
<?php echo $validation->getError('max_amt', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>

<span id="min_amt_error" class="help-block"></span>
</div>
</div>


<div  class="form-group  has-feedback <?php if($validation->getError('duration')) echo "has-error";?>" >
<label class="control-label col-lg-3 text-semibold">Duration  <span class="text-danger">*</span></label>
<div class="col-lg-4">
<div class="input-group" style="width:100%;" >
<input type="text" name="duration" class="form-control"  placeholder="Enter Duration" value="<?php echo set_value('duration',isset($package->duration) ? number_format($package->duration, $currency_info->deimal_point, '.', '') : ''); ?>">
</div>
<?php echo $validation->getError('duration', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
</div>
</div>


<div  class="form-group  has-feedback <?php if($validation->getError('payout')) echo "has-error";?>" >
<label class="control-label col-lg-3 text-semibold">ROI Payout once(Days)  <span class="text-danger">*</span></label>
<div class="col-lg-4">
<div class="input-group" style="width:100%;" >
<input type="text" name="payout" class="form-control"  placeholder="Enter Duration" value="<?php echo set_value('payout',isset($package->payout) ? number_format($package->payout, $currency_info->deimal_point, '.', '') : ''); ?>">
</div>
<?php echo $validation->getError('payout', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
</div>
</div>

<div  class="form-group  has-feedback <?php if($validation->getError('level')) echo "has-error";?>" style='display:block;'>
<label class="control-label col-lg-3 text-semibold"> Level Eligible <span class="text-danger">*</span></label>
<div class="col-lg-4">
<div  style="width:100%;" class="input-group">
<input type="text" name="level" class="form-control"  placeholder="Enter Level Eligible" value="<?php echo set_value('level',isset($package->level) ? number_format($package->level, $currency_info->deimal_point, '.', '') : ''); ?>">

</div>
<?php echo $validation->getError('level', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
</div>
</div>


<div class="form-group" style="display: block;">
<label class="control-label col-lg-3 text-semibold">Package Status</label>
<div class="col-lg-4">
<div class="checkbox checkbox-switch">
<label>
<input type="checkbox" data-on-color="success" data-off-color="danger" class="switchery" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="status" <?php if($package->status==='on'){ echo 'checked="checked"'; }   ?>>
</label>
</div>
</div>
</div>

<input type="hidden" value="<?php echo $package->id; ?>" name="id" id="id">

<div class="text-right col-lg-7">
<button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
</div>

</form>
</div>
</div>
<!-- /horizotal form -->

</div>
<!-- /main content -->

</div>
<!-- /page content -->


<!-- Footer -->
<div class="footer text-muted">
<?php //echo site_footer();?>
<!-- &amp;copy; 2015. <a href="#">Limitless Web App Kit</a> by <a href="http://themeforest.net/user/Kopyov" target="_blank">Eugene Kopyov</a> -->
</div>
<!-- /footer -->

</div>
<!-- /page container -->

<script type="text/javascript">




jQuery.noConflict();
(function( $ ) {
$(function() {


// $(document).ready(function(){

// $('#max_amount').on('change',function(){

// // var value = $(this).val();
// // alert(value);
// // if(value==0)
// // {
// // 	alert('check');
// //   $(":submit").attr("disabled", true);
// // }
// // else
// // {
// // 	 $(":submit").removeAttr("disabled");
// // }

// });

// alert("hi");
// });


function valid1() {

var min_amount=0;
var max_amount=0;
var min_amount = +document.getElementById("min_amt").value;
var max_amount = +document.getElementById("max_amt").value;
// alert(valid1);
// die();
if(max_amount!='' && min_amount!='')
{


if(min_amount>max_amount)

{
//alert(max_amount,min_amount);


document.querySelector("#min_amt_error").style.display="block";
$(':input[type="submit"]').prop('disabled',true);
}

else if(max_amount>min_amount) 
{

//document.querySelector("#max_amt_error").style.display="none";
document.querySelector("#min_amt_error").style.display="none";
// $(':input[type="submit"]').prop('disabled',false);




}

}
}

$(document).ready(function() {

$.jGrowl.defaults.closer = false;

<?php if($session->getFlashData('error_message')) { ?>
$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
header: '<?php echo lang("language_lang.error");?>',
theme: 'bg-danger'
});
<?php } ?>

<?php if($session->getFlashData('success_message')) { ?>
$.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
header: '<?php echo lang("language_lang.success");?>',
theme: 'bg-success'
});
<?php } ?>

$('.form-withdraw').formValidation({
framework: 'bootstrap',
excluded: [':disabled'],
icon: {
// valid: 'glyphicon glyphicon-ok',
// invalid: 'glyphicon glyphicon-remove',
validating: 'glyphicon glyphicon-refresh'
},
fields: {
package_name: {
message: 'Package name is required!!',
validators: {
notEmpty: {
message: 'Package name is required!!'
},
}
},
min_amt: {
message: 'Minimum amount is required',
validators: {
notEmpty: {
message: 'Minimum amount is required'
},
regexp: {
regexp: /^[0-9.]+$/,
message: 'Minimum amount can only consist of numbers'
},
}
},
max_amt: {
message: 'Maximum amount is required',
validators: {
notEmpty: {
message: 'Maximum amount is required'
},
regexp: {
regexp: /^[0-9.]+$/,
message: 'Maximum amount can only consist of numbers'
},
greaterThan: {
value: 'min_amt',
message: 'Package amount greaterthen minimum amount'
}
}
},

duration: {
message: 'Duration is required!!',
validators: {
notEmpty: {
message: 'Duration is required!!'
},
digits: {
message: 'Duration can only consist of numbers'
}
}
},
payout: {
message: 'Payout Days is required!!',
validators: {
notEmpty: {
message: 'Payout Days is required!!'
},
digits: {
message: 'Payout Days can only consist of numbers'
}
}
},
level: {
message: 'Package Level is required',
validators: {
notEmpty: {
message: 'Package Level is required'
},
digits: {
message: 'Level can only consist of numbers'
}
}
},
}
})
});

$('#icon-bck').on('click',function() {
window.history.back();
});
$(".switchery").bootstrapSwitch();

});
})(jQuery);


</script>

</body>
</html>
