<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php 
		use App\Libraries\MyEncrypt;
		$session = \Config\Services::session();


		echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    <!--<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/components_popups.js"></script>-->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>

    <style type="text/css">
	.file-drop-zone-title
	{	
		color: #999999;
		font-size: 21px;
		font-weight: 300;
		text-align:center;
		padding: 15px 10px;
	}
</style> 

</head>

<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.pay_page_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.pay_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
								<!-- <li><a href="<?php echo base_url();?>admin/paymentsettings/add" class="glyphicon-plus"></a></li> -->
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>

					<!-- <div class="panel-body">
						The <code>Responsive</code> extension for DataTables can be applied to a DataTable in one of two ways; with a specific <code>class name</code> on the table, or using the DataTables initialisation options. This method shows the latter, with the <code>responsive</code> option being set to the boolean value <code>true</code>. The <code>responsive</code> option can be given as a boolean value, or as an object with configuration options.
					</div> -->

					

					<table class="table datatable-responsive-row-payment table-hover">
						<thead>
							<tr>
								<th></th>
								<th class=""><?php echo lang('language_lang.lbl_payment_name');?></th>
								<th class="">Payment Mode</th>
								<th class="text-center">Payment Address</th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($payment_data_list) {
								// pr($payment_data_list);
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt(true);
								foreach ($payment_data_list as $row) {
									
								

									

										$get_pay_mode=$this->db->query("select * from payment_controls where payment_id='".$row['payment_id']."' and payment_key='pay_mode'")->getRow();
										$get_address=$this->db->query("select * from payment_controls where payment_id='".$row['payment_id']."' and payment_key='address'")->getRow();
										

										if($get_pay_mode->payment_value=='manual')
											$pay_mode='Manual Deposit Mode';
										else
											$pay_mode="Auto Approval Mode";

									


									
							?>
							<tr>
								<td></td>
								<td><?php echo ucfirst($row['payment_name']);?></td>
								<td class="text-center"><?php echo $pay_mode;?></td>
								<td class="text-center"><?php echo $get_address->payment_value;?></td>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right">
											
											<li><a href="<?php echo base_url('admin/paymentsettings/add/'.$myencrypt->encode($row['payment_id']));?>"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
										
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {



	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
			            header: '<?php echo lang("language_lang.error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                
	                
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});
				
		});

	})(jQuery);

	// function install(valus) {
	// 	swal({
 //            title: "<?php echo lang('language_lang.lbl_install_payment');?>",
 //            showCancelButton: true,
 //            closeOnConfirm: false,
 //            confirmButtonColor: "#2196F3",
 //            cancelButtonColor: true,
 //            showLoaderOnConfirm: true
 //        },
 //        function(inputValue){
 //            if (inputValue === false) {
 //            	return false;
 //            } else {
	// 			var valus1 =  valus;
	// 			jQuery.ajax({
	// 	            type: 'post',
	// 	            url:'<?php echo base_url('admin/paymentsettings/install');?>',
	// 	            data: {'id':valus1},
	// 	            success : function(resp)
	// 	            {
	// 	                if(resp==1)
	// 	                    window.location.href = "<?php echo base_url('admin/paymentsettings');?>";
	// 	                else
	// 	                    console.log('fail');
	// 	            }
	// 	        });
	// 	    }
	// 	});
	// }

	// function uninstall(valus) {
	// 	swal({
 //            title: "<?php echo lang('language_lang.lbl_uninstall_payment');?>",
 //            showCancelButton: true,
 //            closeOnConfirm: false,
 //            confirmButtonColor: "#2196F3",
 //            cancelButtonColor: true,
 //            showLoaderOnConfirm: true
 //        },
 //        function(inputValue){
 //            if (inputValue === false) {
 //            	return false;
 //            } else {
	// 			var valus1 =  valus;
	// 			jQuery.ajax({
	// 	            type: 'post',
	// 	            url:'<?php echo base_url('admin/paymentsettings/uninstall');?>',
	// 	            data: {'id':valus1},
	// 	            success : function(resp)
	// 	            {
	// 	                if(resp==1)
	// 	                    window.location.href = "<?php echo base_url('admin/paymentsettings');?>";
	// 	                else
	// 	                    console.log('fail');
	// 	            }
	// 	        });
	// 	    }
	// 	});
	// }
	</script>

</body>
</html>
