<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Adminsettings extends BaseController {

	public function __construct() {
		$this->common_model = model('CommonModel');
		helper('site_helper');		
		$session = \Config\Services::session();

		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}
		
	}

	private function isCookie($values) {
		$this->common_model = model('CommonModel');
		helper('site_helper');		
		$session = \Config\Services::session();

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

	public function index()
	{
		$this->common_model = model('CommonModel');
		helper('site_helper');		
		$session = \Config\Services::session();
        $this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => lang('Trading Settings')
		);
		 $this->data['module_name'] = 'settings';
		$condition="id = '".$session->get('userid')."'";
        $this->data['admin'] = $this->common_model->GetRow('admin',$condition);

        $condition = "currency_default= '1'";
			$this->data['cur_data'] = $this->common_model->GetRow('currency_controls', $condition);

        $this->data['action'] = 'admin/adminsettings';
        
		if($this->request->getPost()) {
			
			$admin_data = array(
				"activation_cost"	=>	$this->request->getPost('activation_cost'),
				"subs_type" => $this->request->getPost('subs_type'),
				"duration"=>$this->request->getPost('duration'),
				"renewal_amt"=>$this->request->getPost('renewal_amt'),
				"min_fuel_fee"	=>	$this->request->getPost('min_fuel_fee'),
				"min_fuel"	=>	$this->request->getPost('min_fuel'),
				"deduction_type"	=>	$this->request->getPost('deduction_type'),
				"no_of_hours" => $this->request->getPost('no_of_hours'),
				"no_of_trading" => $this->request->getPost('no_of_trading'),
				"amount" => $this->request->getPost('amount'),
				"circle_profit_status" => $this->request->getPost('circle_profit_status'),
				"global_dividend" => $this->request->getPost('global_dividend'),
			);
			$this->db = db_connect();
					$query_status = $this->db->table('adminsettings')->where('id',$this->request->getPost('id'))->update($admin_data);
					

					if($query_status) {
					$session->setFlashData('success_message', lang('Trading Settings Update SuccessFully'));
					return redirect()->to('admin/adminsettings');
				} else {
					$session->setFlashData('error_message', lang('Trading Settings Update Error'));
					return redirect()->to('admin/adminsettings');
				}
			
			
		}
	echo view('admin/settings/adminsettings',$this->data);
	}

	
	
}

