<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mailtemplate extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 07 July, 2016
	 * This controller to manage mail template.
	 * Created saravana kumar.
	 * @see http://ihyip.com/
	 * Last Updated: 07 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();

		// admin login only
		if($this->session->userdata('admin_login')) {
		
			// form validation library
			$this->load->library('form_validation');
			

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set_userdata('last_page', current_url());
				redirect('admin/login');
			}
		}

	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}

	public function index()
	{
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_extra')
		);
		$this->data['module_name'] = 'settings';
		
		$this->data['mail_temp_data'] = $this->common_model->getMailTemplates();

		$this->load->view('admin/settings/mail',$this->data);

	}

	public function add($id='') {

		// if($id) {
		
			$this->data['breadcrumbs'] = array();

			$this->data['breadcrumbs'][] = array(
				'text' => $this->lang->line('text_home'),
				'href' => base_url().'admin'
			);
			$this->data['breadcrumbs'][] = array(
				'text' => $this->lang->line('text_extra')
			);
			
			
			$this->data['module_name'] = 'settings';
			$this->data['action'] =  base_url().'admin/mailtemplate/add';

			
			$this->data['mailtemp_list'] = $this->common_model->GetResults('mailtemplates');

			if($id) {
				$myencrypt = new MyEncrypt;
				$templateid = $myencrypt->decode($id);
				$condition = "templateid = '".$templateid."'";
				$this->data['mail_temp_data'] = $this->common_model->GetRow('mail_template',$condition);
			}
			

			if($this->input->post()) {

				$this->form_validation->set_rules('email', $this->lang->line('lbl_mail_from'), 'trim|required|valid_email');
				$this->form_validation->set_rules('name', $this->lang->line('lbl_mail_fromname'), 'trim|required');
				$this->form_validation->set_rules('subject', $this->lang->line('lbl_mail_subject'), 'trim|required');
				$this->form_validation->set_rules('message', $this->lang->line('lbl_mail_message'), 'trim|required');
				

				// check form validate
				if ($this->form_validation->run() == TRUE) {
					

					$myencrypt = new MyEncrypt;
					$templateid = $myencrypt->decode($this->input->post('mail_id'));
					
					$mailtemplatedata = array(
						"from_mail"	=>	$this->input->post('email'),
						"from_name"	=>	$this->input->post('name'),
						"subject"	=>	$this->input->post('subject'),
						"message"	=>	$this->input->post('message'),
						"status"	=>	($this->input->post('status')) ? '1' : '0'
					);

					$this->db->where('templateid',$templateid);
					$update_status = $this->db->update('mail_template', $mailtemplatedata);
					
					if($update_status) {
						$this->session->set_flashdata('success_message', $this->lang->line('mail_template_success_message'));
						redirect('admin/mailtemplate');
						
					} else {
						$this->session->set_flashdata('error_message', $this->lang->line('mail_template_error_message'));
						redirect('admin/mailtemplate');
					}
					
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('mail_template_error_message'));
				}
			} 
			$this->load->view('admin/settings/addmail',$this->data);
		// } else {
		// 	redirect('admin/mailtemplate');
		// }

	}
	

	// install mailtemplate gateway
	public function install() {

		if($this->input->post()) {
			$myencrypt = new MyEncrypt;
			$templateid = $myencrypt->decode($this->input->post('id'));

			$mailtemplatedata = array(
				"status"	=>	'1',
			);

			$this->db->where('templateid',$templateid);
			$update_status = $this->db->update('mail_template', $mailtemplatedata);

			if($update_status){
				$this->session->set_flashdata('success_message', $this->lang->line('mail_template_install'));
				echo 1;
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('mail_template_error_install'));
				echo 0;
			}

		}
	}

	// uninstall mailtemplate gateway
	public function uninstall() {

		if($this->input->post()) {
			$myencrypt = new MyEncrypt;
			$templateid = $myencrypt->decode($this->input->post('id'));

			$mailtemplatedata = array(
				"status"	=>	'0',
			);

			$this->db->where('templateid',$templateid);
			$update_status = $this->db->update('mail_template', $mailtemplatedata);

			if($update_status){
				$this->session->set_flashdata('success_message', $this->lang->line('mail_template_uninstall'));
				echo 1;
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('mail_template_error_uninstall'));
				echo 0;
			}

		}
	}
	

}

