<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Referralsettings extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 24 Jun, 2016
	 * This controller to manage referral setting page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/referralsettings/
	 * Last Updated: 28 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');
			$this->isSubadmin();

		} else {
			$session->set('last_page', current_url());
			return redirect()->to('admin');
		}
		
	}

	private function isSubadmin() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
        $this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings')
		);

		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/referralsettings';

		$site_data = $this->common_model->GetSettingall('referral');
			
		foreach ($site_data as $row) {
			$this->data[$row->site_key] = $row->site_value;
		}
		$this->data['uusers_list'] = $this->common_model->GetResults('uusers');

		// } else {
		// 	$site_data_default = $this->common_model->defaultlangSettingall('referral');
		// 	foreach ($site_data_default as $row) {
		// 		$this->data[$row->site_key] = $row->site_value;
		// 	}
		// }

		if($this->request->getPost()) {
			// pr($this->request->getPost());exit;

			/// form validation and set rules
		    // $this->form_validation->set_rules('ref_comm_amt_reg', lang('language_lang.referral_comm_aftr_reg'), 'trim|required|callback_amount_check');
		    $validation->setRules([
		    	'ref_user' => ['label'=>lang('language_lang.referral_ID'), 'rules' => 'trim|required']

		    ]);
		    // $this->form_validation->set_rules('ref_comm_aft_deposit', lang('language_lang.referral_comm_aftr_Dep'), 'trim|required|callback_amount_check');
		    /*$this->form_validation->set_rules('ref_mlm_plan', lang('language_lang.referral_force_mlm_plan'), 'trim|required');
		    $this->form_validation->set_rules('ref_mlm_plan2', lang('language_lang.referral_force_mlm_plan'), 'trim|required');*/
      //       $this->form_validation->set_rules('ref_solid_comm_amnt', lang('language_lang.referral_comm_solid_amnt'), 'trim|required|callback_amount_check');
		    // $this->form_validation->set_rules('ref_user', lang('language_lang.referral_ID'), 'trim|required');

		    
            if ($validation->withRequest($this->request)->run() == TRUE) {

                foreach ($site_data as $row) {

					$key_value = $row->site_key;
					
					if($this->request->getPost($key_value)){

						if($key_value=='ref_mlm_plan') {

							if($this->request->getPost('ref_mlm_plan2')){
	                        
		                        $site_data1 = $this->request->getPost('ref_mlm_plan').''.lang("language_lang.referral_force_mlm_cross").''.$this->request->getPost('ref_mlm_plan2');
		                        $sitedata = array(
									"site_value"	=>	$site_data1
								);

	                        } else {

	                         	$sitedata = array(
									"site_value"	=>	$this->request->getPost($key_value)
								);

	                        }

							$update_status = $this->db->table('site_controls')->where('settings_name','referral')->where('site_key',$key_value)->update($sitedata);

	                    } else {

	                    	$sitedata = array(
								"site_value"	=>	$this->request->getPost($key_value)
							);
							$update_status = $this->db->table('site_controls')->where('settings_name','referral')->where('site_key',$row->site_key)->update($sitedata);
	                    	
	                    }

					} else {

                		$sitedata = array(
							"site_value"	=>	'0'
						);
						
						$update_status = $this->db->table('site_controls')->where('settings_name','referral')->where('site_key',$key_value)->update($sitedata);

					}

				}

                if($update_status) {
					$session->setFlashData('success_message', lang('language_lang.referral_success_message'));
					return redirect()->to('admin/referralsettings');
				} else {
					$session->setFlashData('error_message', lang('language_lang.referral_error_message'));
					return redirect()->to('admin/referralsettings');
				}

           }
				
		}
        							
        $this->data['ref_mlm'] = explode("X", $this->data['ref_mlm_plan']);
		echo view('admin/settings/referral',$this->data);

	}
	
	function amount_check($str)
	{
		$currency_info = defaultcurrency();
		if(preg_match("/^[0-9.]+$/", $str)) {
			return true;
		} else {
			$this->form_validation->set_message('amount_check', '<p><em class="text-danger">'.lang('language_lang.amount_check').'</em></p>');
			return false;
		}
	}
	
}

