<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php 
        $session = \Config\Services::session();
		echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
		<div class="page-header">
			<div class="page-header-content">
				<div class="page-title">
					<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.admin_account_sett_title'); ?></span></h4>

					<ul class="breadcrumb breadcrumb-caret position-right">
						<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
						    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
						<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
					</ul>
				</div>
				<?php echo view('admin/'.$module_name.'_header'); ?>
				
			</div>
		</div>	
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.admin_account_sett_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>

					<div class="panel-body">
						<form class="form-horizontal form-account" action="<?php echo site_url($action);?>" method="post" enctype="multipart/form-data">
							<?php 
							$validation = \Config\Services::validation();
							$session = session();
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>

								<div class="form-group ">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.admin_security_mail_title'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="securitymail" <?php if($admin->securitymail==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>
								
								<div class="form-group ">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.admin_email_verify_login'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="mailverification" <?php if($admin->mailverification==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>
								<div class="form-group ">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.admin_ip_verify_login'); ?></label>
                                    <div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="ipVerification" <?php if($admin->ipVerification==='on'){ echo 'checked="checked"'; }   ?>>
											</label>
										</div>
									</div>
								</div>
								

								<div class="text-right col-lg-6">
								<input type="hidden" value="<?php echo $session->get('userid'); ?>" name="id">
									<button style=" padding-right: 14px; margin-right: 205px;" type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
								</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">

	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		   
		});
	    $('#icon-bck').on('click',function() {
			window.history.back();
		});
	    
	    $(".switch").bootstrapSwitch();

	});
	})(jQuery);


	
	</script>

</body>
</html>
