<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php
		use App\Libraries\MyEncrypt;
        helper('form');
		$this->session = session();
		$validation = \Config\Services::validation();

		 echo view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/wizards/stepy.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/styling/uniform.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/libraries/jasny_bootstrap.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/validation/validate.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/extensions/cookie.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	
	<!-- /theme JS files -->

	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>
    <script src="<?php echo base_url('assets/boots/js/select_min.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/boots/css/select2.css');?>">
    <script type="text/javascript" src="<?php echo base_url('assets/js/pages/wizard_stepy.js');?>"></script>

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.users_page_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">


	            <!-- Wizard with validation -->
	            <div class="panel panel-white">
					<div class="panel-heading">
						<h6 class="panel-title"><?php if(isset($user)) { echo lang('language_lang.lbl_edit_user'); } else { echo lang('language_lang.lbl_create_user'); } ?></h6>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<?php 
						$us_data = userMinPass();
					?>
                	<form class="stepy-validation create-user" method="post" action="<?=site_url($action);?>">

						<fieldset title="1">
							<legend class="text-semibold"><?php echo lang('language_lang.lbl_account_info');?></legend>
							<div class="row">
							<?php if(isset($user)) {
								// print_r($user);
								$fullname = explode(' ', $user->fullname);
								$phoneno = explode(' ', $user->phone); 
								
							} ?>
								

							<div class="row">
								<div class="col-md-6">
									<div class="form-group">
										<label><?php echo lang('language_lang.lbl_user_name');?>: <span class="text-danger">*</span></label>
										<input type="text" name="username" value="<?php echo set_value('username',isset($user->username) ? $user->username : ''); ?>" class="form-control required" placeholder="<?php echo lang('language_lang.place_user_name');?>" minlength="5" pattern="">
										<?php echo $validation->getError('username', '<label class="validation-error-label">', '</label>'); ?>
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group">
										<label><?php echo lang('language_lang.lbl_user_email');?> <span class="text-danger">*</span></label>
										<input type="email" name="email" value="<?php echo set_value('email',isset($user->email) ? $user->email : ''); ?>" class="form-control required" placeholder="<?php echo lang('language_lang.place_user_email');?>">
										<?php echo $validation->getError('email', '<label class="validation-error-label">', '</label>'); ?>
									</div>
								</div>
							</div>
							
							
							 <?php if($required_user_country=='on' || $enable_user_country=='on') { ?>

										<div class="col-md-6">
										<div id="flag" class="form-group">
											<label><?php echo lang('language_lang.lbl_user_country');?> <span class="text-danger">*</span></label>
	                                    	<select name="country" id="simg" class="select form-control">
	                                    		<option value=""><?php echo lang('language_lang.reg_select_country'); ?></option>
	                                    		<?php foreach ($countries as $country) { ?>
	                                        		<option <?php if(isset($user->country)) { if($user->country==$country->iso_2) { echo 'selected'; } } ?> value="<?php echo $country->iso_2;?>"><?php echo $country->Country;?></option> 
	                                    	<?php } ?>
	                                    	</select>
	                                	    <?php echo $validation->getError('country', '<label class="validation-error-label">', '</label>'); ?>
                                    	</div>
									</div>

										<!--<input type="hidden" id="code" name="code" value="< ?php echo set_value('code',isset($phoneno[0]) ? $phoneno[0] : ''); ?>">-->

                                            <?php } ?>
                                            
                                            
                            
                            
                            
                            	<div class="col-md-6">
										<div id="flag" class="form-group">
											<label>Rank<span class="text-danger">*</span></label>
	                                    	<select name="rank" class="select form-control">
	                                    		<option value="0">No Rank</option>
	                                    		<?php foreach ($rewards as $rewards) { ?>
	                                        		<option <?php if(isset($user->rankid)) { if($user->rankid==$rewards->id) { echo 'selected'; } } ?> value="<?php echo $rewards->id;?>"><?php echo $rewards->rank_name;?></option> 
	                                    	<?php } ?>
	                                    	</select>
	                                	    <?php echo $validation->getError('rewards', '<label class="validation-error-label">', '</label>'); ?>
                                    	</div>
									</div>
							<?php 
								if(isset($user->uusersid)) { 
								$myencrypt = new MyEncrypt;
							?>

								<input type="hidden" name="id" value="<?php echo $myencrypt->encode($user->uusersid);?>"/>
							<?php
							} else {
							?>
							<div class="row">
								<div class="col-md-6">
									<div class="form-group">
										<label><?php echo lang('language_lang.lbl_user_password');?>: <span class="text-danger">*</span></label>
										<input type="password" name="password" id="password" class="form-control required" placeholder="<?php echo lang('language_lang.place_password');?>" minlength="5">
										<?php echo $validation->getError('password', '<label class="validation-error-label">', '</label>'); ?>
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group">
										<label><?php echo lang('language_lang.lbl_user_confirm_password');?> <span class="text-danger">*</span></label>
										<input type="password" name="cpassword" class="form-control required" placeholder="<?php echo lang('language_lang.place_retype_password');?>" minlength="5">
										<?php echo $validation->getError('cpassword', '<label class="validation-error-label">', '</label>'); ?>
									</div>
								</div>
							</div>
							<?php } ?>
							
						</fieldset>

						
    

						<fieldset title="2">
							<legend class="text-semibold"><?php echo lang('language_lang.lbl_security_info');?></legend>

							<div class="row">
								<div class="col-md-6">
								<?php if(isset($user->changeip)) {
									$changeip = $user->changeip;
								} else {
									$changeip = '';
								}
								?>
									<div class="row" style="display:none;">
										<div class="col-md-10">
											<label class="control-label text-semibold"><?php echo lang('language_lang.lbl_change_ip');?>:</label>
											<div class="form-group">
												<div class="col-md-2">
													<div class="radio">
														<label>
															<input type="radio" <?php if($changeip=='disabled') echo 'checked';?> checked name="change_ip" class="styled" value="disabled">
															<?php echo lang('language_lang.lbl_disabled');?>
														</label>
													</div>
												</div>
												<div class="col-md-2">

													<div class="radio">
														<label>
															<input type="radio" <?php if($changeip=='medium') echo 'checked';?> name="change_ip" class="styled" value="medium">
															<?php echo lang('language_lang.lbl_medium');?>
														</label>
													</div>
												</div>
												<div class="col-md-2">

													<div class="radio">
														<label>
															<input type="radio" <?php if($changeip=='heigh') echo 'checked';?> name="change_ip" class="styled" value="heigh">
															<?php echo lang('language_lang.lbl_heigh');?>
														</label>
													</div>
												</div>
												<div class="col-md-2">
													<div class="radio">
														<label>
															<input type="radio" <?php if($changeip=='paranoic') echo 'checked';?> name="change_ip" class="styled" value="paranoic">
															<?php echo lang('language_lang.lbl_paranoic');?>
														</label>
													</div>

												</div>
											</div>
										</div>
									</div>
									<div class="row" style="margin-top:20px;display:none;">
										<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.lbl_changebrowser'); ?> </label>
										<div class="col-md-10">	
											<div class="form-group">
												<?php 
													if(isset($user->status)){
														$browser_status = $user->change_browser;
													} else {
														$browser_status = '';
													}
												?>
												<div class="col-lg-6">
													<div class="checkbox checkbox-switch">
														<label>
															<input type="checkbox" <?php if($browser_status=='enabled') { echo "checked"; } ?> name="changebrowser" data-on-color="success" data-off-color="danger" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" class="switchery">
														</label>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<div class="row" style="margin-top:20px;">
										<label class="control-label col-lg-3 text-semibold">User Transfer</label>
										<div class="col-md-10">	
											<div class="form-group">
												
												<div class="col-lg-6">
													<div class="checkbox checkbox-switch">
														<label>
															<input type="checkbox" <?php if($user->user_transfer=='1') { echo "checked"; } ?> name="user_transfer" data-on-color="success" data-off-color="danger" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" class="switchery">
														</label>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<div class="row" style="margin-top:20px;">
										<label class="control-label col-lg-3 text-semibold">User Withdraw </label>
										<div class="col-md-10">	
											<div class="form-group">
												
												<div class="col-lg-6">
													<div class="checkbox checkbox-switch">
														<label>
															<input type="checkbox" <?php if($user->user_withdraw=='1') { echo "checked"; } ?> name="user_withdraw" data-on-color="success" data-off-color="danger" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" class="switchery">
														</label>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="row">
										<?php 
											if(isset($user->security_question)) {
												$security_question = $user->security_question;
											} else {
												$security_question = '';
											}
										?>

										<div class="form-group" style="display:none;">
											<label><?php echo lang('language_lang.lbl_security_question');?> <span class="text-danger">*</span></label>
										    <select name="question" class="select form-control">
		                                    	<!--<option value=""><?php echo lang('language_lang.reg_select_question'); ?></option>-->
		                                        <?php foreach ($questions as $question) { ?>
		                                        <option <?php if($security_question == $question->security_question) {echo "selected";} ?> value="<?php echo $question->security_question;?>"><?php echo $question->security_question;?></option> 
		                                        <?php } ?>
		                                    </select>
										</div>
									</div>
									<div class="row">
										<div class="form-group" style="display:none;">
											<label><?php echo lang('language_lang.lbl_security_answer');?> <span class="text-danger">*</span></label>
											<input type="text" name="answer" value="<?php echo set_value('answer',isset($user->security_answer) ? $user->security_answer : ''); ?>" class="form-control" placeholder="<?php echo lang('language_lang.place_security_answer');?>">
										</div>
									</div>
									<?php 
										if(isset($user->uusersid)) {

										} else {
									?>
                                            <?php if($required_trans_pin=='on' || $enable_trans_pin=='on') { ?>

									<div class="row">
										<div class="form-group">
											<label><?php echo lang('language_lang.plac_trans_pin');?> <span class="text-danger">*</span></label>
											<input type="password" name="trans_pin" value="<?php echo set_value('trans_pin',isset($user->trans_pin) ? $user->trans_pin : ''); ?>" class="form-control required" placeholder="<?php echo lang('language_lang.plac_trans_pin');?>">
										</div>
									</div>
                                            <?php } ?>

									<?php } ?>
								</div>
							</div>
							
						</fieldset>

						<button type="submit" class="btn btn-primary stepy-finish">Submit <i class="icon-check position-right"></i></button>	
					</form>
	            </div>
	            <!-- /wizard with validation -->


	            

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->
	<script type="text/javascript">
	jQuery.noConflict();
	(function( $ ) {

		$(function() {

			$(document).ready(function() {

				$(".switchery").bootstrapSwitch();
				
				$('#icon-bck').on('click',function() {
					window.history.back();
				});

				// Styled checkboxes and radios
			    $('.styled').uniform({
			        radioClass: 'choice'
			    });

			    if ($("#simg").length > 0) {
			        function formatFlags(state) {
			            if (!state.id) return state.text;
			            return "<img style='padding-right:10px;' src='<?php echo base_url();?>/assets/images/flags/" + state.id.toLowerCase() + ".png'/>" + state.text;
			        }
			        $("#simg").select2({
			            formatResult: formatFlags,
			            formatSelection: formatFlags,
			            escapeMarkup: function(m) {
			                return m;
			            }
			        });
			    }

			    $('#simg').change(function(){
                	var id = $(this).val();
                  	if(id) {
                    	$.ajax({
                            type: 'post',
                            url : '<?php echo base_url();?>/admin/users/changecountry',
                            data : {'id':id},
                            success : function(msg)
                            {
                            	if(msg!=0) {
                                	$('#code').val('+'+msg);
                                	$('#flag').removeClass('has-error');
                                	$('#flag').addClass('has-success');
                                	$('#simg-error').remove();
                                }
                            }
                        });
                  	}
                });
				
			});


			$.validator.addMethod("alpha", function(value, element) {
				// allow any non-whitespace characters as the host part
			  	return this.optional( element ) || /^[A-Za-z][A-Za-z0-9]*$/.test( value );
			}, 'Please enter a valid username.');

			$.validator.addMethod("aplhanumericspace", function(value, element) {
				// allow any non-whitespace characters as the host part
			  	return this.optional( element ) || /^[A-Za-z0-9 ]*$/.test( value );
			}, 'Please enter a valid zipcode.');

			$.validator.addMethod("aplhaspace", function(value, element) {
				// allow any non-whitespace characters as the host part
			  	return this.optional( element ) || /^[a-zA-Z ]*$/.test( value );
			}, 'Please enter a valid string.');

            $.validator.addMethod("emailvalid", function(value, element) {
				// allow any non-whitespace characters as the host part
			  	return this.optional( element ) || /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/.test( value );
			}, 'Please enter a valid email.');

			 // Initialize validation
		    $(".create-user").validate({
		        ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
		        errorClass: 'validation-error-label',
		        successClass: 'validation-valid-label',
		        highlight: function(element, errorClass) {
		            $(element).removeClass(errorClass);
		            $(element).parent().addClass('has-error');
		            $(element).parent().removeClass('has-success');
		        },
		        unhighlight: function(element, errorClass) {
		            $(element).removeClass(errorClass);
		            $(element).parent().addClass('has-success');
		            $(element).parent().removeClass('has-error');
		        },

		        // Different components require proper error label placement
		        errorPlacement: function(error, element) {

		            // Styled checkboxes, radios, bootstrap switch
		            if (element.parents('div').hasClass("checker") || element.parents('div').hasClass("choice") || element.parent().hasClass('bootstrap-switch-container') ) {
		                if(element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
		                    error.appendTo( element.parent().parent().parent().parent() );
		                }
		                 else {
		                    error.appendTo( element.parent().parent().parent().parent().parent() );
		                }
		            }

		            // Unstyled checkboxes, radios
		            else if (element.parents('div').hasClass('checkbox') || element.parents('div').hasClass('radio')) {
		                error.appendTo( element.parent().parent().parent() );
		            }

		            // Input with icons and Select2
		            else if (element.parents('div').hasClass('has-feedback') || element.hasClass('select2-hidden-accessible')) {
		                error.appendTo( element.parent() );
		            }

		            // Inline checkboxes, radios
		            else if (element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
		                error.appendTo( element.parent().parent() );
		            }

		            // Input group, styled file input
		            else if (element.parent().hasClass('uploader') || element.parents().hasClass('input-group')) {
		                error.appendTo( element.parent().parent() );
		            }

		            else {
		                error.insertAfter(element);
		            }
		        },
		        validClass: "validation-valid-label",
		        success: function(label) {
		        	label.parent().addClass('has-success');
		            // label.addClass("validation-valid-label").text("Success")
		        },
		        rules: {
		        	firstname: {
		        		required: true,
		        		minlength: 3,
		        		alpha: true
		        	},
		        	lastname: {
                                    <?php if($required_last_name=='on') { ?>

		        		required: true,
                                    <?php } ?>

		        		alpha: true
		        	},
		        	username: {
		        		required: true,
		        		minlength: 4,
		        		alpha: true
		        	},
		            email: {
		            	required: true,
		                email: true,
		                emailvalid: true
		            },
		            <?php if(isset($us_data)) { ?>
		            password: {
		            	required: true,
		            	minlength: <?php echo $us_data;?>,
		            },
		            cpassword: {
		            	required: true,
		            	minlength: <?php echo $us_data;?>,
		              	equalTo: "#password"
		            },
		            <?php } else { ?>
		            password: {
		            	required: true
		            },
		            cpassword: {
		            	required: true,
		              	equalTo: "#password"
		            },
		            <?php } ?>
		            address: {
                            <?php if($required_user_address=='on') { ?>

		            	required: true,
		            	<?php } ?>
		            	minlength: 10
		            },
                            <?php if($required_user_city=='on') { ?>

		            city: {
		            	required: true,
		            	minlength: 3,
		            	aplhaspace: true
		            },
		            <?php } ?>
		            state: {
                                    <?php if($required_user_state=='on') { ?>

		            	required: true,
		            	<?php } ?>
		            	minlength: 3,
		            	aplhaspace: true
		            },
		            zip: {
                                    <?php if($required_user_zip=='on') { ?>

		            	required: true,
                                    <?php } ?>
		            	
		            	minlength: 4,
		            	aplhanumericspace: true
		            },
		            phone: {
		            	required: true,
		            	minlength: 6,
		            	number: true
		            },
		            country: {
		            	required: true
		            },
		            /*question: {
		            	required: true
		            },
		            answer: {
		            	required: true
		            },*/
		            trans_pin: {
		            	required: true,
		            	number: true
		            }
		            
		        },
		        messages: {
		        	firstname: {
		        		required: "<?php echo lang('language_lang.user_firstname_empty');?>",
		        		minlength: "<?php echo lang('language_lang.user_firstname_limit');?>",
		        		alpha: "<?php echo lang('language_lang.user_firstname_alpha');?>"
		        	},
		        	lastname: {
                                    <?php if($required_last_name=='on') { ?>

		        		required: "<?php echo lang('language_lang.user_lastname_empty');?>",
                                    <?php } ?>

		        		alpha: "<?php echo lang('language_lang.user_lastname_alpha');?>"
		        	},
		        	username: {
		        		required: "<?php echo lang('language_lang.user_username_empty');?>",
		        		minlength: "<?php echo lang('language_lang.user_username_limit');?>",
		        		alpha: "<?php echo lang('language_lang.user_username_alpha');?>"
		        	},
		            email: {
		            	required: "<?php echo lang('language_lang.user_emailid_empty');?>",
		                email: "<?php echo lang('language_lang.user_emailid_invalid');?>"
		            },
		            <?php if(isset($us_data)) { ?>
		            password: {
		            	required: "<?php echo lang('language_lang.user_password_empty');?>",
		            	minlength: "<?php echo lang('language_lang.user_password_limit');?><?php echo $us_data;?>",
		            },
		            cpassword: {
		            	required: "<?php echo lang('language_lang.user_confirmpassword_empty');?>",
		            	minlength: "<?php echo lang('language_lang.user_confirmpassword_limit');?><?php echo $us_data;?>",
		             	equalTo: "<?php echo lang('language_lang.user_confirmpassword_match');?>"
		            },
		            <?php } else { ?>
		            password: {
		            	required: "<?php echo lang('language_lang.user_password_empty');?>"
		            },
		            cpassword: {
		            	required: "<?php echo lang('language_lang.user_confirmpassword_empty');?>"
		             	equalTo: "<?php echo lang('language_lang.user_confirmpassword_match');?>"
		            },
		            <?php } ?>
		            address: {
                            <?php if($required_user_address=='on') { ?>

		            	required: "<?php echo lang('language_lang.user_address_empty');?>",
                            <?php } ?>

		            	minlength: "<?php echo lang('language_lang.user_address_limit');?>",
		            },
                            <?php if($required_user_city=='on') { ?>

		            city: {

		            	required: "<?php echo lang('language_lang.user_city_empty');?>",

		            	minlength: "<?php echo lang('language_lang.user_city_limit');?>",
		            	aplhaspace: "<?php echo lang('language_lang.user_city_alpha');?>"
		            },
                            <?php } ?>

		            state: {
                                    <?php if($required_user_state=='on') { ?>

		            	required: "<?php echo lang('language_lang.user_state_empty');?>",
                                    <?php } ?>

		            	minlength: "<?php echo lang('language_lang.user_state_limit');?>",
		            	aplhaspace: "<?php echo lang('language_lang.user_state_alpha');?>"
		            },
		            zip: {
                                    <?php if($required_user_zip=='on') { ?>

		            	required: "<?php echo lang('language_lang.user_zip_empty');?>",
                                    <?php } ?>

		            	minlength: "<?php echo lang('language_lang.user_zip_limit');?>",
		            	number: "<?php echo lang('language_lang.user_zip_num');?>"
		            },
                            <?php if($required_user_phone=='on') { ?>

		            phone: {
		            	required: "<?php echo lang('language_lang.user_phone_empty');?>",
		            	minlength: "<?php echo lang('language_lang.user_phone_limit');?>",
		            	number: "<?php echo lang('language_lang.user_phone_num');?>"
		            },
                            <?php } ?>
                            <?php if($required_user_country=='on') { ?>

		            country: {
		            	required: "<?php echo lang('language_lang.country_pls_Select');?>",
		            },
                            <?php } ?>

                            <?php if($required_security_question=='on') { ?>

		            question: {
		            	required: "<?php echo lang('language_lang.user_question_empty');?>"
		            },
		            answer: {
		            	required: "<?php echo lang('language_lang.user_answer_empty');?>",
		            },
                            <?php } ?>
                            <?php if($required_trans_pin=='on') { ?>

		            trans_pin: {
		            	required: "<?php echo lang('language_lang.trans_required');?>",
		            	number: "<?php echo lang('language_lang.registration_trans_digit_err');?>"
		            }
                            <?php } ?>

		            
		        }
		    });
		});
	})(jQuery);

	
	</script>
</body>
</html>
