<!doctype html>
<html lang="en" class="w-[640px]">
   <head>
   <?php echo view('user/layout/head');?>
   </head>
   <style>
      .pagination {
      display: flex;
      justify-content: center;
      margin-top: 20px;
      }
      .pagination-btn {
      background: #007bff;
      color: white;
      border: none;
      padding: 10px 20px;
      border-radius: 5px;
      cursor: pointer;
      margin: 0 5px;
      }
      .pagination-btn:disabled {
      background: #6c757d;
      cursor: not-allowed;
      }
      #pageInfo {
      align-self: center;
      margin: 0 10px;
      color:#fff;
      }
   </style>
   <body class="section-overflow">
      <!--banner start -->
      <section class="banner-bg overall-bg ">
         <div class="container">
         <header class="pt-3 pb-3">
               <div class="row">
                  <div class="col-1">
                     <div class="back-arrow">
                        <a href="<?php echo base_url();?>/revenue">
                           <iconify-icon icon="bi:arrow-left-circle-fill"></iconify-icon>
                        </a>
                     </div>
                  </div>
                  <div class="col-8">
                     <div class="title title-top py-2">
                        <h2 class="text-primary aleo" style="font-size:25px !important">Gas Bonus Records : <?php echo $datee;?></h2>
                     </div>
                  </div>
                  <div class="col-3">
                     <div class="common-icon d-flex align-items-center justify-content-end">
                        <div class="wallet-icon header-icon me-2">
                           <a href="<?php echo base_url();?>/user/asset" class="text-decoration-none ">
                              <iconify-icon icon="ph:wallet-bold"></iconify-icon>
                           </a>
                        </div>
                        <div class="header-icon">
                           <a href="<?php echo base_url();?>/news" class="text-decoration-none">
                              <iconify-icon icon="mdi:notifications-none"></iconify-icon>
                           </a>
                        </div>
                     </div>
                  </div>
               </div>
            </header>
         </div>
         <section class="dash-wrap referral">
            <div class="container">
               <div class="row">
                 
               <div class="table-responsive trans asset-trans position-relative mb-5">
                    <div class="head_trans py-3">
                        <h4 class="fw-medium text-white aleo text-center mb-0"><?php echo $gas_count;?> Records</h4>
                    </div>
                     <table class="payment-info">
                        <tbody id="myItems">
                        <?php 
                         $this->session = session();
                           $i=0;
                           if ($gas) 
                           {
                           foreach ($gas as $value) 
                           {
                              
                             
                           $i++;
                           ?>
                           <tr>
                              <td>
                                 <div class="asset-trans-content d-flex align-items-center justify-content-between">
                                    <div class="asset-trans-left text-start">
                                       <h6 class="aleo text-white mb-0">Gas Bonus</h6>
                                       <small class="text-primary fs-6 py-2 fw-bold lato"><?php echo date('d M Y H:m:s',strtotime($value->date));?></small>
                                       <h6 class="fw-medium fs-6 mb-0"><?php echo $value->description;?></h6>
                                    </div>
                                    <div class="asset-trans-right text-end">
                                       <small class="text-primary lato fw-bold "><?php echo number_format($value->amount,4);?></small>
                                       
                                    </div>
                                 </div>
                              </td>
                           </tr>
                           <?php } }?>
                        </tbody>
                     </table>

                    

                     
                  </div>
               </div>
                 
               
                <div class="pagination">
                    <button id="prevPage" class="pagination-btn" onclick="changePage('prev')">« Previous</button>
                    <span id="pageInfo"></span>
                    <button id="nextPage" class="pagination-btn" onclick="changePage('next')">Next »</button>
                </div>

            </div>
         </section>
         <!--footer start -->
         <?php echo view('user/layout/footer');?>
         <!--footer end -->
      </section>
  
      <?php echo view('user/layout/footer-script');?>
      <script>
         AOS.init({
         });
      </script>
      <script>
        let currentPage = 1;
        const itemsPerPage = 10; // Number of items per page
        let totalPages =1;
        

   document.addEventListener('DOMContentLoaded', function() {
      loadPage(currentPage);
      });

   function loadPage(page) {
      const uusersid = '<?php echo $this->session->get('uusersid');?>';
      const date = '<?php echo date('Y-m-d',strtotime($datee));?>';
      $.ajax({
         method: 'POST',
         url: '<?php echo base_url("/gasbonus_records");?>',
         data: {
            uusersid: uusersid,
            page: page,
            itemsPerPage: itemsPerPage,
            date:date
            
         },
         success: function (data) {
            const response = JSON.parse(data);
            console.log(response.totalPages);

            const tableBody = document.getElementById('myItems');
            tableBody.innerHTML = '';

            if (response.items.length === 0) {
               tableBody.innerHTML = `
                  <tr>
                     <td colspan="3" style="text-align:center; color:red;">No Records Found</td>
                  </tr>`;
            } else {
              
               response.items.forEach(item => {
              

                  tableBody.innerHTML += `
                     <tr>
                        <td>
                           <div class="asset-trans-content d-flex align-items-center justify-content-between">
                              <div class="asset-trans-left text-start">
                                 <h6 class="aleo text-white mb-0">${item.name}</h6>
                                 <small class="text-primary fs-6 py-2 fw-bold lato">${item.date}</small>
                                 <h6 class="fw-medium fs-6 mb-0"> ${item.description}</h6>
                              </div>
                              <div class="asset-trans-right text-end">
                                 <small class="text-primary lato fw-bold ">${item.amount}</small>
                              </div>
                           </div>
                        </td>
                     </tr>`;
               });
            }

            totalPages=response.totalPages;
           
      
      
           // document.getElementById('total_count').innerHTML=response.totalitems;
            document.getElementById('prevPage').disabled = !response.hasPrev;
            document.getElementById('nextPage').disabled = !response.hasNext;
            document.getElementById('pageInfo').innerText = `Page ${page} of ${response.totalPages}`;
         }
         
      });
   }
      
      function changePage(direction) {
      
      if (direction === 'prev' && currentPage > 1) {
      currentPage--;
      } else if (direction === 'next' && currentPage < totalPages) {
      currentPage++;
      }
      
      loadPage(currentPage,start_date,end_date);
      }
      </script>
   </body>
</html>
