<?php
function fetchBinanceData($symbols) {
    $apiUrl = 'https://api2.binance.com/api/v1/ticker/24hr';
    $data = [];

    foreach ($symbols as $symbol) {
        $symbol=$symbol.'USDT';
        $url = $apiUrl . '?symbol=' . $symbol;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        } else {
            $data[] = json_decode($response, true);
        }
        curl_close($ch);
    }

    return $data;
}

$symbols = ['1INCH','ADA','AAVE','ATOM','ALGO','AION','AVAX','AKRO','ANT','APE','BAT','BTC','BCH','BNB','BTCST','BAKE','BOME','BONK','CRV','COMP','CAKE','COS','DOGE','DASH','DOT','ETH','EOS','ETC','FTM','FTT','FIL','GALA','GRT','GMT','HBAR','HOT','IOTA','ICP','IOST','JST','KAVA','KSM','LTC','LINK','LIT','LUNA','MANA','MATIC','MDX','NEO','NOT','OMG','ONT','PEPE','QTUM','REEF','RSR','SUN','SHIB','SLP','SOL','SUSHI','SXP','TRX','THETA','TFUEL','UNI','VET','WRX','XRP','XMR','XEM','XLM','XTZ','YFI','YFII','ZEC','ZEN'];// Add your desired pairs here
$data = fetchBinanceData($symbols);
if($data!='')
{
file_put_contents('binance.json', json_encode($data));
}
?>
