<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php 

		use App\Libraries\MyEncrypt;
		$session = session();

		echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>
   <script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->
	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    <script type="text/javascript" src="<?php echo base_url('assets/js/pages/components_popups.js');?>"></script>

</head>

<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.mail_temp_page_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.mail_temp_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
								<!-- <li><a href="<?php echo base_url();?>admin/mailtemplate/add" class="glyphicon-plus"></a></li> -->
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>

					<!-- <div class="panel-body">
						The <code>Responsive</code> extension for DataTables can be applied to a DataTable in one of two ways; with a specific <code>class name</code> on the table, or using the DataTables initialisation options. This method shows the latter, with the <code>responsive</code> option being set to the boolean value <code>true</code>. The <code>responsive</code> option can be given as a boolean value, or as an object with configuration options.
					</div> -->

					<table class="table datatable-responsive-row-control table-hover">
  						<col width="20%">
  						<col width="20%">
  						<col width="20%">
  						<col width="15%">
  						<col width="15%">
						<thead>
							<tr>
								<th></th>
								<th class=""><?php echo lang('language_lang.lbl_mail_fromname');?></th>
								<th class="" ><?php echo lang('language_lang.lbl_mail_from');?></th>
								<th class=""><?php echo lang('language_lang.lbl_mail_subject');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_mail_status');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($mail_temp_data) {
								// print_r($mail_temp_data);
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($mail_temp_data as $row) {
							?>
							<tr>
								<td></td>
								<td><?php echo ucfirst($row->from_name);?></td>
								<td ><?php echo $row->from_mail;?></td>
								<td><?php echo ucfirst($row->template_name);?></td>
								
								<td class="text-center">

								<?php
									if(strtolower($row->status)=='1'){
								?>
									<button type="button" class="btn btn-success btn-sm" onclick="uninstall('<?php echo $myencrypt->encode($row->templateid);?>')" data-popup="tooltip" title="<?php echo lang('language_lang.click_to_uninstall');?>"><?php echo lang('language_lang.install');?> <i class="fa fa-plus-circle position-right"></i></button>
									
								<?php } else { ?>
									<button type="button" class="btn btn-danger btn-sm" onclick="install('<?php echo $myencrypt->encode($row->templateid);?>')" data-popup="tooltip" title="<?php echo lang('language_lang.click_to_install');?>"><?php echo lang('language_lang.uninstall');?> <i class="fa fa-minus-circle position-right"></i></button>
									
								<?php		
									}
								?>
									
								</td>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right">
												<li><a href="<?php echo base_url('admin/mailtemplate/add/'.$myencrypt->encode($row->templateid));?>"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {



	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
			            header: '<?php echo lang("language_lang.error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});
		});

	})(jQuery);

	function install(valus) {
		var valus1 =  valus;
		jQuery.ajax({
            type: 'post',
            url:'<?php echo base_url('admin/mailtemplate/install');?>',
            data: {'id':valus1},
            success : function(resp)
            {
                if(resp==1)
                    window.location.href = "<?php echo base_url('admin/mailtemplate');?>";
                else
                    console.log('fail');
            }
        });
	}
	function uninstall(valus) {
		var valus1 =  valus;
		jQuery.ajax({
            type: 'post',
            url:'<?php echo base_url('admin/mailtemplate/uninstall');?>',
            data: {'id':valus1},
            success : function(resp)
            {
                if(resp==1)
                    window.location.href = "<?php echo base_url('admin/mailtemplate');?>";
                else
                    console.log('fail');
            }
        });
	}
	</script>

</body>
</html>
