<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Trade Quantity</title>
      <?php echo view('user/layout/head');?>
      <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">
      <link rel="stylesheet" href="https://cdn.datatables.net/v/bs4/dt-1.10.18/b-1.5.6/sc-2.0.0/sl-1.3.0/datatables.min.css">
  
 
   </head>
   <style>
     .items-owner-box {
    border: 1px solid #403D52;
    border-radius: 8px;
    padding: 0 0 0;
    margin-top: 10px;
    }
    .style-two.items-owner {
      padding: 15px 20px 0;
      min-height:140px;
      overflow:auto;
    }
    .style-two .items-owner-thumb {
    float: left;
    margin-right: 10px;
    }
    .style-two .items-owner-title {
  float: left;
}
.items-owner-title h5 {
  font-size: 16px;
  color: #5D82FF;
  font-weight: 400;
  margin: 0;
}
.style-two .items-owner-title span {
  color: #fff;
  font-style: inherit;
  padding-left: 6px;
  line-height: 21px;
  font-size:11px;
  margin-top:20px;
  margin-bottom:20px;
}
.style-two .item-price {
  text-align: right;
}
.style-two.upper.items-owner {
  border-bottom: none;
  padding: 15px 20px 0;
}

.style-two .item-price p {
  color: #fff;
  line-height: 22px;
}

.float {
display: flex;
justify-content: space-between;
align-items: center;
padding: 8px 0; /* Optional: Add some padding for spacing */
border-bottom: none; /* Optional: Add a border for visual separation */
}
.mode{
    padding:10px;
    border:1px solid #ddd;
    margin-bottom:10px;
    margin-left:5px;
    
}

.toggle-icon {
    position: relative;
    top: 10px;
    right: 10px;
    cursor: pointer;
}

.toggle-icon i {
    font-size: 20px;
}
.show {
    display: block !important;
}

.hide {
    display: none !important;
}

.left { text-align: left;}
.right {  text-align: right;}
.btn-success { border-radius:0px;background:green;font-size:12px;}
.btn-danger { border-radius:0px;background:red;font-size:12px;}

.pagination {
    display: flex;
    justify-content: center;
    margin-top: 20px;
}

.pagination-btn {
    background: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    margin: 0 5px;
}

.pagination-btn:disabled {
    background: #6c757d;
    cursor: not-allowed;
}

#pageInfo {
    align-self: center;
    margin: 0 10px;
}
#myItems { padding:10px;}
.modal-backdrop.show { opacity:1; position:relative;}

.text-primary {font-size:15px;}

   </style>
     <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.3/themes/base/jquery-ui.css">
  
   <body class="reg-overflow">
      <section class="dash-banner-bg banner-bg">
         <div class="container">
         <!---header start---->
         <?php echo view('user/layout/header');?>
         <!---header end---->
         <!---banner start---->
         <div class="row">
            <div class="col-lg-12">
               <?php 
                  use App\Libraries\MyEncrypt;
                  use App\Helpers\site_helper;
                  use App\Helpers\form_helper;
                  $this->db = db_connect();
                  $this->session = session();
                  $uusersid = $this->session->get('uusersid');

                  if(!empty($this->session->get('exchange')))
                     $exchange=$this->session->get('exchange');
                  else
                     $exchange='1';
                  
                  $this->common_model = model('CommonModel');
                  helper('form_helper');
                  $buy_bal='0';
                  $tradSets = $this->common_model->GetResults('adminsettings','');
                  $tradSet = $tradSets[0];
                  $activation='';
                  $usdt_balance='0';
                  $sno=0;
                  
                  ?>
               <div class="dash-wrap">
                  <div class="title text-center py-1">
                     <h2 class="text-primary">Trading  Records</h2>
                  </div>

                  <div class="operation-content">
                 <h3 class="text-primary py-1"> <span id="total_count"> <?php echo $count;?> </span> Records <a href="" data-bs-toggle="modal" data-bs-target="#staticBackdrop1" data-bs-whatever="@fat" class="text-decoration-none"><i class="fa fa-filter" id="balance_load" style="float:right;color:#fff;"></i></a> </h3>
                 </div>
                 <br>


                 <div class="modal fade" id="staticBackdrop1" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content" style="border-radius:30px;padding: 11px;" >

                    <div class="modal-header" style="padding-top: 11px;margin-bottom:-15px;">
                    <p class="modal-title" id="staticBackdropLabel" style="padding-left:170px;"><b>Records Filter</b></p>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                    </div>

<div class="modal-body">


<div class="form-check form-check-right mb-3" style="font-size: 14px;">
<div class="row  mt-3">
    <div class="form-group col-lg-6">
       <label class="btn btn-default">Start Date</label>
        <input type="text" name="start_date" id="start_date" class="form-control" required>
    </div>
    
    <div class="form-group col-lg-6">
    <label class="btn btn-default">End Date</label>
    <input type="text" name="end_date" id="end_date" class="form-control" required>
    </div>

    <div class="form-group col-lg-6">
    <label class="btn btn-default">Select Pair</label>
    <select class="form-control" name="pair" id="pair">
        <option value="">No Pair selected</option>
        <?php 
        $required_pairs = ['1INCH','ADA','AAVE','ATOM','ALGO','AION','AVAX','AKRO','ANT','APE','BAT','BTC','BCH','BNB','BTCST','BAKE','BOME','BONK','CRV','COMP','CAKE','COS','DOGE','DASH','DOT','ETH','EOS','ETC','FTM','FTT','FIL','GALA','GRT','GMT','HBAR','HOT','IOTA','ICP','IOST','JST','KAVA','KSM','LTC','LINK','LIT','LUNA','MANA','MATIC','MDX','NEO','NOT','OMG','ONT','PEPE','QTUM','REEF','RSR','SUN','SHIB','SLP','SOL','SUSHI','SXP','TRX','THETA','TFUEL','UNI','VET','WRX','XRP','XMR','XEM','XLM','XTZ','YFI','YFII','ZEC','ZEN'];
        foreach($required_pairs as $required_pairs)
        {   
             $display_pair=$required_pairs.'USDT';
            ?>
            <option value="<?php echo $display_pair;?>"><?php echo $required_pairs."/USDT";?></option>
            <?php 

        }
        ?>

    </select>
    </div>

    <div class="form-group col-lg-6">
    <label class="btn btn-default">Order From</label>
    <select class="form-control" name="ordermode" id="ordermode">
        <option value="">Order From</option>
       <option value="1">Auto Buy</option>
       <option value="2">Auto Sell</option>
       <option value="3">Manual Buy</option>
       <option value="4">Manual Sell</option>

    </select>
    </div>


    
    <div class="form-group col-lg-6">
    <label class="btn btn-default">Strategy Mode</label>
    <select class="form-control" name="sta_mode" id="sta_mode">
        <option value="">All</option>
       <option value="1">Warehouse Mode</option>
       <option value="2">Subbin Mode</option>
       <option value="3">Subbin Realtime</option>
    </select>
    </div>

    <div id="date_err" style="color:red;font-size:12px;font-weight:bold;"></div>
</div>
</div>


</div>
<div class="modal-footer" >

      <button  type="button" class="btn btn-secondary" name="button"  id="confirm">Confirm</button>
      <button  type="button" class="btn btn-secondary" name="button"  id="reset">Reset</button>
   
</div>

</div>
</div>
</div>


                  <div id="load">
                    <?php 
                    if($records)
                    {
                        ?>
                         <div class="row justify-content-center mb-3" id="myItems">
                         <div class="col-md-12 col-xl-12">
                         <?php 
                         $i=0;
                            foreach ($records as $records) 
                            {
                                $i++;
                                $type=$records->type;
                                if($type=='1')
                                {   
                                    $turnover='-';
                                    $label="<label class='btn btn-success'>Buy</label>";
                                }
                                else
                                {
                                    $turnover=$records->quantity;
                                    $label="<label class='btn btn-danger'>Sell</label>";
                                }
                                $get_mode=$this->db->query("select * from trade_process where id='".$records->trade_process_id."'")->getRow();
                                $mode=$get_mode->strategy_type;
                                $order_time=date("Y-m-d H:i:s",$records->time/1000);
                                $base = substr($records->pair, 0, -4);


                                if($records->strategy_mode=='1')
                                    $sta_modes='Warehouse Mode';
                                else if($records->strategy_mode=='2')
                                    $sta_modes='Subbin Mode';
                                else 
                                    $sta_modes='Subbin Realtime';


                                if($records->type=='1' && $records->description!='manual_buy')
                                {
                                    $order_mode='Auto Buy';
                                }
                                else if($records->type=='1' && $records->description=='manual_buy')
                                {
                                    $order_mode='Manual Buy';
                                }

                                
                                else if($records->type=='2' && $records->description!='manual_sell')
                                {
                                    $order_mode='Auto Sell';
                                }
                                else
                                {
                                    $order_mode='Manual Sell';
                                }
                                
                                 
                                ?>
                                
                                <div class="items-owner-box">
                                <div class="items-owner style-two">
                                <div class="items-owner-thumb">
                                    <img src="<?php echo base_url('styles/images/tradingpair_images/'.$records->pair.'.png');?>" alt="" width="60px" height="60px">  
                                </div>
                                <div class="items-owner-title">
                                    <h5 style="margin-top:10px;margin-bottom:20px;"><?php echo $records->pair;?> 
                                </div>
                                <div class="item-price">
                                <?php echo $label;?>
                                </div>
                                <div style="clear:both;"><br></div>
                                
                                <div class="items-owner-title" style="float:none;">
                                <span class="mode"><?php echo $records->strategy_type;?></span> <span class="mode"><?php echo $sta_modes;?></span> <span class="mode"><?php echo $order_mode;?></span>
                                <br><br>
                                    <span>Turnover: <?php echo $turnover;?></span><br>
                                   <span>Order Time: <?php echo $order_time;?></span>
                                    
                                </div>

                                <div style="float:right;margin-top:-40px;" class="toggle-icon" onclick="toggle('<?php echo $i;?>');">
                                <i class="fa fa-circle-chevron-down text-white"></i>
                                </div>
                                </div>
                                
                                <div class="items-owner-box" id="nav<?php echo $i;?>" style="border:none;display:none;">
                                <div class="items-owner style-two">
                                <div class="items-owner-title" style="float:none;width:100%;">
                                <hr>

                               
                                    <div class="float">
                                        <span>Order No</span>  <span class="right"><?php echo $records->order_id;?></span>
                                     </div>
                                     <div class="float">
                                        <span class="left">Live Price</span>  <span class="right">Market</span>
                                     </div>
                                     <div class="float">
                                        <span class="left">Filled Quantity</span>  <span class="right"><?php echo $records->received_amount;?> <?php echo $base;?></span>
                                     </div>
                                     <div class="float">
                                        <span class="left">Filled Amount</span>  <span class="right"><?php echo $records->quantity;?> USDT</span>
                                     </div>
                                    
                             
                                </div>
                                </div>
                                
                                </div>

                           
                            </div>

                            <?php 

                            }
                         ?>
                         

                         </div>
                         </div>

                        <?php 

                    }
                    ?>

                    <div class="pagination">
                            <button id="prevPage" class="pagination-btn" onclick="changePage('prev')">« Previous</button>
                            <span id="pageInfo"></span>
                            <button id="nextPage" class="pagination-btn" onclick="changePage('next')">Next »</button>
                        </div>
                   </div>

                    <input type="hidden" name="pair_val" id="pair_value">
               
                
               
               </div>
            </div>

         
            <?php echo view('user/layout/footer');?>
         </div>
      </section>
      <?php echo view('user/layout/footer-script');?>
      <script src="<?php echo base_url();?>/styles/new_style/js/notify.js"></script>
      <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
  <script src="https://code.jquery.com/ui/1.13.3/jquery-ui.js"></script>
      <script type="text/javascript">

            $( function() {
                $( "#start_date").datepicker({
                    dateFormat: 'yy-mm-dd'
                });
                                $( "#end_date").datepicker({
                    dateFormat: 'yy-mm-dd'
                });
            } );
         function view_trade(str)
         {
           window.location="<?php echo base_url();?>/tradedetails/"+str;
         }

         function toggle(id) {
    // Get the target content and icon
    const content = document.getElementById('nav' + id);
    const icon = document.querySelector(`.toggle-icon[onclick="toggle('${id}');"] i`);

    // Get all contents and icons to hide/show them
    /*document.querySelectorAll('.items-owner-box[id^="nav"]').forEach((section) => {
        if (section.id !== 'nav' + id) {
            section.style.display = 'none';
        }
    });

    document.querySelectorAll('.toggle-icon i').forEach((iconElement) => {
        iconElement.classList.remove('fa-circle-chevron-up');
        iconElement.classList.add('fa-circle-chevron-down');
    });*/

    // Toggle the selected content
    if (content.style.display === 'block') {
        content.style.display = 'none';
        icon.classList.remove('fa-circle-chevron-up');
        icon.classList.add('fa-circle-chevron-down');
    } else {
        content.style.display = 'block';
        icon.classList.remove('fa-circle-chevron-down');
        icon.classList.add('fa-circle-chevron-up');
    }
}


let currentPage = 1;
const itemsPerPage = 10; // Number of items per page
let totalPages =1;
let start_date='';
let end_date='';
let pair='';
let ordermode='';
let sta_mode='';
document.addEventListener('DOMContentLoaded', function() {
   

    loadPage(currentPage,start_date,end_date,pair,ordermode,sta_mode);
});


function loadPage(page,start_date,end_date,pair,ordermode,sta_mode)
{
    var uusersid='<?php echo $this->session->get('uusersid');?>';
    var exchange_id='1';

    var pair=$("#pair").val();
   
    $.ajax({
        'method': 'POST',
        'url': '<?php echo base_url("/order_records");?>',
         data:{'exchange':exchange_id,'uusersid':uusersid,"pair":pair,"page":page,"itemsPerPage":itemsPerPage,"start_date":start_date,"end_date":end_date,"ordermode":ordermode,"stamode":sta_mode},
        success:function(data)
        {
            var data= JSON.parse(data);
            console.log(data.totalPages);
            const myItems = document.getElementById('myItems');
            myItems.innerHTML = '';

            if (data.items.length === 0) {
                myItems.innerHTML = `<div class="items-owner-box">
                        <div class="items-owner style-two" style="margin:10px;text-align:center;color:red;"> No Transaction Records Found</div></div>`;
            }
            else
            {

            data.items.forEach(item => {
                myItems.innerHTML += `
                    <div class="items-owner-box">
                        <div class="items-owner style-two">
                            <div class="items-owner-thumb">
                                <img src="<?php echo base_url();?>/${item.image}" alt="" width="60px" height="60px">
                            </div>
                            <div class="items-owner-title">
                                <h5 style="margin-top:10px;">${item.pair} <span class="mode">${item.mode}</span> </h5>
                            </div>
                            <div class="item-price" style="margin-top:45px;">
                                ${item.type}
                            </div>

                            <div style="clear:both;"><br></div>
                                
                                <div class="items-owner-title" style="float:none;">
                                 <span class="mode">${item.sta_mode}</span> <span class="mode" >${item.order_mode}</span>
                                <br><br>
                                   <span>Turnover: ${item.turnover}</span><br>
                                <span>Order Time: ${item.orderTime}</span><br>
                                    
                                </div>
                            
                             <div style="float:right;margin-top:-40px;" class="toggle-icon" onclick="toggle('${item.id}');">
                                <i class="fa text-white fa-circle-chevron-down"></i>
                            </div>
                        </div>
                        <div class="items-owner-box" id="nav${item.id}" style="border: medium; display: none;">
                            <div class="items-owner style-two">
                                <div class="items-owner-title" style="float:none;width:100%;">
                                    <hr>
                                    
                                     ${item.method === '2' ? `
                                    <div class="operation-content">
                                        <h3 class="text-primary py-1">Profit : ${item.profit} | Fuel : ${item.fuel} <span style="float:right;color:green;font-size:14px;font-weight:bold;margin-top:0px;">${item.percentage} %</span></h3>
                                    </div>
                                ` : ''}
                                
                                    <div class="float">
                                        <span>Order No</span>  <span class="right">${item.orderNo}</span>
                                    </div>
                                    
                                    <div class="float">
                                        <span>Order Limit</span>  <span class="right">Market Price</span>
                                    </div>
                                    
                                    <div class="float">
                                        <span class="left">Market Execution Price</span>  <span class="right">${item.averagePrice}</span>
                                    </div>
                                    <div class="float">
                                        <span class="left">Filled Quantity</span>  <span class="right">${item.filledQuantity} ${item.tradingPair}</span>
                                    </div>
                                    <div class="float">
                                        <span class="left">Filled Amount</span>  <span class="right">${item.filledAmount} ${item.currency}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `; });
            }
       
        totalPages=data.totalPages;
        start_date=start_date;
        end_date=end_date;
        pair=pair;
        ordermode=ordermode;
        sta_mode=sta_mode;
 
    
        document.getElementById('total_count').innerHTML=data.totalitems;
         document.getElementById('prevPage').disabled = !data.hasPrev;
            document.getElementById('nextPage').disabled = !data.hasNext;
            document.getElementById('pageInfo').innerText = `Page ${page} of ${data.totalPages}`;
        }
      })


      
}


function changePage(direction) {
   
    if (direction === 'prev' && currentPage > 1) {
        currentPage--;
    } else if (direction === 'next' && currentPage < totalPages) {
        currentPage++;
    }
    var pair=$("#pair").val();
    var ordermode=$("#ordermode").val();
    var sta_mode=$("#sta_mode").val();
    loadPage(currentPage,start_date,end_date,pair,ordermode,sta_mode);
}


$('#confirm').click(function(){
    $("#date_err").html("");
    var start_date=$("#start_date").val();
    var end_date=$("#end_date").val();
    var pair=$("#pair").val();
    var ordermode=$("#ordermode").val();
    var sta_mode=$("#sta_mode").val();

    if(start_date!='' && end_date=='')
    {
        $("#date_err").html("Start and End date Must Required");
    }
    else if(start_date=='' && end_date!='')
    {
        $("#date_err").html("Start and End date Must Required");
    }
    else
    {
    
        $('#staticBackdrop1').modal('hide');
        let currentPage = 1;
        loadPage(currentPage,start_date,end_date,pair,ordermode,sta_mode);
    }

});

$('#reset').click(function(){
    let currentPage = 1;
    $("#start_date").val('');
    $("#end_date").val('');
    $("#pair").val('');
    $("#ordermode").val('');
    $("#sta_mode").val('');
    
    $('#staticBackdrop1').modal('hide');
    
    loadPage(currentPage);
});



</script>
    


   </body>
</html>
