<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Paysettings extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 17 Jun, 2016
	 * This controller to manage site currency setting page.
	 * Created saravana kumar.
	 * @see http://ihyip.com/admin/sitesettings/
	 * Last Updated: 23 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();

		// admin login only
		if($this->session->userdata('admin_login')) {

			// form validation library
			$this->load->library('form_validation');
			$this->isSubadmin();

			
		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set_userdata('last_page', current_url());
				redirect('admin/login');
			}
		}

	}

	private function isSubadmin() {

		if($this->session->userdata('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($this->session->userdata('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				redirect('admin');
			}
		}
	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}

	public function index()
	{
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_settings')
		);

		$this->data['module_name'] = 'settings';
		$this->data['currency_data'] = $this->common_model->GetResults('payment_currency');

		$this->load->view('admin/settings/paycurrency',$this->data);

	}
	public function add($id='') {
		

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_settings'),
			'href' => base_url().'admin/sitesettings'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_currency'),
			'href' => base_url().'admin/paysettings'
		);
		
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  base_url().'admin/paysettings/add';

		if($id) {
			$myencrypt = new MyEncrypt;
			$currency_id = $myencrypt->decode($id);
			$condition = "currency_id = '".$currency_id."'";
			$this->data['cur_data'] = $this->common_model->GetRow('payment_currency', $condition);
		}

		if($this->input->post()) {

			if($this->input->post('currency_id')) {
				
				$currency_id = $this->input->post('currency_id');
				$this->form_validation->set_rules('name', $this->lang->line("label_cur_name"), 'trim|required|alpha|min_length[4]|edit_unique[currency_controls.currency_name'.$currency_id.']');
				$this->form_validation->set_rules('unit', $this->lang->line("label_cur_unit"), 'trim|required|min_length[3]|max_length[4]|edit_unique[currency_controls.currency_unit'.$currency_id.']');
				
			} else {
				$this->form_validation->set_rules('name', $this->lang->line("label_cur_name"), 'trim|required|alpha|min_length[4]|is_unique[currency_controls.currency_name]');
				$this->form_validation->set_rules('unit', $this->lang->line("label_cur_unit"), 'trim|required|min_length[3]|max_length[4]|is_unique[currency_controls.currency_unit]');
			}
			
			$this->form_validation->set_rules('symbol', $this->lang->line("label_cur_symbol"), 'trim|required|max_length[10]');
			$this->form_validation->set_rules('deimal_point', $this->lang->line("label_cur_decimal_point"), 'trim|required|numeric|max_length[1]');
			

			// check form validate
			if ($this->form_validation->run() == TRUE) {
				

				if($this->input->post('currency_id')) {

					$condition = "currency_id = '".$this->input->post('currency_id')."' ";
					$curr_data = $this->common_model->GetRow('payment_currency',$condition);
					
					
						/*$currencydata = array(
							"currency_name"	=>	strtolower($this->input->post('name')),
							"currency_unit"	=>	strtolower($this->input->post('unit')),
							"currency_symbol"	=>	strtolower($this->input->post('symbol')),
							"currency_default"	=>	($this->input->post('default')) ? '1' : '0',
							"currency_status"	=>	($this->input->post('status')) ? '1' : '0',
							"deimal_point"	=>	strtolower($this->input->post('deimal_point'))
						);*/

					$currencydata = array(
							"currency_symbol"	=>	strtolower($this->input->post('symbol')),
							"currency_default"	=>	($this->input->post('default')) ? '1' : '0',
							"currency_status"	=>	($this->input->post('status')) ? '1' : '0',
							"deimal_point"	=>	strtolower($this->input->post('deimal_point'))
						);					
					
					$this->db->where('currency_id',$this->input->post('currency_id'));
					$query_status = $this->db->update('payment_currency',$currencydata);

					if($this->input->post('default') !='0'){

					$cur_up_data = array(
						"currency_default" => '0'
					);
					$this->db->where("currency_id != '".$this->input->post('currency_id')."'");
					$this->db->update('payment_currency',$cur_up_data);
					}

				} else {

					$currencydata = array(
						"currency_symbol"	=>	strtolower($this->input->post('symbol')),
						"currency_default"	=>	($this->input->post('default')) ? '1' : '0',
						"currency_status"	=>	($this->input->post('status')) ? '1' : '0',
						"deimal_point"	=>	strtolower($this->input->post('deimal_point'))
					);
					
					$query_status = $this->db->insert('payment_currency',$currencydata);
					$currency_id = $this->db->insert_id();

					if($this->input->post('default') !='0'){

						$cur_up_data = array(
						"currency_default" => '0'
					);

					$this->db->where("currency_id != '".$currency_id."'");
					$this->db->update('currency_controls',$cur_up_data);


					}
					
				}
				// echo $this->db->last_query();exit;

				if($query_status) {
					$this->session->set_flashdata('success_message', $this->lang->line('cur_success_message'));
					redirect('admin/paysettings');
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('cur_error_message'));
					redirect('admin/paysettings');
				}
				
			} 
			
		}
		$this->load->view('admin/settings/addpaycurrency',$this->data);
	}

	public function delete($id) {
		if($id) {
			$myencrypt = new MyEncrypt;
			
			$currency_id = $myencrypt->decode($id);

			if($currency_id!=1){

				$condition = "currency_id = '".$currency_id."' ";
				$curr_data = $this->common_model->GetRow('payment_currency',$condition);
				
				if($curr_data->currency_default) {

					$curr_up_data = array(
						"currency_default" => '1'
					);
					$this->db->where('currency_id', '1');
					$update_status = $this->db->update('payment_currency',$curr_up_data);

					$this->db->where('currency_id',$currency_id);
					$delete_status = $this->db->delete('payment_currency');

				} else {
					$this->db->where('currency_id',$currency_id);
					$delete_status = $this->db->delete('payment_currency');
				}

				if($delete_status) {
					$this->session->set_flashdata('success_message', $this->lang->line('cur_success_message'));
					redirect('admin/paysettings');
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('cur_error_message'));
					redirect('admin/paysettings');
				}	
				
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('cur_error_default_message'));
				redirect('admin/paysettings');
			}

		} else {
			redirect('admin/paysettings');
		}
		if($id) {
			$myencrypt = new MyEncrypt;
			$currency_id = $myencrypt->decode($id);

			// $condition = "currency_id = '".$currency_id."' ";
			// $curr_data = $this->common_model->GetRow('currency_controls',$condition);
			// echo $curr_data->currency_default;
			$this->db->where('currency_id',$currency_id);
			$delete_status = $this->db->delete('payment_currency');

			if($delete_status) {
				$this->session->set_flashdata('success_message', $this->lang->line('cur_success_message'));
				redirect('admin/paysettings');
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('cur_error_message'));
				redirect('admin/paysettings');
			}
		} else {
			redirect('admin/paysettings');
		}
	}
	public function makedefaults() {
		if($this->input->post()) {
			$myencrypt = new MyEncrypt;
			$currency_id = $myencrypt->decode($this->input->post('id'));
			$condition = "currency_id = '".$currency_id."' ";
			$curr_data = $this->common_model->GetRow('currency_controls',$condition);
			if($curr_data->currency_default==0)
			{
				$cur_up_data = array(
					"currency_default" => '0'
				);
				$this->db->update('currency_controls',$cur_up_data);

				$cur_up_data1 = array(
					"currency_default" => '1',
					"currency_status"	=> '1'
				);

				$this->db->where('currency_id',$currency_id);
				$default_status = $this->db->update('currency_controls',$cur_up_data1);

				if($default_status){
					$this->session->set_flashdata('success_message', $this->lang->line('cur_success_message_default'));
					echo 1;
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('cur_error_message_default'));
					echo 0;
				}

			}

		}
	}

}

