<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		helper('form');

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- file upload JS files 
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/uploaders/fileinput.min.js"></script>-->
	
	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>
	

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->

	<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->
    

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
		<div class="page-header">
			<div class="page-header-content">
				<div class="page-title">
					<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.email_page_title'); ?></span></h4>

					<ul class="breadcrumb breadcrumb-caret position-right">
						<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
					</ul>
				</div>
				<?php echo view('admin/'.$module_name.'_header'); ?>
				
			</div>
		</div>	
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.email_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>

					<div class="panel-body">
						<form class="form-horizontal emailsetting" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
							<?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>

                            
	                        <div class="form-group  has-feedback <?php if($validation->getError('admin_email')) echo "has-error";?>">
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Admin_email_id'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div class="">
										<input type="text" name="admin_email" class="form-control"  placeholder="<?php echo lang('language_lang.plac_Email_id'); ?>" value="<?php echo set_value('admin_email',isset($this->data['admin_email']) ? $this->data['admin_email'] : ''); ?>">
									</div>
									<?php echo $validation->getError('admin_email', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
								<div class="col-lg-1">
									<input type="checkbox" class="switchery" name="show_email" value="1" data-on-text="SHOW" data-off-text="HIDE" <?php echo ($show_email == '1') ?  "checked" : "" ;  ?>/>
								</div>
							</div>

							<div class="form-group  has-feedback <?php if($validation->getError('email_charset')) echo "has-error";?>">
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Email_charset'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<select id="email_charset" name="email_charset" class="bootstrap-select form-control">
										<option value="UTF-8" <?php echo ($email_charset == 'UTF-8') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.utf_8'); ?></option>
										<option value="UTF-16" <?php echo ($email_charset == 'UTF-16') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.utf_16'); ?></option>
									</select>
								</div>
							</div>

                            <div class="form-group  has-feedback <?php if($validation->getError('email_throw')) echo "has-error";?>">
                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.email_throw'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<select id="email_throw" name="email_throw" class="bootstrap-select form-control">
										<option value="php" <?php echo ($email_throw == 'php') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.php'); ?></option>
										<option value="smtp" <?php echo ($email_throw == 'smtp') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.smtp'); ?></option>
									</select>
									<?php echo $validation->getError('email_throw', '<div style="right:20px;" class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<div class="smtp_display" id="smtp_display" style="display:<?php if($email_throw=='smtp'){echo "block";}else {echo "none";}?>;">

								<div class="form-group  has-feedback <?php if($validation->getError('smtp_type')) echo "has-error";?>">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.smtp_server'); ?>  <span class="text-danger">*</span></label>
									<div class="col-lg-4">
										<select id="email_throw" name="smtp_type" class="bootstrap-select form-control">
											<option value="ssl" <?php echo ($smtp_type == 'ssl') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.ssl'); ?></option>
											<option value="tsl" <?php echo ($smtp_type == 'tsl') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.tsl'); ?></option>
										</select>
									</div>
								</div>


								<div class="form-group  has-feedback <?php if($validation->getError('smtp_hostname')) echo "has-error";?>">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.smtp_hostname'); ?>  <span class="text-danger">*</span></label>
									<div class="col-lg-4">
										<input type="text" name="smtp_hostname" class="form-control"  placeholder="<?php echo lang('language_lang.plac_hostname'); ?>" value="<?php echo set_value('smtp_hostname',isset($this->data['smtp_hostname']) ? $this->data['smtp_hostname'] : ''); ?>">
	                                </div>
	                                <?php echo $validation->getError('smtp_hostname', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
	                            </div>

	                            <div class="form-group  has-feedback <?php if($validation->getError('smtp_portno')) echo "has-error";?>">
	                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.smtp_portno'); ?>  <span class="text-danger">*</span></label>
	                                <div class="col-lg-4">
										<input type="text" name="smtp_portno" class="form-control"  placeholder="<?php echo lang('language_lang.plac_portno'); ?>" value="<?php echo set_value('smtp_portno',isset($this->data['smtp_portno']) ? $this->data['smtp_portno'] : ''); ?>">
	                                </div>
	                                <?php echo $validation->getError('smtp_portno', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
	                            </div>                                								   


								<div class="form-group  has-feedback <?php if($validation->getError('smtp_username')) echo "has-error";?>">
									<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.smtp_user'); ?>  <span class="text-danger">*</span></label>
									<div class="col-lg-4">
										<div  style="width:100%;" class="input-group">
											<input type="text" name="smtp_username" class="form-control"  placeholder="<?php echo lang('language_lang.plac_smtp_username'); ?>" value="<?php echo set_value('smtp_username',isset($this->data['smtp_username']) ? $this->data['smtp_username'] : ''); ?>">
										</div>
										<?php echo $validation->getError('smtp_username', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>

								<div class="form-group  has-feedback <?php if($validation->getError('smtp_password')) echo "has-error";?>">
									<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.smtp_passwd'); ?>  <span class="text-danger">*</span></label>
									<div class="col-lg-4">
										<div style="width:100%;" class="input-group">
											<input type="password" name="smtp_password" class="form-control"  placeholder="<?php echo lang('language_lang.plac_smtp_passwd'); ?>" value="<?php echo set_value('smtp_password',isset($this->data['smtp_password']) ? $this->data['smtp_password'] : ''); ?>">
										</div>
										<?php echo $validation->getError('smtp_password', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>

							</div>
							
							<div class="text-right col-lg-7">
								<button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$(".switchery").bootstrapSwitch();


			$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.emailsetting').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            // valid: 'glyphicon glyphicon-ok',
		            // invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		        	admin_email: {
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.email_required"); ?>'
		                    },
		                    regexp: {
		                    	regexp: /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]/,
		                        message: '<?php echo lang("language_lang.email_valid"); ?>'
		                    }
		                }
		            },
		            email_charset: {
		                validators: {
		                	notEmpty: {
		                        message: '<?php echo lang("language_lang.email_charset"); ?>'
		                    }
		                }
		            },
		            email_throw: {
			            message: '<?php echo lang("language_lang.mail_gateway"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.mail_gateway_required"); ?>'
		                    }
		                }
			        },
		            smtp_hostname: {
		            	enabled: false,
		            	message: '<?php echo lang("language_lang.smtp_host_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.smtp_host_required"); ?>'
		                    }
		                    
		                }
		            },
		            smtp_portno: {
		            	enabled: false,
		            	message: '<?php echo lang("language_lang.smtp_port_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.smtp_port_required"); ?>'
		                    },
		                    digits: {
		                        message: '<?php echo lang("language_lang.smtp_port_digit"); ?>'

		                    },
		                    regexp: {
		                        regexp: /^[0-9]{1,4}$/,
		                        message: '<?php echo lang("language_lang.smtp_port_exceed"); ?>'
		                    }

		                }
		            },
		            smtp_username: {
		            	enabled: false,
		            	message: '<?php echo lang("language_lang.smtp_user_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.smtp_user_required"); ?>'
		                    }

		                }
		            },
		            smtp_password: {
		            	enabled: false,
                        message: '<?php echo lang("language_lang.smtp_passwd_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.smtp_passwd_required"); ?>'
		                    }
		                }
		            },
			        smtp_type: {
			        	enabled: false,
			            message: '<?php echo lang("language_lang.smtp_server_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.smtp_server_required"); ?>'
		                    }
		                }
			        }
		            
		        }
		    })

			// Enable smtp fields
		    $('#email_throw').on('change', function() {
		        var formValidation = $('.emailsetting').data('formValidation'), SMTPEnable  = ($(this).val() == 'smtp');
		        
		        if(SMTPEnable){
		        	$('#smtp_display').css('display','block');
		        } else {
		        	$('#smtp_display').css('display','none');
		        }

		        SMTPEnable ? $('#smtp_display').find('.form-control').removeAttr('disabled') : $('#smtp_display').find('.form-control').attr("disabled","none");

		        formValidation.enableFieldValidators('smtp_portno', SMTPEnable)
		                          .enableFieldValidators('smtp_hostname', SMTPEnable)
		                          .enableFieldValidators('smtp_username', SMTPEnable)
		                          .enableFieldValidators('smtp_password', SMTPEnable)
		                          .enableFieldValidators('smtp_type', SMTPEnable);
		    });


		    
		    var formValidation = $('.emailsetting').data('formValidation'), SMTPEnable  = ($('#email_throw').val() == 'smtp');

		    SMTPEnable ? $('#smtp_display').find('.form-control').removeAttr('disabled') : $('#smtp_display').find('.form-control').attr("disabled","none");
		    formValidation.enableFieldValidators('smtp_portno', SMTPEnable)
		                          .enableFieldValidators('smtp_hostname', SMTPEnable)
		                          .enableFieldValidators('smtp_username', SMTPEnable)
		                          .enableFieldValidators('smtp_password', SMTPEnable)
		                          .enableFieldValidators('smtp_type', SMTPEnable);
		});
	   $('#icon-bck').on('click',function() {
			window.history.back();
		});

	});
	})(jQuery);

	
	</script>

</body>
</html>
