<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php $this->load->view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/datatables.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/extensions/responsive.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/select2.min.js"></script>

	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/datatables_responsive.js"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/jgrowl.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/sweet_alert.min.js"></script>
</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php $this->load->view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php $this->load->view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo $this->lang->line('pcur_page_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php $this->load->view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo $this->lang->line('pcur_page_title'); ?></h5>
						<!--<div class="heading-elements">
							<ul class="icons-list">
								<li><a href="<?php echo base_url();?>admin/currencysettings/add" class="icon-plus-circle2"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>-->
					</div>

					<!-- <div class="panel-body">
						The <code>Responsive</code> extension for DataTables can be applied to a DataTable in one of two ways; with a specific <code>class name</code> on the table, or using the DataTables initialisation options. This method shows the latter, with the <code>responsive</code> option being set to the boolean value <code>true</code>. The <code>responsive</code> option can be given as a boolean value, or as an object with configuration options.
					</div> -->

					<table class="table datatable-responsive-row-control table-hover">
						<col width="15%">
  						<col width="12%">
  						<col width="12%">
  						<col width="12%">
  						<col width="15%">
  						<col width="12%">
  						
						<thead>
							<tr>
								<th></th>
								<th><?php echo $this->lang->line('label_cur_name');?></th>
								<th class="text-center"><?php echo $this->lang->line('label_cur_unit');?></th>
								<th class="text-center"><?php echo $this->lang->line('label_cur_symbol');?></th>
								<th class="text-center"><?php echo $this->lang->line('label_cur_status');?></th>
								<th class="text-center"><?php echo $this->lang->line('label_cur_decimal_point');?></th>
								<th class="text-center"><?php echo $this->lang->line('lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($currency_data) {
								
								$this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($currency_data as $row) {
									
									if($row->currency_status=='1'){
										$label_status = 'label-success';
										$status = $this->lang->line('active');
									} else {
										$label_status = 'label-danger';
										$status = $this->lang->line('in_active');
									}
									
							?>
							<tr>
								<td></td>
								<td><?php echo ucfirst($row->currency_name);?></td>
								<td class="text-center"><?php echo strtoupper($row->currency_unit);?></td>
								<td class="text-center"><?php echo $row->currency_symbol;?></td>
								<td class="text-center"><span class="label <?php echo $label_status;?>"><?php echo $status;?></span></td>
								<td class="text-center"><?php echo $row->deimal_point;?></td>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>
											<ul class="dropdown-menu dropdown-menu-right">
												<li><a href="<?php echo base_url().'admin/paysettings/add/'.$myencrypt->encode($row->currency_id);?>"><i class="fa fa-edit"></i> <?php echo $this->lang->line('edit');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {



	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($this->session->flashdata('error_message')) { ?>
					$.jGrowl("<?php echo $this->session->flashdata('error_message');?>", {
			            header: '<?php echo $this->lang->line("error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($this->session->flashdata('success_message')) { ?>
	                $.jGrowl("<?php echo $this->session->flashdata('success_message');?>", {
			            header: '<?php echo $this->lang->line("success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});
		});

	})(jQuery);

	function makeDefault(valus) {
		var valus1 =  valus;
		jQuery.ajax({
            type: 'post',
            url:'<?php echo base_url();?>admin/currencysettings/makedefaults',
            data: {'id':valus1},
            success : function(resp)
            {
                if(resp==1)
                    window.location.href = "<?php echo base_url();?>admin/currencysettings";
                else
                    console.log('fail');
            }
        });
	}

	function confirmdelete(value) {
		swal({
            title: "<?php echo $this->lang->line('delete_currency');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url();?>admin/paysettings/delete/"+value;
            }
        });
    }
	</script>

</body>
</html>
