<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php

		helper('form');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- file upload JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/uploaders/fileinput.min.js');?>"></script>
	

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>
	

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->

	<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

    <!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.withdraw_page_title'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
						    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
						<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>

			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>	
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.withdraw_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>
                	<?php //print_r(defaultcurrency()->currency_name);?>
                	<?php $currency_info = defaultcurrency();?>
					<div class="panel-body">
						<form class="form-horizontal form-withdraw" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
							<?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>
							<div  class="form-group  has-feedback <?php if($validation->getError('with_fee')) echo "has-error";?>" >
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Withdrawal_fee'); ?> (USDT)  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div style="width:100%;" class="input-group">
										<input type="text" name="with_fee" class="form-control"  placeholder="<?php echo lang('language_lang.plac_with_fee'); ?>" value="<?php echo set_value('with_fee',isset($this->data['with_fee']) ? number_format($this->data['with_fee'],2, '.', '') : ''); ?>">
									</div>
									<?php echo $validation->getError('with_fee', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

					

							<div  class="form-group  has-feedback <?php if($validation->getError('with_min_fee')) echo "has-error";?>" style='display:none;'>
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Minimal_withdrawal_fee'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div class="input-group">
									<span class="input-group-addon" style="font-size: 18px;"><strong><?php echo $currency_info->currency_symbol;?></strong></span>										
										<input type="text" name="with_min_fee" class="form-control"  placeholder="<?php echo lang('language_lang.plac_min_with_fee'); ?>" value="<?php echo set_value('with_min_fee',isset($this->data['with_min_fee']) ? number_format($this->data['with_min_fee'], $currency_info->deimal_point, '.', '') : ''); ?>">
									<span class="input-group-addon"><?php echo strtoupper($currency_info->currency_unit);?></span>
									
									</div>
									<?php echo $validation->getError('with_min_fee', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<div  class="form-group  has-feedback <?php if($validation->getError('with_min_amt')) echo "has-error";?>" style='display:block;'>
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Minimal_withdraw_amnt'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div  style="width:100%;" class="input-group">
										<input type="text" name="with_min_amt" class="form-control"  placeholder="<?php echo lang('language_lang.plac_min_with_amnt'); ?>" value="<?php echo set_value('with_min_amt',isset($this->data['with_min_amt']) ? number_format($this->data['with_min_amt'], $currency_info->deimal_point, '.', '') : ''); ?>">
									
									</div>
									<?php echo $validation->getError('with_min_amt', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>
							<div  class="form-group  has-feedback <?php if($validation->getError('with_max_amt')) echo "has-error";?>" style='display:block;'>
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Maximal_withdraw_amnt'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div  style="width:100%;" class="input-group">
										<input type="text" name="with_max_amt" class="form-control"  placeholder="<?php echo lang('language_lang.plac_max_with_amnt'); ?>" value="<?php echo set_value('with_max_amt',isset($this->data['with_max_amt']) ? number_format($this->data['with_max_amt'], $currency_info->deimal_point, '.', '') : ''); ?>">
 									</div>
									<?php echo $validation->getError('with_max_amt', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<div class="form-group  has-feedback <?php if($validation->getError('with_limit')) echo "has-error";?>">
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Limit_withdraw_period'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-3">
									<div style="width:100%;" class="input-group">
										<input type="text" name="with_limit" class="form-control"  placeholder="<?php echo lang('language_lang.plac_with_period'); ?>" value="<?php echo set_value('with_limit',isset($this->data['with_limit']) ? $this->data['with_limit'] : ''); ?>">
									</div>
									<?php echo $validation->getError('with_limit', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>

                                <div class="form-group  has-feedback <?php if($validation->getError('with_period_type')) echo "has-error";?>">
									<div class="col-lg-1">
										<select name="with_period_type" class="bootstrap-select form-control">
											<option value="day" <?php echo ($with_period_type == 'day') ?  "selected" : "" ;  ?>><?php echo ucfirst(lang('language_lang.day'));?></option>
											<option value="week" <?php echo ($with_period_type == 'week') ?  "selected" : "" ;  ?>><?php echo ucfirst(lang('language_lang.week'));?></option>
											<option value="month" <?php echo ($with_period_type == 'month') ?  "selected" : "" ;?>><?php echo ucfirst(lang('language_lang.month'));?></option>
											<option value="year" <?php echo ($with_period_type == 'year') ?  "selected" : "" ;  ?>><?php echo ucfirst(lang('language_lang.year'));?></option>
										</select>
										<?php echo $validation->getError('with_period_type', '<div style="right:20px;" class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>
							</div>

												<div class="form-group" style="display: block;">
                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.lbl_instant_withdraw'); ?></label>
	                            <div class="col-lg-4">
		                            <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" data-on-color="success" data-off-color="danger" class="switchery" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="with_instant" <?php if($with_instant==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>



                            <div class="form-group">
                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Transaction_passwd_withdraw'); ?></label>
	                            <div class="col-lg-4">
		                            <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" data-on-color="success" data-off-color="danger" class="switchery" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="with_use_pin" <?php if($with_use_pin==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>

							<br/>
							<h5 class="panel-title">Transfer Settings</h5>
							<br/>

										<div  class="form-group  has-feedback <?php if($validation->getError('trans_fee')) echo "has-error";?>" >
								<label class="control-label col-lg-3 text-semibold">Transfer Fee (USDT)  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div style="width:100%;" class="input-group">
										<input type="text" name="trans_fee" class="form-control"  placeholder="Enter Amount" value="<?php echo set_value('trans_fee',isset($this->data['trans_fee']) ? number_format($this->data['trans_fee'],2, '.', '') : ''); ?>">
									</div>
									<?php echo $validation->getError('trans_fee', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>


							<div  class="form-group  has-feedback <?php if($validation->getError('trans_min_amt')) echo "has-error";?>" style='display:block;'>
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Minimal_withdraw_amnt'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div  style="width:100%;" class="input-group">
										<input type="text" name="trans_min_amt" class="form-control"  placeholder="Set minimum transfer amount" value="<?php echo set_value('trans_min_amt',isset($this->data['trans_min_amt']) ? number_format($this->data['trans_min_amt'], $currency_info->deimal_point, '.', '') : ''); ?>">
									
									</div>
									<?php echo $validation->getError('trans_min_amt', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>
							<div  class="form-group  has-feedback <?php if($validation->getError('trans_max_amt')) echo "has-error";?>" style='display:block;'>
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Maximal_withdraw_amnt'); ?>  <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div  style="width:100%;" class="input-group">
										<input type="text" name="trans_max_amt" class="form-control"  placeholder="Set maximum transfer amount" value="<?php echo set_value('trans_max_amt',isset($this->data['trans_max_amt']) ? number_format($this->data['trans_max_amt'], $currency_info->deimal_point, '.', '') : ''); ?>">
 									</div>
									<?php echo $validation->getError('trans_max_amt', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

											<div class="form-group  has-feedback <?php if($validation->getError('with_limit')) echo "has-error";?>">
								<label class="control-label col-lg-3 text-semibold"> Limit Transfer Period  <span class="text-danger">*</span></label>
								<div class="col-lg-3">
									<div style="width:100%;" class="input-group">
										<input type="text" name="trans_limit" class="form-control"  placeholder="<?php echo lang('language_lang.plac_with_period'); ?>" value="<?php echo set_value('trans_limit',isset($this->data['trans_limit']) ? $this->data['trans_limit'] : ''); ?>">
									</div>
									<?php echo $validation->getError('trans_limit', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>

                                <div class="form-group  has-feedback <?php if($validation->getError('trans_period_type')) echo "has-error";?>">
									<div class="col-lg-1">
										<select name="trans_period_type" class="bootstrap-select form-control">
											<option value="day" <?php echo ($trans_period_type == 'day') ?  "selected" : "" ;  ?>><?php echo ucfirst(lang('language_lang.day'));?></option>
											<option value="week" <?php echo ($trans_period_type == 'week') ?  "selected" : "" ;  ?>><?php echo ucfirst(lang('language_lang.week'));?></option>
											<option value="month" <?php echo ($trans_period_type == 'month') ?  "selected" : "" ;?>><?php echo ucfirst(lang('language_lang.month'));?></option>
											<option value="year" <?php echo ($trans_period_type == 'year') ?  "selected" : "" ;  ?>><?php echo ucfirst(lang('language_lang.year'));?></option>
										</select>
										<?php echo $validation->getError('trans_period_type', '<div style="right:20px;" class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>
							</div>

		
							<!-- <div class="form-group">
                                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.withdraw_fees'); ?></label>
	                            <div class="col-lg-4">
		                            <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" data-on-color="success" data-off-color="danger" class="switchery" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="with_instant" <?php if($with_instant==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div> -->

							<div class="text-right col-lg-7">
								<button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
							
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php //echo site_footer();?>
			<!-- &amp;copy; 2015. <a href="#">Limitless Web App Kit</a> by <a href="http://themeforest.net/user/Kopyov" target="_blank">Eugene Kopyov</a> -->
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.form-withdraw').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            // valid: 'glyphicon glyphicon-ok',
		            // invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            with_fee: {
		                message: '<?php echo lang("language_lang.withdraw_fee_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.withdraw_fee_required"); ?>'
		                    },
		                    regexp: {
		                        regexp: /^[0-9.]+$/,
		                        message: '<?php echo lang("language_lang.withdraw_fee_num"); ?>'
		                    }
		                }
		            },
		            with_min_fee: {
		                message: '<?php echo lang("language_lang.withdraw_fee_minimum"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.withdraw_fee_minimum"); ?>'
		                    },
		                    regexp: {
		                        regexp: /^[0-9.]+$/,
		                        message: '<?php echo lang("language_lang.withdraw_fee_min_num"); ?>'
		                    }
		                }
		            },
		            with_min_amt: {
		                message: '<?php echo lang("language_lang.withdraw_min_amnt_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.withdraw_min_amnt_required"); ?>'
		                    },
		                    regexp: {
		                        regexp: /^[0-9.]+$/,
		                        message: '<?php echo lang("language_lang.withdraw_min_amnt_valid_dot"); ?>'
		                    },
		                    lessThan: {
		                    	value: 'with_max_amt',
	                            message: '<?php echo lang("language_lang.withdraw_min_amnt_lessthan"); ?>'
	                        }
		                    
		                }
		            },
		            with_max_amt: {
		                message: '<?php echo lang("language_lang.withdraw_max_amnt_valid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.withdraw_max_amnt_required");?>'
		                    },
		                    regexp: {
		                        regexp: /^[0-9.]+$/,
		                        message: '<?php echo lang("language_lang.withdraw_max_amnt_valid_dot"); ?>'
		                    },
		                    greaterThan: {
		                        value: 'with_min_amt',
		                        message: '<?php echo lang("language_lang.withdraw_max_amnt_graterthan"); ?>'
		                    }
		                }
		            },
		            with_daily_limit: {
		                message: '<?php echo lang("language_lang.withdraw_daily_limit_valid");?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.withdraw_daily_limit_required"); ?>'
		                    },
		                    digits: {
		                        message: '<?php echo lang("language_lang.withdraw_daily_limit_number"); ?>'
		                    }
		                }
		            },
		            		            
		        }
		    })
		});
	    
	    $('#icon-bck').on('click',function() {
			window.history.back();
		});
	    $(".switchery").bootstrapSwitch();

	});
	})(jQuery);

	
	</script>

</body>
</html>
