<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php

		$this->session = session();
		use App\Libraries\MyEncrypt;

		 echo view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <link href="<?php echo base_url('assets/css/icons/fontawesome/styles.min.css');?>" rel="stylesheet" type="text/css">

    <!-- Theme JS files -->
	
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>
	<!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->


	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/bootbox.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>
	<!-- /theme JS files -->
</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.tickt_manage'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.tickt_manage'); ?></h5>
						<div class="heading-elements">
						    <ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<table class="table datatable-responsive-row-control table-hover">
					<colgroup>
						<col width="5%">
						<col width="10%">
						<col width="15%">
						<col width="10%">
						<col width="15%">
						<col width="15%">
						<col width="10%">
						<col width="15%">
						<col width="5%">
					</colgroup>
						<thead>
							<tr><th></th>
							<th><?php echo lang('language_lang.exp_report_sno'); ?></th>
								<!-- <th class=""><?php echo lang('language_lang.ticket_no_lbl');?></th> -->
								<th class="">Email</th>
								<th><?php echo lang('language_lang.lbl_mail_subject');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_mail_message');?></th>
								<th class="text-center"><?php echo lang('language_lang.ticket_contact_mail');?></th>
								<!-- <th class="text-center"><?php echo lang('language_lang.lbl_mail_status');?></th> -->
								<th class="text-center"><?php echo lang('language_lang.lbl_date');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_options');?></th>
							</tr>
						</thead>
						<tbody>
						<?php
							if($ticketlist) {
								$i=1;
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
							
								foreach ($ticketlist as $row) {

									$encode_data = $myencrypt->encode($row->ticket_no);
                                    
                                    $condition = "uusersid = '".$row->uusers_id."'";
									$username = $this->common_model->GetRow('uusers',$condition);

									if($row->ticket_status == 'close'){
										$class = "label bg-danger";
									}
									elseif ($row->ticket_status == 'new') {
										$class = "label bg-primary";
									}
									else{
										$class = "label bg-grey-400";
									}
							?>
							<tr>
							    <td></td>
							    <td><?php echo $i; ?></td>
		<!-- <td class=""><a href="<?php echo base_url("admin/support/ticketdetails/".$encode_data); ?>"><?php echo ucfirst($row->ticket_no);?></a></td> -->
							    <td class=""><?php echo ucfirst(($username->email) ? $username->email : '');?></td>
								<td><?php echo ucfirst($row->subject);?></td>
								<td class="text-center">
									<button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal_theme_primary<?php echo $row->ticket_id;?>"><?php echo lang('language_lang.view_content'); ?> <i class="fa fa-search position-right"></i></button></td>
								</td>
							<td class="text-center"><?php if($row->contact_mail) { echo $row->contact_mail; } else { echo "Nil";} ?></td>
						<!-- <td class="text-center"><span class="<?php echo $class; ?>"><?php echo ucfirst($row->ticket_status);?></span></td> -->
								<td class="text-center"><?php echo $row->post_date;?></td>
								<td class="text-center">
                <!--  <a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.reply');?>"  href="<?php echo base_url('admin/support/ticketdetails/'.$encode_data);?>"><i class="fa fa-reply"></i></a> -->
                            <?php if($row->image) { ?>
                               <a target="_blank" href="<?php echo base_url('uploads/tickets/'.$row->image);?>">view</a> &nbsp;&nbsp;
                            <?php } ?>
                                	<a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.delete');?>"  onclick="confirmdelete('<?php echo $row->ticket_id;?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i></a>
                                </td>
							</tr>
						<?php 
								$i++;
							}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->

			<!-- Basic modal -->
            <?php if($ticketlist) { foreach ($ticketlist as $row) { ?>
				<div id="modal_theme_primary<?php echo $row->ticket_id;?>" class="modal fade" >
					<div class="modal-dialog">
						<div class="modal-content">
							<div class="modal-header bg-primary">
								<button type="button" class="close" data-dismiss="modal">&times;</button>
								<h5 class="modal-title"><b><?php echo lang('language_lang.ticket_no_lbl'); ?>:</b>&nbsp<?php echo $row->ticket_no;?></h5>
							</div>

							<div style="height:200px;overflow-y:scroll;" class="modal-body">
								<b style="font-size: 15px;"><?php echo lang('language_lang.lbl_mail_message'); ?>:</b>&nbsp<?php echo ucfirst($row->message);?>
							</div>

							<div class="modal-footer">
								<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
							</div>
						</div>
					</div>
				</div>
				<? } } ?>
				<!-- /basic modal -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {

	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($this->session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $this->session->getFlashData('error_message');?>", {
			            header: 'Error!',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($this->session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $this->session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});
				

				// $('#language_change').on('change', function() {
				//     console.log($this.val);
				// });
		});

	})(jQuery);
	
	function changeStatus(valus) {
         swal({
            title: "<?php echo lang('language_lang.confirm_status_change');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/support/changeStatus/');?>"+'/'+valus;
            }
            else {
              return false;
            }
		
		});
	}
	// function changeActiveStatus(valus) {
	// 	swal({
 //            title: "<?php echo lang('language_lang.confirm_status_change');?>",
 //            showCancelButton: true,
 //            closeOnConfirm: false,
 //            confirmButtonColor: "#2196F3",
 //            showLoaderOnConfirm: true
 //        },
 //       function(inputValue) {
 //            if(inputValue === true){
 //             window.location.href = "<?php echo base_url();?>admin/news/changeActiveStatus/"+valus;
 //            }
 //            else {
 //              return false;
 //            }
		
	// 	});
	// }
	function confirmdelete(value) {
		swal({
            title: "<?php echo lang('language_lang.delete_ticket');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/support/deleteticket/');?>"+'/'+value;
            }
            else {
              return false;
            }

		});
    }

	
	</script>

</body>
</html>
