<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Revenue</title>
      <?php echo view('user/layout/head');?>
      <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">
   </head>
   <style>
      .notify {
      position: fixed;
      top: 10px;
      left: 10px;
      -moz-box-sizing: border-box;
      box-sizing: border-box;
      width: 350px;
      font-size: 14px;
      text-align: center;
      }
      /* Positions
      ========================================================================== */
      .notify-top-right,
      .notify-bottom-right {
      left: auto;
      right: 10px;
      }
      .notify-top-center,
      .notify-bottom-center {
      left: 50%;
      margin-left: -175px;
      }
      .notify-bottom-left,
      .notify-bottom-right,
      .notify-bottom-center {
      top: auto;
      bottom: 10px;
      }
      .notify button {
      -webkit-appearance: none;
      padding: 0;
      cursor: pointer;
      background: 0 0;
      border: 0;
      display: none;
      }
      /* Responsiveness
      ========================================================================== */
      /* Phones portrait and smaller */
      @media (max-width: 479px) {
      /*
      * Fit in small screen
      */
      .notify {
      left: 10px;
      right: 10px;
      width: auto;
      margin: 0;
      }
      }
      /* Sub-object: `notify-message`
      ========================================================================== */
      .notify-message {
      position: relative;
      cursor: pointer;
      }
      .notify .alert-default {
      background: #fff;
      border: 1px solid #e5e5e5;
      }
      .test
      {
      margin-left : 35px;
      }
   </style>
   <body class="reg-overflow">
      <section class="dash-banner-bg banner-bg">
         <div class="container">
         <!---header start---->
         <?php echo view('user/layout/header');?>
         <!---header end---->
         <!---banner start---->
         <div class="row">
            <div class="col-lg-12">
               <?php 
                  use App\Libraries\MyEncrypt;
                  use App\Helpers\site_helper;
                  use App\Helpers\form_helper;
                  $this->db = db_connect();
                  $this->session = session();
                  $this->common_model = model('CommonModel');
                  helper('form_helper');
                  
                  $uusersid = $this->session->get('uusersid');
                  $user=$this->db->query("SELECT * FROM uusers WHERE uusersid='".$uusersid."'")->getRow();
                  
                   $country = $this->db->query("SELECT * FROM country WHERE iso_2='".$user->country."'")->getRow();
                  
                  
                  
                  
                  ?>
               <div class="dash-wrap">
                  <div class="title text-center py-1">
                     <div class="row">
                        <div class="col-lg-3 offset-lg-1">
                           <a href="<?php echo base_url();?>/user/profile"  class="btn btn-primary" style="border-radius:20px">back</a>
                        </div>
                        <div class="col-lg-4">
                           <h2 class="text-primary ">My Profile</h2>
                        </div>
                     </div>
                  </div>
                  <div class="col-lg-10 offset-lg-1 ">
                     <div class="reg-page">
                        <div class="row mt-4">
                           <form action="" method="post" id="edit-profile" >
                              <div class="col-lg-12">
                                 <div class="form-block form-group mb-3 " >
                                    <label class="form-label">Username</label>
                                    <input name="image" class="form-control" type="file" id="imageInput"/>
                                 </div>
                              </div>
                              <div class="col-lg-12">
                                 <button type="submit" class="btn btn-primary">Edit</button>
                              </div>
                           </form>
                           <div class="col-lg-12 mt-3">
                              <div class="form-block form-group mb-3 " >
                                 <label class="form-label" style="text-align:start !important">Username</label>
                                 <input name="username" class="form-control" type="text" id="username"  value="<?php echo $user->username;?>" readonly/>
                              </div>
                           </div>
                           <div class="col-lg-12">
                              <div class="form-block form-group mb-3 " >
                                 <label class="form-label" style="text-align:start !important">Email</label>
                                 <input name="email" class="form-control " type="text" id="email"  value="<?php echo $user->email;?>" readonly/>
                              </div>
                           </div>
                           <div class="col-lg-12">
                              <div class="form-block form-group mb-3 " >
                                 <label class="form-label" style="text-align:start !important">Location</label>
                                 <input name="location" class="form-control" type="text" id="location"  value="<?php echo $country->Country;?>" readonly/>
                              </div>
                           </div>
                           <div class="col-lg-12">
                              <div class="form-block form-group mb-3 " >
                                 <label class="form-label">Pricing method</label>
                                 <select class="form-control form-arrow" name="pricing_method">
                                    <option value="USD" selected>USD</option>
                            
                                 </select>
                            
                              </div>
                           </div>
                           <div class="col-lg-12">
                              <div class="form-block form-group mb-3 " >
                                 <label class="form-label" style="text-align:start !important">Language</label>
                                 <select class="form-control" name="lang">
                                    <option value="USD" selected>English</option>
                                 </select>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <?php echo view('user/layout/footer');?>
         </div>
      </section>
      <?php echo view('user/layout/footer-script');?>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
      <script src="<?php echo base_url()?>/styles/new_style/js/notify.js"></script>
      <script>
         $(document).ready(function(){
         
         
            
         $('#edit-profile').submit(function(event) {
         event.preventDefault(); // Prevent the form from submitting normally
         
         var form = new FormData(this);
         $.ajax({
         url: '<?php echo base_url();?>/profile_update', 
         type: 'POST',
         data: form,
         processData: false,
         contentType: false,
         success: function(response) {
         
         if(response == '1')
         {
         
         $.notify(' <i class="fas fa-circle-check"></i>&nbsp;&nbsp;  Profile image updated successfully. ', 'success');
         
         }
         else if(response == '2')
         {
         $.notify(' <i class="fas fa-exclamation-triangle"></i>&nbsp;&nbsp; Please select profile image first. ', 'danger'); 
         }
         else
         {
         $.notify(' <i class="fas fa-exclamation-triangle"></i>&nbsp;&nbsp; Profile image updated failed. ', 'danger');
         }
         }
         
         });
         });
         
         });
         
         
      </script>
   </body>
</html>