<?php

namespace App\Controllers\User;
use App\Views;
use App\Models\CommonModel;

class EarningHistory extends BaseController
{
	public function __construct(){
		// $CommonModel = new CommonModel();
		$CommonModel = model('CommonModel');
		$this->db = db_connect();
		$session = \Config\Services::session();
	}
   public function index() {
   		$this->db = db_connect();
		$this->common_model = model('CommonModel');
		$this->finance_model = model('finance_model');
	    $this->userdash_model = model('userdash_model');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!($session->get('user_login') || $session->get('admin_login')))
		{			
			return redirect()->to('login');
		}
		$this->indexpage();
    }
	
	public function indexpage() {
		$this->session = session();
		$uusersid = $this->session->get('uusersid');

        $CommonModel = model('CommonModel');
		$condition = "payment_key in('logo','status')";
		$payment_data_list = $CommonModel->GetPaymentsName($condition);
		$site_data = $CommonModel->GetSettingall('infobox');
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		} else {
			$site_data_default = $CommonModel->defaultlangSettingall('infobox');
			foreach ($site_data_default as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}
		}

		$site_lang_data = $CommonModel->GetSiteSettings('site');
		
		if($site_lang_data){	
			$site_data = array_merge($site_data, $site_lang_data);
		}

		foreach ($site_data as $row) {
			$this->data[$row->site_key] = $row->site_value;
		}
        $type = ['trade_profit','commissions','fuel'];
      
		$this->data['transaction_history'] = $this->db->table('history')->where('uusersid',$uusersid)->whereNotIn('type',$type)->orderBy('historyid','DESC')->get()->getResult();

		$curdate = date('Y-m-d');

		// $this->data['today_reward_profit'] = curbalancetoday($uusersid);
		// $this->data['total_reward_profit'] = curbalance($uusersid);


		$this->data['today_profit'] = $CommonModel->today_profit($uusersid);

		$this->data['total_profit'] = $CommonModel->total_profit($uusersid);

	 //    $this->data['total_activation_reward'] = $CommonModel->today_reward_profit($uusersid);
		// $this->data['today_activation_reward'] = $CommonModel->total_reward_profit($uusersid);

		$curdate = date('Y-m-d');


	$this->data['total_activation_reward'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE  `type` = 'commissions'  AND (`description` LIKE '%Reward Activation%' OR `description` LIKE '%Direct commission%' OR `description` LIKE '%Rank Activation%')  AND uusersid = '".$uusersid."' ORDER BY `uusersid` DESC ")->getRow();

	$this->data['today_activation_reward'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE uusersid = '".$uusersid."' AND `date` LIKE '%$curdate%' AND  `type` = 'commissions' AND (`description`LIKE '%Reward Activation%' OR `description` LIKE '%Direct commission%' OR `description` LIKE '%Rank Activation%') ORDER BY `uusersid` DESC")->getRow();

	$this->data['total_reward_profit'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE  `type` = 'commissions'  AND uusersid = '".$uusersid."'  ORDER BY `historyid` DESC ")->getRow();

	$this->data['today_reward_profit'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE `type` = 'commissions'  AND uusersid = '".$uusersid."' AND `date` LIKE '%$curdate%' ORDER BY `historyid` DESC ")->getRow();

		

      $this->data['total_team_reward'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE uusersid = '".$uusersid."' AND `type` = 'commissions' AND (`description` LIKE '%Direct trading profit%' OR  `description` LIKE '%Trading profit Level%') ORDER BY `historyid` DESC ")->getRow();
      $this->data['today_team_reward'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE `date` LIKE '%$curdate%' AND uusersid = '".$uusersid."' AND `type` = 'commissions' AND (`description` LIKE '%Direct trading profit%' OR  `description` LIKE '%Trading profit Level%') ORDER BY `historyid` DESC")->getRow();

       $this->data['total_peer_reward'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE uusersid = '".$uusersid."' AND `type` = 'commissions' AND `description` LIKE '%Same Rank%' ORDER BY `historyid` DESC ")->getRow();

		$this->data['today_peer_reward'] = $this->db->query("SELECT SUM(amount) as profit FROM `history`  WHERE `date` LIKE '%$curdate%' AND uusersid = '".$uusersid."' AND `type` = 'commissions' AND `description` LIKE '%Same Rank%' ORDER BY `historyid` DESC ")->getRow();

		$this->data['total_fuel_deduction'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE uusersid = '".$uusersid."' AND `type` = 'fuel' ORDER BY `historyid` DESC ")->getRow();

		$this->data['today_fuel_deduction'] = $this->db->query("SELECT SUM(amount) as profit FROM `history` WHERE uusersid = '".$uusersid."' AND `type` = 'fuel' and `date` > DATE(now()) ORDER BY `historyid` DESC ")->getRow();
		
		$this->data['datewis_profit'] = $this->db->query("SELECT date(date) as Time,SUM(amount) as profit FROM `history` WHERE uusersid = '".$uusersid."' AND (type = 'trade_profit' OR type = 'circle_profit') GROUP BY cast(date as date) ORDER BY historyid DESC LIMIT 30 ")->getResult();

		$this->data['sell'] = $this->db->query("SELECT * FROM `api_trade_history` WHERE uuserid = '".$uusersid."' AND `type` = '2' ORDER BY `id` DESC ")->getResult();
	
		$this->data['all_rewards'] = $this->db->query("SELECT * FROM `history` WHERE uusersid = '".$uusersid."' AND `type` IN('commissions')  ORDER BY `historyid` DESC ")->getResult();

		$this->data['activation_reward'] = $this->db->query("SELECT * FROM `history` WHERE uusersid = '".$uusersid."' AND  `type` = 'commissions'  AND (`description` LIKE '%Reward Activation%' OR `description` LIKE '%Direct Commission%' OR `description` LIKE '%Rank Activation%') ORDER BY `historyid`  DESC")->getResult();
        $this->data['team_reward'] = $this->db->query("SELECT * FROM `history` WHERE uusersid = '".$uusersid."' AND `type` = 'commissions' AND (`description` LIKE '%Direct trading profit%' OR `description` LIKE '%Trading profit Level%') ORDER BY `historyid` DESC ")->getResult();

		$this->data['peer_reward'] = $this->db->query("SELECT * FROM `history` WHERE uusersid = '".$uusersid."' AND `type` = 'commissions' AND `description` LIKE '%Same Rank%' ORDER BY `historyid` DESC ")->getResult();

		$this->data['fuel_deduction'] = $this->db->query("SELECT * FROM `history` WHERE uusersid = '".$uusersid."' AND `type` = 'fuel' AND amount > 0 ORDER BY `historyid` DESC ")->getResult();


	

		echo view('user/rewardbalance',$this->data);
	}


	public function gaswallet()
	{

		$this->session = session();
		$uusersid = $this->session->get('uusersid');

        $CommonModel = model('CommonModel');
      
        $earnings=$this->db->query("select sum(amount) as amount from history where uusersid='".$uusersid."' and type='transfer_gaswallet'")->getRow();
        $this->data['earnings']=$earnings->amount;

        $expense=$this->db->query("select sum(amount) as amount from history where uusersid='".$uusersid."' and type='deducted_gaswallet'")->getRow();
        $this->data['expense']=$expense->amount;

		$this->data['records'] = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('transfer_gaswallet','deducted_gaswallet') ORDER BY `historyid` DESC limit 10")->getResult();
        $this->data['total_count'] =$this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('transfer_gaswallet','deducted_gaswallet')")->getNumRows();
        echo view('user/gaswallet_history',$this->data);
	}


	function gaswallet_records()
	{
        $this->common_model = model('CommonModel');
        $session = \Config\Services::session();
        //print_r($this->request->getpost());

        $uusersid = $this->request->getPost('uusersid');
        $page = $this->request->getPost('page');
        $itemsPerPage = $this->request->getPost('itemsPerPage');
        $offset = ($page - 1) * $itemsPerPage;
        $start_date = $this->request->getPost('start_date');
        $end_date = $this->request->getPost('end_date');

        // print_r($page);
        // echo "<br>";

	if($start_date!='' && $end_date!='')
	{
        $start_date=date("Y-m-d 00:00:00",strtotime($start_date));
        $end_date=date("Y-m-d 23:59:59",strtotime($end_date));
        $totalItems = $this->db->query("select * from `history`  WHERE date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type in('transfer_gaswallet','deducted_gaswallet') ORDER BY `historyid` DESC ")->getNumRows();
        $get_records = $this->db->query("select * from `history` WHERE  date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type in('transfer_gaswallet','deducted_gaswallet') ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
    }
	else
	{
		$totalItems = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('transfer_gaswallet','deducted_gaswallet') ORDER BY `historyid` DESC ")->getNumRows();
        $get_records = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('transfer_gaswallet','deducted_gaswallet') ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
    }
	
	$totalPages = ceil($totalItems / $itemsPerPage);
    $items = array();

	if($get_records)
	{
		foreach($get_records as $row)
		{
            $type=str_replace('_',' ',$row->type);
            $type=ucwords($type);
            
            if($row->type=='deducted_gaswallet')
            {
                $amount='<label class="btn btn-danger">'.number_format($row->amount,4).'</label>';
                $description_check=str_replace('fuel fee deduction for order no','',$row->description);
                $get_order=$this->db->query("select * from api_trade_history where order_id='".trim($description_check)."'")->getRow();
                if($get_order)
                {
                    $base=substr($get_order->pair,0,-4);
                    $pair=$base.'/USDT';
                    $description='Fuel Fee &nbsp;: ['.$pair.'&nbsp;TurnOver &nbsp;:&nbsp;'.$get_order->comm_price.'] orderno :'.$get_order->order_id;
                  
                }
            }
            else
            {
                $amount='<label class="btn btn-success">'.number_format($row->amount,4).'</label>';
                $description = $row->description;
            }
		    $items[] = [
				'amount' =>  $amount,
				'date' => $row->date,
                'type' => $type,
                'description' =>$description
            ];

		}
	}
	

	echo json_encode([
		'items' => $items,
		'hasPrev' => $page > 1,
		'hasNext' => $page < $totalPages,
		'totalPages' => $totalPages,
		'totalitems' => $totalItems
	]);

	}


    public function assetwallet()
	{

		$this->session = session();
		$uusersid = $this->session->get('uusersid');

        $CommonModel = model('CommonModel');
      
        $earnings=$this->db->query("select sum(amount) as amount from history where uusersid='".$uusersid."' and type in('bonus','deposit','commissions','fund_received')")->getRow();
        $this->data['earnings']=$earnings->amount;

        $expense=$this->db->query("select sum(amount) as amount from history where uusersid='".$uusersid."' and type IN('withdrawal','withdraw_request','withdraw_fee','transfer','transfer_fee','penalty','activation','rank_activation','transfer_gaswallet')")->getRow();
        $this->data['expense']=$expense->amount;

		$this->data['records'] = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('withdrawal','withdraw_request','withdraw_fee','transfer','transfer_fee','penalty','activation','rank_activation','transfer_gaswallet','bonus','deposit','commissions','fund_received') ORDER BY `historyid` DESC limit 10")->getResult();
        $this->data['total_count'] =$this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('withdrawal','withdraw_request','withdraw_fee','transfer','transfer_fee','penalty','activation','rank_activation','transfer_gaswallet','bonus','deposit','commissions','fund_received')")->getNumRows();
        echo view('user/assetwallet_history',$this->data);
	}



    function assetwallet_records()
	{
        $this->common_model = model('CommonModel');
        $session = \Config\Services::session();
        //print_r($this->request->getpost());

        $uusersid = $this->request->getPost('uusersid');
        $page = $this->request->getPost('page');
        $itemsPerPage = $this->request->getPost('itemsPerPage');
        $offset = ($page - 1) * $itemsPerPage;
        $start_date = $this->request->getPost('start_date');
        $end_date = $this->request->getPost('end_date');

        // print_r($page);
        // echo "<br>";

	if($start_date!='' && $end_date!='')
	{
        $start_date=date("Y-m-d 00:00:00",strtotime($start_date));
        $end_date=date("Y-m-d 23:59:59",strtotime($end_date));
        $totalItems = $this->db->query("select * from `history`  WHERE date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type in('withdrawal','withdraw_request','withdraw_fee','transfer','transfer_fee','penalty','activation','rank_activation','transfer_gaswallet','bonus','deposit','commissions','fund_received') ORDER BY `historyid` DESC ")->getNumRows();
        $get_records = $this->db->query("select * from `history` WHERE  date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type in('withdrawal','withdraw_request','withdraw_fee','transfer','transfer_fee','penalty','activation','rank_activation','transfer_gaswallet','bonus','deposit','commissions','fund_received') ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
    }
	else
	{
		$totalItems = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('withdrawal','withdraw_request','withdraw_fee','transfer','transfer_fee','penalty','activation','rank_activation','transfer_gaswallet','bonus','deposit','commissions','fund_received') ORDER BY `historyid` DESC ")->getNumRows();
        $get_records = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('withdrawal','withdraw_request','withdraw_fee','transfer','transfer_fee','penalty','activation','rank_activation','transfer_gaswallet','bonus','deposit','commissions','fund_received') ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
    }
	
	$totalPages = ceil($totalItems / $itemsPerPage);
    $items = array();

	if($get_records)
	{
		foreach($get_records as $row)
		{
            $type=str_replace('_',' ',$row->type);
            $type=ucwords($type);

            if($row->type=='bonus' || $row->type=='commissions' || $row->type=='deposit' || $row->type=='fund_received')
            {
                $amount='<label class="btn btn-success">'.number_format($row->amount,4).' USDT</label>';
                $description=$row->description;
               
                
            }
            else
            {
                $amount='<label class="btn btn-danger">'.number_format($row->amount,4).' USDT</label>';
                $description = $row->description;
                if($row->type=='fuel' || $row->type=='deducted_gaswallet')
                {
                    $description_check=str_replace('fuel fee deduction for order no','',$row->description);
                    $get_order=$this->db->query("select * from api_trade_history where order_id='".trim($description_check)."'")->getRow();
                    if($get_order)
                    {
                        $base=substr($get_order->pair,0,-4);
                        $pair=$base.'/USDT';
                        $description='Fuel Fee &nbsp;: ['.$pair.'&nbsp;TurnOver &nbsp;:&nbsp;'.$get_order->comm_price.'] orderno :'.$get_order->order_id;
                      
                    }
                    
                }
            }
		    $items[] = [
				'amount' =>  $amount,
				'date' => $row->date,
                'type' => $type,
                'description' =>$description
            ];

		}
	}
	echo json_encode([
		'items' => $items,
		'hasPrev' => $page > 1,
		'hasNext' => $page < $totalPages,
		'totalPages' => $totalPages,
		'totalitems' => $totalItems
	]);

	}

    public function allhistory()
	{

		$this->session = session();
		$uusersid = $this->session->get('uusersid');

        $CommonModel = model('CommonModel');
      

		$this->data['records'] = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' ORDER BY `historyid` DESC limit 10")->getResult();
        $this->data['total_count'] =$this->db->query("select * from `history` WHERE uusersid = '".$uusersid."'")->getNumRows();
        echo view('user/alltransaction_history',$this->data);
	}


	



    function allhistory_records()
	{
        $this->common_model = model('CommonModel');
        $session = \Config\Services::session();
        //print_r($this->request->getpost());

        $uusersid = $this->request->getPost('uusersid');
        $page = $this->request->getPost('page');
        $itemsPerPage = $this->request->getPost('itemsPerPage');
        $offset = ($page - 1) * $itemsPerPage;
        $start_date = $this->request->getPost('start_date');
        $end_date = $this->request->getPost('end_date');
		$types = $this->request->getPost('type');

        // print_r($page);
        // echo "<br>";

		if($start_date!='' && $end_date!='')
		{
			if($types!='')
			{
				$start_date=date("Y-m-d 00:00:00",strtotime($start_date));
				$end_date=date("Y-m-d 23:59:59",strtotime($end_date));
				$totalItems = $this->db->query("select * from `history`  WHERE date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type='".$types."'  ORDER BY `historyid` DESC ")->getNumRows();
				$get_records = $this->db->query("select * from `history` WHERE  date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type='".$types."' ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
			}
			else
			{
				$start_date=date("Y-m-d 00:00:00",strtotime($start_date));
				$end_date=date("Y-m-d 23:59:59",strtotime($end_date));
				$totalItems = $this->db->query("select * from `history`  WHERE date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type!='activation' ORDER BY `historyid` DESC ")->getNumRows();
				$get_records = $this->db->query("select * from `history` WHERE  date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type!='activation' ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
			}
		}
		else
		{
			if($types!='')
			{
				$totalItems = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type='".$types."'  ORDER BY `historyid` DESC ")->getNumRows();
				$get_records = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type='".$types."' ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
			}
			else
			{
				$totalItems = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type!='activation' ORDER BY `historyid` DESC")->getNumRows();
				$get_records = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type!='activation' ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();

			}
		}
		
		$totalPages = ceil($totalItems / $itemsPerPage);
		$items = array();

		if($get_records)
		{
			foreach($get_records as $row)
			{
				$type=str_replace('_',' ',$row->type);
				$type=ucwords($type);

            if($row->type=='bonus' || $row->type=='commissions' || $row->type=='deposit' || $row->type=='fund_received')
            {
                $amount='<label class="btn btn-success">'.number_format($row->amount,4).' USDT</label>';
                $description=$row->description;
               
                
            }
            else if($row->type=='activation' )
            {
                $amount='0';
                $description=$row->description;
               
                
            }
            else
            {
                $amount=number_format($row->amount,4);
                $description = $row->description;
                if($row->type=='fuel' || $row->type=='deducted_gaswallet')
                {
                    $description_check=str_replace('fuel fee deduction for order no','',$row->description);
                    $get_order=$this->db->query("select * from api_trade_history where order_id='".trim($description_check)."'")->getRow();
                    if($get_order)
                    {
                        $base=substr($get_order->pair,0,-4);
                        $pair=$base.'/USDT';
                        $description='Fuel Fee &nbsp;: ['.$pair.'&nbsp;TurnOver &nbsp;:&nbsp;'.$get_order->comm_price.'] orderno :'.$get_order->order_id;
                      
                    }
                    
                }
            }
		    $items[] = [
				'amount' =>  $amount,
				'date' => $row->date,
                'type' => $type,
                'description' =>$description
            ];

		}
	}
	echo json_encode([
		'items' => $items,
		'hasPrev' => $page > 1,
		'hasNext' => $page < $totalPages,
		'totalPages' => $totalPages,
		'totalitems' => $totalItems
	]);

	}


	public function rewardhistory()
	{

		$this->session = session();
		$uusersid = $this->session->get('uusersid');
		$CommonModel = model('CommonModel');
		$start_date=date("Y-m-d 00:00:00");
		$end_date=date("Y-m-d 23:59:59");

		$earnings=$this->db->query("select sum(amount) as amount from history where uusersid='".$uusersid."' and date between '".$start_date."' and '".$end_date."' and type in('commissions')")->getRow();
        $this->data['earnings']=$earnings->amount;

        $expense=$this->db->query("select sum(amount) as amount from history where uusersid='".$uusersid."' and type IN('commissions')")->getRow();
        $this->data['expense']=$expense->amount;
		
      	$this->data['records'] = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' and type='commissions' ORDER BY `historyid` DESC limit 10")->getResult();
        $this->data['total_count'] =$this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' and type='commissions' ")->getNumRows();
        echo view('user/rewardhistory',$this->data);
	}


	function rewardhistory_records()
	{
        $this->common_model = model('CommonModel');
        $session = \Config\Services::session();
        //print_r($this->request->getpost());

        $uusersid = $this->request->getPost('uusersid');
        $page = $this->request->getPost('page');
        $itemsPerPage = $this->request->getPost('itemsPerPage');
        $offset = ($page - 1) * $itemsPerPage;
        $start_date = $this->request->getPost('start_date');
        $end_date = $this->request->getPost('end_date');

        // print_r($page);
        // echo "<br>";

	if($start_date!='' && $end_date!='')
	{
        $start_date=date("Y-m-d 00:00:00",strtotime($start_date));
        $end_date=date("Y-m-d 23:59:59",strtotime($end_date));
        $totalItems = $this->db->query("select * from `history`  WHERE date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type in('commissions') ORDER BY `historyid` DESC ")->getNumRows();
        $get_records = $this->db->query("select * from `history` WHERE  date between '".$start_date."' and '".$end_date."' and  uusersid = '".$uusersid."' AND type in('commissions') ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
    }
	else
	{
		$totalItems = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('commissions') ORDER BY `historyid` DESC ")->getNumRows();
        $get_records = $this->db->query("select * from `history` WHERE uusersid = '".$uusersid."' AND type in('commissions') ORDER BY `historyid` DESC limit $offset,$itemsPerPage")->getResult();
    }
	
	$totalPages = ceil($totalItems / $itemsPerPage);
    $items = array();

	if($get_records)
	{
		foreach($get_records as $row)
		{
            $type=str_replace('_',' ',$row->type);
            $type=ucwords($type);

            if($row->type=='bonus' || $row->type=='commissions' || $row->type=='deposit' || $row->type=='fund_received')
            {
                $amount='<label class="btn btn-success">'.number_format($row->amount,4).' USDT</label>';
                $description=$row->description;
               
                
            }
            else
            {
                $amount='<label class="btn btn-danger">'.number_format($row->amount,4).' USDT</label>';
                $description = $row->description;
                if($row->type=='fuel' || $row->type=='deducted_gaswallet')
                {
                    $description_check=str_replace('fuel fee deduction for order no','',$row->description);
                    $get_order=$this->db->query("select * from api_trade_history where order_id='".trim($description_check)."'")->getRow();
                    if($get_order)
                    {
                        $base=substr($get_order->pair,0,-4);
                        $pair=$base.'/USDT';
                        $description='Fuel Fee &nbsp;: ['.$pair.'&nbsp;TurnOver &nbsp;:&nbsp;'.$get_order->comm_price.']';
                      
                    }
                    
                }
            }
		    $items[] = [
				'amount' =>  $amount,
				'date' => $row->date,
                'type' => $type,
                'description' =>$description
            ];

		}
	}
	echo json_encode([
		'items' => $items,
		'hasPrev' => $page > 1,
		'hasNext' => $page < $totalPages,
		'totalPages' => $totalPages,
		'totalitems' => $totalItems
	]);

	}


	


 
}
