<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php
		use App\Libraries\MyEncrypt;
		$session = session();
		$validation = \Config\Services::validation();
		helper('form');

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>

	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    <!-- Theme JS files -->

	<!-- ckeditor JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/ckeditor/ckeditor.js');?>"></script>
	<!--<script src="<?php echo base_url();?>assets/boots/js/jquery.js"></script>-->
    
   
</head>

<body class="navbar-top-md-md">
	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.cms_page_title'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { ?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
			
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.cms_page_edit');?>   </h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>
                	
					<div class="panel-body">
						<form class="form-horizontal cms" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
							<?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.Error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>
							
                            <?php
                            
                            foreach ($languages as $row) { 
                            	
                            	$pageinfo = $this->common_model->Getpageinfo($page_url,$row->language_id);
                            	
                            	

                            	?>
                            	<h5 class="text-semibold"><?php echo ucfirst($row->language_name);?></h5>

                            	<div class="form-group  <?php if($validation->getError('page_content_'.$row->language_id)) echo "has-error";?>">
                            		<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.cms_page_titlename'); ?><span class="text-danger">*</span></label>
                            		<div class="col-lg-4">
										<div class="">
											<input type="text" name="page_title_<?php echo $row->language_id; ?>" class="form-control" placeholder="<?php echo lang('language_lang.plac_page_title'); ?>" value="<?php echo set_value('page_title_'.$row->language_id, isset($pageinfo->page_title) ? ucfirst($pageinfo->page_title) : ''); ?>">
										</div>
									</div>
                            	</div>

								<div class="form-group   <?php if($validation->getError('page_content_'.$row->language_id)) echo "has-error";?>">
									<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.cms_page_content'); ?><span class="text-danger">*</span></label>
									<div class="col-lg-11">
										<div class="content-group">
									    	<textarea class="ckeditor" name="page_content_<?php echo $row->language_id; ?>" id="editor-readonly" rows="4" cols="4" placeholder="<?php echo lang('language_lang.plac_page_content'); ?>"><?php echo set_value('page_content_'.$row->language_id,isset($pageinfo->page_content) ? $pageinfo->page_content : ''); ?></textarea>
										</div>
										<?php echo $validation->getError('page_content_'.$row->language_id, '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>
							

							<?php 
								} 
								$myencrypt = new MyEncrypt;
							?>
							<input type="hidden" name="page_url" class="form-control" value="<?php echo (isset($page_url)) ? $myencrypt->encode($page_url) : ''; ?>">

							<div class="text-right col-lg-9">
								<button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->
		

		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		jQuery.noConflict();
		(function( $ ) {
		$(function() {

			$(document).ready(function() {

				$.jGrowl.defaults.closer = false;

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
			            header: '<?php echo lang("language_lang.Error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.Success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	      //       $('.cms').formValidation({
			    // 	framework: 'bootstrap',
			    // 	excluded: [':disabled'],
			    //     icon: {
			    //         // valid: 'glyphicon glyphicon-ok',
			    //         // invalid: 'glyphicon glyphicon-remove',
			    //         validating: 'glyphicon glyphicon-refresh'
			    //     },
			    //     fields: {
			    //     	<?php
       //                      //foreach ($languages as $row) { 
       //                  ?>
			    //         page_content_1: {
			    //             message: '<?php echo lang("language_lang.cms_content_valid");?>',
			    //             validators: {
			    //                 notEmpty: {
			    //                     message: '<?php echo lang("language_lang.cms_content_required");?>'
			    //                 },
			    //                 stringLength: {
				   //              	min: 20,
				   //              	message: '<?php echo lang("language_lang.cms_content_exceeds");?>'
				   //              }
			    //             }
			                
			    //         },
			    //         <?php //} ?>
			            
			            
			    //     }
			    // })

				// .find('<?php foreach ($languages as $row) { ?> [name="page_content_<?php echo $row->language_id;?>"] <?php } ?>')
				// .find('[name="page_content_1"]')
				// 	.ckeditor()
		  //           .editor
	   //              .on('change', function() {
	   //                  $('.cms').formValidation('revalidateField', 'page_content_1');
	   //              });

			   

			});
		    
		 	$('#icon-bck').on('click',function() {
				window.history.back();
			});
		});
		})(jQuery);
	
	</script>

</body>
</html>
