<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Title -->
    <title>Touareg Trading Bot</title>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <!-- Favicon -->
    <link rel="shortcut icon" href="public/img/favicon.ico">

    <!-- Template -->
    <link rel="stylesheet" href="public/graindashboard/css/graindashboard.css">
    <style>
        .err {
            font-size:14px;
            color:red;
            margin:10px;
        }
    </style>
  </head>

  <body class="">

    <main class="main">

      <div class="content">

			<div class="container-fluid pb-5">

				<div class="row justify-content-md-center">
					<div class="card-wrapper col-12 col-md-4 mt-5">
						<div class="brand text-center mb-3">
							<a href=""><img src="https://member.touaregcapital.co/images/newlogo5.png" width="250px"></a>
						</div>
						<div class="card">
							<div class="card-body">
                                <?php 
                                session_start();
                                
                                if(!empty($_SESSION['success']))
                                {
                                    ?>
                                    <div class="alert alert-success">
                                        <strong>Success!</strong> <?php echo $_SESSION['success'];?>
                                        </div>
                                    <?php 
                                    $_SESSION['success']='';

                                }
                                ?>

                                <div id="dis" class="err"></div>
								<h4 class="card-title">Login</h4>
								<form>
									<div class="form-group">
										<label for="email">E-Mail Address</label>
										<input id="email" type="email" class="form-control" name="email" id="email" required="" autofocus="">
                                        <div class="err" id="email_err"></div>
                                    </div>
                                   

									<div class="form-group">
										<label for="password">Password
										</label>
										<input id="password" type="password" class="form-control" name="password" id="password" required="">
										<div class="err" id="pass_err"></div>
									</div>

								
                                   
									<div class="form-group no-margin">
										<input type="button" class="btn btn-primary btn-block" value="submit" onclick="login_verify();">
									</div>
									
								</form>
							</div>
						</div>
						<footer class="footer mt-3">
							<div class="container-fluid">
								<div class="footer-content text-center small">
									<span class="text-muted">&copy; 2025 Touareg Global. All Rights Reserved.</span>
								</div>
							</div>
						</footer>
					</div>
				</div>



			</div>

      </div>
    </main>

	<script src="public/graindashboard/js/graindashboard.js"></script>
    <script src="public/graindashboard/js/graindashboard.vendor.js"></script>
    <script>
     function login_verify()
     {
        var username= $("#email").val();
        var password= $("#password").val();

        $("#email_err").html('');
        $("#pass_err").html('');
        var flag=0;
        if(username=='')
        {
            flag=1;
            $("#email_err").html('Please Enter Email ID');

        }
        if(password=='')
        {
            flag=1;
            $("#pass_err").html('Please Enter password');
        }
        if(flag!='1')
        {
            $("#dis").html('Please Wait Data Loading Progressing...');
            $.ajax({
                type: "POST",
                url: "login_verify",
                data:{email:username,password:password},
                success: function(msg) {
                    var msg = msg.trim();
                    if(msg=='yes')
                    {
                        window.location='dashboard';
                    }
                    else
                    {
                       $("#dis").html("<div class='alert alert-danger'><strong>Danger!</strong> Invalid email or password.</div>");
                        
                    }
                }
            });



        }


     }
    </script>
  </body>
</html>