<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Levelsettings extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 29 Sep, 2016
	 * This controller to manage level commision setting page.
	 * Created saravanan.
	 * @see http://ihyip.com/admin/levelsettings/
	 * Last Updated: 29 Sep, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();
		// admin login only
		if($this->session->userdata('admin_login')) {

			// form validation library
			$this->load->library('form_validation');

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set_userdata('last_page', current_url());
				redirect('admin/login');
			}
		}
		
	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}

	public function index()
	{
        
        $this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_settings')
			
		);
		// $this->data['breadcrumbs'][] = array(
		// 	'text' => $this->lang->line('email_text'),
		// 	'href' => base_url().'admin/emailsetting'
		// );
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  base_url().'admin/levelsettings';

		$site_data = $this->common_model->GetSettingall('level');
		
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		} 
		

		if($this->input->post()) {

			$this->form_validation->set_rules('level1', $this->lang->line('level1'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level2', $this->lang->line('level2'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level3', $this->lang->line('level3'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level4', $this->lang->line('level4'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level5', $this->lang->line('level5'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level6', $this->lang->line('level6'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level7', $this->lang->line('level7'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level8', $this->lang->line('level8'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level9', $this->lang->line('level9'), 'trim|required|callback_amount_check');
			$this->form_validation->set_rules('level10', $this->lang->line('level10'), 'trim|required|callback_amount_check');
			
			
			// check form validate
			if ($this->form_validation->run() == TRUE) {
				
                foreach ($site_data as $row) {

					$key_value = $row->site_key;
					
					if($this->input->post($key_value)){

						$sitedata = array(
							"site_value"	=>	$this->input->post($key_value)
						);
						
						$this->db->where('settings_name','level');
						$this->db->where('site_key',$row->site_key);
						$update_status = $this->db->update('site_controls', $sitedata);

					} else {
						$sitedata = array(
							"site_value"	=>	'0'
						);
						$this->db->where('settings_name','level');
						$this->db->where('site_key',$row->site_key);
						$update_status = $this->db->update('site_controls', $sitedata);
					}

				}

                if($update_status) {
					$this->session->set_flashdata('success_message', $this->lang->line('level_success_message'));
					redirect('admin/levelsettings');
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('level_error_message'));
					redirect('admin/levelsettings');
				}
				

			}
			
		}

		$this->load->view('admin/settings/levels',$this->data);

	}

	function amount_check($str)
	{
		$currency_info = defaultcurrency();
		if(preg_match("/^[0-9.]+$/", $str)) {
			return true;
		} else {
			$this->form_validation->set_message('amount_check', '<p><em class="text-danger">'.$this->lang->line("amount_check").'</em></p>');
			return false;
		}
	}
	
	
}

