<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Withdrawsettings extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 21 Jun, 2016
	 * This controller to manage withdraw setting page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/withdrawsettings/
	 * Last Updated: 24 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');
			$this->isSubadmin();

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}
		
	}

	private function isCookie($values) {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if ($hashed_password == crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

	private function isSubadmin() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}


		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings')
		);
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/withdrawsettings';
        
		$site_data = $this->common_model->GetSettingall('withdraw');
		
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		} 
		// else {
		// 	$site_data_default = $this->common_model->defaultlangSettingall('withdraw');
		// 	foreach ($site_data_default as $row) {
		// 		$this->data[$row->site_key] = $row->site_value;
		// 	}
		// }        

		if($this->request->getPost()) {

			if($this->request->getPost('with_min_amt'))
			{
				$min_amount = $this->request->getPost('with_min_amt');
			} else {
				$min_amount = '';
			}

			if($this->request->getPost('with_max_amt'))
			{
				$max_amount = $this->request->getPost('with_max_amt');
			} else {
				$max_amount =  '';
			}

			/// form validation and set rules

			$validation->setRules([
				'with_fee' => ['label' => lang('language_lang.Withdrawal_fee'), 'rules' => 'trim|required|amount_check'],
				'with_min_fee' => ['label' => lang('language_lang.Minimal_withdrawal_fee'), 'rules' => 'trim|required|amount_check'],
				'with_min_amt' => ['label' => lang('language_lang.Minimal_withdraw_amnt'), 'rules' => 'trim|required|min_check['.$max_amount.']'],
				'with_max_amt' => ['label' => lang('language_lang.Maximal_withdraw_amnt'), 'rules' => 'trim|required|max_check['.$min_amount.']'],
				'with_limit' => ['label' => lang('language_lang.Limit_withdraw_period'), 'rules' => 'trim|required|numeric'],
				'with_period_type' => ['label' => lang('language_lang.withdraw_limit_type'), 'rules' => 'trim|required'],
			]);
		    // $this->form_validation->set_rules('with_fee', lang('language_lang.Withdrawal_fee'), 'trim|required|callback_amount_check');
		    // $this->form_validation->set_rules('with_min_fee', lang('language_lang.Minimal_withdrawal_fee'), 'trim|required|callback_amount_check');
		    // $this->form_validation->set_rules('with_min_amt', lang('language_lang.Minimal_withdraw_amnt'), 'trim|required|callback_min_check['.$max_amount.']');
		    // $this->form_validation->set_rules('with_max_amt', lang('language_lang.Maximal_withdraw_amnt'), 'trim|required|callback_max_check['.$min_amount.']');
		    // $this->form_validation->set_rules('with_limit', lang('language_lang.Limit_withdraw_period'), 'trim|required|numeric');
		    // $this->form_validation->set_rules('with_period_type', lang('language_lang.withdraw_limit_type'), 'trim|required');

            if ($validation->withRequest($this->request)->run() == TRUE) {

                foreach ($site_data as $row) {

					$key_value = $row->site_key;
					
					if($this->request->getPost($key_value)){

						$sitedata = array(
							"site_value"	=>	$this->request->getPost($key_value)
						);
						$update_status = $this->db->table('site_controls')->where('settings_name','withdraw')->where('site_key',$row->site_key)->update($sitedata);


					} else {

						$sitedata = array(
							"site_value"	=>	'0'
						);
						
						$update_status = $this->db->table('site_controls')->where('settings_name','withdraw')->where('site_key',$row->site_key)->update($sitedata);

					}

				}
    
                if($update_status) {
					$session->setFlashData('success_message', lang('language_lang.withdraw_success_message'));
					return redirect()->to('admin/withdrawsettings');
				} else {
					$session->setFlashData('error_message', lang('language_lang.withdraw_error_message'));
					return redirect()->to('admin/withdrawsettings');
				}
			}
		}

		echo view('admin/settings/withdraw',$this->data);
	}

	function min_check($str, $max){
$validation = \Config\Services::validation();
		$currency_info = defaultcurrency();
		if(preg_match("/^[0-9.]+$/", $str)) {
			if($str < $max) {
				return true;
			} else {
				$validation->setMessage('min_check', '<p><em class="text-danger">'.lang("language_lang.withdraw_min_amnt_lessthan").'</em></p>');
				return false;
			}
		} else {
			$validation->setMessage('min_check', '<p><em class="text-danger">'.lang("language_lang.amount_check").'</em></p>');
			return false;
		}
	}

	function max_check($str, $min){
$validation = \Config\Services::validation();


		$currency_info = defaultcurrency();
		if(preg_match("/^[0-9.]+$/", $str)) {
			if($str > $min) {
				return true;
			} else {
				$validation->setMessage('max_check', '<p><em class="text-danger">'.lang("language_lang.withdraw_max_amnt_graterthan").'</em></p>');
				return false;
			}
		} else {
			$validation->setMessage('max_check', '<p><em class="text-danger">'.lang("language_lang.amount_check").'</em></p>');
			return false;
		}
	}
	
	function amount_check($str)
	{
$validation = \Config\Services::validation();

		$currency_info = defaultcurrency();
		if(preg_match("/^[0-9.]+$/", $str)) {
			return true;
		} else {
			$validation->setMessage('amount_check', '<p><em class="text-danger">'.lang("language_lang.amount_check").'</em></p>');
			return false;
		}
	}
	
}

