<?php
   use App\Libraries\MyEncrypt;
   use App\Models\CommonModel;
   $session = session();
   $validation =  \Config\Services::validation();
   $this->db = db_connect();
   
   $CommonModel = model('CommonModel');
   $header_data = $CommonModel->GetSiteSettings('site');
   if(!$header_data){
   	$header_data = $CommonModel->defaultlangSettingall('site');
   }
   foreach ($header_data as $row) 
   {
   	$headers[$row->site_key] = $row->site_value;
   }
   ?>
<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title><?php echo $headers['site_meta_title'];?></title>
      <!--Basic Bootstrap-->
      <link href="<?php echo base_url();?>/styles/web_style/css/bootstrap.min.css" rel="stylesheet" type="text/css">
      <!--Font icons-->
      <link href="<?php echo base_url();?>/styles/web_style/css/all.css"  rel="stylesheet" type="text/css">
      <!--Carousel Slider-->
      <link href="<?php echo base_url();?>/styles/web_style/css/owl.carousel.min.css" rel="stylesheet" type="text/css">
      <link href="<?php echo base_url();?>/styles/web_style/css/owl.theme.default.min.css" rel="stylesheet" type="text/css">
      <!--fonts-->
      <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">
      <!--Theme CSS -->
      <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>/styles/web_style/css/style.css">
      <style>
    .user-box {
    	position: relative;
    	margin-bottom: 30px;
    }
    .user-box input {
    	display: block;
    	width: 100%;
    	padding: 15px 10px;
    	font-size: 12px;
    	font-weight: 400;
    	line-height: 1.5;
    	color: #fff;
    	background-color: #2e2d2c;
    	background-clip: padding-box;
    	border: 0;
    	-webkit-appearance: none;
    	-moz-appearance: none;
    	appearance: none;
    	border-radius: 10px;
     transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
    }
     .user-box input:focus ~ label,  .user-box input:valid ~ label {
     transform: translateY(-20px);
     font-size: 14px;
     color: #333;
    }
    .password-toggle-icon {
    	position: absolute;
    	top: 60%;
    	right: 10px;
    	color:#fff;
    	transform: translateY(-50%);
    	cursor: pointer;
    }
    .password-toggle-icon1 {
    	position: absolute;
    	top: 60%;
    	right: 10px;
    	color:#fff;
    	transform: translateY(-50%);
    	cursor: pointer;
    }
    .password-toggle-icon i {
    	font-size: 18px;
    	line-height: 1;
    	color: #fff;
    	transition: color 0.3s ease-in-out;
    	margin-bottom: 20px;
    }
    .password-toggle-icon1 i {
    	font-size: 18px;
    	line-height: 1;
    	color: #fff;
    	transition: color 0.3s ease-in-out;
    	margin-bottom: 20px;
    }
    .password-toggle-icon i:hover {
    	color: #000;
    }
    .help-block {
    	color:red;
    	font-size:12px;
    	font-weight:bold;
    }
    p.frgtpwd1 {
    	background:#8DC540 !important
    }
    p.frgtpwd1 i {
    	background:#8DC540 !important;
    	color:#fff !important
    }
    p.frgtpwd {
    	font-size: 13px;
    	color: #fff;
    	text-align: left;
    	line-height: 24px;
    	margin: 0 0 1em 0;
    	background: #22313F;
    	border-radius: 2px;
    	padding:10px 39px 10px 10px;
    	font-weight: 600;
    	position: relative;
    }
    p.frgtpwd i {
    	position: absolute;
    	top: 0;
    	right: 0;
    	padding:15px 8px 8px 8px;
    	font-size: 14px;
    	background: #F5AB35;
    	color: #22313F;
    	height: 100%;
    }
    p.frgtpwdred {
    	background:#EB5055 !important
    }
    p.frgtpwdred i {
    	background:#EB5055 !important
    }
    .alert-success {
    	color: #0f5132;
    	background-color: #d1e7dd;
    	border-color: #badbcc;
    	font-size: 12px;
    }
    .reg-height {
    	min-height:100vh;
    }
    .rules p {
    	margin-bottom:8px !important;
    	font-size:13px;
    	display:flex;
    	align-items:center;
    	text-align:justify;
    }
    .input-group-btn .btn-primary {
    	padding:8px 22px;
    	margin-top:5px;
    }
    .content-wrap
    {
      height: 65vh;
    }
    .reg-overflow
{
   overflow:hidden !important;
}
    
    </style>
   </head>
   <body class="reg-overflow banner-bg reg-height">
      <!---header---->
      <section class="pb-1 regsiter">
         <div class="container">
            <div class="header">
               <div class="row bg-black">
                  <div class="col-3">
                     <div class="header-arrow">
                        <a href="<?php echo base_url();?>/login"><i class="fa-solid fa-circle-arrow-left" style="font-size:28px;color:orange;"></i></a> 
                     </div>
                  </div>
                  <div class="col-9">
                     <div class="reg-logo">
                        <img src="<?php echo base_url();?>/styles/web_style/images/login-logo.png" alt="" style="width:100%;">
                     </div>
                  </div>
               </div>
            </div>
            <div class="content-wrap mt-4">
               <div class="reg-page">
                  <div class="row">
                     <div class="col-lg-12">
                        <div class="title py-2 text-center">
                           <h2 class="fw-bold text-primary mb-3">Register</h2>
                           <p class="text-white-50">Please provide your information below and submit for verification. Upon completion, a TAC (Transaction Authorization Code) will be sent for verification.</p>
                        </div>
                     </div>
                  </div>
                  <form class="steps-validation create-user" id="register" method="post" action="<?php echo base_url();?>/user/register/reg">
                  <div class="form-page">
                     <div class="row">
                        <div class="col-sm-12">
                           <div class="form-block form-group position-relative mb-3 mt-3">
                              <label for="" class="form-label text-primary"><i class="fa-solid fa-user me-2"></i>Personal Details </label>
                              <select class="form-control ps-2 form-arrow" name="country">
                                 <option value="">  Country </option>
                                 <?php foreach ($country as $country) 
                                    { 
                                          $ms="MY";
                                        
                                      ?>
                                 <option value="<?php echo $country->iso_2; ?>" <?php if($country->iso_2==$ms) { echo "selected==selected";}?>><?php echo $country->Country;?></option>
                                 <?php } ?>
                              </select>
                           </div>
                           </div>
                           
                           <div class="col-sm-12">
                           <div class="form-block form-group">
                              <input type="text" class="form-control" placeholder="Username" name="username" id="username">
                           </div>
                           </div>
                           <div class="col-sm-12">
                           <div class="form-block form-group">
                              <input type="text" class="form-control" placeholder=" Email id" id="email" name="email">
                           </div>
                           </div>
                           
                           <div class="col-sm-12">
                           <div class="mb-2 form-block form-group">
                              <input type="text" class="form-control" placeholder="Invitation code" id="invitor_code" name="invitor_code" value="<?php echo $referral;?>">
                           </div>
                           </div>
                           
                           <!--<div class="col-sm-12">
                           <label for="" class="form-label  text-primary"><i class="fa-solid fa-lock me-2"></i>Security Details</label>
                           <div class="mb-2 form-block  form-group user-box">
                              <input type="password" class="form-control" placeholder="Enter Password" name="password" id="password">
                              <span class="password-toggle-icon"><i class="fas fa-eye-slash"></i></span>
                              <div id="pass_error" class="help-block"></div>
                           </div>
                           </div>-->
                           
                            <div class="col-sm-12">
                              <label for="" class="form-label  text-primary"><i class="fa-solid fa-lock me-2"></i>Security Details</label>
                              <div class="form-block position-relative login-ico">
                                <div class="form-ico password-toggle-icon"><i class="fa-regular fa-eye-slash"></i></div>
                                <input type="password" class="form-control" placeholder="Enter Password" name="password" id="password">
                                 <div id="pass_error" class="help-block"></div>
                              </div>
                            </div>
                            
                            
                           <div class="row">
                               <div class="col-sm-12">
                               <div class="rules">
                                  <div id="disp1" style="display:none;">
                                     <p class="text-success mb-0">
                                        <iconify-icon icon="mdi:tick-circle-outline" class="me-2"></iconify-icon>
                                        Please ensure your entry consists of at least 8 characters
                                     </p>
                                  </div>
                                  <div id="disp1a">
                                     <p class="text-white mb-0">
                                        <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>
                                        Please ensure your entry consists of at least 8 characters
                                     </p>
                                  </div>
                                  <div id="disp2" style="display:none;">
                                     <p class="text-success mb-0">
                                        <iconify-icon icon="mdi:tick-circle-outline" class="me-2"></iconify-icon>
                                        Please include at least 1 uppercase character in your entry.
                                     </p>
                                  </div>
                                  <div id="disp2a">
                                     <p class="text-white mb-0">
                                        <iconify-icon icon="clarity:success-standard-solid" class="me-2" ></iconify-icon>
                                        Please include at least 1 uppercase character in your entry.
                                     </p>
                                  </div>
                                  <div id="disp3" style="display:none;">
                                     <p class="text-success mb-0">
                                        <iconify-icon icon="mdi:tick-circle-outline" class="me2"></iconify-icon>
                                        Please ensure your entry contains at least 1 numerical digit
                                     </p>
                                  </div>
                                  <div id="disp3a">
                                     <p class="text-white mb-0">
                                        <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>
                                        Please ensure your entry contains at least 1 numerical digit
                                     </p>
                                  </div>
                                  <div id="disp4" style="display:none;">
                                     <p class="text-success mb-0">
                                        <iconify-icon icon="mdi:tick-circle-outline" class="me-2"></iconify-icon>
                                        Please include at least 1 special character (e.g., ?/#~!) in your entry.
                                     </p>
                                  </div>
                                  <div id="disp4a">
                                     <p class="text-white">
                                        <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>
                                        Please include at least 1 special character (e.g., ?/#~!) in your entry.
                                     </p>
                                  </div>
                                  
                                </div>
                                </div>
                                </div>
                                
                           <input type='hidden' name="ps_sudo1" id="ps_sudo1" value='0'>
                           <input type='hidden' name="ps_sudo2" id="ps_sudo2" value='0'>
                           <input type='hidden' name="ps_sudo3" id="ps_sudo3" value='0'>
                           <input type='hidden' name="ps_sudo4" id="ps_sudo4" value='0'>
                           
                           <!--<div class="col-sm-12">
                           <div class="form-block form-group user-box">
                              <input type="password" class="form-control" placeholder="Security PIN" maxLength="6" name="trans_pin" id="trans_pin">
                              <span class="password-toggle-icon1"><i class="fas fa-eye-slash"></i></span>
                           </div>
                           </div>-->
                           
                             <div class="col-sm-12">
                                <div class="form-block position-relative login-ico">
                                <div class="form-ico password-toggle-icon1"><i class="fa-regular fa-eye-slash"></i></div>
                                <input type="text" class="form-control" placeholder="Security PIN" maxLength="6" name="trans_pin" id="trans_pin">
                                </div>
                             </div>
                           
                           <div class="col-sm-12">
                           <div class="form-block form-group  position-relative">
                              <label for="" class="form-label text-primary"><i class="fa-solid fa-shield me-2"></i> Email Verification </label>
                              <div class="input-group">
                                 <input type="text" class="form-control" name="code1" id="code1"  maxLength="6"  placeholder="Verfication Code">
                                 <span class="input-group-btn"> &nbsp;
                                 <button type="button" name="getcode" id="getcode"  class="btn btn-primary">SEND</button>
                                 </span>
                              </div>
                              <div id="otpmsg"></div>
                           </div>
                           </div>
                           <div class="col-sm-12">
                           <p class="text-white mb-0">  *The TAC code will be sent to your registered email address</p>
                           </div>
                           <div class="row">
                           <div class="col-sm-12">
                                <div class="form-btn-bg position-relative" >
                                  <div class="form-button ">
                                     <button class="btn btn-primary" type="submit">
                                        <iconify-icon icon="ep:d-arrow-right"></iconify-icon>
                                     </button>
                                  </div>
                                </div>
                            </div>
                            </div>
                        </div>
                     </div>
                  </div>
                  </from>
               </div>
               <br>
               <div class="row">
          <div class="col-lg-12">
             <div class="copy-rights text-center ">
                <span class="text-white"> 2024 <a href="" class="text-decoration-none"> @Revotech </a> All Rights Reserved</span>
             </div>
            </div>
         </div>
      </section>
      

      <script src="<?php echo base_url();?>/styles/web_style/js/jquery.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/bootstrap.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/script.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/iconify-icon.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/owl.carousel.min.js"></script>
      <script src="http://code.jquery.com/jquery-1.11.3.min.js"></script>
      <script type="text/javascript" src="<?php echo base_url();?>/assets/js/formValidation1.js"></script>
      <script type="text/javascript" src="<?php echo base_url();?>/assets/js/bootstrap.js"></script>
      <script type="text/javascript">
         jQuery.noConflict();
         (function( $ ) {
         
         $(document).ready(function() {
         $(document).on("click", '#getcode', function() 
         {
         
           var referral=$('#invitor_code').val();
           var email=$('#email').val();
           if(email !="")
           {

             $("#otpmsg").html('<div class="help-block">Please Wait Email progressing...</div>');
              $.ajax({
                 type: 'post',
                 url : '<?php echo base_url();?>/user/register/verifyregcode',
                 data : {'email':email,'referral':referral},
                 dataType:'json',
                 success : function(msg)
                 {
                 
                   console.log(msg);
                   
                    if(msg!='exist' && msg!='exist1')
                    {
                       var myVar;
                       /*setTimeout(function(){
                           $("#otpmsg").html('<div class="help-block">'+msg+'</div>')},500);*/
         
                           setTimeout(function(){
                         $("#otpmsg").html('<div class="help-block">'+msg+'</div>');
                             setTimeout(function(){
                             $("#otpmsg").html('');
                         }, 4000); // Adjust this duration as needed
                         }, 500);
                    }
                    else
                    {
                       if(msg=='exist')
                       {
         
                         setTimeout(function(){
                         $("#otpmsg").html('<div class="help-block">Email Already Exist</div>');
                             setTimeout(function(){
                             $("#otpmsg").html('');
                         }, 3000); // Adjust this duration as needed
                         }, 500);
                         
                         
         
                       }
                       else
                       {
                         setTimeout(function(){
                         $("#otpmsg").html('<div class="help-block">Given Invitor code invalid</div>');
                             setTimeout(function(){
                             $("#otpmsg").html('');
                         }, 2000); // Adjust this duration as needed
                         }, 500);
                           
                       }
                   } 
                 }
             })
           }
           else
           {
             setTimeout(function(){
             $("#otpmsg").html('<div class="help-block">Please Enter Email First</div>');
                 setTimeout(function(){
                 $("#otpmsg").html('');
             }, 2000); // Adjust this duration as needed
             }, 500);
             
           }
         });

         $('.create-user').formValidation({
            framework: 'bootstrap',
            excluded: [':disabled'],
            fields: {
                email: {
                    validators: {
                        notEmpty: {
                            message: '<?php echo "Email Address Cant be Empty" ;?>'
                        },
                        regexp: {
                            regexp: /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/,
                            message: '<?php echo "Email Address is Invalid"; ?>'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/validemail';
                            },
                            type: 'POST',
                            delay: 1000,
                            message: '<?php echo "Email Address already Existed"; ?>'
                        }
                    }
                },
                username: {
                    validators: {
                        notEmpty: {
                            message: 'Username is required'
                        },
                        regexp: {
                            regexp: /^[a-zA-Z0-9]*$/,
                            message: 'Username only accepts alphanumerics'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/validuser';
                            },
                            type: 'POST',
                            delay: 1000,
                            message: 'Username already taken. Please try another'
                        }
                    }
                },
                country: {
                    validators: {
                        notEmpty: {
                            message: 'Country is Required'
                        }
                    }
                },
                invitor_code: {
                    validators: {
                        notEmpty: {
                            message: 'Invitor code is Required'
                        },
                        regexp: {
                            regexp: /^[a-zA-Z0-9]*$/,
                            message: 'Only Accepts alphanumerics'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/validreferral';
                            },
                            type: 'POST',
                            delay: 1000,
                            message: 'Invitor code not found'
                        }
                    }
                },
                password: {
                    validators: {
                        notEmpty: {
                            message: 'Password is Required'
                        }
                    }
                },
                trans_pin: {
                    validators: {
                        notEmpty: {
                            message: 'Security Pin is Required'
                        },
                        regexp: {
                            regexp: /^[0-9]*$/,
                            message: 'Only Accepts numerics'
                        },
                        stringLength: {
                            min: 5,
                            message: 'Minimum 5 digits required'
                        }
                    }
                },
                code1: {
                    validators: {
                        notEmpty: {
                            message: 'Enter the verification code'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/verifyotp';
                            },
                            type: 'POST',
                            delay: 500,
                            message: '<?php echo "Invalid Code, Try again "; ?>'
                        }
                    }
                }
            }
        }).on('success.form.fv', function(e) {
            // Prevent form submission
            e.preventDefault();

            // You can perform additional tasks here, like AJAX submission
            var $form = $(e.target);

            var ps1=document.getElementById('ps_sudo1').value;
            var ps2=document.getElementById('ps_sudo2').value;
            var ps3=document.getElementById('ps_sudo3').value;
            var ps4=document.getElementById('ps_sudo4').value;
            if(ps1=='0' || ps2=='0' || ps3=='0' || ps4=='0')
            {
              document.getElementById('pass_error').innerHTML='Password combination not verified';
              document.getElementById('password').focus();
            }
            else
            {
              document.getElementById('pass_error').innerHTML='';
              document.getElementById("register").submit(); 
            }
          });
         })
         })(jQuery);
         
         var myInput = document.getElementById('password');
         // When the user clicks on the password field, show the message box
         myInput.onfocus = function() {
           // Add any code to show message box if needed
         }
         // When the user clicks outside of the password field, hide the message box
         myInput.onblur = function() {
           // Add any code to hide message box if needed
         }
         // When the user starts to type something inside the password field
         myInput.onkeyup = function() {
          document.getElementById('pass_error').innerHTML='';
           // Validate special characters
           var specialCharacters = /[*@!#%&()^~{}]/g;
           if(myInput.value.match(specialCharacters)) { 
             document.getElementById('disp4a').style.display = 'none';
             document.getElementById('disp4').style.display = 'block';
             document.getElementById('ps_sudo1').value='1';
           } else {
             document.getElementById('ps_sudo1').value='0';
             document.getElementById('disp4a').style.display = 'block';
             document.getElementById('disp4').style.display = 'none';
           }
         
           // Validate capital letters
           var upperCaseLetters = /[A-Z]/g;
           if(myInput.value.match(upperCaseLetters)) {
             document.getElementById('ps_sudo2').value='1';
             document.getElementById('disp2a').style.display = 'none';
             document.getElementById('disp2').style.display = 'block';
           } else {
             document.getElementById('ps_sudo2').value='0';
             document.getElementById('disp2a').style.display = 'block';
             document.getElementById('disp2').style.display = 'none';
           }
         
           // Validate numbers
           var numbers = /[0-9]/g;
           if(myInput.value.match(numbers)) {
             document.getElementById('disp3a').style.display = 'none';
             document.getElementById('disp3').style.display = 'block';
             document.getElementById('ps_sudo3').value='1';
           } else {
            document.getElementById('ps_sudo3').value='0';
             document.getElementById('disp3a').style.display = 'block';
             document.getElementById('disp3').style.display = 'none';
           }
         
           // Validate length
           if(myInput.value.length >= 8) {
             document.getElementById('disp1a').style.display = 'none';
             document.getElementById('disp1').style.display = 'block';
             document.getElementById('ps_sudo4').value='1';
           } else {
            document.getElementById('ps_sudo4').value='0';
             document.getElementById('disp1a').style.display = 'block';
             document.getElementById('disp1').style.display = 'none';
           }
         }
         
         
         const passwordField = document.getElementById("password");
         const togglePassword = document.querySelector(".password-toggle-icon i");
         
         togglePassword.addEventListener("click", function () {
             
           if (passwordField.type === "password") {
             passwordField.type = "text";
             
             togglePassword.classList.remove("fa-eye-slash");
             togglePassword.classList.add("fa-eye");
           } else {
             passwordField.type = "password";
             togglePassword.classList.remove("fa-eye");
             togglePassword.classList.add("fa-eye-slash");
            
           }
         });
         
         const passwordField1 = document.getElementById("trans_pin");
         const togglePassword1 = document.querySelector(".password-toggle-icon1 i");
         
         togglePassword1.addEventListener("click", function () {
             
           if (passwordField1.type === "password") {
             passwordField1.type = "text";
             
             togglePassword1.classList.remove("fa-eye-slash");
             togglePassword1.classList.add("fa-eye");
           } else {
             passwordField1.type = "password";
             togglePassword1.classList.remove("fa-eye");
             togglePassword1.classList.add("fa-eye-slash");
           }
         });
      </script>
   </body>
</html>
