<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Trade Settings</title>
      <?php echo view('user/layout/head');?>
      <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>/styles/web_style/css/jquery.dataTables.min.css" />
      <style>
         .password-toggle-icon2 
         {
         position: absolute;
         top: 35%;
         right: 25px;
         color:#fff;
         transform: translateY(-50%);
         cursor: pointer;
         background:orange;
         border-radius:20px;
         }
         .btn { margin:5px;}
         label { font-size:13px; color:#fff !important; margin-bottom:10px;}
         .notify {
         position: fixed;
         top: 10px;
         left: 10px;
         -moz-box-sizing: border-box;
         box-sizing: border-box;
         width: 350px;
         font-size: 14px;
         text-align: center;
         }
         /* Positions
         ========================================================================== */
         .notify-top-right,
         .notify-bottom-right {
         left: auto;
         right: 10px;
         }
         .notify-top-center,
         .notify-bottom-center {
         left: 50%;
         margin-left: -175px;
         }
         .notify-bottom-left,
         .notify-bottom-right,
         .notify-bottom-center {
         top: auto;
         bottom: 10px;
         }
         .notify button {
         -webkit-appearance: none;
         padding: 0;
         cursor: pointer;
         background: 0 0;
         border: 0;
         display: none;
         }
         /* Responsiveness
         ========================================================================== */
         /* Phones portrait and smaller */
         @media (max-width: 479px) {
         /*
         * Fit in small screen
         */
         .notify {
         left: 10px;
         right: 10px;
         width: auto;
         margin: 0;
         }
         }
         /* Sub-object: `notify-message`
         ========================================================================== */
         .notify-message {
         position: relative;
         cursor: pointer;
         }
         .notify .alert-default {
         background: #fff;
         border: 1px solid #e5e5e5;
         }
      </style>
   </head>
   <body class="reg-overflow">
      <?php 
         $this->db = db_connect();
         $this->session = session();
         $uusersid = $this->session->get('uusersid');
         function formatTradingPair($pair) 
         {
            $base = substr($pair, 0, -4);  // Extract the base currency (all but the last 4 characters)
            $quote = substr($pair, -4);    // Extract the quote currency (last 4 characters)
            return strtoupper($base) . '/' . strtoupper($quote); // Combine and convert to lowercase
          }
         
         
          $qury = $this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' AND  pair = '".$symbol."' and trade_status != 2 order by id desc limit 1")->getResult();
          if(!empty($qury))
          {
            //$qry=$qury[0];
            //$qury = $this->db->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getResult();
            $qry=$qury[0];
            $first_buy_amount=$qry->first_buy_amount;
            $open_position_doubled=$qry->open_position_doubled;
            $margin_column_limit=$qry->margin_column_limit;
            $whole_profit_ratio=$qry->whole_profit_ratio;
            $whole_profit_callback=$qry->whole_profit_callback;
            $buyin_callback=$qry->buyin_callback;
            $sub_position_callback=$qry->sub_position_callback;
            $strategy_mode=$qry->strategy_mode;
            $strategy_type = $qry->strategy_type;
            $risk_type=$qry->risk_type;
          }
          else
          {
          
            $qry='';
            $qury = $this->db->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getResult();
            $qry=$qury[0];
            $first_buy_amount=$qry->first_buy_amount;
            $open_position_doubled=$qry->open_position_doubled;
            $margin_column_limit=$qry->margin_column_limit;
            $whole_profit_ratio=$qry->whole_profit_ratio;
            $whole_profit_callback=$qry->whole_profit_callback;
            $buyin_callback=$qry->buyin_callback;
            $sub_position_callback=$qry->sub_position_callback;
            $strategy_mode=$qry->strategy_mode;
            $strategy_type = $qry->strategy_type;
            $risk_type=$qry->risk_type;
          
          
          }
         ?>
      <section class="dash-banner-bg banner-bg">
         <div class="container">
            <!---header start---->
            <?php echo view('user/layout/header');?>
            <!---header end---->
            <!---banner start---->
            <div class="dash-wrap">
               <div class="title text-center py-2">
                  <h2 class="text-primary ">Transaction Settings</h2>
               </div>
               <form class="" id="exampleModal1" method="post" action="<?php echo base_url().'/tradedetails/'.$symbol;?>" enctype="multipart/form-data">
                  <div class="team-tab">
                     <div class="row">
                        <div class="col-sm-10 offset-sm-1">
                        
                              <div class="row mb-3" >
                                 <div class="col-sm-4">
                                    <label>Risk Type</label>
                                 </div>
                                 <div class="col-sm-8">
                                    <!-- <div class="form position-relative login-ico"> -->
                                    <select name="risk_type" id="risk_type" class="form-control ps-2 form-arrow">
                                       <option value="1" <?php if($risk_type==='1'){ echo "selected==selected";} ?>>Steady</option>
                                       <option value="2" <?php  if($risk_type==='2') { echo "selected==selected";}?>>Conservative</option>
                                       <option value="3" <?php if($risk_type==='3'){ echo "selected==selected";}?>>Radical</option>
                                    </select>
                                    <!-- </div> -->
                                 </div>
                              </div>
                              
                               <div class="row mb-3" >
                                 <div class="col-sm-4">
                                    <label>Strategy Mode</label>
                                 </div>
                                 <div class="col-sm-8">
                                    <!-- <div class="form position-relative login-ico"> -->
                                    <select name="strategy_mode" id="strategy_mode" class="form-control ps-2 form-arrow">
                                       <option value="1" <?php if($strategy_mode==='1'){ echo "selected==selected";} ?>>Whole warehouse mode</option>
                                       <option value="2" <?php  if($strategy_mode==='2') { echo "selected==selected";}?>>Sub-bin mode</option>
                                       <option value="3" <?php if($strategy_mode==='3'){ echo "selected==selected";}?>>Sub-bin mode Realtime settlement</option>
                                    </select>
                                    <!-- </div> -->
                                 </div>
                              </div>
                              
                              <div class="row mb-3" style="display:none;">
                                 <div class="col-sm-4">
                                    <label>Remarks (optional)</label>
                                 </div>
                                 <div class="col-sm-8">
                                   
                                    <input type="text" class="form-control mt-1" placeholder="Optional" name="remark" id="remark" value="">
                                 </div>
                              </div>
                              <div class="row mb-3">
                                 <div class="col-sm-4">
                                    <label>First order amount</label>
                                 </div>
                                 <div class="form-block col-sm-8 position-relative login-ico">
                                 
                                    <input type="number" class="form-control mt-1 required" placeholder="" name="first_buy_amount" id="first_buy_amount" value="<?php echo $first_buy_amount;?>"  onkeypress="return isNumber(event)" />
                                    <div id="old_error1" class="help-block"></div>
                                 </div>
                              </div>
                              <div class="row mb-3">
                                 <div class="col-sm-4">
                                    <label>Double open position</label>
                                 </div>
                                 <div class="col-sm-8">
                                    <select name="open_position_doubled" class="form-control ps-2 form-arrow">
                                       <option value="off" <?php if($open_position_doubled=='off') { echo "selected==selected";}?>>No</option>
                                       <option value="on" <?php if($open_position_doubled=='on') { echo "selected==selected";}?>>Yes</option>
                                    </select>
                                 </div>
                              </div>
                              <div class="row mb-3">
                                 <div class="col-sm-4">
                                    <label class="">Replenishment times</label>
                                 </div>
                                 <div class="col-sm-8">
                                    <input type="number" class="form-control mt-1 required" id="replenishment_time" name="replenishment_time" placeholder=""  value="<?php echo $margin_column_limit;?>"  onkeypress="return isNumber(event)" / >
                                 </div>
                              </div>
                              <div class="row mb-3">
                                 <div class="col-sm-4">
                                    <label class="">Whole position take profit ratio (%)</label>
                                 </div>
                                 <div class="form-block col-sm-8 position-relative login-ico">
                                  
                                    <input type="number" class="form-control mt-1 required" placeholder=""  name="whole_profit_ratio" value="<?php echo $whole_profit_ratio;?>"  onkeypress="return isNumber(event)" />
                                 </div>
                              </div>
                              <div class="row mb-3">
                                 <div class="col-sm-4">
                                    <label class="">Whole position take profit Callback (%)</label>
                                 </div>
                                 <div class="form-block col-sm-8 position-relative login-ico">
                                
                                    <input type="number" class="form-control mt-1 required" placeholder=""  name="whole_profit_callback" value="<?php echo $whole_profit_callback;?>"  onkeypress="return isNumber(event)" / >
                                 </div>
                              </div>
                              <div class="row mb-3">
                                 <div class="col-sm-4 sublabel" >
                                    <label>Sub-Position take-profit callback (%)</label>
                                 </div>
                                 <div class="form-block col-sm-8 position-relative login-ico " id="subposition" >
                                  
                                    <input type="number" class="form-control mt-1 required" placeholder="" name="sub_position_callback"  value="<?php echo $sub_position_callback;?>" onkeypress="return isNumber(event)" />
                                 </div>
                              </div>
                              <div class="row mb-3">
                               
                                 <div class="form-block col-sm-12 position-relative login-ico" id="margin" onclick="margin_pass()">
                                 
                                    <div class="form-ico password-toggle-icon2">
                                       <i class="fa fa-angle-right"></i>
                                    </div>
                                    <input type="text" class="form-control mt-1" style="border:none!important;" placeholder="Margin Configuration" id="" value="" readonly>
                                 </div>
                              </div>
                              <div class="row mb-3">
                                 <div class="col-sm-4">
                                    <label class="">Buy in callback (%)</label>
                                 </div>
                                 <div class="form-block col-sm-8 position-relative login-ico">
                                  
                                    <input type="number" class="form-control mt-1 required" placeholder=""  name="buyin_callback" value="<?php echo $buyin_callback;?>" onkeypress="return isNumber(event)" / >
                                 </div>
                              </div>

                              <div class="row mb-3">
                                 <div class="col-sm-4">
                                    <label>Strategy Type</label>
                                 </div>
                                 <div class="col-sm-8">
                                    <select name="strategy_type" class="form-control ps-2 form-arrow">
                                       <option value="Cycle Strategy" <?php if($strategy_type=='Cycle Strategy') { echo "selected==selected";}?>>Cycle</option>
                                       <option value="Single strategy" <?php if($strategy_type=='One-shot strategy') { echo "selected==selected";}?>>Single</option>
                                    </select>
                                 </div>
                              </div>
                              
                      
                           <div align="center">
                           <button type="submit" class="btn btn-primary" name="strategy" value="strategy">Get a Suggested Strategy</button>
                              <button type="button" id="submit_button" class="btn btn-primary" name="sub" value="sub">Submit</button>
                           </div>
                        </div>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </section>
      <?php echo view('user/layout/footer');?> 
      <?php echo view('user/layout/footer-script');?>
      <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
      <script src="<?php echo base_url();?>/styles/new_style/js/notify.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/jquery.dataTables.min.js"></script>
      <script type="text/javascript">
        
        function isNumber(evt) {
            evt = (evt) ? evt : window.event;
            var charCode = (evt.which) ? evt.which : evt.keyCode;
           
            if (charCode > 31 && (charCode < 48 || charCode > 57)) 
            {
                if(charCode!='46')
                return false;
                else
                return true;
            }
            return true;
        }

         function margin_pass()
         {
          
           var num = $('#replenishment_time').val();
           window.location.href = "<?php echo base_url();?>/margin-configuration/"+"<?php echo $symbol;?>/"+num;

         }
         
         
         $(window).on('load', function () 
         {
           var num= "<?php if(!empty($trade_process->margin_column_limit)) { echo $trade_process->margin_column_limit; } else echo "";?>";
           if(num =="")
           num = 7;
         
           $.ajax({
           type: 'post',
           dataType:'html',
           url : '<?php echo base_url("/replenishment_time1");?>',
           data : {'number1':num,'pair':'<?php echo $symbol;?>'},
           headers: {'X-Requested-With': 'XMLHttpRequest'},
           success : function(msg)
           {
           if(msg)
           {
           $('#ex_demo1').html(msg);
           }
           }
           });
         
           $.ajax({
           type: 'post',
           dataType:'html',
           url : '<?php echo base_url("/replenishment_time2");?>',
           data : {'number2':num,'pair':'<?php echo $symbol;?>'},
           headers: {'X-Requested-With': 'XMLHttpRequest'},
           success : function(msg)
           {
           if(msg)
           {
           $('#ex_demo2').html(msg);
           }
           }
           });
         
           $.ajax({
           type: 'post',
           dataType:'html',
           url : '<?php echo base_url("/replenishment_time");?>',
           data : {'number':num,'pair':'<?php echo $symbol;?>'},
           headers: {'X-Requested-With': 'XMLHttpRequest'},
           success : function(msg)
           {
           if(msg)
           {
           $('#ex_demo').html(msg);
           }
           }
           });
         
         });
         
         
         $('#replenishment_time').keyup(function(){
         
         var num = $('#replenishment_time').val();
         
         if(num>=5)
         {
                   $.ajax({
                   type: 'post',
                   dataType:'html',
                   url : '<?php echo base_url("/replenishment_time");?>',
                   data : {'number':num,'pair':'<?php echo $symbol;?>'},
                   headers: {'X-Requested-With': 'XMLHttpRequest'},
                   success : function(msg)
                   {
                       if(msg)
                       {
                       $('#ex_demo').html(msg);
                       }
                   }
                   });
         
                   $('#subposition').css('display', 'block');
                   $('.sublabel').css('display', 'block');
         
         }
         else
         {
           $('#ex_demo').html("");
           $('#subposition').css('display', 'block');
           $('.sublabel').css('display', 'block');
         }
         });
         
         
         $('#replenishment_time').keyup(function(){
         
         var num = $('#replenishment_time').val();
         
         if(num>0)
         {
                   $.ajax({
                   type: 'post',
                   dataType:'html',
                   url : '<?php echo base_url("/replenishment_time1");?>',
                   data : {'number1':num,'pair':'<?php echo $symbol;?>'},
                   headers: {'X-Requested-With': 'XMLHttpRequest'},
                   success : function(msg)
                   {
                       if(msg)
                       {
                       $('#ex_demo1').html(msg);
                       }
                   }
                   });
         
         }
         });
         
         $('#replenishment_time').keyup(function(){
         var num = $('#replenishment_time').val();
         if(num>0)
         {
                   $.ajax({
                   type: 'post',
                   dataType:'html',
                   url : '<?php echo base_url("/replenishment_time2");?>',
                   data : {'number2':num,'pair':'<?php echo $symbol;?>'},
                   headers: {'X-Requested-With': 'XMLHttpRequest'},
                   success : function(msg)
                   {
                       if(msg)
                       {
                       $('#ex_demo2').html(msg);
                       }
                   }
                   });
         
         }
         });
         
         $('#submit_button').click(function(){
         var first_buy_amount =  $("[name=first_buy_amount]").val();
         var whole_profit_ratio =  $("[name=whole_profit_ratio]").val();
         var whole_profit_callback =  $("[name=whole_profit_callback]").val();
         var sub_position_callback = $("[name=sub_position_callback]").val();
         var limit = $("[name=replenishment_time]").val();
         var buyin_callback =  $("[name=buyin_callback]").val();
         var flag = 1;
         if(!(whole_profit_ratio > 0)){
             $.notify(' <i class="fas fa-exclamation-triangle"></i> Please enter a value greater than 1', 'danger');
             flag = 0;
         }
           if(limit >= 5){
           var j=0;
           var i;
              for(i=5; limit >= i; i++){
               var var_name = "rep_time"+j;
               if($("[name="+var_name+"]").val() < sub_position_callback && flag == 1){
               $.notify(' <i class="fas fa-exclamation-triangle"></i> Subbin Take profit ratio will be greater than subbin take profit callback', 'danger');
               flag = 0;
               }
               j++;
              }
           }
         
         
         if(whole_profit_ratio < whole_profit_callback && flag == 1){
             $.notify(' <i class="fas fa-exclamation-triangle"></i> Take profit ratio will be greater than take profit callback', 'danger');
             //flag = 0;
           }
           if(!(buyin_callback >= 0) && flag == 1){
             $.notify(' <i class="fas fa-exclamation-triangle"></i> Please enter a positive value', 'danger');
             flag = 0;
           }
           if(!(first_buy_amount >= 11 && flag == 1)){
             $.notify(' <i class="fas fa-exclamation-triangle"></i> Minimum first buy amount is 11 USDT', 'danger');
             flag = 0;
         }
         
         var empty = true;
         
         $('#exampleModal1 input[type="text"]').each(function() {
          var fieldValue = $(this).val().trim();

          if ($(this).hasClass('required') && fieldValue === '') {
          
         $flag = 0;
         empty = false;
         return false;
         }
        
         });
         
         if(empty == false){
         $.notify(' <i class="fas fa-exclamation-triangle"></i> Some fields are empty', 'danger');
         }
         else
         {
             
              $('#exampleModal1').submit();
              $.notify('<i class="fas fa-check"></i>  Set Successfully', 'success');
             
         }
         
          //  if(flag == 1 && empty == true){
          //    $('#exampleModal1').submit();
          //    $.notify('<i class="fas fa-check"></i>  Set Successfully', 'success');
          //  }
             
         });  
         
         $('#subposition').css('display', 'block');
         $('.sublabel').css('display', 'block');
         
          var num = $('#replenishment_time').val();
          if (num >= 5) {
         
        $('#subposition').css('display', 'block');
       
        $('.sublabel').css('display', 'block');
    
    } else {
        $('#subposition').css('display', 'block');
        $('.sublabel').css('display', 'block');
    }
         
      </script>
   </body>
</html>