<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>API Binding</title>
      <?php echo view('user/layout/head');?>
   </head>
   <style>
      .para
      {
      text-align:justify;
      color:#fff;
      }
      .help-block {
      color: red;
      margin: 0em 0em 0em !important;
      }
      .alert-success {
      color: #0f5132;
      background-color: #d1e7dd;
      border-color: #badbcc;
      font-size: 12px;
      }
      .span
      {
      font-size: 12px;
      color: #9395a1;
      margin-top: 14px;
      font-weight: 900;
      }
      #getcode1 {
      background: #b18720;
      box-shadow: 0px 0px 39px 0px rgba(255,227,172,0.27);
      border: none;
      padding: 16px;
      margin-top: -66px;
      /* margin-right: -38px !important; */
      margin-left: 80%;
      font-size: 12px;
      /* position: absolute; */
      border-top-right-radius: 10px;
      display: flex;
      align-items: end;
      border-bottom-right-radius: 10px;
      }
      p.frgtpwd1 {
      background:#8DC540 !important
      }
      p.frgtpwd1 i {
      background:#8DC540 !important;
      color:#fff !important
      }
      p.frgtpwd {
      font-size: 13px;
      color: #fff;
      text-align: left;
      line-height: 24px;
      margin: 0 0 1em 0;
      background: #22313F;
      border-radius: 2px;
      padding:10px 39px 10px 10px;
      font-weight: 600;
      position: relative;
      }
      p.frgtpwd i {
      position: absolute;
      top: 0;
      right: 0;
      padding:15px 8px 8px 8px;
      font-size: 14px;
      background: #F5AB35;
      color: #22313F;
      height: 100%;
      }
      p.frgtpwdred {
      background:#EB5055 !important;
      }
      p.frgtpwdred i {
      background:#EB5055 !important
      }
      .content{
      text-align : justify;
      }
      .ref-copy .copyLink {
      color:#fff;
      top: 50%;
      right: 20px;
      cursor: pointer;
      transform: translateY(-50%);
      }
      .ref-copy .copyLink:hover:after {
      opacity: 1;
      transform: translateY(0) translateX(-50%);
      }
      .ref-copy .copyLink:after {
      content: attr(tooltip);
      width: 140px;
      /* bottom: 80px; */
      left: 80%;
      padding: 5px;
      border-radius: 4px;
      font-size: 0.8rem;
      opacity: 0;
      pointer-events: none;
      position: absolute;
      background:linear-gradient(180deg, rgba(179,137,34,1) 0%, rgba(140,98,10,1) 50%, rgba(179,137,34,1) 100%, rgba(14,72,62,1) 100%);
      color: #000;
      transform: translateY(-10px) translateX(-50%);
      transition: all 300ms ease;
      text-align: center;
      }
      .password-toggle-icon {
      position: absolute;
      top: 67%;
      right: 10px;
      color:#fff;
      transform: translateY(-50%);
      cursor: pointer;
      }
      .password-toggle-icon i {
      font-size: 18px;
      line-height: 1;
      color: #fff;
      transition: color 0.3s ease-in-out;
      margin-bottom: 15px;
      }
      .password-toggle-icon i:hover {
      color: gold;
      }
   </style>
   <body class="reg-overflow">
      <section class=" dash-banner-bg banner-bg referral profile">
         <div class="container">
         <!---header start---->
         <?php echo view('user/layout/header');?>
         <!---header end---->
         <!---banner start---->
         <div class="dash-wrap">
            <div class="title text-center py-2">
               <div class="row">
                  <div class="col-lg-3">
                     <a href="<?php echo base_url();?>/apikeylist"  class="btn btn-primary" style="border-radius:20px">back</a>
                  </div>
                  <div class="col-lg-7">
                     <h2 class="text-primary ">Bybit binding</h2>
                  </div>
               </div>
            </div>
            <div class="row">
               <center>
                  <?php
                     use App\Libraries\MyEncrypt;
                     use App\Helpers\site_helper;
                     use App\Helpers\form_helper;
                     $this->db = db_connect();
                     $this->session = session();
                     $this->common_model = model('CommonModel');
                     $this->form_validation =  \Config\Services::validation();
                     $list = \Config\Services::validation()->listErrors();
                     
                     helper('form_helper');
                     //echo view('user/common_header');
                     $us_data = userMinPass();
                     ?>       
                  <div class="col-lg-10">
                     <?php 
                        $session = \Config\Services::session();
                        if($session->getFlashData('success_message')) 
                        {
                        ?>
                     <p class="frgtpwd frgtpwd1 mt-5"><i class="fa fa-thumbs-up"></i><?php echo $session->getFlashData('success_message');?></p>
                     <?php 
                        } 
                        else if($session->getFlashData('error_message')) 
                        { 
                        ?>
                     <p class="frgtpwd frgtpwd1 frgtpwdred mt-5"><i class="fa fa-thumbs-down"></i><?php echo $session->getFlashData('error_message');?></p>
                     <?php 
                        } 
                        
                        
                        $this->session = session();
                        $api = $this->common_model->GetRow('api_exchange_list','id=5');
                        $uusersid = $this->session->get('uusersid');
                           $referral1=$this->db->query("SELECT * FROM bind_process WHERE uusersid='".$uusersid."' and type=5");
                           $ref=$referral1->getRow();
                        
                        ?>
                     <div class="reg-page mt-5 ">
                        <div class="ip mt-3 content">
                           <p class="text-white text-start"><strong>IP group binding</strong></p>
                           <p class="text-white-50 ">
                              ByBit suggest that users bind IP address when creating API for safety purpose. If not bound, the API private key will expire after 3 months. Please copy the following IP address and paste it to the "Only IPs with permissions granted are allowed to access the OpenAPI" on ByBit API binding page.
                           </p>
                        </div>
                        <div class="ref-form-list mt-5 mb-5" >
                           <div class="ref-form d-flex align-items-center">
                              <div class="ref-content text-start">
                                 <h5 class="text-white" id="test" ><?php echo $api->ip_address;?></h5>
                              </div>
                              <div class="ref-copy">
                                 <span class="copyLink text-decoration-none" id="copy" >
                                 <i class="fa-regular fa-copy"></i>
                                 </span>
                              </div>
                           </div>
                        </div>
                        <div class="pre-con content">
                           <p class="text-start text-white"><strong>Precautions</strong></p>
                           <div class="pre-list">
                              <ul class="list-unstyled text-white-50">
                                 <li>
                                    <h5>1. Please confirm that the API permission Enable Spot & Margin Trading has been checked.</h5>
                                 </li>
                                 <li>
                                    <h5>2. Please enter the correct API, please do not enter special characters</h5>
                                 </li>
                              </ul>
                           </div>
                        </div>
                        <span id="api_err1" style="color:red;font:bold;font-size: 15px;padding-top:10px;"></span>
                        <form class="steps-validation withdraw" method="post"  id="pin" action="<?php echo base_url();?>/bybit-bind">
                           <div class="row" style="margin-top:20px ">
                              <div class="col-lg-12 <?php if($this->form_validation->getError('account')) echo "has-error";?>">
                                 <div class="form-block form-group mb-3 user-box" >
                                    <select class="form-control form-arrow" name="account">
                                       <option value='1' <?php if($ref->account == '1'){echo 'selected';};?>>General Account</option>
                                       <option value='2' <?php if($ref->account == '2'){echo 'selected';};?>>Unified Trading Account</option>
                                    </select>
                                    <span id="account_err" style="color:red;font:bold;font-size: 15px;padding-top:10px;"></span>
                                    <?php echo $this->form_validation->getError('account', '<span class="help-block">', '</span>'); ?>
                                 </div>
                              </div>
                              <div class="col-lg-12 <?php if($this->form_validation->getError('api_code1')) echo "has-error";?>">
                                 <div class="form-block form-group mb-3 user-box" >
                                    <input name="api_code1" class="form-control" type="text" id="api_code1" placeholder="API Key" value="<?php echo isset($ref->api_key) ? $ref->api_key : '' ;?>" required=""/>
                                    <span id="api_err" style="color:red;font:bold;font-size: 15px;padding-top:10px;"></span>
                                    <?php echo $this->form_validation->getError('api_code1', '<span class="help-block">', '</span>'); ?>
                                 </div>
                              </div>
                              <div class="col-lg-12 <?php if($this->form_validation->getError('sec_code1')) echo "has-error";?>">
                                 <div class="form-block position-relative mb-3">
                                    <div class="form-ico password-toggle-icon" style="right:0px;" ><i class="fa-regular fa-eye-slash"></i></div>
                                    <input class="form-control" type="password" name="sec_code1" id="sec_code1" value="<?php echo isset($ref->secret_key) ? $ref->secret_key : '';?>" placeholder="Secret Key" required="">
                                    <!-- <span class=" password-toggle-icon"><i class="fas fa-eye-slash"></i></span> -->
                                    <span id="sec_err" style="color:red;font:bold;font-size: 15px;padding-top:10px;"></span>
                                    <?php echo $this->form_validation->getError('sec_code1', '<span class="help-block">', '</span>'); ?>
                                 </div>
                              </div>
                              <!-- <div class="col-lg-12">
                                 <div id="otp_val" ></div>
                                 </div>
                                 <div class="col-lg-12   <?php //if($this->form_validation->getError('code1')) echo "has-error";?>" >
                                 <div class="form-block form-group mb-3 user-box position-relative" >
                                    <input name="code1" class="form-control" type="text" id="code11" placeholder="Enter verification code" value="" required=""/>
                                    <button type="button" id="getcode1" name="getcode1">GETCODE</button>
                                 </div>
                                 <?php //echo $this->form_validation->getError('code1', '<span class="help-block">', '</span>'); ?>
                                 </div> -->
                           </div>
                           <input type="hidden" name="userid" id="userid" value="<?php echo $uusersid; ?>">
                           <div name="otpval" id="otpval" ></div>
                           <button type="submit" id="trans" name="trans" class="btn btn-primary mt-4 mb-5" >Bind API</button>
                        </form>
                     </div>
               </center>
               </div>
            </div>
            <?php echo view('user/layout/footer');?>
         </div>
      </section>
      <?php echo view('user/layout/footer-script');?>
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
      <script>
         jQuery.noConflict();
         (function( $ ) {
         $(function() {
         $(document).ready(function() {
         
         
         
         $(document).on("click", '#getcode1', function() {
          
             var uusersid = $('#userid').val();
             var api = $('#api_code1').val();
             var sec = $('#sec_code1').val();
         
         
             if((api=='') || (sec==''))
             {
               if(api=='')
               {
                 $('#api_err').html("Api Key is Required");
                    $('#trans').addClass('disabled');
               }
               if(sec=='')
               {
                 $('#sec_err').html("Secret Key is Required");
                   $('#trans').addClass('disabled');
               }
             }
             else
             {
               $('#api_err').html("");
               $('#sec_err').html("");
                 $('#trans').removeClass('disabled');
               $.ajax({
                     type: 'post',
                     url : '<?php echo base_url();?>/apikeylist/verificationcode',            
                     data : {'uusersid':uusersid},
                     dataType:'json',
                     success : function(msg)
                     {             
                     if(msg!=='')
                        {
                   
                            $("#otp_val").html('<div  class="alert alert-success">'+msg+'</div>');
         
                            setTimeout(otphide,3000);
         
                         }
                     }
                 });
             }
         });
         
         function otphide()
         {
         $('#otp_val').html("");
         }
         $(document).on("keyup", '#api_code1', function() {
             
             var api = $('#api_code1').val();
             var sec = $('#sec_code1').val();
               $.ajax({
                     type: 'post',
                     url : '<?php echo base_url();?>/apikeylist/verifyapi',            
                     data : {'api':api,'sec':sec},
                     dataType:'json',
                     success : function(msg)
                     {  
                       
                     if(msg!='')
                        {
                           $('#api_err1').html("Api Key or Secret Key is invalid");
                                             
                             $('#getcode1').prop('disabled', true);
                             $('#trans').addClass('disabled');
                         }
                       else
                       {
                         $('#api_err1').html("");
                                       
                          $('#getcode1').prop('disabled', false);
                          $('#trans').removeClass('disabled');
                       }
                     }
                 });
         });
         $('#sec_code1').keyup(function() {
             
             var api = $('#api_code1').val();
             var sec = $('#sec_code1').val();
               $.ajax({
                     type: 'post',
                     url : '<?php echo base_url();?>/apikeylist/verifyapi',            
                     data : {'api':api,'sec':sec},
                     dataType:'json',
                     success : function(msg)
                     {  
                      
                     if(msg!='')
                        {
                          $('#api_err1').html("Api Key or Secret Key is invalid");                
                             $('#getcode1').prop('disabled', true);
                             $('#trans').addClass('disabled');
                         }
                       else
                       {
                         $('#api_err1').html("Api Key or Secret Key is invalid");        
                          $('#getcode1').prop('disabled', false);
                          $('#trans').removeClass('disabled');
                       }
                     }
                 });
         });
         
         $(document).on("keyup", '#code11', function() {
             var uusersid = $('#userid').val();
             var code1 = $('#code11').val();
         
           if(uusersid!="")
           {
               $.ajax({
                     type: 'post',
                     url : '<?php echo base_url();?>/apikeylist/verifyotp',            
                     data : {'code1':code1},
                     dataType:'json',
                     success : function(msg)
                     {           
                     if(msg!=='')
                        {                               
                        $("#otpval").html('<div class="text-danger" style="font-size:15px;font-weight: 900;;">'+msg+'</div>');
                        $('#trans').addClass('disabled');
                         }
                     else
                       {
                         $("#otpval").html("");
                         $('#trans').removeClass('disabled');
                       }
                     }
                 })
         } 
         
         });
         });
         });
         })(jQuery);
         
      </script>
      <script>
         const passwordField = document.getElementById("sec_code1");
         const togglePassword = document.querySelector(".password-toggle-icon i");
         
         togglePassword.addEventListener("click", function () {
         
         if (passwordField.type === "password") {
         passwordField.type = "text";
         
         togglePassword.classList.remove("fa-eye-slash");
         togglePassword.classList.add("fa-eye");
         } else {
         passwordField.type = "password";
         togglePassword.classList.remove("fa-eye");
         togglePassword.classList.add("fa-eye-slash");
         
         }
         });
         
         
         const input = document.getElementById("test");
         // console.log(input);
         const copyButton1 = document.getElementById("copy");
         const copyText = (e) => {
         var temp = $("<input>");
         $("body").append(temp);
         temp.val($(input).html()).select();
         document.execCommand("copy");
         e.currentTarget.setAttribute("tooltip", "Copied!");
         };
         const resetTooltip = (e) => {
         e.currentTarget.setAttribute("tooltip", "Copy to clipboard");
         };
         copyButton1.addEventListener("click", (e) => copyText(e));
         copyButton1.addEventListener("mouseover", (e) => resetTooltip(e));
      </script>
   </body>
</html>