<?php
$required_pairs = ['1INCH','ADA','AAVE','ATOM','ALGO','AION','AVAX','AKRO','ANT','APE','BAT','BTC','BCH','BNB','BTCST','BAKE','BOME','BONK','CRV','COMP','CAKE','COS','DOGE','DASH','DOT','ETH','EOS','ETC','FTM','FTT','FIL','GALA','GRT','GMT','HBAR','HOT','IOTA','ICP','IOST','JST','KAVA','KSM','LTC','LINK','LIT','LUNA','MANA','MATIC','MDX','NEO','NOT','OMG','ONT','PEPE','QTUM','REEF','RSR','SUN','SHIB','SLP','SOL','SUSHI','SXP','TRX','THETA','TFUEL','UNI','VET','WRX','XRP','XMR','XEM','XLM','XTZ','YFI','YFII','ZEC','ZEN'];

$data_binance = json_decode(file_get_contents('https://trade.apfm.io/trading_pairs.json'), true);

if($data_binance) {
    echo '<table border="1">';
    echo '<tr><th>Symbol</th><th>Last Price</th><th>Price Change Percentage</th></tr>';
    
    foreach($required_pairs as $pair) {
        $symbol_find = $pair . 'USDT';
        
        foreach ($data_binance as $data) {
            if ($data['symbol'] == $symbol_find) {
                echo '<tr>';
                echo '<td>' . $data['symbol'] . '</td>';
                echo '<td>' . $data['lastPrice'] . '</td>';
                echo '<td>' . $data['priceChangePercentage'] . '%</td>';
                echo '</tr>';
                break; // Exit the inner loop if a match is found
            }
        }
    }
    
    echo '</table>';
} else {
    echo 'No data found';
}
?>