<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*

 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------

*/



// We get a performance increase by specifying the default
// route since we don't have to scan directories.
//user-dashboard Routes

$routes->add('/autoLoad', "dashboard::autoLoad", ["namespace" => "App\Controllers\User"]);

$routes->add('/tradeLoad', "dashboard::tradeLoad", ["namespace" => "App\Controllers\User"]);
$routes->add('/autoLoad1', "dashboard::autoLoad1", ["namespace" => "App\Controllers\User"]);
$routes->add('/getPairDetails', "dashboard::getPairDetails", ["namespace" => "App\Controllers\User"]);
$routes->add('/autoLoadPrice', "TradeDetail::autoLoadPrice", ["namespace" => "App\Controllers\User"]);
$routes->add('/update_live_price', "TradeDetail::update_live_price", ["namespace" => "App\Controllers\User"]);
$routes->add('/orderDetails', "TradeDetail::orderDetails", ["namespace" => "App\Controllers\User"]);
$routes->add('/sell_calculate', "TradeDetail::sell_calculate", ["namespace" => "App\Controllers\User"]);
$routes->add('/buy_calculate', "TradeDetail::buy_calculate", ["namespace" => "App\Controllers\User"]);
$routes->add('/cancel_order', "TradeDetail::cancel_order", ["namespace" => "App\Controllers\User"]);
$routes->add('/profit_calculation', "TradeDetail::profit_calculation", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/favourites', "dashboard::favourites", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/favourites1', "dashboard::favourites1", ["namespace" => "App\Controllers\User"]);
$routes->post('/balance_update', "dashboard::balance_update", ["namespace" => "App\Controllers\User"]);
$routes->get('/asset_update', "dashboard::asset_update", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/favourites_trade', "dashboard::favourites_trade", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/favourites1_trade', "dashboard::favourites1_trade", ["namespace" => "App\Controllers\User"]);
$routes->add('/currency_block_list', "circle::currency_block_list", ["namespace" => "App\Controllers\User"]);

$routes->add('/dashboard/first_preset_drop', "dashboard::first_preset_drop", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/oneshot_limit', "dashboard::oneshot_limit", ["namespace" => "App\Controllers\User"]);
$routes->add('/logModal', "TradeDetail::logModal", ["namespace" => "App\Controllers\User"]);
$routes->add('/call_margin', "TradeDetail::call_margin", ["namespace" => "App\Controllers\User"]);
$routes->add('/orders/(:any)', "TradingOrders::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/', "Login::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/request', "Login::request", ["namespace" => "App\Controllers\User"]);
$routes->get('/wallet_connect', "Login::wallet_connect", ["namespace" => "App\Controllers\User"]);
$routes->add('/global_divide', "Login::global_divide", ["namespace" => "App\Controllers\User"]);
$routes->get('/check', "Login::check", ["namespace" => "App\Controllers\User"]);
$routes->get('/test', "Login::test", ["namespace" => "App\Controllers\User"]);
$routes->post('/depositverify', "Login::depositverify", ["namespace" => "App\Controllers\User"]);
$routes->get('/depositverify', "Login::depositverify", ["namespace" => "App\Controllers\User"]);

$routes->get('/register', "Register::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/register/(:any)', "Register::index/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/register', "Register::index", ["namespace" => "App\Controllers\User"]);
$routes->add('/apikeylist', "ApiKeyList::index", ["namespace" => "App\Controllers\User"]);
$routes->add('/apikeylist/verificationcode', "ApiKeyList::verificationcode", ["namespace" => "App\Controllers\User"]);
$routes->add('/apikeylist/verifyotp', "ApiKeyList::verifyotp", ["namespace" => "App\Controllers\User"]);
$routes->add('/apikeylist/verifyapi', "ApiKeyList::verifyapi", ["namespace" => "App\Controllers\User"]);
$routes->add('/apikeylist/submit_data', "ApiKeyList::submit_data", ["namespace" => "App\Controllers\User"]);
$routes->add('/orders', "TradingOrders::index", ["namespace" => "App\Controllers\User"]);
$routes->add('/balance', "RewardBalance::index", ["namespace" => "App\Controllers\User"]);
$routes->add('/user/settings', "UserSettings::index", ["namespace" => "App\Controllers\User"]);
 $routes->add('/settings', "UserSettings::index", ["namespace" => "App\Controllers\User"]);
$routes->add('/reset', "Login::reset", ["namespace" => "App\Controllers\User"]);
$routes->add('/testmail', "Login::testmail", ["namespace" => "App\Controllers\User"]);
$routes->get('/testmail', "Login::testmail", ["namespace" => "App\Controllers\User"]);
$routes->add('/tradedetails/(:any)', "TradeDetail::index/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/tradesettingsupdate/(:any)', "TradeDetail::trade_change/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('/first_preset_price', "TradeDetail::first_preset_price", ["namespace" => "App\Controllers\User"]);
$routes->add('/strategy_mode', "TradeDetail::strategy_mode", ["namespace" => "App\Controllers\User"]);
$routes->add('/tradingprocess', "TradeDetail::tradingprocess", ["namespace" => "App\Controllers\User"]);
$routes->add('/traderesume', "TradeDetail::tradingprocess_resume", ["namespace" => "App\Controllers\User"]);
$routes->add('/tradingprocess1', "TradeDetail::tradingprocess1", ["namespace" => "App\Controllers\User"]);
$routes->add('/tradingprocess2', "TradeDetail::tradingprocess2", ["namespace" => "App\Controllers\User"]);
$routes->add('/tradingsell', "TradeDetail::tradingsell", ["namespace" => "App\Controllers\User"]);
$routes->add('/tradingbuy', "TradeDetail::tradingbuy", ["namespace" => "App\Controllers\User"]);
$routes->add('/replenishment_time', "TradeDetail::replenishment_time", ["namespace" => "App\Controllers\User"]);
$routes->add('/replenishment_time1', "TradeDetail::replenishment_time1", ["namespace" => "App\Controllers\User"]);
$routes->add('/replenishment_time2', "TradeDetail::replenishment_time2", ["namespace" => "App\Controllers\User"]);
$routes->add('/news_details/(:any)', "news::news_details/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/checkpin', "withdraw::checkpin", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/validate_email', "withdraw::validate_email", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/email_verify', "withdraw::email_verify", ["namespace" => "App\Controllers\User"]);
$routes->add('/Cstartegy', "TradeDetail::Cstartegy", ["namespace" => "App\Controllers\User"]);
$routes->add('/Ostartegy', "TradeDetail::Ostartegy", ["namespace" => "App\Controllers\User"]);
$routes->add('/Cstartegy_mode', "TradeDetail::Cstartegy_mode", ["namespace" => "App\Controllers\User"]);
$routes->add('/user/UserSetting/pro_update','UserSettings::pro_update',["namespace"=>"App\Controllers\User"]);
$routes->add('/UserSetting/pro_update','UserSettings::pro_update',["namespace"=>"App\Controllers\User"]);
$routes->add('/UserSettings/verifyregcode5','UserSettings::verifyregcode5',["namespace"=>"App\Controllers\User"]);
$routes->add('/UserSettings/verifyotp5','UserSettings::verifyotp5',["namespace"=>"App\Controllers\User"]);
$routes->add('/Usersettings/changePwd','UserSettings::changePwd',["namespace"=>"App\Controllers\User"]);
$routes->add('/UserSettings/verifyregcode4','UserSettings::verifyregcode5',["namespace"=>"App\Controllers\User"]);
$routes->add('/UserSettings/verifyotp4','UserSettings::verifyotp4',["namespace"=>"App\Controllers\User"]);
$routes->add('/Usersettings/changeTpwd','UserSettings::changeTpwd',["namespace"=>"App\Controllers\User"]);
$routes->add('referral/(:any)', "Register::referral", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/circle', "circle::index", ["namespace" => "App\Controllers\User"]);
$routes->add('/circle/pair_select', "circle::pair_select", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle_registration', "circle::circle_registration", ["namespace" => "App\Controllers\User"]);
$routes->add('/tickets', "circle::tickets", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle_edit/(:any)', "circle::circle_edit/$1", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle_list', "circle::circle_list", ["namespace" => "App\Controllers\User"]);
$routes->add('/circle_add', "circle::circle_add", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/circle', "circle::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle/user_view/(:any)', "circle::user_view/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle/user_view/(:any)', "circle::user_view/$1", ["namespace" => "App\Controllers\User"]);
$routes->get('/currency_edit/(:any)', "circle::currency_edit/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/currency_edit/(:any)', "circle::currency_edit/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/sug_strategy', "TradeDetail::sug_strategy", ["namespace" => "App\Controllers\User"]);


$routes->get('/circle_delete/(:any)', "circle::circle_delete/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle_delete/(:any)', "circle::circle_delete/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle/strategy_payment_exit(:any)', "circle::circle_payment_exit/$1", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle/strategy_payment_exit(:any)', "circle::circle_payment_exit/$1", ["namespace" => "App\Controllers\User"]);

$routes->get('admin/bot/activate-list', "Botactivate::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/bot/activate-list', "Botactivate::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/bot/activate-trade', "Botactivate::acitvate_trade", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/bot/pause-trade', "Botactivate::pause_trade", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/bot/close-trade', "Botactivate::close_trade", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/bot/close-trade', "Botactivate::close_trade", ["namespace" => "App\Controllers\Admin"]);


$routes->get('/circle/strategy_payment/(:any)', "circle::strategy_payment/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle/strategy_payment/(:any)', "circle::strategy_payment/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle/strategy_payment_cancel/(:any)', "circle::strategy_payment_cancel/$1", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle/strategy_payment_cancel/(:any)', "circle::strategy_payment_cancel/$1", ["namespace" => "App\Controllers\User"]);


$routes->get('ipn_process', "Ipn_verify::index", ["namespace" => "App\Controllers\User"]);
$routes->get('cron', "Login::cron", ["namespace" => "App\Controllers\User"]);
$routes->add('cron_first', "Login::cron", ["namespace" => "App\Controllers\User"]);
$routes->add('cron_buy', "Login::cronbuy", ["namespace" => "App\Controllers\User"]);
$routes->add('cron_second', "Login::cron2", ["namespace" => "App\Controllers\User"]);
$routes->add('cron2', "Login::cron2", ["namespace" => "App\Controllers\User"]);
$routes->add('cron3', "Login::cron3", ["namespace" => "App\Controllers\User"]);
$routes->add('cron_third', "Login::cron3", ["namespace" => "App\Controllers\User"]);
$routes->add('trade_fill_check_local', "Login::trade_fill_check", ["namespace" => "App\Controllers\User"]);
$routes->add('trade_fill_check', "Login::trade_fill_check", ["namespace" => "App\Controllers\User"]);
$routes->add('trade_update', "TradeDetail::trade_update", ["namespace" => "App\Controllers\User"]);
$routes->post('trade_update', "TradeDetail::trade_update", ["namespace" => "App\Controllers\User"]);
$routes->add('ordermessage', "TradeDetail::order_message", ["namespace" => "App\Controllers\User"]);
$routes->add('informations', "TradeDetail::system_information", ["namespace" => "App\Controllers\User"]);

$routes->add('trades/(:any)', "TradeDetail::trades", ["namespace" => "App\Controllers\User"]);
$routes->add('trade_orders', "TradeDetail::orders", ["namespace" => "App\Controllers\User"]);
$routes->post('trade_records', "TradeDetail::trade_records", ["namespace" => "App\Controllers\User"]);
$routes->post('order_records', "TradeDetail::order_records", ["namespace" => "App\Controllers\User"]);
$routes->add('trades_calc', "TradeDetail::trades_calc", ["namespace" => "App\Controllers\User"]);

$routes->get('admin/rewardsettings',"rewardsettings::index", ["namespace"=>"App\Controllers\Admin"]);





$routes->post('admin/rewardsettings',"rewardsettings::index", ["namespace"=>"App\Controllers\Admin"]);
$routes->get('admin/rewardsettings/edit/(:any)', "rewardsettings::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/rewardsettings/edit/', "rewardsettings::edit", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/rewardsettings/edit/(:any)', "rewardsettings::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/rewardsettings/add', "rewardsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/rewardsettings/add', "rewardsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/tradedelete/(:any)', "finance::tradedelete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/tradedelete/(:any)', "finance::tradedelete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/tradeaccept/(:any)', "finance::tradeaccept/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/tradeaccept/(:any)', "finance::tradeaccept/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/apibinding', "ApiBinding::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('/admin/apibind/ipchange', "ApiBinding::ipchange", ["namespace" => "App\Controllers\Admin"]);  
$routes->add('admin/apibinding/changeActiveStatus/(:any)', "ApiBinding::changeActiveStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/apibinding/changeStatus/(:any)', "ApiBinding::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);

$routes->get('withdraws', "dashboard::withdraw", ["namespace" => "App\Controllers\User"]);
$routes->add('withdrawfund', "withdraw::index", ["namespace" => "App\Controllers\User"]);
$routes->add('transfer', "withdraw::transfer", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/verifyregcode', "withdraw::verifyregcode", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/verifyregcode1', "withdraw::verifyregcode1", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/verifyotp', "withdraw::verifyotp", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw_details', "withdraw::withdraw_details", ["namespace" => "App\Controllers\User"]);
$routes->add('transfer_details', "withdraw::transfer_details", ["namespace" => "App\Controllers\User"]);
$routes->add('deposit_details', "withdraw::deposit_details", ["namespace" => "App\Controllers\User"]);
$routes->add('checkbalance(:any)', "withdraw::checkbalance/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('withdrawfee', "withdraw::withdrawfee", ["namespace" => "App\Controllers\User"]);
$routes->add('checkfee(:any)', "withdraw::checkfee", ["namespace" => "App\Controllers\User"]);
$routes->add('/user/validatewithdraw', "withdraw::validatewithdraw", ["namespace" => "App\Controllers\User"]);
$routes->add('/user/validatetransfer', "withdraw::validatetransfer", ["namespace" => "App\Controllers\User"]);
$routes->add('/withdraw/validatewithdraw', "withdraw_ico::validatewithdraw", ["namespace" => "App\Controllers\User"]);



$routes->get('myreferral', "myreferral::index", ["namespace" => "App\Controllers\User"]);

$routes->get('/login', "Login::index", ["namespace" => "App\Controllers\User"]);
$routes->post('/login', "Login::index", ["namespace" => "App\Controllers\User"]);
$routes->post('user/login', "Login::index", ["namespace" => "App\Controllers\User"]);

$routes->add('cms/(:any)', "User::cms", ["namespace" => "App\Controllers\User"]);
//fees
$routes->add('fees', "contact::fees", ["namespace" => "App\Controllers\User"]);
$routes->add('contact', "contact::index", ["namespace" => "App\Controllers\User"]);
$routes->post('contact', "contact::index", ["namespace" => "App\Controllers\User"]);
//fees
$routes->add('faq', "faq::index", ["namespace" => "App\Controllers\User"]);
//news
$routes->add('news', "news::index", ["namespace" => "App\Controllers\User"]);
//listing
$routes->add('listing', "listing::index", ["namespace" => "App\Controllers\User"]);
//$routes->get('/user/activation', "activation::activate", ["namespace" => "App\Controllers\User"]);
//$routes->post('/user/activation', "activation::activate", ["namespace" => "App\Controllers\User"]);
//$routes->get('/user/activation/activate',"activation::activate1",["namespace"=>"App\Controllers\User"]);
//$routes->post('/user/activation/activate',"activation::activate1",["namespace"=>"App\Controllers\User"]);
$routes->post('/user/activation_history',"activation::activation_history",["namespace"=>"App\Controllers\User"]);




$routes->get('user/login', "Login::index", ["namespace" => "App\Controllers\User"]);
$routes->get('user/dbbackup', "Login::dbbackup", ["namespace" => "App\Controllers\User"]);

$routes->get('/user/register', "Register::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/register/reg',"Register::reg",["namespace"=>"App\Controllers\User"]);
$routes->get('/check', "Login::check", ["namespace" => "App\Controllers\User"]);
$routes->get('/loadpair', "Login::loadpair", ["namespace" => "App\Controllers\User"]);

$routes->post('/user/register/reg',"Register::reg",["namespace"=>"App\Controllers\User"]);

$routes->get('/user/dashboard', "dashboard::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/dashboard', "dashboard::index", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/dashboard', "dashboard::index", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/suggested_strategy', "dashboard::suggested_strategy", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/replenishment_time', "dashboard::replenishment_time", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/replenishment_time1', "dashboard::replenishment_time1", ["namespace" => "App\Controllers\User"]);
$routes->add('/dashboard/replenishment_time2', "dashboard::replenishment_time2", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/activation', "activation::index", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/activation', "activation::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/activation/activate',"activation::activate",["namespace"=>"App\Controllers\User"]);
$routes->post('/user/activation/activate',"activation::activate",["namespace"=>"App\Controllers\User"]);

$routes->get('/user/activation/activate2',"activation::activate2",["namespace"=>"App\Controllers\User"]);
$routes->post('/user/activation/activate2',"activation::activate2",["namespace"=>"App\Controllers\User"]);

$routes->add('/user/activation/fuel',"activation::fuel",["namespace"=>"App\Controllers\User"]);
$routes->add('/user/deposit',"activation::deposit",["namespace"=>"App\Controllers\User"]);
$routes->post('/user/address',"activation::address",["namespace"=>"App\Controllers\User"]);

$routes->post('/user/payment_confirm',"activation::address_confirm",["namespace"=>"App\Controllers\User"]);
$routes->add('/user/payment_validate',"activation::address_validate",["namespace"=>"App\Controllers\User"]);

$routes->post('/user/verify_deposit',"activation::deposit_verify",["namespace"=>"App\Controllers\User"]);

$routes->add('/network',"activation::network",["namespace"=>"App\Controllers\User"]);


$routes->add('/activate/(:any)',"Login::activate",["namespace"=>"App\Controllers\User"]);
$routes->add('user/login/resetupdate',"Login::resetupdate",["namespace"=>"App\Controllers\User"]);

$routes->post('/user/activation/activate',"activation::activate",["namespace"=>"App\Controllers\User"]);
$routes->get('logout', "Login::logout", ["namespace" => "App\Controllers\User"]);
$routes->add('circle_promotion', "circle::promotion_list", ["namespace" => "App\Controllers\User"]);
$routes->get('promotion', "circle::promotion_list", ["namespace" => "App\Controllers\User"]);
$routes->get('promotion_list', "circle::promotion_list", ["namespace" => "App\Controllers\User"]);
$routes->add('circle/promotion_add', "circle::promotion_add", ["namespace" => "App\Controllers\User"]);
$routes->get('promotion_edit/(:any)', "circle::promotion_edit/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('promotion_delete/(:any)', "circle::promotion_delete/$1", ["namespace" => "App\Controllers\User"]);

$routes->get('/user/dashboard/genealogy', "Genealogy::index", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/genealogyview/view/(:any)', "Genealogyview::view/$1", ["namespace" => "App\Controllers\User"]);

$routes->get('/user/genealogyview/view/(:any)', "Genealogyview::view/$1", ["namespace" => "App\Controllers\User"]);

// know_customer
$routes->add('know_customer', "know_customer::index", ["namespace" => "App\Controllers\User"]);

$routes->get('ipn_process', "Ipn_verify::index", ["namespace" => "App\Controllers\User"]);

######################### end #####################################################
//admin-dashboard Routes
$routes->get('admin', "admin::index", ["namespace" => "App\Controllers\Admin"]);



$routes->get('admin/genealogy/view/(:any)',"Genealogy::view/$1",["namespace"=>"App\Controllers\Admin"]);

$routes->get('genealogy/view/(:any)',"Genealogy::view/$1",["namespace"=>"App\Controllers\Admin"]);
$routes->post('genealogy/view/(:any)',"Genealogy::view/$1",["namespace"=>"App\Controllers\Admin"]);





$routes->post('register','Register::verifyregcode',["namespace"=>"App\Controllers\User"]);

$routes->get('admin/profile', "profile::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/profile', "profile::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/changepassword', "profile::changepassword", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/changepassword', "profile::changepassword", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/validpassword', "profile::validpassword", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/accountsettings', "accountsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/usersettings', "usersettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/usersettings', "usersettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/emailsettings', "emailsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/emailsettings', "emailsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/referralsettings', "referralsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/referralsettings', "referralsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/addrset', "addrset::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/addrset', "addrset::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/addrset/add', "addrset::add", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/addrset/add', "addrset::add", ["namespace" => "App\Controllers\Admin"]);


$routes->add('referral/(:any)', "Register::referral", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/mycircle', "mycircle::index", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/mycircle', "mycircle::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/mycircle/mycircle_view/(:any)', "mycircle::mycircle_view/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/mycircle/mycircle_view/(:any)', "mycircle::mycircle_view/$1", ["namespace" => "App\Controllers\User"]);
$routes->get('/mycircle/strategy_table/(:any)', "mycircle::strategy_table/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/mycircle/strategy_table/(:any)', "mycircle::strategy_table/$1", ["namespace" => "App\Controllers\User"]);
$routes->get('/mycircle/cancel_sync/(:any)', "mycircle::cancel_sync/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/mycircle/cancel_sync/(:any)', "mycircle::cancel_sync/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('/mycircle/replenishment_time', "mycircle::replenishment_time", ["namespace" => "App\Controllers\User"]);
$routes->add('/mycircle/replenishment_time1', "mycircle::replenishment_time1", ["namespace" => "App\Controllers\User"]);
$routes->add('/mycircle/replenishment_time2', "mycircle::replenishment_time2", ["namespace" => "App\Controllers\User"]);

$routes->get('/user/circle', "circle::index", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/circle', "circle::index", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle/user_view/(:any)', "circle::user_view/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle/user_view/(:any)', "circle::user_view/$1", ["namespace" => "App\Controllers\User"]);
$routes->get('/circle/strategy_payment/(:any)', "circle::strategy_payment/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle/strategy_payment/(:any)', "circle::strategy_payment/$1", ["namespace" => "App\Controllers\User"]);

$routes->get('/circle/favourites_trade/(:any)', "circle::favourites_trade/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/circle/favourites1_trade/(:any)', "circle::favourites1_trade/$1", ["namespace" => "App\Controllers\User"]);


$routes->get('admin/users', "users::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/newusers', "users::newusers", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/users/autocomplete', "users::autocomplete", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/pending_activation', "users::pending_activation", ["namespace" => "App\Controllers\Admin"]);
$routes->add('pin_rankupgrade', "users::pin_rankupgrade", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/users/changeBotStatus', "users::changeBotStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/users/changeActiveBotStatus', "users::changeActiveBotStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/users', "users::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/users/changecountry', "users::changecountry", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/login/(:any)', "users::login/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/view/(:any)', "users::view/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/resetpassword/(:any)', "users::resetpassword/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/add/(:any)', "users::add/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/bonus/(:any)', "finance::bonus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/list_user/(:any)', "finance::list_user/$1", ["namespace" => "App\Controllers\Admin"]);

$routes->add('admin/finance/list_user_new', "finance::list_user_new", ["namespace" => "App\Controllers\Admin"]);



$routes->get('admin/finance/pendingpayouts', "masspayout::index", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/finance/pendingwithdraw', "masspayout::pendingpayment", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/history/adminearnings', "history::adminearnings", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/history/deposit', "history::deposit", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/history/deposit', "history::deposit", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/history/transfer', "history::transfer", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/history/transfer', "history::transfer", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/reports/checkusertypes/(:any)', "reports::checkusertypes/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/subadmin', "subadmin::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/subadmin/add', "subadmin::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/subadmin/edit/(:any)', "subadmin::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/subadmin/delete/(:any)', "subadmin::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/subadmin/changeStatus/(:any)', "subadmin::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/subadmin/changeActiveStatus/(:any)', "subadmin::changeActiveStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/subadmin/delete/(:any)', "subadmin::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/subadmin/add', "subadmin::add", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/subadmin/edit', "subadmin::edit", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/support', "support::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/backup', "backup::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/backup/import', "backup::import", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/backup/export', "backup::export", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/backup/export', "backup::export", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/support/ticketdetails', "support::ticketdetails", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/support/ticketdetails/(:any)', "support::ticketdetails/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/support/deleteticket/(:any)', "support::deleteticket/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/reports/payouts', "reports::payouts", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/reports/payouts', "reports::payouts", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/reports/deposits', "reports::deposit", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/reports/deposits', "reports::deposit", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/reports/transfers', "reports::fundtransfer", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/reports/transfers', "reports::fundtransfer", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/reports/bonus', "reports::bonus", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/reports/bonus', "reports::bonus", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/reports/earnings', "reports::earnings", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/reports/earnings', "reports::earnings", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/reports/adminearnings', "reports::adminearnings", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/reports/adminearnings', "reports::adminearnings", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/history/payouts', "history::payouts", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/history/payouts', "history::payouts", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/history/bonus', "history::bonus", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/history/earnings', "history::earnings", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/history/earnings', "history::earnings", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/changemarket', "finance::changemarket", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/changemarketstatus', "finance::changemarketstatus", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/listing', "finance::listing", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/bonus', "finance::bonus", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/bonus', "finance::bonus", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/penalty', "finance::penalty", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/penalty', "finance::penalty", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/penalty/(:any)', "finance::penalty/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/verify/(:any)', "users::verify/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/users/verify', "users::verify", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/add/', "users::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/pending/', "users::pending/", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/market', "finance::market", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/changeActiveStatus', "finance::changeActiveStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/addlist/(:any)', "finance::addlist/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/addlist', "finance::addlist", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/addlist', "finance::addlist", ["namespace" => "App\Controllers\Admin"]);

$routes->add('admin/finance/changeStatus', "finance::changeStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/changeCircleStatus', "finance::changeCircleStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/changeCircleActiveStatus', "finance::changeCircleActiveStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/changePromotionStatus', "finance::changePromotionStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/changePromotionActiveStatus', "finance::changePromotionActiveStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/paircurrency', "finance::paircurrency", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/bank', "bank::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/bank/add', "bank::add", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/bank/add', "bank::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/bank/add/(:any)', "bank::add/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/bank/delete/(:any)', "bank::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/bank/changeinStatus/(:any)', "bank::changeinStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/bank/changeStatus/(:any)', "bank::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/bank/delete/(:any)', "bank::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/paircurrency/(:any)', "finance::paircurrency/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/addMarket', "finance::addMarket", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/currencypairlist', "finance::currencypairlist", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/tradelist', "finance::tradelist", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/promotionlist', "finance::promotionlist", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/pending_trade', "finance::pending_trade", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/pending_withdraw', "finance::pending_withdraw", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/pendingdeposit', "finance::pendingdeposit", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/Deleterequest/(:any)', "finance::Deleterequest", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/approverequest/(:any)', "finance::approverequest", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/Deleterequest/(:any)', "finance::Deleterequest", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/users/changeActiveStatus', "users::changeActiveStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/users/changeStatus', "users::changeStatus", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/users/delete/(:any)', "users::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/marketdelete/(:any)', "finance::marketdelete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/mark_delete/(:any)', "finance::mark_delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/users/add/', "users::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/checkip', "checkip::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/sales_monthly', "admin::sales_monthly", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/checkip', "checkip::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/checkip/listip/(:any)', "checkip::listip/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/sendnewsletter', "sendnewsletter::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/sendnewsletter', "sendnewsletter::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/sendnewsletter/list_user/(:any)', "sendnewsletter::list_user/$1", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/slider', "slider::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/slider', "slider::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/slider/add/(:any)', "slider::add/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/slider/add/', "slider::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/slider/add/', "slider::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/slider/delete/(:any)', "slider::delete/$1", ["namespace" => "App\Controllers\Admin"]);


$routes->get('admin/index_slider', "index_slider::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/index_slider', "index_slider::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/index_slider/add/(:any)', "index_slider::add/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/index_slider/add/', "index_slider::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/index_slider/add/', "index_slider::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/index_slider/delete/(:any)', "index_slider::delete/$1", ["namespace" => "App\Controllers\Admin"]);


$routes->get('admin/mailtemplate', "mailtemplate::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/mailtemplate', "mailtemplate::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/mailtemplate/install', "mailtemplate::install", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/mailtemplate/uninstall', "mailtemplate::uninstall", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/mailtemplate/add/(:any)', "mailtemplate::add/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/mailtemplate/add/', "mailtemplate::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/ip', "ip::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/ip', "ip::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/ip/add/', "ip::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/ip/edit_data/', "ip::edit_data/", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/ip/edit/(:any)', "ip::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/ip/delete/(:any)', "ip::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/message', "message::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/message', "message::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/message/add/', "message::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/message/edit/', "message::edit/", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/message/edit/(:any)', "message::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/message/changeActiveStatus/(:any)', "message::changeActiveStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/message/changeStatus/(:any)', "message::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/message/delete/(:any)', "message::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/news', "news::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/news', "news::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/news/add/', "news::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/news/edit/', "news::edit/", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/news/edit/(:any)', "news::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/news/changeActiveStatus/(:any)', "news::changeActiveStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/news/changeStatus/(:any)', "news::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/news/delete/(:any)', "news::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/faq', "faq::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/faq', "faq::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/faq/add/', "faq::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/profile/changepassword', "profile::changepassword", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/login/reset', "Login::reset", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/verify', "Login::verify", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/twofactor', "Login::twofactor", ["namespace" => "App\Controllers\Admin"]);

$routes->post('admin/faq/add/(:any)', "faq::add/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/faq/edit/(:any)', "faq::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/faq/delete/(:any)', "faq::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/faq/edit/', "faq::edit/", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/faq/changeActiveStatus/(:any)', "faq::changeActiveStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/faq/changeStatus/(:any)', "faq::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/cms', "cms::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/cms', "cms::index", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/checkip', "checkip::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/checkip', "checkip::index", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/cms/edit/(:any)', "cms::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/cms/delete/(:any)', "cms::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/cms/edit/', "cms::edit/", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/cms/viewcontents/(:any)', "cms::viewcontents/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/cms/changeActiveStatus/(:any)', "cms::changeActiveStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/cms/changeStatus/(:any)', "cms::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/langsettings', "langsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/langsettings', "langsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/registersettings', "registersettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/registersettings', "registersettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/footersettings', "footersettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/footersettings', "footersettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/langsettings/add/(:any)', "langsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/langsettings/delete/(:any)', "langsettings::delete", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/langsettings/add', "langsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/langsettings/add', "langsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/withdrawsettings', "withdrawsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/withdrawsettings', "withdrawsettings::index", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/loginsettings', "loginsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/loginsettings', "loginsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/adminsettings', "adminsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/adminsettings', "adminsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/currencysettings', "currencysettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/paymentsettings', "paymentsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/paymentsettings/add/(:any)', "paymentsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/paymentsettings/add/(:any)', "paymentsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/paymentsettings/add', "paymentsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/rewardsettings',"rewardsettings::index", ["namespace"=>"App\Controllers\Admin"]);
$routes->post('admin/rewardsettings',"rewardsettings::index", ["namespace"=>"App\Controllers\Admin"]);

$routes->get('admin/rewardsettings/edit/(:any)', "rewardsettings::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/rewardsettings/edit/', "rewardsettings::edit", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/rewardsettings/edit/(:any)', "rewardsettings::edit/$1", ["namespace" => "App\Controllers\Admin"]);

$routes->post('admin/rewardsettings/add', "rewardsettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/rewardsettings/add', "rewardsettings::add", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/finance/edit_trader', "finance::edit_trader", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/edit_trader', "finance::edit_trader", ["namespace" => "App\Controllers\Admin"]);

$routes->get('admin/finance/edit_trader/(:any)', "finance::edit_trader/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/finance/edit_trader/(:any)', "finance::edit_trader/$1", ["namespace" => "App\Controllers\Admin"]);

$routes->post('admin/finance/trader', "finance::trader", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/trader', "finance::trader", ["namespace" => "App\Controllers\Admin"]);

$routes->post('admin/finance/trader', "finance::trader", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/finance/trader', "finance::trader", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/config_field0', "finance::config_field0", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/config_field1', "finance::config_field1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/config_field2', "finance::config_field2", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/config_field3', "finance::config_field3", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/config_field4', "finance::config_field4", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/config_field5', "finance::config_field5", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/finance/trade_validuser', "finance::trade_validuser", ["namespace" => "App\Controllers\Admin"]);


$routes->get('admin/currencysettings/makedefault', "currencysettings::makedefaults", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/currencysettings/add/', "currencysettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/currencysettings/add/', "currencysettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/currencysettings/add/(:any)', "currencysettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/currencysettings/add/(:any)', "currencysettings::add", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/currencysettings/delete/(:any)', "currencysettings::delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/accountsettings', "accountsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/sitesettings', "sitesettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/sitesettings', "sitesettings::index", ["namespace" => "App\Controllers\Admin"]);



$routes->get('admin/logout', "Login::logout", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/login', "Login::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/login', "Login::index", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/rewardsettings/delete/(:any)', "rewardsettings::delete/$1", ["namespace" => "App\Controllers\Admin"]);




/*-------------------------------------------------------------------------------------------------*/
/*----------------------------     tradeing pool settings start  ----------------------------------*/
/*-------------------------------------------------------------------------------------------------*/


// interest  settings routs

$routes->get('admin/interestsettings',"interestsettings::index", ["namespace"=>"App\Controllers\Admin"]);
$routes->post('admin/interestsettings',"interestsettings::index", ["namespace"=>"App\Controllers\Admin"]);
$routes->get('verify', "Login::verify", ["namespace" => "App\Controllers\User"]);

// package settings routs

$routes->get('admin/packagesettings',"interestsettings::packagesettings", ["namespace"=>"App\Controllers\Admin"]);
$routes->get('admin/packagesettings/edit/(:any)', "interestsettings::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/packagesettings/edit/(:any)', "interestsettings::edit/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/pack_delete/delete/(:any)', "interestsettings::pack_delete/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/packagesettings/add', "interestsettings::add/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/packagesettings',"interestsettings::packagesettings", ["namespace"=>"App\Controllers\Admin"]);


//withdraw pooling settings routs

$routes->get('admin/withdrawsettingspool', "withdrawsettingspool::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/withdrawsettingspool', "withdrawsettingspool::index", ["namespace" => "App\Controllers\Admin"]);


// twofactorial enable

$routes->get('user/twofactor/enable', "Twofactor::enable", ["namespace" => "App\Controllers\User"]);
$routes->get('user/twofactor/disable', "Twofactor::disable", ["namespace" => "App\Controllers\User"]);
$routes->post('/auth_verify', "Login::auth_verify", ["namespace" => "App\Controllers\User"]);
$routes->post('/withdraw_authverify', "withdraw::withdraw_auth_verify", ["namespace" => "App\Controllers\User"]);
$routes->post('/transfer_authverify', "withdraw::transfer_authverify", ["namespace" => "App\Controllers\User"]);
$routes->get('UserSettings/verify_passwordauth', "UserSettings::verify_passwordauth", ["namespace" => "App\Controllers\User"]);
$routes->get('success_password_auth', "UserSettings::success_password_auth", ["namespace" => "App\Controllers\User"]);
$routes->post('password_authverify', "UserSettings::password_authverify", ["namespace" => "App\Controllers\User"]);


// two factor disable mail 
$routes->post('UserSettings/verifyregcode', "UserSettings::verifyregcode", ["namespace" => "App\Controllers\User"]);
$routes->post('UserSettings/verifyotp', "UserSettings::verifyotp", ["namespace" => "App\Controllers\User"]);


// pooling investment 

$routes->post('UserSettings/check_pack', "UserSettings::check_pack", ["namespace" => "App\Controllers\User"]);
$routes->post('UserSettings/pool_trading_invest', "UserSettings::pool_trading_invest", ["namespace" => "App\Controllers\User"]);

//pooling investment profit wallet

$routes->post('UserSettings/pool_invest_profit_wallet', "UserSettings::pool_invest_profit_wallet", ["namespace" => "App\Controllers\User"]);


//pooling investment cash wallet

$routes->post('UserSettings/pool_invest_cash_wallet', "UserSettings::pool_invest_cash_wallet", ["namespace" => "App\Controllers\User"]);


//pooling investment reward wallet

$routes->post('UserSettings/pool_invest_reward_wallet', "UserSettings::pool_invest_reward_wallet", ["namespace" => "App\Controllers\User"]);




// pooling fund withdraw 
$routes->get('poolwithdraw/(:any)', "pooltrade::poolwithdraw", ["namespace" => "App\Controllers\User"]);
$routes->add('pool/checkfee/(:any)', "pooltrade::checkfee/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('pool/checkbalance/(:any)', "pooltrade::checkbalance/$1", ["namespace" => "App\Controllers\User"]);


$routes->post('admin/masspayout/singleuserpay_internal', "masspayout::singleuserpay_internal", ["namespace" => "App\Controllers\Admin"]);

$routes->post('admin/masspayout/singpaywithdraw', "masspayout::singpaywithdraw", ["namespace" => "App\Controllers\Admin"]);

$routes->add('admin/masspayout/singpaywithdraw', "masspayout::singpaywithdraw", ["namespace" => "App\Controllers\Admin"]);


$routes->post('admin/masspayout/Deleterequest', "masspayout::Deleterequest", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/masspayout/Deleterequest', "masspayout::Deleterequest", ["namespace" => "App\Controllers\Admin"]);

$routes->post('admin/masspayout/Deleterequest1', "masspayout::Deleterequest1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/masspayout/Deleterequest1', "masspayout::Deleterequest1", ["namespace" => "App\Controllers\Admin"]);


$routes->add('user/poolwithdrawconfirm', "pooltrade::poolwithdrawconfirm", ["namespace" => "App\Controllers\User"]);



// pool investment settings admin

$routes->add('admin/pool_invest',"interestsettings::pool_invest", ["namespace"=>"App\Controllers\Admin"]);

$routes->add('admin/level_set',"interestsettings::level_set", ["namespace"=>"App\Controllers\Admin"]);
$routes->add('admin/bonus_level_set',"interestsettings::bonus_level_set", ["namespace"=>"App\Controllers\Admin"]);



// pool investment transation admin 

$routes->add('admin/active_pools',"interestsettings::active_pools", ["namespace"=>"App\Controllers\Admin"]);

$routes->add('admin/request_pools',"interestsettings::request_pools", ["namespace"=>"App\Controllers\Admin"]);

$routes->add('admin/completed_pools',"interestsettings::completed_pools", ["namespace"=>"App\Controllers\Admin"]);




// pool investment release 

$routes->post('admin/claim_pack',"interestsettings::claim_pack_release", ["namespace"=>"App\Controllers\Admin"]);



// pool investment claim

$routes->add('UserSettings/pool_trade_list',"UserSettings::pool_trade_list", ["namespace"=>"App\Controllers\User"]);

$routes->add('/pool_trade_list',"UserSettings::pool_trade_list", ["namespace"=>"App\Controllers\User"]);


$routes->post('UserSettings/claim_pack',"UserSettings::claim_pack", ["namespace"=>"App\Controllers\User"]);


//pool trade
$routes->get('/pool', "pooltrade::index", ["namespace" => "App\Controllers\User"]);
$routes->get('user/pool', "pooltrade::index", ["namespace" => "App\Controllers\User"]);
$routes->get('user/levels', "Pooltrade::levels", ["namespace" => "App\Controllers\User"]);


//pool Earn 
$routes->get('/pool_earn', "Poolearn::pool_earn", ["namespace" => "App\Controllers\User"]);

$routes->get('admin/active_pools/view/(:any)', "interestsettings::view/$1", ["namespace" => "App\Controllers\Admin"]);

$routes->add('/pool_info/(:any)', "Poolearn::pool_history/$1", ["namespace" => "App\Controllers\User"]);

$routes->get('/earn_trad', "Poolearn::earn_trad", ["namespace" => "App\Controllers\User"]);

$routes->get('/Poolearn/earn_trad_count/(:any)', "Poolearn::earn_trad_count/$1", ["namespace" => "App\Controllers\User"]);


$routes->get('/pool_team/(:any)', "pooldashboard::pool_team_member", ["namespace" => "App\Controllers\User"]);
$routes->get('/pool_team/', "pooldashboard::pool_team_member", ["namespace" => "App\Controllers\User"]);

$routes->get('/earn_pool', "pooldashboard::pool_team_earn", ["namespace" => "App\Controllers\User"]);


$routes->get('/withdraw_pool', "Poolearn::history_withdraw", ["namespace" => "App\Controllers\User"]);

$routes->get('/api_check', "Poolearn::api_check", ["namespace" => "App\Controllers\User"]);

$routes->get('/user/asset', "Profile::asset", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/asset_history', "Profile::asset_history", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/invite', "Profile::invite", ["namespace" => "App\Controllers\User"]);
$routes->get('/user/security', "Profile::security_center", ["namespace" => "App\Controllers\User"]);
$routes->get('/asset/recharge', "Profile::recharge", ["namespace" => "App\Controllers\User"]);
$routes->post('/asset/recharge', "Profile::deposit_req", ["namespace" => "App\Controllers\User"]);
$routes->get('/asset/transfer', "Profile::transfer", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/changepassword', "Profile::change_pass", ["namespace" => "App\Controllers\User"]);
$routes->post('/user/securitypin', "Profile::change_security", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/name_verify', "withdraw::name_verify", ["namespace" => "App\Controllers\User"]);
$routes->add('withdraw/validsecuritypin', "withdraw::validsecuritypin", ["namespace" => "App\Controllers\User"]);
$routes->add('checkuserbalance(:any)', "activation::checkuserbalance/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('botStatistic', "Profile::botStatistic", ["namespace" => "App\Controllers\User"]);


$routes->add('/binding/binance', "ApiKeyList::binance_bind", ["namespace" => "App\Controllers\User"]);
$routes->add('/binding/huobi', "ApiKeyList::huobi_bind", ["namespace" => "App\Controllers\User"]);
$routes->add('/huobi-bind', "ApiKeyList::huobi_bind_update", ["namespace" => "App\Controllers\User"]);
$routes->add('/binding/bybit', "ApiKeyList::bybit_bind", ["namespace" => "App\Controllers\User"]);
$routes->add('/bybit-bind', "ApiKeyList::bybit_bind_update", ["namespace" => "App\Controllers\User"]);
$routes->add('/binding/kucoin', "ApiKeyList::kucoin_bind", ["namespace" => "App\Controllers\User"]);
$routes->add('/kucoin-bind', "ApiKeyList::kucoin_bind_update", ["namespace" => "App\Controllers\User"]);
$routes->add('/binding/okx', "ApiKeyList::okx_bind", ["namespace" => "App\Controllers\User"]);
$routes->add('/okx-bind', "ApiKeyList::okx_bind_update", ["namespace" => "App\Controllers\User"]);
$routes->add('/removeapi', "ApiKeyList::remove_api", ["namespace" => "App\Controllers\User"]);
$routes->post('/removeapi', "ApiKeyList::remove_api", ["namespace" => "App\Controllers\User"]);

$routes->get('/activate/account', "activation::activate_account", ["namespace" => "App\Controllers\User"]);
$routes->get('/revenue', "RewardBalance::revenue_details", ["namespace" => "App\Controllers\User"]);
$routes->get('/profile', "Profile::profile", ["namespace" => "App\Controllers\User"]);
$routes->post('/profile_update', "Profile::profile_update", ["namespace" => "App\Controllers\User"]);
$routes->add('/tradesettings/(:any)', "TradeDetail::trade_settings", ["namespace" => "App\Controllers\User"]);

$routes->add('user/quantify', "dashboard::quantify", ["namespace" => "App\Controllers\User"]);
$routes->add('user/quantify1', "dashboard::quantify1", ["namespace" => "App\Controllers\User"]);
$routes->add('websocket', "dashboard::websocket", ["namespace" => "App\Controllers\User"]);
$routes->get('/rank', "Profile::rank", ["namespace" => "App\Controllers\User"]);
$routes->get('/activate/rank/(:any)', "Profile::activate_rank/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('/rank/activation', "Profile::rank_update", ["namespace" => "App\Controllers\User"]);


$routes->add('/apikeylist/verifykucoinapi', "ApiKeyList::verifykucoinapi", ["namespace" => "App\Controllers\User"]);

$routes->add('/user/dashboard/changeSession/(:any)', "dashboard::changeSession/$1", ["namespace" => "App\Controllers\User"]);

//08.07.2024 ADDED Routes
$routes->post('/user/validatePin', "activation::validatepin", ["namespace" => "App\Controllers\User"]);

$routes->post('/user/validategastransfer', "withdraw::validategastransfer", ["namespace" => "App\Controllers\User"]);
$routes->add('/margin-configuration/(:any)/(:any)', "TradeDetail::margin_pass", ["namespace" => "App\Controllers\User"]);
$routes->post('/margin-update', "TradeDetail::margin_update", ["namespace" => "App\Controllers\User"]);
$routes->get('/bybit_order', "TradeDetail::bybit_order", ["namespace" => "App\Controllers\User"]);
$routes->post('/bybit_order', "TradeDetail::bybit_order", ["namespace" => "App\Controllers\User"]);
$routes->get('/check_orders', "TradeDetail::check_orders", ["namespace" => "App\Controllers\User"]);
/*-------------------------------------------------------------------------------------------------*/
/*----------------------------     tradeing pool settings end  ----------------------------------*/
/*-------------------------------------------------------------------------------------------------*/


$routes->add('/apikeylist/verifykucoinapi', "ApiKeyList::verifykucoinapi", ["namespace" => "App\Controllers\User"]);
$routes->add('/user/dashboard/changeSession/(:any)', "dashboard::changeSession/$1", ["namespace" => "App\Controllers\User"]);


$routes->post('revenue_records', "RewardBalance::revenue_records", ["namespace" => "App\Controllers\User"]);
$routes->add('profit_details/(:any)', "RewardBalance::profit_details/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('profit_records/(:any)', "RewardBalance::profit_records/$1", ["namespace" => "App\Controllers\User"]);
$routes->post('rank_bonus', "RewardBalance::rank_bonus", ["namespace" => "App\Controllers\User"]);
$routes->post('gas_bonus', "RewardBalance::gas_bonus", ["namespace" => "App\Controllers\User"]);
$routes->add('rankbonus_details/(:any)', "RewardBalance::rankbonus_details/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('gasbonus_details/(:any)', "RewardBalance::gasbonus_details/$1", ["namespace" => "App\Controllers\User"]);
$routes->add('rankbonus_records', "RewardBalance::rankbonus_records", ["namespace" => "App\Controllers\User"]);
$routes->add('gasbonus_records', "RewardBalance::gasbonus_records", ["namespace" => "App\Controllers\User"]);



//new transaction history

$routes->add('gaswallet', "EarningHistory::gaswallet", ["namespace" => "App\Controllers\User"]);
$routes->add('gaswallet_records', "EarningHistory::gaswallet_records", ["namespace" => "App\Controllers\User"]);

$routes->add('assetwallet', "EarningHistory::assetwallet", ["namespace" => "App\Controllers\User"]);
$routes->add('assetwallet_records', "EarningHistory::assetwallet_records", ["namespace" => "App\Controllers\User"]);

$routes->add('allhistory', "EarningHistory::allhistory", ["namespace" => "App\Controllers\User"]);
$routes->add('allhistory_records', "EarningHistory::allhistory_records", ["namespace" => "App\Controllers\User"]);

$routes->add('rewardhistory', "EarningHistory::rewardhistory", ["namespace" => "App\Controllers\User"]);
$routes->add('rewardhistory_records', "EarningHistory::rewardhistory_records", ["namespace" => "App\Controllers\User"]);



//tradepair settings

$routes->get('admin/tradepairs', "Tradepairsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/tradepairs', "Tradepairsettings::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/tradepairs/add/', "Tradepairsettings::add/", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/tradepairs/changeActiveStatus/(:any)', "Tradepairsettings::changeActiveStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('admin/tradepairs/changeStatus/(:any)', "Tradepairsettings::changeStatus/$1", ["namespace" => "App\Controllers\Admin"]);
$routes->get('admin/tradepairs/delete/(:any)', "Tradepairsettings::delete/$1", ["namespace" => "App\Controllers\Admin"]);

//trade strategy settings
$routes->get('admin/tradestrategy', "Tradestrategy::index", ["namespace" => "App\Controllers\Admin"]);
$routes->post('admin/tradestrategy', "Tradestrategy::index", ["namespace" => "App\Controllers\Admin"]);
$routes->add('/margin_column_limit', "Tradestrategy::margin_column_limit", ["namespace" => "App\Controllers\Admin"]);
$routes->add('/margin_column_limit1', "Tradestrategy::margin_column_limit1", ["namespace" => "App\Controllers\Admin"]);
$routes->add('/margin_column_limit2', "Tradestrategy::margin_column_limit2", ["namespace" => "App\Controllers\Admin"]);


/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
