<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php 

		$this->session = session();
		$validation = \Config\Services::validation();


		echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- file upload JS files 
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/uploaders/fileinput.min.js"></script>-->
	
	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>
	

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->

	<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->
    

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.lbl_backup_database_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">
				<div class="row">

					<div class="col-lg-6">
						<div class="panel panel-flat">
							<div class="panel-heading">
								<h5 class="panel-title"><?php echo lang('language_lang.lbl_restore_database'); ?></h5>
								<div class="heading-elements">
									<ul class="icons-list">
				                		<li><a data-action="collapse"></a></li>
				                		<li><a data-action="close"></a></li>
				                	</ul>
			                	</div>
		                	</div>

		                	<div class="panel-body">

		                		<form class="form-horizontal" id="importdb_form" role="form" method="post" action="<?php echo base_url('admin/backup/import');?>" enctype="multipart/form-data">
				                    <div class="form-group  <?php if($validation->getError('importdb')) echo "has-error";?>">
										<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.lbl_restore_file'); ?> <span class="text-danger">*</span></label>
										
										<div class="col-lg-6">
											<div>
												<input type="file" name="importdb" class="file-input-extensions1" value="">
											</div>
											<span class="help-block"><?php echo lang('language_lang.restore_file_extension');?></span>
											<?php echo $validation->getError('importdb', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
										</div>
										<div class="col-lg-3">
											<!-- <button type="button" onclick="importDB()" class="btn btn-primary"><?php echo lang('language_lang.button_import'); ?> <i class="icon-arrow-right14 position-right"></i></button> -->
											<button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_import'); ?> <i class="icon-arrow-right14 position-right"></i></button>
										</div>
									</div>
			                    </form>

			                </div>
							
						</div>
					</div>

					<div class="col-lg-6">
						<div class="panel panel-flat">
							<div class="panel-heading">
								<h5 class="panel-title"><?php echo lang('language_lang.lbl_backup_database'); ?></h5>
								<div class="heading-elements">
									<ul class="icons-list">
				                		<li><a data-action="collapse"></a></li>
				                		<li><a data-action="close"></a></li>
				                	</ul>
			                	</div>
		                	</div>

		                	<div class="panel-body">
		                		<form class="form-horizontal" role="form" id="exportdb_form" method="post" action="<?php echo base_url('admin/backup/export');?>">
			                		<div class="form-group">
			                			<label class="control-label col-lg-6 text-semibold"><?php echo lang('language_lang.lbl_export_file'); ?> </label>
										<div class="col-lg-6">
											<button type="button" onclick="exportDB()" class="btn btn-primary"><?php echo lang('language_lang.button_export'); ?> <i class="icon-arrow-right14 position-right"></i></button>
										</div>
									</div>
			                    </form>
			                </div>
							
						</div>
					</div>
					
				</div>
			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$(".switchery").bootstrapSwitch();


			$.jGrowl.defaults.closer = false;

			<?php if($this->session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $this->session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($this->session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $this->session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

            $('#importdb_form').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            // valid: 'glyphicon glyphicon-ok',
		            // invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            importdb: {
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo "file is required"; ?>'
		                    },
		                    file: {
			                    extension: 'txt,sql',
			                    message: '<?php echo lang("language_lang.fav_icon_must");?>'
			                }
		                    
		                }
		            }
		        }
		    })
			
		});
		
		
	    $('#icon-bck').on('click',function() {
			window.history.back();
		});

	});
	})(jQuery);

	
	</script>
	<script type="text/javascript">
	    function exportDB(){
	        jQuery('#exportdb_form').submit();
	    }
	    function importDB(){
	    	console.log('click');
	        jQuery('#importdb_form').submit();
	    }
	</script>

</body>
</html>
