<!DOCTYPE html>
<html lang="en">
<head>
    <!-- header -->
		<?php
		$validation = \Config\Services::validation();
		$this->session = session();

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/formValidation.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/bootstrap.js"></script>
	

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>
	<!-- /theme JS files -->
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url();?>assets/boots/js/bootstrap-switch.js"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/jgrowl.min.js"></script>

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.menu_bank_page'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><? echo lang('language_lang.menu_bank_page'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>
                	
					<div class="panel-body">
						<form class="form-horizontal form-user" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
							 <?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>
							

							

						    <input type="hidden" name="hid" value="<?php echo $addr_data->id;?>">


						    <div class="form-group  has-feedback <?php if($validation->getError('address')) echo "has-error";?>" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.menu_bank_aaddress'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-4">
							        <div style="width:100%;" class="input-group">
								       <textarea class="form-control" name="address"> <?php echo $addr_data->address;?> </textarea>
							        </div>
							        <?php echo $validation->getError('address', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>

						    <div class="form-group  has-feedback <?php if($validation->getError('bank_name')) echo "has-error";?>">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.menu_bank_name'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-4">
							        <div style="width:100%;" class="input-group">
								        <input type="text" name="bank_name" class="form-control"   value="<?php echo $addr_data->bank_name;?>">
							        </div>
							        <?php echo $validation->getError('bank_name', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>


						   <div class="form-group  has-feedback <?php if($validation->getError('account_name')) echo "has-error";?>">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.menu_bank_aname'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-4">
							        <div style="width:100%;" class="input-group">
								        <input type="text" name="account_name" class="form-control"   value="<?php echo $addr_data->account_name;?>">
							        </div>
							        <?php echo $validation->getError('account_name', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>

						       <div class="form-group  has-feedback <?php if($validation->getError('iban')) echo "has-error";?>">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.menu_bank_account'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-4">
							        <div style="width:100%;" class="input-group">
								        <input type="text" name="iban" class="form-control" value="<?php echo $addr_data->iban;?>">
							        </div>
							        <?php echo $validation->getError('iban', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>


						    <div class="form-group  has-feedback <?php if($validation->getError('bank_addr')) echo "has-error";?>" >
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.lbl_user_country'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-4">
							        <div style="width:100%;" class="input-group">
								       <!--<textarea class="form-control" name="bank_addr"> <?php echo $addr_data->bank_addr;?> </textarea>-->
								       <input type="text" name="bank_addr" value="<?php echo $addr_data->bank_addr;?>" class="form-control">
									</div>
							        <?php echo $validation->getError('bank_addr', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>

						 
							
							<div class="form-group  has-feedback <?php if($validation->getError('swift_code')) echo "has-error";?>" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.menu_bank_swift'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-4">
							        <div style="width:100%;" class="input-group">
								        <input type="text" name="swift_code" class="form-control" value="<?php echo $addr_data->swift_code;?>">
							        </div>
							        <?php echo $validation->getError('swift_code', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>
													
	                       <div class="text-right col-lg-5"> 
	                            <button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
						   </div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

    </div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if($this->session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $this->session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($this->session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $this->session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.form-user').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            // valid: 'glyphicon glyphicon-ok',
		            // invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            account_name: {
		                message: 'Please Enter Account Name',
		                validators: {
		                    notEmpty: {
		                        message: 'Please Enter Account Name'
		                    }
		                }
		            },
		            bank_name: {
		                message: 'Please Enter Bank Name',
		                validators: {
		                    notEmpty: {
		                        message: 'Please Enter Bank Name'
		                    }
		                }
		            },
		            bank_addr: {
		                message: 'Please Enter Address',
		                validators: {
		                    notEmpty: {
		                        message: 'Please Enter  Address'
		                    }
		                }
		            },
		            iban: {
		                message: 'Please Enter Account Number',
		                validators: {
		                    notEmpty: {
		                        message: 'Please Enter Account Number'
		                    }
		                }
		            }
		            
				}
		    })
		});
	    
	    $('#icon-bck').on('click',function() {
			window.history.back();
		});
	    $(".switch").bootstrapSwitch();

	});
	})(jQuery);

	
	</script>

</body>
</html>
