<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
	<?php
    use App\Libraries\MyEncrypt;
	$session = session();
    $this->db = db_connect();
	$userranks = $this->db->query("Select * from uusers_matrix")->getResult();
	echo view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/bootbox.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>
    
    <style type="text/css">
	    .icons-list a[data-action="reload1"]:after {
		  content: '\e9fb';
		}
		.btns {
			padding: 5px;
		}
		@media only screen and (max-width:768px){
            .dropdown-menu-right{
                margin-top: -37px !important;
                margin-right: 37px !important;
            }
        }

        /* Pagination Styles */
        .pagination {
            display: inline-block;
            padding: 0;
            margin: 20px 0;
        }
        .pagination li {
            display: inline;
        }
        .pagination li a, 
        .pagination li span {
            position: relative;
            float: left;
            margin-left: -1px;
            line-height: 1.42857143;
            color: #337ab7;
            text-decoration: none;
            background-color: #fff;   
        }
        .pagination li:first-child a, 
        .pagination li:first-child span {
            margin-left: 0;
            border-top-left-radius: 4px;
            border-bottom-left-radius: 4px;
        }
        .pagination li:last-child a, 
        .pagination li:last-child span {
            border-top-right-radius: 4px;
            border-bottom-right-radius: 4px;
        }
        .pagination li a:hover, 
        .pagination li span:hover,
        .pagination li a:focus, 
        .pagination li span:focus {
            z-index: 2;
            color: #23527c;
            background-color: #eee;
            border-color: #ddd;
        }
        .pagination .active a, 
        .pagination .active span,
        .pagination .active a:hover, 
        .pagination .active span:hover,
        .pagination .active a:focus, 
        .pagination .active span:focus {
            z-index: 3;
            color: #fff;
            cursor: default;
            background-color: #337ab7;
            border-color: #337ab7;
        }
        .pagination .disabled span, 
        .pagination .disabled span:hover,
        .pagination .disabled span:focus, 
        .pagination .disabled a,
        .pagination .disabled a:hover, 
        .pagination .disabled a:focus {
            color: #777;
            cursor: not-allowed;
            background-color: #fff;
            border-color: #ddd;
        }
        .pagination-info {
            margin-top: 10px;
            color: #666;
            font-size: 14px;
        }
	</style>
</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">
		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->

		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->
	</div>
	<!-- /fixed navbars wrapper -->

	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.users_page_title'); ?></h4>
				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { 
                        if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> 
                        <li><?php echo $breadcrumb['text']; ?></li>
                    <?php } 
                    } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->

	<!-- Page container -->
	<div class="page-container">
		<!-- Page content -->
		<div class="page-content">
			<!-- Main content -->
			<div class="content-wrapper">
			
				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.users_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
                                <li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload1"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<?php $currency_info = defaultcurrency();?>
					<div class="table-responsive">
						<table class="table table-hover">	
							<thead>
								<tr>
									<th class="">SI.NO</th>
									<th class="text-center">User Name</th>
									<th class="text-center"><?php echo lang('language_lang.lbl_user_email');?></th>
									<th class="text-center">Referral Name</th>
									<th class="text-center">Inviter Code</th>
									<th class="text-center">Rank</th>
									<?php if($current_uri != 'pending_activation') { ?>
									<th class="text-center"><?php echo lang('language_lang.lbl_login_ip');?></th>
									<?php } ?>
									<th class="text-center"><?php echo lang('language_lang.lbl_createon');?></th>
									<th class="text-center"><?php echo lang('language_lang.lbl_status');?></th>
									<th class="text-center">Activity</th>
									<?php if($current_uri != 'pending_activation') { ?>
									<th class="text-center"><?php echo lang('language_lang.lbl_options');?></th>
									<?php } else { ?>
                                    <th class="text-center">Bot Status</th>
                                    <th class="text-center">Action</th>
									<?php } ?>		
								</tr>
							</thead>
							<tbody>
							<?php 
								if($users) {
									$myencrypt = new MyEncrypt;
									foreach ($users as $i => $row) {
										if($row->status=='1'){
											$label_status = 'label-success';
											$status = lang('language_lang.active');
										} else {
											$label_status = 'label-danger';
											$status = lang('language_lang.in_active');
										}
								
										if($row->activation=='1'){
											$label_status1 = 'label-success';
											if($row->pin_activation)
												$status1 = "PIN-Active";
											else
												$status1 = "Active";
										} else {
											$label_status1 = 'label-danger';
											if($row->pin_activation)
												$status1 = "PIN-Pending";
											else
												$status1 = "Pending";
										}
										
										if(isset($ava_balance[$i]) && $ava_balance[$i] < 0) {
											$user_balance = 0;
										} else {
											$user_balance = $ava_balance[$i] ?? 0;
										}
                                        
                                        if($row->email!='') {
                                            $referral_info = $this->db->table("uusers")->where('uusersid',$row->referral_id)->get()->getRow();
                                            if($referral_info)
                                                $referral_name=$referral_info->username;
                                            else
                                                $referral_name="- NIL -";
                                                
                                            $rank_info = $this->db->table("rewardsettings")->where('id',$row->rankid)->get()->getRow();
                                            if($rank_info)
                                                $rank_name=$rank_info->rank_name;
                                            else
                                                $rank_name="- NIL -";
							?>
							<tr>
							    <td><?php echo (($currentPage - 1) * 10) + $i + 1; ?></td>
								<td class="text-center"><?php echo $row->username;?></td>
								<td class="text-center"><?php echo $row->email;?></td>
								<td class="text-center"><?php echo $referral_name;?></td>
								<td class="text-center"><?php echo $row->invitation_code;?></td>
								<td class="text-center"><?php echo $rank_name;?></td>
								<?php if($current_uri != 'pending_activation') { ?>
								<td class="text-center"><?php echo ($row->loginipaddr) ? $row->loginipaddr : $row->createdipaddr;?></td>
								<?php } ?>
								<td class="text-center"><?php echo date('Y-m-d', strtotime($row->createdate));?></td>

								<?php if($row->status=='1') { ?>
							    <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" data-popup="tooltip" title="<?php echo lang('language_lang.click_to_deactive');?>" onclick="changeStatus('<?php echo $myencrypt->encode($row->uusersid); ?>')"><?php echo $status;?></a></span></td>
								<?php } else { ?>
 							    <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" data-popup="tooltip" title="<?php echo lang('language_lang.click_to_active');?>" onclick="changeActiveStatus('<?php echo $myencrypt->encode($row->uusersid); ?>')"><?php echo $status;?></a></span></td>
                                <?php } ?>
                                
                                <?php 
                                    if($row->user_transfer=='1')
                                        $transfer="<i class='fa fa-check-circle' style='color:green;'> </i> Enabled";
                                    else
                                        $transfer="<i class='fa fa-times-circle' style='color:red;'> </i> Disabled";
                                        
                                     if($row->user_withdraw=='1')
                                        $withdraw="<i class='fa fa-check-circle' style='color:green;'> </i> Enabled";
                                    else
                                        $withdraw="<i class='fa fa-times-circle' style='color:red;'> </i> Disabled";
                                ?>
                                
                                <td>
                                    <p> Transfer : <?php echo $transfer;?></p>
                                    <p> Withdraw : <?php echo $withdraw;?></p>
                                </td>
                                <?php if($current_uri!='pending' && $current_uri != 'pending_activation') { ?>
                                <td class="text-right">
                                	<a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_login');?>" href="<?php echo base_url('admin/users/login/'.$myencrypt->encode($row->uusersid));?>" target="_new"><i class="fa fa-lock position-center"></i></a>
                                    <a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_view');?>" href="<?php echo base_url('admin/users/view/'.$myencrypt->encode($row->uusersid));?>"><i class="fa fa-search position-center"></i></a>
                                    <a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_reset_password');?>"  href="javascript:void(0)" onclick="confirmreset('<?php echo $myencrypt->encode($row->uusersid);?>')"><i class="fa fa-key"></i></a>
                                    <a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_bonus');?>"  href="javascript:void(0)" onclick="sendbonus('<?php echo $myencrypt->encode($row->uusersid);?>')"><i class="fa fa-thumbs-up"></i></a>
                                    <a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_penality');?>"  href="javascript:void(0)" onclick="sendpenalty('<?php echo $myencrypt->encode($row->uusersid);?>')"><i class="fa fa-thumbs-down"></i></a>
                                    <a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.edit');?>"  href="<?php echo base_url('admin/users/add/'.$myencrypt->encode($row->uusersid));?>"><i class="fa fa-edit"></i></a>
                                    <a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.delete');?>"  onclick="confirmdelete('<?php echo $myencrypt->encode($row->uusersid);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i></a>
                                </td>
                                <?php } elseif($current_uri == "pending") { ?>
                                	<td class="text-right">
                                		<?php
	                                	$resu=$this->db->query("select * from site_controls where site_id='390'");
	                            		$das=$resu->getResult();
	                            		if($das[0]->site_value=='on' && $row->proof_verify=='0') {
	                                		?>
	                                		<a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_verify');?>" href="<?php echo base_url('admin/users/verify/'.$myencrypt->encode($row->uusersid));?>"><i class="fa fa-user-secret"></i>Verify proof</a>
	                                		<?php
	                                	} else { ?>
	                                		<a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_verify');?>" href="#"><i class="fa fa-times"></i>Proof not upload</a>
	                                	<?php } ?>
                                	<a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.lbl_view');?>" href="<?php echo base_url('admin/users/view/'.$myencrypt->encode($row->uusersid));?>"><i class="fa fa-search position-center"></i></a>
                                	<a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.edit');?>"  href="<?php echo base_url('/admin/users/add/'.$myencrypt->encode($row->uusersid));?>"><i class="fa fa-edit"></i></a>
                                	<a class="btns" data-popup="tooltip" title="<?php echo lang('language_lang.delete');?>"  onclick="confirmdelete('<?php echo $myencrypt->encode($row->uusersid);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i></a>
                                </td>
                                <?php } elseif($current_uri == "pending_activation") { ?>
                                    <?php if($row->activation=='1') { ?>
								    <td class="text-center"><span class="label <?php echo $label_status1;?>"><a style="color:#fff;text-transform:none;font-size:13px;"><?php echo $status1;?></a></span></td>
									<?php } else { ?>
 								    <td class="text-center"><span class="label <?php echo $label_status1;?>"><a style="color:#fff;text-transform:none;font-size:13px;"><?php echo $status1;?></a></span></td>
                                    <?php } ?>
                                	<td class="text-center">
										<ul class="icons-list">
											<li class="dropdown">
												<a href="#" class="dropdown-toggle" data-toggle="dropdown">
													<i class="icon-menu9"></i>
												</a>
												<ul class="dropdown-menu dropdown-menu-right">
													<?php if($row->activation == 1) { ?>
														<li><a href="javascript:void(0)" onclick="changeBotStatus('<?php echo $myencrypt->encode($row->uusersid); ?>',1)"><i class="fa fa-thumb-tack"></i>Pin</a></li>
														<li><a href="javascript:void(0)" onclick="changeBotStatus('<?php echo $myencrypt->encode($row->uusersid); ?>',0)"><i class="fa fa-money"></i>Paid</a></li>
														<?php if($row->pin_activation == 1){ ?>
														<li><a href="javascript:void(0)" data-toggle="modal" data-target="#modal_theme_primary<?php echo $row->uusersid;?>"><i class="fa fa-random"></i>Rank</a></li>
														<?php } ?>
													<?php } else { ?>
	 													<li><a href="javascript:void(0)" onclick="changeBotActiveStatus('<?php echo $myencrypt->encode($row->uusersid); ?>',1)"><i class="fa fa-thumb-tack"></i>Pin</a></li>
														<li><a href="javascript:void(0)" onclick="changeBotActiveStatus('<?php echo $myencrypt->encode($row->uusersid); ?>',0)"><i class="fa fa-money"></i>Paid</a></li>
													<?php } ?>
												</ul>
											</li>
										</ul>
									</td>
									<div id="modal_theme_primary<?php echo $row->uusersid;?>" class="modal fade">
										<div class="modal-dialog">
											<div class="modal-content">
												<div class="modal-header bg-primary">
													<button type="button" class="close" data-dismiss="modal">&times;</button>
													<h5 class="modal-title">Rank Details</h5>
												</div>
												<div class="modal-body">
													<h5 class="modal-title"><b>Current Rank:</b>&nbsp<?php echo $row->rankname;?></h5>
													<br/>
													<form method="post" action="<?php echo base_url('pin_rankupgrade');?>">
														<label style="font-weight: bold;">Change The Rank</label>
														<select class="bootstrap-select form-control" name="rank" id="rank" required="">
															<option>Select Rank</option>
															<?php foreach ($ranks as $key => $row_new) { ?>
															<option value="<?php echo $row_new->id;?>"><?php echo $row_new->rank_name;?></option>
															<?php } ?>
														</select>
														<input type="hidden" name="uusersid" id="uusersid" value="<?php echo $row->uusersid;?>"> 
														<br/>
														<input type="submit" name="submit" class="btn btn-primary">
													</form>
												</div>
											</div>
										</div>
									</div>
                                <?php } ?>
							</tr>
							<?php 
									}
								} 
							?>
								<!-- <tr>
									<td colspan="<?php echo ($current_uri != 'pending_activation') ? 11 : 12; ?>" class="text-center">No users found</td>
								</tr> -->
							<?php }else{?>
                                       <tr>
									<td colspan="<?php echo ($current_uri != 'pending_activation') ? 11 : 12; ?>" class="text-center">No users found</td>
								</tr> 
								<?php }?>
							</tbody>
						</table>
						
						<!-- Pagination -->
						
					</div>
				</div>
				<div class="text-center">
    <?php if (isset($pager)) : ?>
        <div class="pagination-container">
            <div class="row">
               
                    <?= $pager ?>
              
               
                    <div class="pagination-info">
                        Showing <?= (($currentPage - 1) * 10) + 1 ?> to <?= min($currentPage * 10, $total) ?> of <?= $total ?> entries
                    </div>
                
            </div>
        </div>
    <?php endif; ?>
</div>

				<!-- /basic responsive configuration -->
			</div>
			<!-- /main content -->
		</div>
		<!-- /page content -->

		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
	</div>
	<!-- /page container -->

	<script type="text/javascript">
	(function($) {
	    $(document).ready(function() {
	    	$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>
            
			$('.panel [data-action=reload1]').click(function (e) {
		        e.preventDefault();
		        var block = $(this).parent().parent().parent().parent().parent();
		        var currentPage = <?= $currentPage ?? 1 ?>;
		        
		        jQuery.ajax({
		            url:'<?php echo base_url("admin/users");?>?page=' + currentPage,
		            beforeSend: function() {
			            $(block).block({ 
				            message: '<i class="icon-spinner2 spinner"></i>',
				            overlayCSS: {
				                backgroundColor: '#fff',
				                opacity: 0.8,
				                cursor: 'wait',
				                'box-shadow': '0 0 0 1px #ddd'
				            },
				            css: {
				                border: 0,
				                padding: 0,
				                backgroundColor: 'none'
				            }
				        });
			        },
			        complete: function() {
			            $(block).unblock();
			        },
		            success: function(resp) {
		                $('.panel .panel-body').html($(resp).find('.panel .panel-body').html());
		            }
		        });
		    });

			$('#icon-bck').on('click',function() {
				window.history.back();
			});
		});
	})(jQuery);
	
	function changeStatus(valus) {
		swal({
            title: "<?php echo lang('language_lang.confirm_status_text');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
	            var valus1 =  valus;
				jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/users/changeStatus');?>',
		            data: {'id':valus1},
		            success : function(resp)
		            {
		                if(resp){
		                    window.location.href = "<?php echo base_url('admin/users');?>";
		                } 
		            }
		        });
		    }
        });
	}
	
	function changeActiveStatus(valus) {
		swal({
            title: "<?php echo lang('language_lang.confirm_status_text');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	var valus1 =  valus;
				jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/users/changeActiveStatus');?>',
		            data: {'id':valus1},
		            success : function(resp)
		            {
		                if(resp){
		                    window.location.href = "<?php echo base_url('admin/users');?>";
		                }
		            }
		        });
            }
        });
	}

	function changeBotStatus(valus,status) {
        var title_var = (status == 1) ? 
            "Do you want to deactivate the pin account bot" : 
            "Do you want to deactivate the bot";
            
		swal({
            title: title_var,
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
	            var valus1 =  valus;
				jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/users/changeBotStatus');?>',
		            data: {'id':valus1,'status':status},
		            success : function(resp)
		            {
		                if(resp){
		                    window.location.href = "<?php echo base_url('admin/users/pending_activation');?>";
		                } 
		            }
		        });
		    }
        });
	}
	
	function changeBotActiveStatus(valus,status) {
		var title_var = (status == 1) ? 
            "Do you want to activate the pin account bot" : 
            "Do you want to activate the bot";
            
		swal({
            title: title_var,
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	var valus1 =  valus;
				jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/users/changeActiveBotStatus');?>',
		            data: {'id':valus1,'status':status},
		            success : function(resp)
		            {
		                if(resp){
		                    window.location.href = "<?php echo base_url('admin/users/pending_activation');?>";
		                }
		            }
		        });
            }
        });
	}

	function confirmdelete(value) {
		swal({
            title: "<?php echo lang('language_lang.confirm_delete_text');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url('admin/users/delete/');?>"+'/'+value;
            }
        });
    }

    function confirmreset(value) {
    	swal({
            title: "<?php echo lang('language_lang.confirm_reset_text');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url('admin/users/resetpassword/');?>"+'/'+value;
            }
        });
    }

    function confirmdeposit(value) {
        if(value != ''){
            window.location.href = "<?php echo base_url('admin/finance/deposit/');?>"+'/'+value;
        }
    }

    function sendbonus(value) {
        if(value != ''){
            window.location.href = "<?php echo base_url('admin/finance/bonus/');?>"+'/'+value;
        }
    }

    function sendpenalty(value) {
        if(value != ''){
            window.location.href = "<?php echo base_url('admin/finance/penalty/');?>"+'/'+value;
        }
    }
	</script>
</body>
</html>