<?php
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Ip extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 13 July, 2016
	 * This controller to manage ip page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/ip/
	 * Last Updated: 14 July, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		// admin login only
		if($session->get('admin_login'))
		{
			// form validation library

			// custom encryption
			$myencrypt = new MyEncrypt;
			$this->isSubadmin();
		}
		else
		{
			return redirect()->to('admin/login');
		}
	}

	private function isSubadmin() {
		$session = session();
        $this->router = service('router');
		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_extra')
		);
		$this->data['module_name'] = 'settings';
        $this->data['ip_data'] = $this->common_model->GetResults('ip_controls');
        $this->data['action'] =  'admin/ip/add';
        $this->data['action1'] =  'admin/ip/edit_data';
		echo view('admin/blockip/ip',$this->data);
	}
	
	public function add($id='') {
			$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$validation->setRules([
			'ip_address' => ['label' => lang("language_lang.ip_address"), 'rules' => 'trim|required|is_unique[ip_controls.ip_address]']
		]);
		// $this->form_validation->set_rules('ip_address', lang("language_lang.ip_address"), 'trim|required|is_unique[ip_controls.ip_address]');	
		

		// check form validate
		if ($validation->withRequest($this->request)->run() == TRUE) {
			
			$ip_data = array(
				"ip_address"	=>	$this->request->getPost('ip_address')
			);
			$query_status = $this->db->table('ip_controls')->insert($ip_data);
			

			if($query_status) {
				$session->setFlashData('success_message', lang('language_lang.ip_success_message'));
				echo 1;
			} else {
				$session->setFlashData('error_message', lang('language_lang.ip_error_message'));
				echo 0;
			}
			
		}
		else
		{
			echo 3;
		}
		
	}
	public function edit($id='') {
	     $myencrypt = new MyEncrypt;
		 $ip_id = $myencrypt->decode($id);
		 $condition = 'ip_id ='.$ip_id;
	     $json = $this->common_model->GetRow('ip_controls',$condition);

	     echo json_encode($json);
	}
	public function edit_data() {
    $this->db = db_connect();
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
	
	        $ipid = $this->request->getPost('ip_id');
	 //        $validation->setRules([
		// 	'ip_address' => ['label' => lang("language_lang.ip_address"), 'rules' => 'trim|required|edit_uniques['.$ipid.']']
		// ]);
            // $this->form_validation->set_rules('ip_address', 'ip address', 'trim|required|callback_edit_uniques['.$ipid.']');
			
			// check form validate
			if ($validation->withRequest($this->request)->run() == TRUE || 1) {

				if($this->request->getPost('ip_id')) {
				 	$ip_data = array(
						"ip_address"	=>	$this->request->getPost('ip_address')
						
					);
					$ip_id = $this->request->getPost('ip_id');
			
					$query_status = $this->db->table('ip_controls')->where('ip_id',$ip_id)->update($ip_data);

				}	
				if($query_status) {
					$session->setFlashData('success_message', lang('language_lang.ip_success_message'));
					echo 1;
				} else {
					$session->setFlashData('error_message', lang('language_lang.ip_error_message'));
					echo 0;
				}
				
			} 

		else
		{
							
			echo 3;

		}		

	}
	function edit_uniques($str,$ipid)
	{
		$builder = $this->db->table('ip_controls');

		$builder->select('ip_address');
		$builder->where('ip_id !='.$ipid);
		$builder->where('ip_address',$str);

		$query = $builder->get();
		if ($query->getNumRows()>0) {
			$validation->setMessage('username_check', '<label class="validation-error-label">This invalid details of %s</label>');
			return false;
		}
		else{
			return true;
		}
	}

	public function delete($id) {
		$session = session();
		$myencrypt = new MyEncrypt;
		$ip_id = $myencrypt->decode($id);
		if(isset($ip_id)){
			

			$delete_status = $this->db->table('ip_controls')->where('ip_id',$ip_id)->delete();
			

			if($delete_status) {
				$session->setFlashData('success_message', lang('language_lang.ip_delete_success_message'));
				return redirect()->to('admin/ip');
			} else {
				$session->setFlashData('error_message', lang('language_lang.ip_delete_error_message'));
				return redirect()->to('admin/ip');
			}	
			
		} else {
			return redirect()->to('admin/ip');
		}
	}

}

