(()=>{var e={2862:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TransactionBuilder=void 0;const o=r(5562),n=r(9193),s=r(9055),a=r(8557),i=r(7035),c=r(3331),u=r(705),d=r(5401);t.TransactionBuilder=class{tronWeb;validator;constructor(e){if(!(e&&e instanceof o.TronWeb))throw new Error("Expected instance of TronWeb");this.tronWeb=e,this.validator=new i.Validator}async sendTrx(e,t=0,r=this.tronWeb.defaultAddress.hex,o={}){t=parseInt(t),this.validator.notValid([{name:"recipient",type:"address",value:e},{name:"origin",type:"address",value:r},{names:["recipient","origin"],type:"notEqual",msg:"Cannot transfer TRX to the same account"},{name:"amount",type:"integer",gt:0,value:t}]);const n={to_address:(0,s.toHex)(e),owner_address:(0,s.toHex)(r),amount:t},a=(0,d.getTransactionOptions)(o);return(0,d.createTransaction)(this.tronWeb,u.ContractType.TransferContract,n,o?.permissionId,a)}async sendToken(e,t=0,r,o=this.tronWeb.defaultAddress.hex,n={}){t=parseInt(t),this.validator.notValid([{name:"recipient",type:"address",value:e},{name:"origin",type:"address",value:o},{names:["recipient","origin"],type:"notEqual",msg:"Cannot transfer tokens to the same account"},{name:"amount",type:"integer",gt:0,value:t},{name:"token ID",type:"tokenId",value:r}]);const a={to_address:(0,s.toHex)(e),owner_address:(0,s.toHex)(o),asset_name:(0,d.fromUtf8)(r),amount:t},i=(0,d.getTransactionOptions)(n);return(0,d.createTransaction)(this.tronWeb,u.ContractType.TransferAssetContract,a,n?.permissionId,i)}async purchaseToken(e,t,r=0,o=this.tronWeb.defaultAddress.hex,n={}){this.validator.notValid([{name:"buyer",type:"address",value:o},{name:"issuer",type:"address",value:e},{names:["buyer","issuer"],type:"notEqual",msg:"Cannot purchase tokens from same account"},{name:"amount",type:"integer",gt:0,value:r},{name:"token ID",type:"tokenId",value:t}]);const a={to_address:(0,s.toHex)(e),owner_address:(0,s.toHex)(o),asset_name:(0,d.fromUtf8)(t),amount:parseInt(r)},i=(0,d.getTransactionOptions)(n);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ParticipateAssetIssueContract,a,n?.permissionId,i)}async freezeBalance(e=0,t=3,r="BANDWIDTH",o=this.tronWeb.defaultAddress.hex,n,a={}){this.validator.notValid([{name:"origin",type:"address",value:o},{name:"receiver",type:"address",value:n,optional:!0},{name:"amount",type:"integer",gt:0,value:e},{name:"duration",type:"integer",gte:3,value:t},{name:"resource",type:"resource",value:r,msg:'Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"'}]);const i={owner_address:(0,s.toHex)(o),frozen_balance:parseInt(e),frozen_duration:parseInt(String(t))};"BANDWIDTH"!==r&&(i.resource=r),(0,c.isNotNullOrUndefined)(n)&&(0,s.toHex)(n)!==(0,s.toHex)(o)&&(i.receiver_address=(0,s.toHex)(n));const l=(0,d.getTransactionOptions)(a);return(0,d.createTransaction)(this.tronWeb,u.ContractType.FreezeBalanceContract,i,a?.permissionId,l)}async unfreezeBalance(e="BANDWIDTH",t=this.tronWeb.defaultAddress.hex,r,o={}){this.validator.notValid([{name:"origin",type:"address",value:t},{name:"receiver",type:"address",value:r,optional:!0},{name:"resource",type:"resource",value:e,msg:'Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"'}]);const n={owner_address:(0,s.toHex)(t)};"BANDWIDTH"!==e&&(n.resource=e),(0,c.isNotNullOrUndefined)(r)&&(0,s.toHex)(r)!==(0,s.toHex)(t)&&(n.receiver_address=(0,s.toHex)(r));const a=(0,d.getTransactionOptions)(o);return(0,d.createTransaction)(this.tronWeb,u.ContractType.UnfreezeBalanceContract,n,o?.permissionId,a)}async freezeBalanceV2(e=0,t="BANDWIDTH",r=this.tronWeb.defaultAddress.hex,o={}){this.validator.notValid([{name:"origin",type:"address",value:r},{name:"amount",type:"integer",gt:0,value:e},{name:"resource",type:"resource",value:t,msg:'Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"'}]);const n={owner_address:(0,s.toHex)(r),frozen_balance:parseInt(e)};"BANDWIDTH"!==t&&(n.resource=t);const a=(0,d.getTransactionOptions)(o);return(0,d.createTransaction)(this.tronWeb,u.ContractType.FreezeBalanceV2Contract,n,o?.permissionId,a)}async unfreezeBalanceV2(e=0,t="BANDWIDTH",r=this.tronWeb.defaultAddress.hex,o={}){this.validator.notValid([{name:"origin",type:"address",value:r},{name:"amount",type:"integer",gt:0,value:e},{name:"resource",type:"resource",value:t,msg:'Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"'}]);const n={owner_address:(0,s.toHex)(r),unfreeze_balance:parseInt(e)};"BANDWIDTH"!==t&&(n.resource=t);const a=(0,d.getTransactionOptions)(o);return(0,d.createTransaction)(this.tronWeb,u.ContractType.UnfreezeBalanceV2Contract,n,o?.permissionId,a)}async cancelUnfreezeBalanceV2(e=this.tronWeb.defaultAddress.hex,t={}){this.validator.notValid([{name:"origin",type:"address",value:e}]);const r={owner_address:(0,s.toHex)(e)},o=(0,d.getTransactionOptions)(t);return(0,d.createTransaction)(this.tronWeb,u.ContractType.CancelAllUnfreezeV2Contract,r,t?.permissionId,o)}async delegateResource(e=0,t,r="BANDWIDTH",o=this.tronWeb.defaultAddress.hex,n=!1,a,i={}){if(this.validator.notValid([{name:"amount",type:"integer",gt:0,value:e},{name:"resource",type:"resource",value:r,msg:'Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"'},{name:"receiver",type:"address",value:t},{name:"origin",type:"address",value:o},{name:"lock",type:"boolean",value:n},{name:"lock period",type:"integer",gte:0,value:a,optional:!0}]),(0,s.toHex)(t)===(0,s.toHex)(o))throw new Error("Receiver address must not be the same as owner address");const l={owner_address:(0,s.toHex)(o),receiver_address:(0,s.toHex)(t),balance:parseInt(e)};"BANDWIDTH"!==r&&(l.resource=r),n&&(l.lock=n,(0,c.isNotNullOrUndefined)(a)&&(l.lock_period=a));const p=(0,d.getTransactionOptions)(i);return(0,d.createTransaction)(this.tronWeb,u.ContractType.DelegateResourceContract,l,i?.permissionId,p)}async undelegateResource(e=0,t,r="BANDWIDTH",o=this.tronWeb.defaultAddress.hex,n={}){if(this.validator.notValid([{name:"origin",type:"address",value:o},{name:"receiver",type:"address",value:t},{name:"amount",type:"integer",gt:0,value:e},{name:"resource",type:"resource",value:r,msg:'Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"'}]),(0,s.toHex)(t)===(0,s.toHex)(o))throw new Error("Receiver address must not be the same as owner address");const a={owner_address:(0,s.toHex)(o),receiver_address:(0,s.toHex)(t),balance:parseInt(e)};"BANDWIDTH"!==r&&(a.resource=r);const i=(0,d.getTransactionOptions)(n);return(0,d.createTransaction)(this.tronWeb,u.ContractType.UnDelegateResourceContract,a,n?.permissionId,i)}async withdrawExpireUnfreeze(e=this.tronWeb.defaultAddress.hex,t={}){this.validator.notValid([{name:"origin",type:"address",value:e}]);const r={owner_address:(0,s.toHex)(e)},o=(0,d.getTransactionOptions)(t);return(0,d.createTransaction)(this.tronWeb,u.ContractType.WithdrawExpireUnfreezeContract,r,t?.permissionId,o)}async withdrawBlockRewards(e=this.tronWeb.defaultAddress.hex,t={}){this.validator.notValid([{name:"origin",type:"address",value:e}]);const r={owner_address:(0,s.toHex)(e)},o=(0,d.getTransactionOptions)(t);return(0,d.createTransaction)(this.tronWeb,u.ContractType.WithdrawBalanceContract,r,t?.permissionId,o)}async applyForSR(e=this.tronWeb.defaultAddress.hex,t="",r={}){this.validator.notValid([{name:"origin",type:"address",value:e},{name:"url",type:"url",value:t,msg:"Invalid url provided"},{name:"url",type:"string",value:t,lte:256,msg:"Invalid url provided"}]);const o={owner_address:(0,s.toHex)(e),url:(0,d.fromUtf8)(t)},n=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.WitnessCreateContract,o,r?.permissionId,n)}async vote(e={},t=this.tronWeb.defaultAddress.hex,r={}){this.validator.notValid([{name:"voter",type:"address",value:t},{name:"votes",type:"notEmptyObject",value:e}]);const o=Object.entries(e);for(const[e,t]of o)this.validator.notValid([{name:"SR",type:"address",value:e},{name:"vote count",type:"integer",gt:0,value:t,msg:"Invalid vote count provided for SR: "+e}]);const n=o.map((([e,t])=>({vote_address:(0,s.toHex)(e),vote_count:parseInt(t)}))),a={owner_address:(0,s.toHex)(t),votes:n},i=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.VoteWitnessContract,a,r?.permissionId,i)}async createSmartContract(e={},t=this.tronWeb.defaultAddress.hex){const r=e.feeLimit||this.tronWeb.feeLimit;let o=e.userFeePercentage;"number"==typeof o||o||(o=100);const i=e.originEnergyLimit||1e7,l=e.callValue||0,p=e.tokenValue,g=e.tokenId||e.token_id;let{abi:f}=e;const{parameters:y=[]}=e;let b="";const{bytecode:h=!1,name:T=""}=e;if(f&&(0,c.isString)(f))try{f=JSON.parse(f)}catch{throw new Error("Invalid options.abi provided")}const W=f;let P=W;if(W.entrys&&(P=W.entrys),!(0,c.isArray)(P))throw new Error("Invalid options.abi provided");const m=P.some((e=>"constructor"===e.type&&"payable"===e.stateMutability.toLowerCase()));if(this.validator.notValid([{name:"bytecode",type:"hex",value:h},{name:"feeLimit",type:"integer",value:r,gt:0},{name:"callValue",type:"integer",value:l,gte:0},{name:"userFeePercentage",type:"integer",value:o,gte:0,lte:100},{name:"originEnergyLimit",type:"integer",value:i,gte:0,lte:1e7},{name:"parameters",type:"array",value:y},{name:"issuer",type:"address",value:t},{name:"tokenValue",type:"integer",value:p,gte:0,optional:!0},{name:"tokenId",type:"integer",value:g,gte:0,optional:!0}]),!m&&(l>0||p>0))throw new Error("When contract is not payable, options.callValue and options.tokenValue must be 0");const{rawParameter:A,funcABIV2:B,parametersV2:C}=e;if(A&&(0,c.isString)(A))b=A.replace(/^(0x)/,"");else if(B)b=(0,a.encodeParamsV2ByABI)(B,C).replace(/^(0x)/,"");else{let e=P.find((e=>"constructor"===e.type));if(void 0!==e&&e){const t=new n.AbiCoder,r=[],o=[];if(e=e.inputs,y.length!=e.length)throw new Error(`constructor needs ${e.length} but ${y.length} provided`);for(let t=0;t<y.length;t++){let n=e[t].type,a=y[t];if(!n||!(0,c.isString)(n)||!n.length)throw new Error("Invalid parameter type provided: "+n);const i=e=>(0,c.isArray)(e)?e.map((e=>i(e))):(0,s.toHex)(e).replace(s.ADDRESS_PREFIX_REGEX,"0x");"address"===n||"address["===n.match(/^([^\x5b]*)(\x5b|$)/)?.[0]?a=i(a):/trcToken/.test(n)&&(n=n.replace(/trcToken/,"uint256")),r.push(n),o.push(a)}try{b=t.encode(r,o).replace(/^(0x)/,"")}catch(e){throw new Error(e)}}else b=""}const w={owner_address:(0,s.toHex)(t),fee_limit:parseInt(r),call_value:parseInt(l),consume_user_resource_percent:o,origin_energy_limit:i,abi:JSON.stringify(f),bytecode:h,parameter:b,name:T};(0,c.isNotNullOrUndefined)(p)&&(w.call_token_value=parseInt(p)),(0,c.isNotNullOrUndefined)(g)&&(w.token_id=parseInt(g));const E={};E.owner_address=w.owner_address,(0,c.isNotNullOrUndefined)(w.call_token_value)&&(E.call_token_value=w.call_token_value),(0,c.isNotNullOrUndefined)(w.token_id)&&(E.token_id=w.token_id);const I=E.new_contract={};w.abi?I.abi={entrys:JSON.parse(w.abi)}:I.abi={},w.call_value&&(I.call_value=w.call_value),I.consume_user_resource_percent=w.consume_user_resource_percent,I.origin_energy_limit=w.origin_energy_limit,I.origin_address=w.origin_address??w.owner_address,w.bytecode+w.parameter&&(I.bytecode=(w.bytecode+w.parameter).replace(/^0x/,"")),(0,c.isNotNullOrUndefined)(w.name)&&(I.name=w.name);const F=(0,d.getTransactionOptions)(e),M=await(0,d.createTransaction)(this.tronWeb,u.ContractType.CreateSmartContract,E,e?.permissionId,{...F,fee_limit:w.fee_limit});return M.contract_address=(0,d.genContractAddress)(w.owner_address,M.txID),M}async triggerSmartContract(e,t,r,o,n){const s=[e,t,r,o,n];return"object"!=typeof s[2]&&(s[2]={feeLimit:s[2],callValue:s[3]},s.splice(3,1)),s[2]?.txLocal?this._triggerSmartContractLocal(...s):this._triggerSmartContract(...s)}async triggerConstantContract(e,t,r={},o=[],n=this.tronWeb.defaultAddress.hex){return r._isConstant=!0,this._triggerSmartContract(e,t,r,o,n)}async triggerConfirmedConstantContract(e,t,r={},o=[],n=this.tronWeb.defaultAddress.hex){return r._isConstant=!0,r.confirmed=!0,this._triggerSmartContract(e,t,r,o,n)}async estimateEnergy(e,t,r={},o=[],n=this.tronWeb.defaultAddress.hex){return r.estimateEnergy=!0,await this._triggerSmartContract(e,t,r,o,n)}async deployConstantContract(e={input:"",ownerAddress:""}){const{input:t,ownerAddress:r,tokenId:o,tokenValue:n,callValue:a=0}=e;this.validator.notValid([{name:"input",type:"not-empty-string",value:t},{name:"callValue",type:"integer",value:a,gte:0},{name:"owner",type:"address",value:r},{name:"tokenValue",type:"integer",value:n,gte:0,optional:!0},{name:"tokenId",type:"integer",value:o,gte:0,optional:!0}]);const i={data:t,owner_address:(0,s.toHex)(r),call_value:a};o&&(i.token_id=o),n&&(i.call_token_value=n);const c=`wallet${e.confirmed?"solidity":""}/estimateenergy`,u=await this.tronWeb[e.confirmed?"solidityNode":"fullNode"].request(c,i,"post");if(u.Error)throw new Error(u.Error);if(u.result&&u.result.message)throw new Error(this.tronWeb.toUtf8(u.result.message));return u}_getTriggerSmartContractArgs(e,t,r,o,i,u,d,l,p){const g={contract_address:(0,s.toHex)(e),owner_address:(0,s.toHex)(i)};if(t&&(0,c.isString)(t)){let e;if(t=t.replace(/\s*/g,""),o.length){const t=new n.AbiCoder;let r=[];const a=[];for(let e=0;e<o.length;e++){let{value:t}=o[e];const{type:n}=o[e];if(!n||!(0,c.isString)(n)||!n.length)throw new Error("Invalid parameter type provided: "+n);const i=e=>(0,c.isArray)(e)?e.map((e=>i(e))):(0,s.toHex)(e).replace(s.ADDRESS_PREFIX_REGEX,"0x");("address"===n||"address["===n.match(/^([^\x5b]*)(\x5b|$)/)?.[0])&&(t=i(t)),r.push(n),a.push(t)}try{r=r.map((e=>(/trcToken/.test(e)&&(e=e.replace(/trcToken/,"uint256")),e))),e=t.encode(r,a).replace(/^(0x)/,"")}catch(e){throw new Error(e)}}else e="";r.funcABIV2&&(e=(0,a.encodeParamsV2ByABI)(r.funcABIV2,r.parametersV2).replace(/^(0x)/,"")),r.shieldedParameter&&(0,c.isString)(r.shieldedParameter)&&(e=r.shieldedParameter.replace(/^(0x)/,"")),r.rawParameter&&(0,c.isString)(r.rawParameter)&&(e=r.rawParameter.replace(/^(0x)/,"")),g.function_selector=t,g.parameter=e}else r.input&&(g.data=r.input);return g.call_value=parseInt(l),(0,c.isNotNullOrUndefined)(u)&&(g.call_token_value=parseInt(u)),(0,c.isNotNullOrUndefined)(d)&&(g.token_id=parseInt(d)),r._isConstant||r.estimateEnergy||(g.fee_limit=parseInt(p)),r.permissionId&&(g.Permission_id=r.permissionId),g}async _triggerSmartContractLocal(e,t,r={},o=[],s=this.tronWeb.defaultAddress.hex){const{tokenValue:a,tokenId:i,callValue:c,feeLimit:l}=Object.assign({callValue:0,feeLimit:this.tronWeb.feeLimit},r);this.validator.notValid([{name:"feeLimit",type:"integer",value:l,gt:0},{name:"callValue",type:"integer",value:c,gte:0},{name:"parameters",type:"array",value:o},{name:"contract",type:"address",value:e},{name:"issuer",type:"address",value:s,optional:!0},{name:"tokenValue",type:"integer",value:a,gte:0,optional:!0},{name:"tokenId",type:"integer",value:i,gte:0,optional:!0}]);const p=this._getTriggerSmartContractArgs(e,t,r,o,s,a,i,c,l);p.function_selector&&(p.data=(0,n.keccak256)(Buffer.from(p.function_selector,"utf-8")).toString().substring(2,10)+p.parameter);const g={data:p.data,owner_address:p.owner_address,contract_address:p.contract_address};p.call_value&&(g.call_value=p.call_value),p.call_token_value&&(g.call_token_value=p.call_token_value),p.token_id&&(g.token_id=p.token_id);const f=(0,d.getTransactionOptions)(r);return{result:{result:!0},transaction:await(0,d.createTransaction)(this.tronWeb,u.ContractType.TriggerSmartContract,g,r.permissionId,{...f,fee_limit:p.fee_limit})}}async _triggerSmartContract(e,t,r={},o=[],n=this.tronWeb.defaultAddress.hex){const{tokenValue:s,tokenId:a,callValue:i,feeLimit:c}=Object.assign({callValue:0,feeLimit:this.tronWeb.feeLimit},r);this.validator.notValid([{name:"feeLimit",type:"integer",value:c,gt:0},{name:"callValue",type:"integer",value:i,gte:0},{name:"parameters",type:"array",value:o},{name:"contract",type:"address",value:e},{name:"issuer",type:"address",value:n,optional:!0},{name:"tokenValue",type:"integer",value:s,gte:0,optional:!0},{name:"tokenId",type:"integer",value:a,gte:0,optional:!0}]);const u=this._getTriggerSmartContractArgs(e,t,r,o,n,s,a,i,c);let l="triggersmartcontract";r._isConstant?l="triggerconstantcontract":r.estimateEnergy&&(l="estimateenergy"),l=`wallet${r.confirmed?"solidity":""}/${l}`;const p=await this.tronWeb[r.confirmed?"solidityNode":"fullNode"].request(l,u,"post");return(0,d.resultManagerTriggerSmartContract)(p,u,r)}async clearABI(e,t=this.tronWeb.defaultAddress.hex,r={}){if(!o.TronWeb.isAddress(e))throw new Error("Invalid contract address provided");if(!o.TronWeb.isAddress(t))throw new Error("Invalid owner address provided");const n={contract_address:(0,s.toHex)(e),owner_address:(0,s.toHex)(t)};this.tronWeb.trx.cache.contracts[e]&&delete this.tronWeb.trx.cache.contracts[e];const a=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ClearABIContract,n,r?.permissionId,a)}async updateBrokerage(e,t=this.tronWeb.defaultAddress.hex,r={}){if(!(0,c.isNotNullOrUndefined)(e))throw new Error("Invalid brokerage provided");if(!(0,c.isInteger)(e)||e<0||e>100)throw new Error("Brokerage must be an integer between 0 and 100");if(!o.TronWeb.isAddress(t))throw new Error("Invalid owner address provided");const n={brokerage:parseInt(e),owner_address:(0,s.toHex)(t)},a=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.UpdateBrokerageContract,n,r?.permissionId,a)}async createToken(e={},t=this.tronWeb.defaultAddress.hex){const{name:r=!1,abbreviation:o=!1,description:n="",url:a=!1,totalSupply:i=0,trxRatio:l=1,tokenRatio:p=1,saleStart:g=Date.now(),saleEnd:f=!1,freeBandwidth:y=0,freeBandwidthLimit:b=0,frozenAmount:h=0,frozenDuration:T=0,voteScore:W,precision:P}=e;if(this.validator.notValid([{name:"Supply amount",type:"positive-integer",value:i},{name:"TRX ratio",type:"positive-integer",value:l},{name:"Token ratio",type:"positive-integer",value:p},{name:"token abbreviation",type:"string",value:o,lte:32,gt:0},{name:"token name",type:"not-empty-string",value:r},{name:"token description",type:"string",value:n,lte:200},{name:"token url",type:"url",value:a},{name:"token url",type:"string",value:a,lte:256},{name:"issuer",type:"address",value:t},{name:"sale start timestamp",type:"integer",value:g,gte:Date.now()},{name:"sale end timestamp",type:"integer",value:f,gt:g},{name:"Frozen supply",type:"integer",value:h,gte:0},{name:"Frozen duration",type:"integer",value:T,gte:0}]),(0,c.isNotNullOrUndefined)(W)&&(!(0,c.isInteger)(W)||W<=0))throw new Error("voteScore must be a positive integer greater than 0");if((0,c.isNotNullOrUndefined)(P)&&(!(0,c.isInteger)(P)||P<0||P>6))throw new Error("precision must be a positive integer >= 0 and <= 6");const m={owner_address:(0,s.toHex)(t),name:(0,d.fromUtf8)(r),abbr:(0,d.fromUtf8)(o),description:(0,d.fromUtf8)(n),url:(0,d.fromUtf8)(a),total_supply:parseInt(i),trx_num:parseInt(l),num:parseInt(p),start_time:parseInt(g),end_time:parseInt(f),frozen_supply:[{frozen_amount:parseInt(h),frozen_days:parseInt(T)}]};["name","abbr","description","url"].forEach((e=>{m[e]||delete m[e]})),parseInt(h)>0||delete m.frozen_supply,y&&!isNaN(parseInt(y))&&parseInt(y)>=0&&(m.free_asset_net_limit=parseInt(y)),b&&!isNaN(parseInt(b))&&parseInt(b)>=0&&(m.public_free_asset_net_limit=parseInt(b)),P&&!isNaN(parseInt(P))&&(m.precision=parseInt(P)),W&&!isNaN(parseInt(W))&&(m.vote_score=parseInt(W));const A=(0,d.getTransactionOptions)(e);return(0,d.createTransaction)(this.tronWeb,u.ContractType.AssetIssueContract,m,e?.permissionId,A)}async createAccount(e,t=this.tronWeb.defaultAddress.hex,r={}){this.validator.notValid([{name:"account",type:"address",value:e},{name:"origin",type:"address",value:t}]);const o={owner_address:(0,s.toHex)(t),account_address:(0,s.toHex)(e)},n=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.AccountCreateContract,o,r?.permissionId,n)}async updateAccount(e,t=this.tronWeb.defaultAddress.hex,r={}){this.validator.notValid([{name:"Name",type:"string",lte:200,gt:0,value:e,msg:"Invalid accountName"},{name:"origin",type:"address",value:t}]);const o={account_name:(0,d.fromUtf8)(e),owner_address:(0,s.toHex)(t)},n=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.AccountUpdateContract,o,r?.permissionId,n)}async setAccountId(e,t=this.tronWeb.defaultAddress.hex,r={}){e&&(0,c.isString)(e)&&e.startsWith("0x")&&(e=e.slice(2)),this.validator.notValid([{name:"accountId",type:"hex",value:e},{name:"accountId",type:"string",lte:32,gte:8,value:e},{name:"origin",type:"address",value:t}]);const o={account_id:e,owner_address:(0,s.toHex)(t)},n=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.SetAccountIdContract,o,r?.permissionId,n)}async updateToken(e={},t=this.tronWeb.defaultAddress.hex){const{description:r="",url:o=!1,freeBandwidth:n=0,freeBandwidthLimit:a=0}=e;this.validator.notValid([{name:"token description",type:"string",value:r,lte:200},{name:"token url",type:"url",value:o},{name:"token url",type:"string",value:o,lte:256},{name:"issuer",type:"address",value:t}]);const i={owner_address:(0,s.toHex)(t),description:(0,d.fromUtf8)(r),url:(0,d.fromUtf8)(o)};n&&!isNaN(parseInt(n))&&parseInt(n)>=0&&(i.new_limit=parseInt(n)),a&&!isNaN(parseInt(a))&&parseInt(a)>=0&&(i.new_public_limit=parseInt(a));const c=(0,d.getTransactionOptions)(e);return(0,d.createTransaction)(this.tronWeb,u.ContractType.UpdateAssetContract,i,e?.permissionId,c)}async sendAsset(e,t=0,r,o=this.tronWeb.defaultAddress.hex,n={}){return this.sendToken(e,t,r,o,n)}async purchaseAsset(e,t,r=0,o=this.tronWeb.defaultAddress.hex,n={}){return this.purchaseToken(e,t,r,o,n)}async createAsset(e,t){return this.createToken(e,t)}async updateAsset(e={},t=this.tronWeb.defaultAddress.hex){return this.updateToken(e,t)}async createProposal(e,t=this.tronWeb.defaultAddress.hex,r={}){this.validator.notValid([{name:"issuer",type:"address",value:t}]);const o="Invalid proposal parameters provided";if(!e)throw new Error(o);const n=(0,c.isArray)(e)?e:[e];for(const e of n)if(!(0,c.isObject)(e))throw new Error(o);const a={owner_address:(0,s.toHex)(t),parameters:n},i=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ProposalCreateContract,a,r?.permissionId,i)}async deleteProposal(e,t=this.tronWeb.defaultAddress.hex,r={}){this.validator.notValid([{name:"issuer",type:"address",value:t},{name:"proposalID",type:"integer",value:e,gte:0}]);const o={owner_address:(0,s.toHex)(t),proposal_id:parseInt(e)},n=(0,d.getTransactionOptions)(r);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ProposalDeleteContract,o,r?.permissionId,n)}async voteProposal(e,t=!1,r=this.tronWeb.defaultAddress.hex,o={}){this.validator.notValid([{name:"voter",type:"address",value:r},{name:"proposalID",type:"integer",value:e,gte:0},{name:"has approval",type:"boolean",value:t}]);const n={owner_address:(0,s.toHex)(r),proposal_id:parseInt(e),is_add_approval:t},a=(0,d.getTransactionOptions)(o);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ProposalApproveContract,n,o?.permissionId,a)}async createTRXExchange(e,t,r,o=this.tronWeb.defaultAddress.hex,n={}){this.validator.notValid([{name:"owner",type:"address",value:o},{name:"token name",type:"not-empty-string",value:e},{name:"token balance",type:"positive-integer",value:t},{name:"trx balance",type:"positive-integer",value:r}]);const a={owner_address:(0,s.toHex)(o),first_token_id:(0,d.fromUtf8)(e),first_token_balance:t,second_token_id:"5f",second_token_balance:r},i=(0,d.getTransactionOptions)(n);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ExchangeCreateContract,a,n?.permissionId,i)}async createTokenExchange(e,t,r,o,n=this.tronWeb.defaultAddress.hex,a={}){this.validator.notValid([{name:"owner",type:"address",value:n},{name:"first token name",type:"not-empty-string",value:e},{name:"second token name",type:"not-empty-string",value:r},{name:"first token balance",type:"positive-integer",value:t},{name:"second token balance",type:"positive-integer",value:o}]);const i={owner_address:(0,s.toHex)(n),first_token_id:(0,d.fromUtf8)(e),first_token_balance:t,second_token_id:(0,d.fromUtf8)(r),second_token_balance:o},c=(0,d.getTransactionOptions)(a);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ExchangeCreateContract,i,a?.permissionId,c)}async injectExchangeTokens(e,t,r,o=this.tronWeb.defaultAddress.hex,n={}){this.validator.notValid([{name:"owner",type:"address",value:o},{name:"token name",type:"not-empty-string",value:t},{name:"token amount",type:"integer",value:r,gte:1},{name:"exchangeID",type:"integer",value:e,gte:0}]);const a={owner_address:(0,s.toHex)(o),exchange_id:parseInt(e),token_id:(0,d.fromUtf8)(t),quant:parseInt(r)},i=(0,d.getTransactionOptions)(n);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ExchangeInjectContract,a,n?.permissionId,i)}async withdrawExchangeTokens(e,t,r,o=this.tronWeb.defaultAddress.hex,n={}){this.validator.notValid([{name:"owner",type:"address",value:o},{name:"token name",type:"not-empty-string",value:t},{name:"token amount",type:"integer",value:r,gte:1},{name:"exchangeID",type:"integer",value:e,gte:0}]);const a={owner_address:(0,s.toHex)(o),exchange_id:parseInt(e),token_id:(0,d.fromUtf8)(t),quant:parseInt(r)},i=(0,d.getTransactionOptions)(n);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ExchangeWithdrawContract,a,n?.permissionId,i)}async tradeExchangeTokens(e,t,r,n,a=this.tronWeb.defaultAddress.hex,i={}){this.validator.notValid([{name:"owner",type:"address",value:a},{name:"token name",type:"not-empty-string",value:t},{name:"tokenAmountSold",type:"integer",value:r,gte:1},{name:"tokenAmountExpected",type:"integer",value:n,gte:1},{name:"exchangeID",type:"integer",value:e,gte:0}]);const c={owner_address:(0,s.toHex)(a),exchange_id:parseInt(e),token_id:o.TronWeb.fromAscii(t).replace(/^0x/,""),quant:parseInt(r),expected:parseInt(n)},l=(0,d.getTransactionOptions)(i);return(0,d.createTransaction)(this.tronWeb,u.ContractType.ExchangeTransactionContract,c,i?.permissionId,l)}async updateSetting(e,t,r=this.tronWeb.defaultAddress.hex,o={}){this.validator.notValid([{name:"owner",type:"address",value:r},{name:"contract",type:"address",value:e},{name:"userFeePercentage",type:"integer",value:t,gte:0,lte:100}]);const n={owner_address:(0,s.toHex)(r),contract_address:(0,s.toHex)(e),consume_user_resource_percent:t},a=(0,d.getTransactionOptions)(o);return(0,d.createTransaction)(this.tronWeb,u.ContractType.UpdateSettingContract,n,o?.permissionId,a)}async updateEnergyLimit(e,t=0,r=this.tronWeb.defaultAddress.hex,o={}){this.validator.notValid([{name:"owner",type:"address",value:r},{name:"contract",type:"address",value:e},{name:"originEnergyLimit",type:"integer",value:t,gte:0,lte:1e7}]);const n={owner_address:(0,s.toHex)(r),contract_address:(0,s.toHex)(e),origin_energy_limit:t},a=(0,d.getTransactionOptions)(o);return(0,d.createTransaction)(this.tronWeb,u.ContractType.UpdateEnergyLimitContract,n,o?.permissionId,a)}checkPermissions(e,t){if(e){if(e.type!==t||!e.permission_name||!(0,c.isString)(e.permission_name)||!(0,c.isInteger)(e.threshold)||e.threshold<1||!e.keys)return!1;for(const r of e.keys)if(!o.TronWeb.isAddress(r.address)||!(0,c.isInteger)(r.weight)||r.weight>e.threshold||r.weight<1||2===t&&!e.operations)return!1}return!0}async updateAccountPermissions(e=this.tronWeb.defaultAddress.hex,t,r,n,a={}){if(!o.TronWeb.isAddress(e))throw new Error("Invalid ownerAddress provided");if(!this.checkPermissions(t,0))throw new Error("Invalid ownerPermissions provided");if(!this.checkPermissions(r,1))throw new Error("Invalid witnessPermissions provided");Array.isArray(n)||(n=[n]);for(const e of n)if(!this.checkPermissions(e,2))throw new Error("Invalid activesPermissions provided");const i={owner_address:(0,s.toHex)(e)};if(t){const e=(0,d.deepCopyJson)(t);"type"in e&&delete e.type,e.keys=e.keys?.map((({address:e,weight:t})=>({address:this.tronWeb.address.toHex(e),weight:t}))),i.owner=e}if(r){const e=(0,d.deepCopyJson)(r);e.type="Witness",e.keys=e.keys.map((({address:e,weight:t})=>({address:this.tronWeb.address.toHex(e),weight:t}))),i.witness=e}if(n){const e=(0,d.deepCopyJson)(n);e.forEach((e=>{e.type="Active"})),e.forEach((e=>{e.keys=e.keys.map((({address:e,weight:t})=>({address:this.tronWeb.address.toHex(e),weight:t})))})),i.actives=e}const c=(0,d.getTransactionOptions)(a);return(0,d.createTransaction)(this.tronWeb,u.ContractType.AccountPermissionUpdateContract,i,a?.permissionId,c)}async newTxID(e,t={}){if(t?.txLocal){const t=e.raw_data.contract[0];try{const r=await(0,d.createTransaction)(this.tronWeb,t.type,t.parameter.value,t.Permission_id,{fee_limit:e.raw_data.fee_limit,data:e.raw_data.data,ref_block_bytes:e.raw_data.ref_block_bytes,ref_block_hash:e.raw_data.ref_block_hash,expiration:e.raw_data.expiration,timestamp:e.raw_data.timestamp});return r.signature=e.signature,r.visible=e.visible,r}catch(e){throw new Error("Error generating a new transaction id.")}}try{const t=await this.tronWeb.fullNode.request("wallet/getsignweight",e,"post");return"boolean"==typeof e.visible&&(t.transaction.transaction.visible=e.visible),(0,d.resultManager)(t.transaction.transaction,{...e.raw_data.contract[0].parameter.value,Permission_id:e.raw_data.contract[0].Permission_id},{data:e.raw_data.data,fee_limit:e.raw_data.fee_limit})}catch(e){throw new Error("Error generating a new transaction id.")}}async alterTransaction(e,t={}){if(Reflect.has(e,"signature"))throw new Error("You can not extend the expiration of a signed transaction.");if(t.data){if("hex"!==t.dataFormat&&(t.data=o.TronWeb.toHex(t.data)),t.data=t.data.replace(/^0x/,""),0===t.data.length)throw new Error("Invalid data provided");e.raw_data.data=t.data}if(t.extension){if(t.extension=parseInt(1e3*t.extension),isNaN(t.extension)||e.raw_data.expiration+t.extension<=Date.now()+3e3)throw new Error("Invalid extension provided");e.raw_data.expiration+=t.extension}return await this.newTxID(e,{txLocal:t.txLocal})}async extendExpiration(e,t,r={}){return await this.alterTransaction(e,{extension:t,txLocal:r?.txLocal})}async addUpdateData(e,t,r="utf8",o={}){return this.alterTransaction(e,{data:t,dataFormat:r,txLocal:o?.txLocal})}}},5401:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.fromUtf8=function(e){return o.TronWeb.fromUtf8(e).replace(/^0x/,"")},t.deepCopyJson=function(e){return JSON.parse(JSON.stringify(e))},t.resultManager=function(e,t,r){if(e.Error)throw new Error(e.Error);if(e.result&&e.result.message)throw new Error(o.TronWeb.toUtf8(e.result.message));if((0,n.txCheckWithArgs)(e,t,r))return e;throw new Error("Invalid transaction")},t.resultManagerTriggerSmartContract=function(e,t,r){if(e.Error)throw new Error(e.Error);if(e.result&&e.result.message)throw new Error(o.TronWeb.toUtf8(e.result.message));if(!r._isConstant&&!r.estimateEnergy){if((0,n.txCheckWithArgs)(e.transaction,t,r))return e;throw new Error("Invalid transaction")}return e},t.genContractAddress=function(e,t){return"41"+(0,s.keccak256)(Buffer.from(t+e,"hex")).toString().substring(2).slice(24)},t.getHeaderInfo=a,t.createTransaction=async function(e,t,r,o,s={}){const c={visible:!1,txID:"",raw_data_hex:"",raw_data:{contract:[{parameter:{value:r,type_url:`type.googleapis.com/protocol.${t}`},type:t}],...i(s)?{}:await a(e.fullNode),...s}};o&&(c.raw_data.contract[0].Permission_id=o);const u=(0,n.txJsonToPb)(c);return c.txID=(0,n.txPbToTxID)(u).replace(/^0x/,""),c.raw_data_hex=(0,n.txPbToRawDataHex)(u).toLowerCase(),c},t.getTransactionOptions=function(e={}){const t={};return i(e.blockHeader)&&(t.ref_block_bytes=e.blockHeader.ref_block_bytes,t.ref_block_hash=e.blockHeader.ref_block_hash,t.expiration=e.blockHeader.expiration,t.timestamp=e.blockHeader.timestamp),t};const o=r(5562),n=r(8931),s=r(9193);function a(e){return e.request("wallet/getblock",{detail:!1},"post").then((e=>({ref_block_bytes:e.block_header.raw_data.number.toString(16).slice(-4).padStart(4,"0"),ref_block_hash:e.blockID.slice(16,32),expiration:e.block_header.raw_data.timestamp+6e4,timestamp:e.block_header.raw_data.timestamp})))}function i(e={}){if(void 0===e.ref_block_bytes&&void 0===e.ref_block_hash&&void 0===e.expiration&&void 0===e.timestamp)return!1;if("string"!=typeof e.ref_block_bytes)throw new Error("Invalid ref_block_bytes provided.");if("string"!=typeof e.ref_block_hash)throw new Error("Invalid ref_block_hash provided.");if("number"!=typeof e.expiration)throw new Error("Invalid expiration provided.");if("number"!=typeof e.timestamp)throw new Error("Invalid timestamp provided.");return!0}},5884:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Method=t.Contract=void 0;const o=r(5584),n=r(5562),s=o.__importDefault(r(6219)),a=r(7759);t.Contract=class{tronWeb;abi;address;eventListener;bytecode;deployed;lastBlock;methods;methodInstances;props;constructor(e,t=[],r){if(!(e&&e instanceof n.TronWeb))throw new Error("Expected instance of TronWeb");this.tronWeb=e,this.address=r,this.abi=t,this.eventListener=!1,this.bytecode=!1,this.deployed=!1,this.lastBlock=!1,this.methods={},this.methodInstances={},this.props=[],s.default.address.isAddress(r)?this.deployed=!0:this.address=!1,this.loadAbi(t)}hasProperty(e){return this.hasOwnProperty(e)||this.__proto__.hasOwnProperty(e)}loadAbi(e){this.abi=e,this.methods={},this.props.forEach((e=>delete this[e])),e.forEach((e=>{if(!e.type||/constructor|error/i.test(e.type))return;const t=new a.Method(this,e),r=t.onMethod.bind(t),{name:o,functionSelector:n,signature:s}=t;this.methods[o]=r,this.methods[n]=r,this.methods[s]=r,this.methodInstances[o]=t,this.methodInstances[n]=t,this.methodInstances[s]=t,this.hasProperty(o)||(this[o]=r,this.props.push(o)),this.hasProperty(n)||(this[n]=r,this.props.push(n)),this.hasProperty(s)||(this[s]=r,this.props.push(s))}))}decodeInput(e){const t=e.substring(0,8),r=e.substring(8);if(!this.methodInstances[t])throw new Error("Contract method "+t+" not found");return{name:this.methodInstances[t].name,params:this.methodInstances[t].decodeInput(r)}}async new(e,t=this.tronWeb.defaultPrivateKey){const r=this.tronWeb.address.fromPrivateKey(t),o=await this.tronWeb.transactionBuilder.createSmartContract(e,r),n=await this.tronWeb.trx.sign(o,t),a=await this.tronWeb.trx.sendRawTransaction(n);if(a.code)throw{error:a.code,message:this.tronWeb.toUtf8(a.message)};return await s.default.sleep(3e3),this.at(n.contract_address)}async at(e){try{const t=await this.tronWeb.trx.getContract(e);if(!t.contract_address)throw new Error("Unknown error: "+JSON.stringify(t,null,2));return this.address=t.contract_address,this.bytecode=t.bytecode,this.deployed=!0,this.loadAbi(t.abi&&t.abi.entrys?t.abi.entrys:[]),this}catch(e){if(e.toString().includes("does not exist"))throw new Error("Contract has not been deployed on the network");throw new Error(e)}}};var i=r(7759);Object.defineProperty(t,"Method",{enumerable:!0,get:function(){return i.Method}})},7759:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Method=void 0;const o=r(5584).__importDefault(r(6219)),n=r(8557),s=r(7154),a=(e,t)=>(0,n.decodeParamsV2ByABI)(e,t);t.Method=class{tronWeb;contract;abi;name;inputs;outputs;functionSelector;signature;defaultOptions;constructor(e,t){this.tronWeb=e.tronWeb,this.contract=e,this.abi=t,this.name=t.name||t.type,this.inputs=t.inputs||[],this.outputs=[],"outputs"in t&&t.outputs&&(this.outputs=t.outputs),this.functionSelector=(e=>{if("stateMutability"in e&&(e.stateMutability=e.stateMutability?e.stateMutability.toLowerCase():"nonpayable"),e.type=e.type?e.type.toLowerCase():"","fallback"===e.type||"receive"===e.type)return"0x";const t=new o.default.ethersUtils.Interface([e]);let r;if(r="event"===e.type?t.getEvent(e.name):t.getFunction(e.name),r)return r.format("sighash");throw new Error("unknown function")})(t),this.signature=(0,s.sha3)(this.functionSelector,!1).slice(0,8),this.defaultOptions={feeLimit:this.tronWeb.feeLimit,callValue:0,userFeePercentage:100,shouldPollResponse:!1}}decodeInput(e){const t=JSON.parse(JSON.stringify(this.abi));return t.outputs=t.inputs,a(t,"0x"+e)}onMethod(...e){let t="";return this.abi&&!/event/i.test(this.abi.type)&&(t=(0,n.encodeParamsV2ByABI)(this.abi,e)),{call:async(e={})=>(e={...e,rawParameter:t},await this._call([],[],e)),send:async(e={},r=this.tronWeb.defaultPrivateKey)=>(e={...e,rawParameter:t},await this._send([],[],e,r))}}async _call(e,t,r={}){if(e.length!==t.length)throw new Error("Invalid argument count provided");if(!this.contract.address)throw new Error("Smart contract is missing address");if(!this.contract.deployed)throw new Error("Calling smart contracts requires you to load the contract first");if("stateMutability"in this.abi){const{stateMutability:e}=this.abi;if(e&&!["pure","view"].includes(e.toLowerCase()))throw new Error(`Methods with state mutability "${e}" must use send()`)}r={...this.defaultOptions,from:this.tronWeb.defaultAddress.hex,...r,_isConstant:!0};const n=t.map(((t,r)=>({type:e[r],value:t}))),s=await this.tronWeb.transactionBuilder.triggerSmartContract(this.contract.address,this.functionSelector,r,n,r.from?this.tronWeb.address.toHex(r.from):void 0);if(!o.default.hasProperty(s,"constant_result"))throw new Error("Failed to execute");const i=s.constant_result[0].length;if(0===i||i%64==8){let e="The call has been reverted or has thrown an error.";if(0!==i){e+=" Error message: ";let t="";const r=s.constant_result[0].substring(8);for(let e=0;e<i-8;e+=64)t+=this.tronWeb.toUtf8(r.substring(e,e+64));e+=t.replace(/(\u0000|\u000b|\f)+/g," ").replace(/ +/g," ").replace(/\s+$/g,"")}throw new Error(e)}let c=a(this.abi,"0x"+s.constant_result[0]);return 1===c.length&&1===Object.keys(c).length&&(c=c[0]),c}async _send(e,t,r={},n=this.tronWeb.defaultPrivateKey){if(e.length!==t.length)throw new Error("Invalid argument count provided");if(!this.contract.address)throw new Error("Smart contract is missing address");if(!this.contract.deployed)throw new Error("Calling smart contracts requires you to load the contract first");const{stateMutability:s}=this.abi;if(["pure","view"].includes(s.toLowerCase()))throw new Error(`Methods with state mutability "${s}" must use call()`);["payable"].includes(s.toLowerCase())||(r.callValue=0),r={...this.defaultOptions,from:this.tronWeb.defaultAddress.hex,...r};const i=t.map(((t,r)=>({type:e[r],value:t}))),c=n?this.tronWeb.address.fromPrivateKey(n):this.tronWeb.defaultAddress.base58,u=await this.tronWeb.transactionBuilder.triggerSmartContract(this.contract.address,this.functionSelector,r,i,this.tronWeb.address.toHex(c));if(!u.result||!u.result.result)throw new Error("Unknown error: "+JSON.stringify(u,null,2));const d=await this.tronWeb.trx.sign(u.transaction,n);if(!d.signature){if(!n)throw new Error("Transaction was not signed properly");throw new Error("Invalid private key provided")}const l=await this.tronWeb.trx.sendRawTransaction(d);if(l.code){const e={error:l.code,message:l.code};l.message&&(e.message=this.tronWeb.toUtf8(l.message));const t=new Error(e.message);throw t.error=l.code,t}if(!r.shouldPollResponse)return d.txID;const p=async e=>{if(e===(r.pollTimes||20)){const e=new Error("Cannot find result in solidity node");throw e.error="Cannot find result in solidity node",e.transaction=d,e}const t=await this.tronWeb.trx.getTransactionInfo(d.txID);if(!Object.keys(t).length)return await new Promise((e=>setTimeout(e,3e3))),p(e+1);if(t.result&&"FAILED"===t.result){const e=new Error(this.tronWeb.toUtf8(t.resMessage));throw e.error=this.tronWeb.toUtf8(t.resMessage),e.transaction=d,e.output=t,e}if(!o.default.hasProperty(t,"contractResult")){const e=new Error("Failed to execute: "+JSON.stringify(t,null,2));throw e.error="Failed to execute: "+JSON.stringify(t,null,2),e.transaction=d,e.output=t,e}if(r.rawResponse)return t;let n=a(this.abi,"0x"+t.contractResult[0]);return 1===n.length&&1===Object.keys(n).length&&(n=n[0]),r.keepTxID?[d.txID,n]:n};return p(0)}}},3569:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Event=void 0;const o=r(5584),n=r(5562),s=o.__importDefault(r(6219)),a=r(4612);t.Event=class{tronWeb;constructor(e){if(!(e&&e instanceof n.TronWeb))throw new Error("Expected instance of TronWeb");this.tronWeb=e}setServer(e,t="healthcheck"){if(!e)return this.tronWeb.eventServer=void 0;if(s.default.isString(e)&&(e=new a.HttpProvider(e)),!this.tronWeb.isValidProvider(e))throw new Error("Invalid event server provided");this.tronWeb.eventServer=e,this.tronWeb.eventServer.isConnected=()=>this.tronWeb.eventServer.request(t).then((()=>!0)).catch((()=>!1))}async getEventsByContractAddress(e,t={}){const r=Object.assign({limit:20},t),{eventName:o,blockNumber:n,onlyUnconfirmed:a,onlyConfirmed:i,minBlockTimestamp:c,maxBlockTimestamp:u,orderBy:d,fingerprint:l}=r;let{limit:p}=r;if(!this.tronWeb.eventServer)throw new Error("No event server configured");if(!this.tronWeb.isAddress(e))throw new Error("Invalid contract address provided");if(void 0!==c&&!s.default.isInteger(c))throw new Error("Invalid minBlockTimestamp provided");if(void 0!==u&&!s.default.isInteger(u))throw new Error("Invalid maxBlockTimestamp provided");s.default.isInteger(p)&&p>200&&(console.warn("Defaulting to maximum accepted limit: 200"),p=200);const g={};o&&(g.event_name=o),n&&(g.block_number=n),"boolean"==typeof a&&(g.only_unconfirmed=a),"boolean"==typeof i&&(g.only_confirmed=i),c&&(g.min_block_timestamp=c),u&&(g.max_block_timestamp=u),d&&(g.order_by=d),l&&(g.fingerprint=l),s.default.isInteger(p)&&(g.limit=p);const f=await this.tronWeb.eventServer.request(`v1/contracts/${this.tronWeb.address.fromHex(e)}/events?${new URLSearchParams(g).toString()}`);if(f.success)return f;throw new Error(f.error)}async getEventsByTransactionID(e,t={}){if(!this.tronWeb.eventServer)throw new Error("No event server configured");const r={};return"boolean"==typeof t.only_unconfirmed&&(r.only_unconfirmed=t.only_unconfirmed),"boolean"==typeof t.only_confirmed&&(r.only_confirmed=t.only_confirmed),this.tronWeb.eventServer.request(`v1/transactions/${e}/events?${new URLSearchParams(r).toString()}`).then((e=>{if(e.success)return e;throw new Error(JSON.parse(e.error).message)}))}async getEventsByBlockNumber(e,t={}){if(!this.tronWeb.eventServer)throw new Error("No event server configured");const r={};return"boolean"==typeof t.only_confirmed&&(r.only_confirmed=t.only_confirmed),t.limit&&(r.limit=t.limit),t.fingerprint&&(r.fingerprint=t.fingerprint),this.tronWeb.eventServer.request(`v1/blocks/${e}/events?${new URLSearchParams(r).toString()}`).then((e=>{if(e.success)return e;throw new Error(e.error)}))}async getEventsOfLatestBlock(e={}){if(!this.tronWeb.eventServer)throw new Error("No event server configured");const t={};return"boolean"==typeof e.only_confirmed&&(t.only_confirmed=e.only_confirmed),this.tronWeb.eventServer.request(`v1/blocks/latest/events?${new URLSearchParams(t).toString()}`).then((e=>{if(e.success)return e;throw new Error(e.error)}))}}},8050:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Plugin=void 0;const o=r(5584),n=r(5562),s=o.__importDefault(r(6219)),a=o.__importDefault(r(8064));t.Plugin=class{tronWeb;pluginNoOverride;disablePlugins;constructor(e,t={}){if(!(e&&e instanceof n.TronWeb))throw new Error("Expected instance of TronWeb");this.tronWeb=e,this.pluginNoOverride=["register"],this.disablePlugins=!!t.disablePlugins}register(e,t){let r={requires:"0.0.0",components:{}};const o={libs:[],plugged:[],skipped:[],error:void 0};if(this.disablePlugins)return o.error="This instance of TronWeb has plugins disabled.",o;const i=new e(this.tronWeb);if(s.default.isFunction(i.pluginInterface)&&(r=i.pluginInterface(t)),!a.default.satisfies(n.TronWeb.version,r.requires))throw new Error("The plugin is not compatible with this version of TronWeb");if(r.fullClass){const t=i.constructor.name,r=t.substring(0,1).toLowerCase()+t.substring(1);t!==r&&(Object.assign(n.TronWeb,{[t]:e}),Object.assign(this.tronWeb,{[r]:i}),o.libs.push(t))}else for(const e in r.components){if(!this.tronWeb.hasOwnProperty(e))continue;const t=r.components[e],n=this.tronWeb[e].pluginNoOverride||[];for(const r in t)"constructor"===r||this.tronWeb[e][r]&&(n.includes(r)||/^_/.test(r))?o.skipped.push(r):(this.tronWeb[e][r]=t[r].bind(this.tronWeb[e]),o.plugged.push(r))}return o}}},5231:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=r(5584).__importDefault(r(8938)),n=r(3331);t.default=class{host;timeout;user;password;headers;statusPage;instance;constructor(e,t=3e4,r="",s="",a={},i="/"){if(!(0,n.isValidURL)(e))throw new Error("Invalid URL provided to HttpProvider");if(isNaN(t)||t<0)throw new Error("Invalid timeout duration provided");if(!(0,n.isObject)(a))throw new Error("Invalid headers object provided");e=e.replace(/\/+$/,""),this.host=e,this.timeout=t,this.user=r,this.password=s,this.headers=a,this.statusPage=i,this.instance=o.default.create({baseURL:e,timeout:t,headers:a,auth:r?{username:r,password:s}:void 0})}setStatusPage(e="/"){this.statusPage=e}async isConnected(e=this.statusPage){return this.request(e).then((e=>(0,n.hasProperties)(e,"blockID","block_header"))).catch((()=>!1))}request(e,t={},r="get"){return r=r.toLowerCase(),this.instance.request({data:"post"==r&&Object.keys(t).length?t:null,params:"get"==r&&t,url:e,method:r}).then((({data:e})=>e))}}},4612:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.HttpProvider=t.providers=void 0;const o=r(5584).__importDefault(r(5231));t.HttpProvider=o.default,t.providers={HttpProvider:o.default}},983:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Trx=void 0;const o=r(5584),n=r(5562),s=o.__importDefault(r(6219)),a=r(9193),i=r(9055),c=r(7035),u=r(8931),d=r(7154),l="TRON Signed Message:\n32",p="Ethereum Signed Message:\n32";function g(e){return n.TronWeb.address.toHex(e)}class f{tronWeb;cache;validator;signMessage;sendAsset;send;sendTrx;broadcast;broadcastHex;signTransaction;constructor(e){this.tronWeb=e,this.cache={contracts:{}},this.validator=new c.Validator,this.signMessage=this.sign,this.sendAsset=this.sendToken,this.send=this.sendTransaction,this.sendTrx=this.sendTransaction,this.broadcast=this.sendRawTransaction,this.broadcastHex=this.sendHexTransaction,this.signTransaction=this.sign}_parseToken(e){return{...e,name:this.tronWeb.toUtf8(e.name),abbr:e.abbr&&this.tronWeb.toUtf8(e.abbr),description:e.description&&this.tronWeb.toUtf8(e.description),url:e.url&&this.tronWeb.toUtf8(e.url)}}getCurrentBlock(){return this.tronWeb.fullNode.request("wallet/getnowblock")}getConfirmedCurrentBlock(){return this.tronWeb.solidityNode.request("walletsolidity/getnowblock")}async getBlock(e=this.tronWeb.defaultBlock){if(!1===e)throw new Error("No block identifier provided");return"earliest"==e&&(e=0),"latest"==e?this.getCurrentBlock():isNaN(+e)&&s.default.isHex(e.toString())?this.getBlockByHash(e):this.getBlockByNumber(e)}async getBlockByHash(e){const t=await this.tronWeb.fullNode.request("wallet/getblockbyid",{value:e},"post");if(!Object.keys(t).length)throw new Error("Block not found");return t}async getBlockByNumber(e){if(!s.default.isInteger(e)||e<0)throw new Error("Invalid block number provided");return this.tronWeb.fullNode.request("wallet/getblockbynum",{num:parseInt(e)},"post").then((e=>{if(!Object.keys(e).length)throw new Error("Block not found");return e}))}async getBlockTransactionCount(e=this.tronWeb.defaultBlock){const{transactions:t=[]}=await this.getBlock(e);return t.length}async getTransactionFromBlock(e=this.tronWeb.defaultBlock,t){const{transactions:r}=await this.getBlock(e);if(!r)throw new Error("Transaction not found in block");if(t>=0&&t<r.length)return r[t];throw new Error("Invalid transaction index provided")}async getTransactionsFromBlock(e=this.tronWeb.defaultBlock){const{transactions:t}=await this.getBlock(e);if(!t)throw new Error("Transaction not found in block");return t}async getTransaction(e){const t=await this.tronWeb.fullNode.request("wallet/gettransactionbyid",{value:e},"post");if(!Object.keys(t).length)throw new Error("Transaction not found");return t}async getConfirmedTransaction(e){const t=await this.tronWeb.solidityNode.request("walletsolidity/gettransactionbyid",{value:e},"post");if(!Object.keys(t).length)throw new Error("Transaction not found");return t}getUnconfirmedTransactionInfo(e){return this.tronWeb.fullNode.request("wallet/gettransactioninfobyid",{value:e},"post")}getTransactionInfo(e){return this.tronWeb.solidityNode.request("walletsolidity/gettransactioninfobyid",{value:e},"post")}getTransactionsToAddress(e=this.tronWeb.defaultAddress.hex,t=30,r=0){return this.getTransactionsRelated(this.tronWeb.address.toHex(e),"to",t,r)}getTransactionsFromAddress(e=this.tronWeb.defaultAddress.hex,t=30,r=0){return this.getTransactionsRelated(this.tronWeb.address.toHex(e),"from",t,r)}async getTransactionsRelated(e=this.tronWeb.defaultAddress.hex,t="all",r=30,o=0){if(!["to","from","all"].includes(t))throw new Error('Invalid direction provided: Expected "to", "from" or "all"');if("all"==t){const[t,n]=await Promise.all([this.getTransactionsRelated(e,"from",r,o),this.getTransactionsRelated(e,"to",r,o)]);return[...t.map((e=>(e.direction="from",e))),...n.map((e=>(e.direction="to",e)))].sort(((e,t)=>t.raw_data.timestamp-e.raw_data.timestamp))}if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");if(!s.default.isInteger(r)||r<0||o&&r<1)throw new Error("Invalid limit provided");if(!s.default.isInteger(o)||o<0)throw new Error("Invalid offset provided");return e=this.tronWeb.address.toHex(e),this.tronWeb.solidityNode.request(`walletextension/gettransactions${t}this`,{account:{address:e},offset:o,limit:r},"post").then((({transaction:e})=>e))}async getAccount(e=this.tronWeb.defaultAddress.hex){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return e=this.tronWeb.address.toHex(e),this.tronWeb.solidityNode.request("walletsolidity/getaccount",{address:e},"post")}getAccountById(e){return this.getAccountInfoById(e,{confirmed:!0})}async getAccountInfoById(e,t){return this.validator.notValid([{name:"accountId",type:"hex",value:e},{name:"accountId",type:"string",lte:32,gte:8,value:e}]),e.startsWith("0x")&&(e=e.slice(2)),this.tronWeb[t.confirmed?"solidityNode":"fullNode"].request(`wallet${t.confirmed?"solidity":""}/getaccountbyid`,{account_id:e},"post")}async getBalance(e=this.tronWeb.defaultAddress.hex){const{balance:t=0}=await this.getAccount(e);return t}async getUnconfirmedAccount(e=this.tronWeb.defaultAddress.hex){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return e=this.tronWeb.address.toHex(e),this.tronWeb.fullNode.request("wallet/getaccount",{address:e},"post")}getUnconfirmedAccountById(e){return this.getAccountInfoById(e,{confirmed:!1})}async getUnconfirmedBalance(e=this.tronWeb.defaultAddress.hex){const{balance:t=0}=await this.getUnconfirmedAccount(e);return t}async getBandwidth(e=this.tronWeb.defaultAddress.hex){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return e=this.tronWeb.address.toHex(e),this.tronWeb.fullNode.request("wallet/getaccountnet",{address:e},"post").then((({freeNetUsed:e=0,freeNetLimit:t=0,NetUsed:r=0,NetLimit:o=0})=>t-e+(o-r)))}async getTokensIssuedByAddress(e=this.tronWeb.defaultAddress.hex){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return e=this.tronWeb.address.toHex(e),this.tronWeb.fullNode.request("wallet/getassetissuebyaccount",{address:e},"post").then((({assetIssue:e})=>e?e.map((e=>this._parseToken(e))).reduce(((e,t)=>(e[t.name]=t,e)),{}):{}))}async getTokenFromID(e){if(s.default.isInteger(e)&&(e=e.toString()),!s.default.isString(e)||!e.length)throw new Error("Invalid token ID provided");return this.tronWeb.fullNode.request("wallet/getassetissuebyname",{value:this.tronWeb.fromUtf8(e)},"post").then((e=>{if(!e.name)throw new Error("Token does not exist");return this._parseToken(e)}))}async listNodes(){const{nodes:e=[]}=await this.tronWeb.fullNode.request("wallet/listnodes");return e.map((({address:{host:e,port:t}})=>`${this.tronWeb.toUtf8(e)}:${t}`))}async getBlockRange(e=0,t=30){if(!s.default.isInteger(e)||e<0)throw new Error("Invalid start of range provided");if(!s.default.isInteger(t)||t<e)throw new Error("Invalid end of range provided");if(t+1-e>100)throw new Error("Invalid range size, which should be no more than 100.");return this.tronWeb.fullNode.request("wallet/getblockbylimitnext",{startNum:parseInt(e),endNum:parseInt(t)+1},"post").then((({block:e=[]})=>e))}async listSuperRepresentatives(){const{witnesses:e=[]}=await this.tronWeb.fullNode.request("wallet/listwitnesses");return e}async listTokens(e=0,t=0){if(!s.default.isInteger(e)||e<0||t&&e<1)throw new Error("Invalid limit provided");if(!s.default.isInteger(t)||t<0)throw new Error("Invalid offset provided");return e?this.tronWeb.fullNode.request("wallet/getpaginatedassetissuelist",{offset:parseInt(t),limit:parseInt(e)},"post").then((({assetIssue:e=[]})=>e.map((e=>this._parseToken(e))))):this.tronWeb.fullNode.request("wallet/getassetissuelist").then((({assetIssue:e=[]})=>e.map((e=>this._parseToken(e)))))}async timeUntilNextVoteCycle(){const{num:e=-1}=await this.tronWeb.fullNode.request("wallet/getnextmaintenancetime");if(-1==e)throw new Error("Failed to get time until next vote cycle");return Math.floor(e/1e3)}async getContract(e){if(!this.tronWeb.isAddress(e))throw new Error("Invalid contract address provided");if(this.cache.contracts[e])return this.cache.contracts[e];e=this.tronWeb.address.toHex(e);const t=await this.tronWeb.fullNode.request("wallet/getcontract",{value:e});if(t.Error)throw new Error("Contract does not exist");return this.cache.contracts[e]=t,t}ecRecover(e){return f.ecRecover(e)}static ecRecover(e){if(!(0,u.txCheck)(e))throw new Error("Invalid transaction");if(!e.signature?.length)throw new Error("Transaction is not signed");if(1===e.signature.length){const t=(0,d.ecRecover)(e.txID,e.signature[0]);return n.TronWeb.address.fromHex(t)}return e.signature.map((t=>{const r=(0,d.ecRecover)(e.txID,t);return n.TronWeb.address.fromHex(r)}))}async verifyMessage(e,t,r=this.tronWeb.defaultAddress.base58,o=!0){if(!s.default.isHex(e))throw new Error("Expected hex message input");if(f.verifySignature(e,r,t,o))return!0;throw new Error("Signature does not match")}static verifySignature(e,t,r,o=!0){e=e.replace(/^0x/,"");const c=[...(0,a.toUtf8Bytes)(o?l:p),...s.default.code.hexStr2byteArray(e)],u=(0,a.keccak256)(new Uint8Array(c)),d=(0,a.recoverAddress)(u,a.Signature.from(`0x${r.replace(/^0x/,"")}`)),g=i.ADDRESS_PREFIX+d.substr(2);return n.TronWeb.address.fromHex(g)==n.TronWeb.address.fromHex(t)}async verifyMessageV2(e,t){return f.verifyMessageV2(e,t)}static verifyMessageV2(e,t){return s.default.message.verifyMessage(e,t)}verifyTypedData(e,t,r,o,n=this.tronWeb.defaultAddress.base58){if(f.verifyTypedData(e,t,r,o,n))return!0;throw new Error("Signature does not match")}static verifyTypedData(e,t,r,o,c){const u=s.default._TypedDataEncoder.hash(e,t,r),d=(0,a.recoverAddress)(u,a.Signature.from(`0x${o.replace(/^0x/,"")}`)),l=i.ADDRESS_PREFIX+d.substr(2);return n.TronWeb.address.fromHex(l)==n.TronWeb.address.fromHex(c)}async sign(e,t=this.tronWeb.defaultPrivateKey,r=!0,o=!1){if(s.default.isString(e)){if(!s.default.isHex(e))throw new Error("Expected hex message input");return f.signString(e,t,r)}if(!s.default.isObject(e))throw new Error("Invalid transaction provided");if(!o&&e.signature)throw new Error("Transaction is already signed");if(!o){if(this.tronWeb.address.toHex(this.tronWeb.address.fromPrivateKey(t)).toLowerCase()!==this.tronWeb.address.toHex(e.raw_data.contract[0].parameter.value.owner_address))throw new Error("Private key does not match address in transaction");if(!(0,u.txCheck)(e))throw new Error("Invalid transaction")}return s.default.crypto.signTransaction(t,e)}static signString(e,t,r=!0){e=e.replace(/^0x/,"");const o=`0x${t.replace(/^0x/,"")}`,n=new a.SigningKey(o),i=[...(0,a.toUtf8Bytes)(r?l:p),...s.default.code.hexStr2byteArray(e)],c=(0,a.keccak256)(new Uint8Array(i)),u=n.sign(c);return["0x",u.r.substring(2),u.s.substring(2),Number(u.v).toString(16)].join("")}signMessageV2(e,t=this.tronWeb.defaultPrivateKey){return f.signMessageV2(e,t)}static signMessageV2(e,t){return s.default.message.signMessage(e,t)}_signTypedData(e,t,r,o=this.tronWeb.defaultPrivateKey){return f._signTypedData(e,t,r,o)}static _signTypedData(e,t,r,o){return s.default.crypto._signTypedData(e,t,r,o)}async multiSign(e,t=this.tronWeb.defaultPrivateKey,r=0){if(!s.default.isObject(e)||!e.raw_data||!e.raw_data.contract)throw new Error("Invalid transaction provided");if(!e.raw_data.contract[0].Permission_id&&r>0){e.raw_data.contract[0].Permission_id=r;const o=this.tronWeb.address.toHex(this.tronWeb.address.fromPrivateKey(t)).toLowerCase(),n=await this.getSignWeight(e,r);if("PERMISSION_ERROR"===n.result.code)throw new Error(n.result.message);let s=!1;if(n.permission.keys.map((e=>{e.address===o&&(s=!0)})),!s)throw new Error(t+" has no permission to sign");if(n.approved_list&&-1!=n.approved_list.indexOf(o))throw new Error(t+" already sign transaction");if(!n.transaction||!n.transaction.transaction)throw new Error("Invalid transaction provided");e=n.transaction.transaction,r>0&&(e.raw_data.contract[0].Permission_id=r)}if(!(0,u.txCheck)(e))throw new Error("Invalid transaction");return s.default.crypto.signTransaction(t,e)}async getApprovedList(e){if(!s.default.isObject(e))throw new Error("Invalid transaction provided");return this.tronWeb.fullNode.request("wallet/getapprovedlist",e,"post")}async getSignWeight(e,t){if(!s.default.isObject(e)||!e.raw_data||!e.raw_data.contract)throw new Error("Invalid transaction provided");return s.default.isInteger(t)?e.raw_data.contract[0].Permission_id=parseInt(t):"number"!=typeof e.raw_data.contract[0].Permission_id&&(e.raw_data.contract[0].Permission_id=0),this.tronWeb.fullNode.request("wallet/getsignweight",e,"post")}async sendRawTransaction(e){if(!s.default.isObject(e))throw new Error("Invalid transaction provided");if(!e.signature||!s.default.isArray(e.signature))throw new Error("Transaction is not signed");return{...await this.tronWeb.fullNode.request("wallet/broadcasttransaction",e,"post"),transaction:e}}async sendHexTransaction(e){if(!s.default.isHex(e))throw new Error("Invalid hex transaction provided");const t={transaction:e},r=await this.tronWeb.fullNode.request("wallet/broadcasthex",t,"post");return r.result?{...r,transaction:JSON.parse(r.transaction),hexTransaction:e}:r}async sendTransaction(e,t,r={}){if("string"==typeof r&&(r={privateKey:r}),!this.tronWeb.isAddress(e))throw new Error("Invalid recipient provided");if(!s.default.isInteger(t)||t<=0)throw new Error("Invalid amount provided");if(!(r={privateKey:this.tronWeb.defaultPrivateKey,address:this.tronWeb.defaultAddress.hex,...r}).privateKey&&!r.address)throw new Error("Function requires either a private key or address to be set");const o=r.privateKey?this.tronWeb.address.fromPrivateKey(r.privateKey):r.address,n=await this.tronWeb.transactionBuilder.sendTrx(e,t,o),a=await this.sign(n,r.privateKey);return await this.sendRawTransaction(a)}async sendToken(e,t,r,o={}){if("string"==typeof o&&(o={privateKey:o}),!this.tronWeb.isAddress(e))throw new Error("Invalid recipient provided");if(!s.default.isInteger(t)||t<=0)throw new Error("Invalid amount provided");if(s.default.isInteger(r)&&(r=r.toString()),!s.default.isString(r))throw new Error("Invalid token ID provided");if(!(o={privateKey:this.tronWeb.defaultPrivateKey,address:this.tronWeb.defaultAddress.hex,...o}).privateKey&&!o.address)throw new Error("Function requires either a private key or address to be set");const n=o.privateKey?this.tronWeb.address.fromPrivateKey(o.privateKey):o.address,a=await this.tronWeb.transactionBuilder.sendToken(e,t,r,n),i=await this.sign(a,o.privateKey);return await this.sendRawTransaction(i)}async freezeBalance(e=0,t=3,r="BANDWIDTH",o={},n){if("string"==typeof o&&(o={privateKey:o}),!["BANDWIDTH","ENERGY"].includes(r))throw new Error('Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"');if(!s.default.isInteger(e)||e<=0)throw new Error("Invalid amount provided");if(!s.default.isInteger(t)||t<3)throw new Error("Invalid duration provided, minimum of 3 days");if(!(o={privateKey:this.tronWeb.defaultPrivateKey,address:this.tronWeb.defaultAddress.hex,...o}).privateKey&&!o.address)throw new Error("Function requires either a private key or address to be set");const a=o.privateKey?this.tronWeb.address.fromPrivateKey(o.privateKey):o.address,i=await this.tronWeb.transactionBuilder.freezeBalance(e,t,r,a,n),c=await this.sign(i,o.privateKey);return await this.sendRawTransaction(c)}async unfreezeBalance(e="BANDWIDTH",t={},r){if("string"==typeof t&&(t={privateKey:t}),!["BANDWIDTH","ENERGY"].includes(e))throw new Error('Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"');if(!(t={privateKey:this.tronWeb.defaultPrivateKey,address:this.tronWeb.defaultAddress.hex,...t}).privateKey&&!t.address)throw new Error("Function requires either a private key or address to be set");const o=t.privateKey?this.tronWeb.address.fromPrivateKey(t.privateKey):t.address,n=await this.tronWeb.transactionBuilder.unfreezeBalance(e,o,r),s=await this.sign(n,t.privateKey);return await this.sendRawTransaction(s)}async updateAccount(e,t={}){if("string"==typeof t&&(t={privateKey:t}),!s.default.isString(e)||!e.length)throw new Error("Name must be a string");if(!(t={privateKey:this.tronWeb.defaultPrivateKey,address:this.tronWeb.defaultAddress.hex,...t}).privateKey&&!t.address)throw Error("Function requires either a private key or address to be set");const r=t.privateKey?this.tronWeb.address.fromPrivateKey(t.privateKey):t.address,o=await this.tronWeb.transactionBuilder.updateAccount(e,r),n=await this.sign(o,t.privateKey);return await this.sendRawTransaction(n)}async getProposal(e){if(!s.default.isInteger(e)||e<0)throw new Error("Invalid proposalID provided");return this.tronWeb.fullNode.request("wallet/getproposalbyid",{id:parseInt(e)},"post")}async listProposals(){const{proposals:e=[]}=await this.tronWeb.fullNode.request("wallet/listproposals",{},"post");return e}async getChainParameters(){const{chainParameter:e=[]}=await this.tronWeb.fullNode.request("wallet/getchainparameters",{},"post");return e}async getAccountResources(e=this.tronWeb.defaultAddress.hex){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return this.tronWeb.fullNode.request("wallet/getaccountresource",{address:this.tronWeb.address.toHex(e)},"post")}async getDelegatedResourceV2(e=this.tronWeb.defaultAddress.hex,t=this.tronWeb.defaultAddress.hex,r={confirmed:!0}){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");if(!this.tronWeb.isAddress(t))throw new Error("Invalid address provided");return this.tronWeb[r.confirmed?"solidityNode":"fullNode"].request(`wallet${r.confirmed?"solidity":""}/getdelegatedresourcev2`,{fromAddress:g(e),toAddress:g(t)},"post")}async getDelegatedResourceAccountIndexV2(e=this.tronWeb.defaultAddress.hex,t={confirmed:!0}){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return this.tronWeb[t.confirmed?"solidityNode":"fullNode"].request(`wallet${t.confirmed?"solidity":""}/getdelegatedresourceaccountindexv2`,{value:g(e)},"post")}async getCanDelegatedMaxSize(e=this.tronWeb.defaultAddress.hex,t="BANDWIDTH",r={confirmed:!0}){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return this.validator.notValid([{name:"resource",type:"resource",value:t,msg:'Invalid resource provided: Expected "BANDWIDTH" or "ENERGY"'}]),this.tronWeb[r.confirmed?"solidityNode":"fullNode"].request(`wallet${r.confirmed?"solidity":""}/getcandelegatedmaxsize`,{owner_address:g(e),type:"ENERGY"===t?1:0},"post")}async getAvailableUnfreezeCount(e=this.tronWeb.defaultAddress.hex,t={confirmed:!0}){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");return this.tronWeb[t.confirmed?"solidityNode":"fullNode"].request(`wallet${t.confirmed?"solidity":""}/getavailableunfreezecount`,{owner_address:g(e)},"post")}async getCanWithdrawUnfreezeAmount(e=this.tronWeb.defaultAddress.hex,t=Date.now(),r={confirmed:!0}){if(!this.tronWeb.isAddress(e))throw new Error("Invalid address provided");if(!s.default.isInteger(t)||t<0)throw new Error("Invalid timestamp provided");return this.tronWeb[r.confirmed?"solidityNode":"fullNode"].request(`wallet${r.confirmed?"solidity":""}/getcanwithdrawunfreezeamount`,{owner_address:g(e),timestamp:t},"post")}async getExchangeByID(e){if(!s.default.isInteger(e)||e<0)throw new Error("Invalid exchangeID provided");return this.tronWeb.fullNode.request("wallet/getexchangebyid",{id:e},"post")}async listExchanges(){return this.tronWeb.fullNode.request("wallet/listexchanges",{},"post").then((({exchanges:e=[]})=>e))}async listExchangesPaginated(e=10,t=0){return this.tronWeb.fullNode.request("wallet/getpaginatedexchangelist",{limit:e,offset:t},"post").then((({exchanges:e=[]})=>e))}async getNodeInfo(){return this.tronWeb.fullNode.request("wallet/getnodeinfo",{},"post")}async getTokenListByName(e){if(s.default.isInteger(e)&&(e=e.toString()),!s.default.isString(e)||!e.length)throw new Error("Invalid token ID provided");return this.tronWeb.fullNode.request("wallet/getassetissuelistbyname",{value:this.tronWeb.fromUtf8(e)},"post").then((e=>{if(Array.isArray(e.assetIssue))return e.assetIssue.map((e=>this._parseToken(e)));if(!e.name)throw new Error("Token does not exist");return this._parseToken(e)}))}getTokenByID(e){if(s.default.isInteger(e)&&(e=e.toString()),!s.default.isString(e)||!e.length)throw new Error("Invalid token ID provided");return this.tronWeb.fullNode.request("wallet/getassetissuebyid",{value:e},"post").then((e=>{if(!e.name)throw new Error("Token does not exist");return this._parseToken(e)}))}async getReward(e,t={}){return t.confirmed=!0,this._getReward(e,t)}async getUnconfirmedReward(e,t={}){return t.confirmed=!1,this._getReward(e,t)}async getBrokerage(e,t={}){return t.confirmed=!0,this._getBrokerage(e,t)}async getUnconfirmedBrokerage(e,t={}){return t.confirmed=!1,this._getBrokerage(e,t)}async _getReward(e=this.tronWeb.defaultAddress.hex,t){this.validator.notValid([{name:"origin",type:"address",value:e}]);const r={address:g(e)};return this.tronWeb[t.confirmed?"solidityNode":"fullNode"].request(`wallet${t.confirmed?"solidity":""}/getReward`,r,"post").then(((e={reward:void 0})=>{if(void 0===e.reward)throw new Error("Not found.");return e.reward}))}async _getBrokerage(e=this.tronWeb.defaultAddress.hex,t){this.validator.notValid([{name:"origin",type:"address",value:e}]);const r={address:g(e)};return this.tronWeb[t.confirmed?"solidityNode":"fullNode"].request(`wallet${t.confirmed?"solidity":""}/getBrokerage`,r,"post").then(((e={})=>{if(void 0===e.brokerage)throw new Error("Not found.");return e.brokerage}))}async getBandwidthPrices(){return this.tronWeb.fullNode.request("wallet/getbandwidthprices",{},"post").then(((e={})=>{if(void 0===e.prices)throw new Error("Not found.");return e.prices}))}async getEnergyPrices(){return this.tronWeb.fullNode.request("wallet/getenergyprices",{},"post").then(((e={})=>{if(void 0===e.prices)throw new Error("Not found.");return e.prices}))}}t.Trx=f},7035:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Validator=void 0;const o=r(9055),n=r(3331);t.Validator=class{invalid(e){return e.msg||`Invalid ${e.name}${"address"===e.type?" address":""} provided`}notPositive(e){return`${e.name} must be a positive integer`}notEqual(e){return e.msg||`${e.names?.[0]} can not be equal to ${e.names?.[1]}`}notValid(e){const t={};let r=!1;for(const s of e){const{name:e,names:a,value:i,type:c,gt:u,lt:d,gte:l,lte:p,optional:g}=s;if(!g||(0,n.isNotNullOrUndefined)(i)&&("boolean"===c||!1!==i)){switch(t[e]=s.value,c){case"address":(0,o.isAddress)(i)?t[e]=(0,o.toHex)(i):r=!0;break;case"integer":(!(0,n.isInteger)(i)||"number"==typeof u&&i<=u||"number"==typeof d&&i>=d||"number"==typeof l&&i<l||"number"==typeof p&&i>p)&&(r=!0);break;case"positive-integer":if(!(0,n.isInteger)(i)||i<=0)throw new Error(this.notPositive(s));break;case"tokenId":case"not-empty-string":(0,n.isString)(i)&&i.length||(r=!0);break;case"notEmptyObject":(0,n.isObject)(i)&&Object.keys(i).length||(r=!0);break;case"notEqual":if(a&&t[a[0]]===t[a[1]])throw new Error(this.notEqual(s));break;case"resource":["BANDWIDTH","ENERGY"].includes(i)||(r=!0);break;case"url":(0,n.isValidURL)(i)||(r=!0);break;case"hex":(0,n.isHex)(i)||(r=!0);break;case"array":Array.isArray(i)||(r=!0);break;case"boolean":(0,n.isBoolean)(i)||(r=!0);break;case"string":(!(0,n.isString)(i)||"number"==typeof u&&i.length<=u||"number"==typeof d&&i.length>=d||"number"==typeof l&&i.length<l||"number"==typeof p&&i.length>p)&&(r=!0)}if(r)throw new Error(this.invalid(s))}}return!1}}},5562:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TronWeb=void 0;const o=r(5584),n=r(4612),s=o.__importDefault(r(6219)),a=r(2860),i=o.__importDefault(r(1343)),c=o.__importDefault(r(8064)),u=r(2862),d=r(983),l=r(5884),p=r(8050),g=r(3569),f=r(9193),y=r(9055),b=r(3331),h="4.7.1";function T(e){return!(!e||"object"!=typeof e||!e.fullNode&&!e.fullHost)}class W extends i.default{providers;BigNumber;transactionBuilder;trx;plugin;event;version;static version="6.0.1";utils;defaultBlock;defaultPrivateKey;defaultAddress;fullnodeVersion;feeLimit;fullNode;solidityNode;eventServer;constructor(e,t="",r,o=""){let i;super();let c=!1,l=!1;T(e)?(i=e.fullNode||e.fullHost,t=e.solidityNode||e.fullHost,r=e.eventServer||e.fullHost,c=e.headers||!1,l=e.eventHeaders||c,o=e.privateKey):i=e,s.default.isString(i)&&(i=new n.providers.HttpProvider(i)),s.default.isString(t)&&(t=new n.providers.HttpProvider(t)),s.default.isString(r)&&(r=new n.providers.HttpProvider(r)),this.event=new g.Event(this),this.transactionBuilder=new u.TransactionBuilder(this),this.trx=new d.Trx(this),this.plugin=new p.Plugin(this,{disablePlugins:!!T(e)&&e.disablePlugins}),this.utils=s.default,this.setFullNode(i),this.setSolidityNode(t),this.setEventServer(r),this.providers=n.providers,this.BigNumber=a.BigNumber,this.defaultBlock=!1,this.defaultPrivateKey=!1,this.defaultAddress={hex:!1,base58:!1},this.version=W.version,this.sha3=W.sha3,this.fromUtf8=W.fromUtf8,this.address=W.address,this.toAscii=W.toAscii,this.toUtf8=W.toUtf8,this.isAddress=W.isAddress,this.fromAscii=W.fromAscii,this.toHex=W.toHex,this.toBigNumber=W.toBigNumber,this.toDecimal=W.toDecimal,this.fromDecimal=W.fromDecimal,this.toSun=W.toSun,this.fromSun=W.fromSun,this.createAccount=W.createAccount,this.createRandom=W.createRandom,this.fromMnemonic=W.fromMnemonic,o&&this.setPrivateKey(o),this.fullnodeVersion=h,this.feeLimit=15e7,c&&this.setFullNodeHeader(c),l&&this.setEventHeader(l)}async getFullnodeVersion(){try{const e=await this.trx.getNodeInfo();this.fullnodeVersion=e.configNodeInfo.codeVersion,2===this.fullnodeVersion.split(".").length&&(this.fullnodeVersion+=".0")}catch(e){this.fullnodeVersion=h}}setDefaultBlock(e=!1){if([!1,"latest","earliest",0].includes(e))return this.defaultBlock=e;if(!s.default.isInteger(e)||!e)throw new Error("Invalid block ID provided");return this.defaultBlock=Math.abs(e)}setPrivateKey(e){try{this.setAddress(W.address.fromPrivateKey(e))}catch{throw new Error("Invalid private key provided")}this.defaultPrivateKey=e,this.emit("privateKeyChanged",e)}setAddress(e){if(!W.isAddress(e))throw new Error("Invalid address provided");const t=W.address.toHex(e),r=W.address.fromHex(e);this.defaultPrivateKey&&W.address.fromPrivateKey(this.defaultPrivateKey)!==r&&(this.defaultPrivateKey=!1),this.defaultAddress={hex:t,base58:r},this.emit("addressChanged",{hex:t,base58:r})}fullnodeSatisfies(e){return c.default.satisfies(this.fullnodeVersion,e)}isValidProvider(e){return Object.values(n.providers).some((t=>e instanceof t))}setFullNode(e){if((0,b.isString)(e)&&(e=new n.providers.HttpProvider(e)),!this.isValidProvider(e))throw new Error("Invalid full node provided");this.fullNode=e,this.fullNode.setStatusPage("wallet/getnowblock")}setSolidityNode(e){if(s.default.isString(e)&&(e=new n.providers.HttpProvider(e)),!this.isValidProvider(e))throw new Error("Invalid solidity node provided");this.solidityNode=e,this.solidityNode.setStatusPage("walletsolidity/getnowblock")}setEventServer(e,t){this.event.setServer(e,t)}setHeader(e={}){const t=new n.providers.HttpProvider(this.fullNode.host,3e4,"","",e),r=new n.providers.HttpProvider(this.solidityNode.host,3e4,"","",e),o=new n.providers.HttpProvider(this.eventServer.host,3e4,"","",e);this.setFullNode(t),this.setSolidityNode(r),this.setEventServer(o)}setFullNodeHeader(e={}){const t=new n.providers.HttpProvider(this.fullNode.host,3e4,"","",e),r=new n.providers.HttpProvider(this.solidityNode.host,3e4,"","",e);this.setFullNode(t),this.setSolidityNode(r)}setEventHeader(e={}){const t=new n.providers.HttpProvider(this.eventServer.host,3e4,"","",e);this.setEventServer(t)}currentProviders(){return{fullNode:this.fullNode,solidityNode:this.solidityNode,eventServer:this.eventServer}}currentProvider(){return this.currentProviders()}getEventResult(...e){return this.event.getEventsByContractAddress(...e)}getEventByTransactionID(...e){return this.event.getEventsByTransactionID(...e)}contract(e=[],t){return new l.Contract(this,e,t)}address;static get address(){return{fromHex:e=>(0,y.fromHex)(e),toHex:e=>(0,y.toHex)(e),toChecksumAddress:e=>(0,y.toChecksumAddress)(e),isChecksumAddress:e=>(0,y.isChecksumAddress)(e),fromPrivateKey:(e,t=!1)=>(0,y.fromPrivateKey)(e,t)}}sha3;static sha3(e,t=!0){return(t?"0x":"")+(0,f.keccak256)(Buffer.from(e,"utf-8")).toString().substring(2)}toHex;static toHex(e){if(s.default.isBoolean(e))return W.fromDecimal(+e);if(s.default.isBigNumber(e))return W.fromDecimal(e);if("object"==typeof e)return W.fromUtf8(JSON.stringify(e));if(s.default.isString(e)){if(/^(-|)0x/.test(e))return e;if(!isFinite(e)||/^\s*$/.test(e))return W.fromUtf8(e)}const t=W.fromDecimal(e);if("0xNaN"===t)throw new Error("The passed value is not convertible to a hex string");return t}toUtf8;static toUtf8(e){if(s.default.isHex(e))return e=e.replace(/^0x/,""),Buffer.from(e,"hex").toString("utf8");throw new Error("The passed value is not a valid hex string")}fromUtf8;static fromUtf8(e){if(!s.default.isString(e))throw new Error("The passed value is not a valid utf-8 string");return"0x"+Buffer.from(e,"utf8").toString("hex")}toAscii;static toAscii(e){if(s.default.isHex(e)){let t="",r=0;const o=e.length;for("0x"===e.substring(0,2)&&(r=2);r<o;r+=2){const o=parseInt(e.substr(r,2),16);t+=String.fromCharCode(o)}return t}throw new Error("The passed value is not a valid hex string")}fromAscii;static fromAscii(e,t){if(!s.default.isString(e))throw new Error("The passed value is not a valid utf-8 string");return"0x"+Buffer.from(e,"ascii").toString("hex").padEnd(t,"0")}toDecimal;static toDecimal(e){return W.toBigNumber(e).toNumber()}fromDecimal;static fromDecimal(e){const t=W.toBigNumber(e),r=t.toString(16);return t.isLessThan(0)?"-0x"+r.substr(1):"0x"+r}fromSun;static fromSun(e){const t=W.toBigNumber(e).div(1e6);return s.default.isBigNumber(e)?t:t.toString(10)}toSun;static toSun(e){const t=W.toBigNumber(e).times(1e6);return s.default.isBigNumber(e)?t:t.toString(10)}toBigNumber;static toBigNumber(e=0){return s.default.isBigNumber(e)?e:s.default.isString(e)&&/^(-|)0x/.test(e)?new a.BigNumber(e.replace("0x",""),16):new a.BigNumber(e.toString(10),10)}isAddress;static isAddress(e=""){return(0,y.isAddress)(e)}createAccount;static async createAccount(){return s.default.accounts.generateAccount()}createRandom;static createRandom(...e){return s.default.accounts.generateRandom(...e)}fromMnemonic;static fromMnemonic(...e){return s.default.accounts.generateAccountWithMnemonic(...e)}async isConnected(){return{fullNode:await this.fullNode.isConnected(),solidityNode:await this.solidityNode.isConnected(),eventServer:this.eventServer&&await this.eventServer.isConnected()}}}t.TronWeb=W,t.default=W},5593:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},6416:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},705:(e,t)=>{"use strict";var r,o,n;Object.defineProperty(t,"__esModule",{value:!0}),t.AccountType=t.Permission_PermissionType=t.ContractType=void 0,function(e){e.AccountCreateContract="AccountCreateContract",e.TransferContract="TransferContract",e.TransferAssetContract="TransferAssetContract",e.VoteAssetContract="VoteAssetContract",e.VoteWitnessContract="VoteWitnessContract",e.WitnessCreateContract="WitnessCreateContract",e.AssetIssueContract="AssetIssueContract",e.WitnessUpdateContract="WitnessUpdateContract",e.ParticipateAssetIssueContract="ParticipateAssetIssueContract",e.AccountUpdateContract="AccountUpdateContract",e.FreezeBalanceContract="FreezeBalanceContract",e.UnfreezeBalanceContract="UnfreezeBalanceContract",e.CancelAllUnfreezeV2Contract="CancelAllUnfreezeV2Contract",e.WithdrawBalanceContract="WithdrawBalanceContract",e.UnfreezeAssetContract="UnfreezeAssetContract",e.UpdateAssetContract="UpdateAssetContract",e.ProposalCreateContract="ProposalCreateContract",e.ProposalApproveContract="ProposalApproveContract",e.ProposalDeleteContract="ProposalDeleteContract",e.SetAccountIdContract="SetAccountIdContract",e.CustomContract="CustomContract",e.CreateSmartContract="CreateSmartContract",e.TriggerSmartContract="TriggerSmartContract",e.GetContract="GetContract",e.UpdateSettingContract="UpdateSettingContract",e.ExchangeCreateContract="ExchangeCreateContract",e.ExchangeInjectContract="ExchangeInjectContract",e.ExchangeWithdrawContract="ExchangeWithdrawContract",e.ExchangeTransactionContract="ExchangeTransactionContract",e.UpdateEnergyLimitContract="UpdateEnergyLimitContract",e.AccountPermissionUpdateContract="AccountPermissionUpdateContract",e.ClearABIContract="ClearABIContract",e.UpdateBrokerageContract="UpdateBrokerageContract",e.ShieldedTransferContract="ShieldedTransferContract",e.MarketSellAssetContract="MarketSellAssetContract",e.MarketCancelOrderContract="MarketCancelOrderContract",e.FreezeBalanceV2Contract="FreezeBalanceV2Contract",e.UnfreezeBalanceV2Contract="UnfreezeBalanceV2Contract",e.WithdrawExpireUnfreezeContract="WithdrawExpireUnfreezeContract",e.DelegateResourceContract="DelegateResourceContract",e.UnDelegateResourceContract="UnDelegateResourceContract",e.UNRECOGNIZED="UNRECOGNIZED"}(r||(t.ContractType=r={})),function(e){e[e.Owner=0]="Owner",e[e.Witness=1]="Witness",e[e.Active=2]="Active",e[e.UNRECOGNIZED=-1]="UNRECOGNIZED"}(o||(t.Permission_PermissionType=o={})),function(e){e[e.Normal=0]="Normal",e[e.AssetIssue=1]="AssetIssue",e[e.Contract=2]="Contract",e[e.UNRECOGNIZED=-1]="UNRECOGNIZED"}(n||(t.AccountType=n={}))},3749:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},7431:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},312:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},804:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},1529:(e,t)=>{"use strict";var r,o,n,s;Object.defineProperty(t,"__esModule",{value:!0}),t.ResourceCode=void 0,function(e){e[e.BANDWIDTH=0]="BANDWIDTH",e[e.ENERGY=1]="ENERGY",e[e.TRON_POWER=2]="TRON_POWER"}(r||(t.ResourceCode=r={})),function(e){e.ENOUGH_PERMISSION="ENOUGH_PERMISSION",e.NOT_ENOUGH_PERMISSION="NOT_ENOUGH_PERMISSION",e.SIGNATURE_FORMAT_ERROR="SIGNATURE_FORMAT_ERROR",e.COMPUTE_ADDRESS_ERROR="COMPUTE_ADDRESS_ERROR",e.PERMISSION_ERROR="PERMISSION_ERROR",e.OTHER_ERROR="OTHER_ERROR"}(o||(o={})),function(e){e[e.SUCCESS=0]="SUCCESS",e[e.SIGERROR=1]="SIGERROR",e[e.CONTRACT_VALIDATE_ERROR=2]="CONTRACT_VALIDATE_ERROR",e[e.CONTRACT_EXE_ERROR=3]="CONTRACT_EXE_ERROR",e[e.BANDWITH_ERROR=4]="BANDWITH_ERROR",e[e.DUP_TRANSACTION_ERROR=5]="DUP_TRANSACTION_ERROR",e[e.TAPOS_ERROR=6]="TAPOS_ERROR",e[e.TOO_BIG_TRANSACTION_ERROR=7]="TOO_BIG_TRANSACTION_ERROR",e[e.TRANSACTION_EXPIRATION_ERROR=8]="TRANSACTION_EXPIRATION_ERROR",e[e.SERVER_BUSY=9]="SERVER_BUSY",e[e.NO_CONNECTION=10]="NO_CONNECTION",e[e.NOT_ENOUGH_EFFECTIVE_CONNECTION=11]="NOT_ENOUGH_EFFECTIVE_CONNECTION",e[e.OTHER_ERROR=20]="OTHER_ERROR"}(n||(n={})),function(e){e[e.PENDING=0]="PENDING",e[e.DISAPPROVED=1]="DISAPPROVED",e[e.APPROVED=2]="APPROVED",e[e.CANCELED=3]="CANCELED"}(s||(s={}))},9805:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},751:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=r(5584);o.__exportStar(r(5593),t),o.__exportStar(r(6416),t),o.__exportStar(r(705),t),o.__exportStar(r(3749),t),o.__exportStar(r(7431),t),o.__exportStar(r(312),t),o.__exportStar(r(804),t),o.__exportStar(r(1529),t),o.__exportStar(r(9805),t)},8557:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.decodeParams=function(e,t,r,o=!1){if(o&&r.replace(/^0x/,"").length%64==8&&(r="0x"+r.replace(/^0x/,"").substring(8)),r.replace(/^0x/,"").length%64)throw new Error("The encoded string is not valid. Its length must be a multiple of 64.");return t=t.map((e=>(/trcToken/.test(e)&&(e=e.replace(/trcToken/,"uint256")),e))),a.decode(t,r).reduce(((r,o,n)=>("address"==t[n]&&(o=s.ADDRESS_PREFIX+o.substr(2).toLowerCase()),e.length?r[e[n]]=o:r.push(o),r)),e.length?{}:[])},t.encodeParams=function(e,t){for(let r=0;r<e.length;r++)"address"===e[r]&&(t[r]=n.TronWeb.address.toHex(t[r]).replace(s.ADDRESS_PREFIX_REGEX,"0x"));return a.encode(e,t)},t.encodeParamsV2ByABI=function(e,t){const r=[],o=e=>e&&0===e.type.indexOf("tuple")&&e.components?`tuple(${e.components.map((e=>o(e))).join(",")})${c(e.type)}`:/trcToken/.test(e.type)?e.type.replace(/trcToken/,"uint256"):e.type,n=e=>Array.isArray(e)?(e.forEach(((t,r)=>{e[r]=n(t)})),e):i(e),s=(e,t,r)=>{r>1?t.length&&t.forEach((t=>{s(e,t,r-1)})):t.length&&r&&t.forEach((t=>{d(e,t)}))},d=(e=[],t)=>{e.length&&e.forEach(((e,r)=>{const o=e.type;if(t[r])if("address"===o)t[r]=i(t[r]);else if("address["===o.match(/^([^\x5b]*)(\x5b|$)/)[0])n(t[r]);else if(0===o.indexOf("tuple"))if(c(o)){const n=u(o);s(e.components,t[r],n)}else d(e.components,t[r])}))};if(e.inputs&&e.inputs.length)for(let n=0;n<e.inputs.length;n++){const s=e.inputs[n].type;"bool"===s&&"false"===t[n]&&(t[n]=!1),r.push(0===s.indexOf("tuple")?o(e.inputs[n]):s),t.length<r.length&&t.push("")}return d(e.inputs,t),(e=>{for(let t=0;t<e.length;t++){const r=e[t];/trcToken/.test(r)&&(e[t]=r.replace(/trcToken/,"uint256"))}})(r),a.encode(r,t)},t.decodeParamsV2ByABI=function(e,t){const r=e=>Array.isArray(e)?(e.forEach(((t,o)=>{e[o]=r(t)})),e):n.TronWeb.address.toHex(e),o=(e,t,r)=>{r>1?t.length&&t.forEach((t=>{o(e,t,r-1)})):t.length&&r&&t.forEach((t=>{i(e,t)}))},s=e=>{const t=e.name?` ${e.name}`:"";return e&&0===e.type.indexOf("tuple")&&e.components?`tuple(${e.components.map((e=>s(e))).join(",")})${c(e.type)}${t}`:/trcToken/.test(e.type)?e.type.replace(/trcToken/,"uint256")+t:e.type+t},i=(e,t)=>{e.length&&e.forEach(((e,s)=>{const{type:a,name:d}=e;if(t[s])if("address"===a)t[s]=n.TronWeb.address.toHex(t[s]),d&&(t[d]=n.TronWeb.address.toHex(t[s]));else if("address["===a.match(/^([^\x5b]*)(\x5b|$)/)[0])r(t[s]),d&&(t[d]=r(t[s]));else if(0===a.indexOf("tuple")){if(c(a)){const r=u(a);o(e.components,t[s],r)}else i(e.components,t[s]);d&&(t[d]=t[s])}else d&&(t[d]=t[s]);else d&&(t[d]=t[s])}))};if("outputs"in e&&e.outputs&&e.outputs.length>0){const r=[];for(let t=0;t<e.outputs.length;t++){const o=e.outputs[t].type,n=e.outputs[t].name?` ${e.outputs[t].name}`:"";r.push(0===o.indexOf("tuple")?s(e.outputs[t]):o+n)}(e=>{for(let t=0;t<e.length;t++){const r=e[t];/^trcToken/.test(r)&&(e[t]=r.replace(/^trcToken/,"uint256"))}})(r),t&&t.length||(t=new Uint8Array(32*e.outputs.length));const o=a.decode(r,t).toArray(!0);return i(e.outputs,o),o}return[]};const o=r(9193),n=r(5562),s=r(9055),a=new o.AbiCoder;function i(e){return n.TronWeb.address.toHex(e).replace(s.ADDRESS_PREFIX_REGEX,"0x")}function c(e){const t=e.match(/([a-zA-Z0-9])(\[.*\])/);return t?t[2]:""}function u(e){return(c(e).match(/\]\[/g)||[]).length+1}},2079:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.generateAccount=function(){const e=(0,n.genPriKey)(),t=(0,n.getPubKeyFromPriKey)(e),r=(0,n.getAddressFromPriKey)(e);return{privateKey:(0,o.byteArray2hexStr)(e),publicKey:(0,o.byteArray2hexStr)(t),address:{base58:(0,n.getBase58CheckAddress)(r),hex:(0,o.byteArray2hexStr)(r)}}},t.generateRandom=function(e="",t=a.TRON_BIP39_PATH_INDEX_0,r){const o=s.ethersHDNodeWallet.createRandom(e,t,r);return{mnemonic:o.mnemonic,privateKey:o.privateKey,publicKey:o.signingKey.publicKey,address:(0,n.pkToAddress)(o.privateKey.replace(/^0x/,"")),path:o.path}},t.generateAccountWithMnemonic=function(e,t=a.TRON_BIP39_PATH_INDEX_0,r="",o=null){if(!String(t).match(/^m\/44\'\/195\'/))throw new Error(i);const c=s.ethersHDNodeWallet.fromMnemonic(s.Mnemonic.fromPhrase(e,r,o),t);return{mnemonic:c.mnemonic,privateKey:c.privateKey,publicKey:c.signingKey.publicKey,address:(0,n.pkToAddress)(c.privateKey.replace(/^0x/,""))}};const o=r(9436),n=r(7154),s=r(9193),a=r(9055),i="Invalid tron path provided"},9055:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TRON_BIP39_PATH_INDEX_0=t.TRON_BIP39_PATH_PREFIX=t.ADDRESS_PREFIX_REGEX=t.ADDRESS_PREFIX_BYTE=t.ADDRESS_PREFIX=t.ADDRESS_SIZE=void 0,t.fromHex=function(e){return(0,s.isHex)(e)?(0,n.getBase58CheckAddress)((0,o.hexStr2byteArray)(e.replace(/^0x/,t.ADDRESS_PREFIX))):e},t.toHex=i,t.toChecksumAddress=c,t.isChecksumAddress=function(e){if(!(0,s.isHex)(e)||42!==e.length)return!1;try{return c(e)===e}catch{return!1}},t.fromPrivateKey=function(e,t=!1){try{return(0,n.pkToAddress)(e,t)}catch{return!1}},t.isAddress=u;const o=r(9690),n=r(7154),s=r(3331),a=r(9193);function i(e){return(0,s.isHex)(e)?e.toLowerCase().replace(/^0x/,t.ADDRESS_PREFIX):(0,o.byteArray2hexStr)((0,n.decodeBase58Address)(e)).toLowerCase()}function c(e){if(!u(e))throw new Error(`'${e}' is not a valid address string`);return function(e){const r=(e=e.toLowerCase()).substring(2).split(""),n=new Uint8Array(40);for(let e=0;e<40;e++)n[e]=r[e].charCodeAt(0);const s=(0,o.hexStr2byteArray)((0,a.keccak256)(n).slice(2));for(let e=0;e<40;e+=2)s[e>>1]>>4>=8&&(r[e]=r[e].toUpperCase()),(15&s[e>>1])>=8&&(r[e+1]=r[e+1].toUpperCase());return t.ADDRESS_PREFIX+r.join("")}(i(e))}function u(e){if(!e||!(0,s.isString)(e))return!1;if(42===e.length)try{return u((0,n.getBase58CheckAddress)((0,o.hexStr2byteArray)(e)))}catch(e){return!1}try{return(0,n.isAddressValid)(e)}catch(e){return!1}}t.ADDRESS_SIZE=34,t.ADDRESS_PREFIX="41",t.ADDRESS_PREFIX_BYTE=65,t.ADDRESS_PREFIX_REGEX=/^(41)/,t.TRON_BIP39_PATH_PREFIX="m/44'/195'",t.TRON_BIP39_PATH_INDEX_0=t.TRON_BIP39_PATH_PREFIX+"/0'/0/0"},183:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.encode58=function(e){if(0===e.length)return"";let t,o;const s=[0];for(t=0;t<e.length;t++){for(o=0;o<s.length;o++)s[o]<<=8;s[0]+=e[t];let r=0;for(o=0;o<s.length;++o)s[o]+=r,r=s[o]/n|0,s[o]%=n;for(;r;)s.push(r%n),r=r/n|0}for(t=0;0===e[t]&&t<e.length-1;t++)s.push(0);return s.reverse().map((e=>r[e])).join("")},t.decode58=function(e){if(0===e.length)return[];let t,r;const s=[0];for(t=0;t<e.length;t++){const a=e[t];if(!(a in o))throw new Error("Non-base58 character");for(r=0;r<s.length;r++)s[r]*=n;s[0]+=o[a];let i=0;for(r=0;r<s.length;++r)s[r]+=i,i=s[r]>>8,s[r]&=255;for(;i;)s.push(255&i),i>>=8}for(t=0;"1"===e[t]&&t<e.length-1;t++)s.push(0);return s.reverse()};const r="123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz",o={};for(let e=0;e<r.length;e++)o[r.charAt(e)]=e;const n=58},5720:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Base64=void 0;const r="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";t.Base64=class{encode(e){let t,o,n,s,a,i,c,u="",d=0;for(;d<e.length;)t=e.charCodeAt(d++),o=e.charCodeAt(d++),n=e.charCodeAt(d++),s=t>>2,a=(3&t)<<4|o>>4,i=(15&o)<<2|n>>6,c=63&n,isNaN(o)?i=c=64:isNaN(n)&&(c=64),u=u+r.charAt(s)+r.charAt(a)+r.charAt(i)+r.charAt(c);return u}encodeIgnoreUtf8(e){let t,o,n,s,a,i,c,u="",d=0;for(;d<e.length;)t=e[d++],o=e[d++],n=e[d++],s=t>>2,a=(3&t)<<4|o>>4,i=(15&o)<<2|n>>6,c=63&n,isNaN(o)?i=c=64:isNaN(n)&&(c=64),u=u+r.charAt(s)+r.charAt(a)+r.charAt(i)+r.charAt(c);return u}decode(e){let t,o,n,s,a,i,c,u="",d=0;for(e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"");d<e.length;)s=r.indexOf(e.charAt(d++)),a=r.indexOf(e.charAt(d++)),i=r.indexOf(e.charAt(d++)),c=r.indexOf(e.charAt(d++)),t=s<<2|a>>4,o=(15&a)<<4|i>>2,n=(3&i)<<6|c,u+=String.fromCharCode(t),64!=i&&(u+=String.fromCharCode(o)),64!=c&&(u+=String.fromCharCode(n));return this._utf8_decode(u)}decodeToByteArray(e){let t,o,n,s,a,i,c,u="",d=0;for(e=e.replace(/[^A-Za-z0-9\+\/\=]/g,"");d<e.length;)s=r.indexOf(e.charAt(d++)),a=r.indexOf(e.charAt(d++)),i=r.indexOf(e.charAt(d++)),c=r.indexOf(e.charAt(d++)),t=s<<2|a>>4,o=(15&a)<<4|i>>2,n=(3&i)<<6|c,u+=String.fromCharCode(t),64!=i&&(u+=String.fromCharCode(o)),64!=c&&(u+=String.fromCharCode(n));return this._out2ByteArray(u)}_out2ByteArray(e){const t=new Array(e.length);let r=0,o=0;for(;r<e.length;)o=e.charCodeAt(r),t[r]=o,r++;return t}_utf8_encode(e){e=e.replace(/\r\n/g,"\n");let t="";for(let r=0;r<e.length;r++){const o=e.charCodeAt(r);o<128?t+=String.fromCharCode(o):o>127&&o<2048?(t+=String.fromCharCode(o>>6|192),t+=String.fromCharCode(63&o|128)):(t+=String.fromCharCode(o>>12|224),t+=String.fromCharCode(o>>6&63|128),t+=String.fromCharCode(63&o|128))}return t}_utf8_decode(e){let t="",r=0,o=0,n=0,s=0;for(;r<e.length;)o=e.charCodeAt(r),o<128?(t+=String.fromCharCode(o),r++):o>191&&o<224?(n=e.charCodeAt(r+1),t+=String.fromCharCode((31&o)<<6|63&n),r+=2):(n=e.charCodeAt(r+1),s=e.charCodeAt(r+2),t+=String.fromCharCode((15&o)<<12|(63&n)<<6|63&s),r+=3);return t}}},9436:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.byte2hexStr=n,t.bytesToString=function(e){let t="";for(let r=0;r<e.length;r++){const o=e[r].toString(2),n=o.match(/^1+?(?=0)/);if(n&&8===o.length){const o=n[0].length;let s=e[r].toString(2).slice(7-o);for(let t=1;t<o;t++)s+=e[t+r].toString(2).slice(2);t+=String.fromCharCode(parseInt(s,2)),r+=o-1}else t+=String.fromCharCode(e[r])}return t},t.hextoString=function(e){const t=e.replace(/^0x/,"").split("");let r="";for(let e=0;e<t.length/2;e++){const o=`0x${t[2*e]}${t[2*e+1]}`;r+=String.fromCharCode(parseInt(o))}return r},t.byteArray2hexStr=function(e){let t="";for(let r=0;r<e.length;r++)t+=n(e[r]);return t},t.base64DecodeFromString=function(e){return(new o.Base64).decodeToByteArray(e)},t.base64EncodeToString=function(e){return(new o.Base64).encodeIgnoreUtf8(e)};const o=r(5720);function n(e){if(e<0||e>255)throw new Error("Input must be a byte");const t="0123456789ABCDEF";let r="";return r+=t.charAt(e>>4),r+=t.charAt(15&e),r}},9690:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.base64EncodeToString=t.base64DecodeFromString=t.byteArray2hexStr=t.hextoString=t.bytesToString=t.byte2hexStr=void 0,t.bin2String=function(e){return(0,o.bytesToString)(e)},t.arrayEquals=function(e,t,r=!1){if(e.length!=t.length)return!1;for(let o=0;o<e.length;o++)if(r){if(e[o]!=t[o])return!1}else if(JSON.stringify(e[o])!=JSON.stringify(t[o]))return!1;return!0},t.stringToBytes=function(e){const t=[],r=e.length;let o;for(let n=0;n<r;n++)o=e.charCodeAt(n),o>=65536&&o<=1114111?(t.push(o>>18&7|240),t.push(o>>12&63|128),t.push(o>>6&63|128),t.push(63&o|128)):o>=2048&&o<=65535?(t.push(o>>12&15|224),t.push(o>>6&63|128),t.push(63&o|128)):o>=128&&o<=2047?(t.push(o>>6&31|192),t.push(63&o|128)):t.push(255&o);return t},t.hexChar2byte=n,t.isHexChar=s,t.hexStr2byteArray=function(e,t=!1){let r=e.length;t&&r%2&&(e=`0${e}`,r++);const o=[];let a=0,i=0,c=0;for(let t=0;t<r;t++){const r=e.charAt(t);if(!s(r))throw new Error("The passed hex char is not a valid hex string");a<<=4,a+=n(r),i++,0==i%2&&(o[c++]=a,a=0)}return o},t.strToDate=function(e){if(!/^\d{4}-\d{2}-\d{2}( \d{2}-\d{2}-\d{2}|)/.test(e))throw new Error("The passed date string is not valid");const t=e.split(" "),r=t[0].split("-"),o=parseInt(r[0],10),n=parseInt(r[1],10)-1,s=parseInt(r[2],10);if(t.length>1){const e=t[1].split("-"),r=parseInt(e[0],10),a=parseInt(e[1],10),i=parseInt(e[2],10);return new Date(o,n,s,r,a,i)}return new Date(o,n,s)},t.isNumber=a,t.getStringType=function(e){if(null==e)return-1;if(0==e.length||""==e)return-1;let t=0;if(40==e.length)for(;t<40&&s(e.charAt(t));t++);if(40==t)return 1;for(t=0;t<e.length&&a(e.charAt(t));t++);if(t==e.length)return 2;for(t=0;t<e.length;t++)if(e.charAt(t)>" ")return 3;return-1};const o=r(9436);function n(e){let t;if(e>="A"&&e<="F"?t=e.charCodeAt(0)-"A".charCodeAt(0)+10:e>="a"&&e<="f"?t=e.charCodeAt(0)-"a".charCodeAt(0)+10:e>="0"&&e<="9"&&(t=e.charCodeAt(0)-"0".charCodeAt(0)),"number"==typeof t)return t;throw new Error("The passed hex char is not a valid hex char")}function s(e){return e>="A"&&e<="F"||e>="a"&&e<="f"||e>="0"&&e<="9"?1:0}function a(e){return e>="0"&&e<="9"?1:0}Object.defineProperty(t,"byte2hexStr",{enumerable:!0,get:function(){return o.byte2hexStr}}),Object.defineProperty(t,"bytesToString",{enumerable:!0,get:function(){return o.bytesToString}}),Object.defineProperty(t,"hextoString",{enumerable:!0,get:function(){return o.hextoString}}),Object.defineProperty(t,"byteArray2hexStr",{enumerable:!0,get:function(){return o.byteArray2hexStr}}),Object.defineProperty(t,"base64DecodeFromString",{enumerable:!0,get:function(){return o.base64DecodeFromString}}),Object.defineProperty(t,"base64EncodeToString",{enumerable:!0,get:function(){return o.base64EncodeToString}})},7154:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getBase58CheckAddress=d,t.decodeBase58Address=function(e){if("string"!=typeof e)return!1;if(e.length<=4)return!1;let t=(0,s.decode58)(e);if(e.length<=4)return!1;const r=t.length-4,o=t.slice(r);t=t.slice(0,r);const n=y(t),a=y(n).slice(0,4);if(o[0]==a[0]&&o[1]==a[1]&&o[2]==a[2]&&o[3]==a[3])return t;throw new Error("Invalid address provided")},t.signTransaction=function(e,t){"string"==typeof e&&(e=(0,n.hexStr2byteArray)(e));const r=t.txID,o=f((0,n.hexStr2byteArray)(r),e);return Array.isArray(t.signature)?t.signature.includes(o)||t.signature.push(o):t.signature=[o],t},t.ecRecover=function(e,t){e="0x"+e.replace(/^0x/,""),t="0x"+t.replace(/^0x/,"");const r=(0,i.recoverAddress)((0,i.arrayify)(e),i.Signature.from(t));return o.ADDRESS_PREFIX+r.substring(2)},t.arrayToBase64String=function(e){return btoa(String.fromCharCode(...e))},t.signBytes=function(e,t){"string"==typeof e&&(e=(0,n.hexStr2byteArray)(e));return f(y(t),e)},t._signTypedData=function(e,t,r,o){const n=`0x${o.replace(/^0x/,"")}`,s=new i.SigningKey(n),a=c.TypedDataEncoder.hash(e,t,r),u=s.sign(a);return["0x",u.r.substring(2),u.s.substring(2),Number(u.v).toString(16)].join("")},t.getRowBytesFromTransactionBase64=function(e){const t=(0,n.base64DecodeFromString)(e);return globalThis.proto.protocol.Transaction.deserializeBinary(t).getRawData().serializeBinary()},t.genPriKey=function(){const e=u.secp256k1.utils.randomPrivateKey();let t=(0,a.byteArray2hexStr)(e);return t=t.padStart(64,"0"),(0,n.hexStr2byteArray)(t)},t.computeAddress=l,t.getAddressFromPriKey=p,t.decode58Check=function(e){const t=(0,s.decode58)(e);if(t.length<=4)return!1;const r=t.slice(0,t.length-4),o=y(r),n=y(o);return n[0]===t[r.length]&&n[1]===t[r.length+1]&&n[2]===t[r.length+2]&&n[3]===t[r.length+3]&&r},t.isAddressValid=function(e){if("string"!=typeof e)return!1;if(e.length!==o.ADDRESS_SIZE)return!1;let t=(0,s.decode58)(e);if(25!==t.length)return!1;if(t[0]!==o.ADDRESS_PREFIX_BYTE)return!1;const r=t.slice(21);t=t.slice(0,21);const n=y(t),a=y(n).slice(0,4);return r[0]==a[0]&&r[1]==a[1]&&r[2]==a[2]&&r[3]==a[3]},t.getBase58CheckAddressFromPriKeyBase64String=function(e){return d(l(g((0,n.base64DecodeFromString)(e))))},t.getHexStrAddressFromPriKeyBase64String=function(e){const t=l(g((0,n.base64DecodeFromString)(e)));return(0,a.byteArray2hexStr)(t)},t.getAddressFromPriKeyBase64String=function(e){const t=l(g((0,n.base64DecodeFromString)(e)));return(0,n.base64EncodeToString)(t)},t.getPubKeyFromPriKey=g,t.ECKeySign=f,t.SHA256=y,t.passwordToAddress=function(e){return d(p((0,n.base64DecodeFromString)(e)))},t.pkToAddress=function(e,t=!1){return d(p((0,n.hexStr2byteArray)(e,t)))},t.sha3=function(e,t=!0){return(t?"0x":"")+(0,i.keccak256)(Buffer.from(e,"utf-8")).toString().substring(2)};const o=r(9055),n=r(9690),s=r(183),a=r(9436),i=r(9193),c=r(4903),u=r(3277);function d(e){const t=y(e);let r=y(t).slice(0,4);return r=e.concat(r),(0,s.encode58)(r)}function l(e){65===e.length&&(e=e.slice(1));const t=(0,i.keccak256)(new Uint8Array(e)).toString().substring(2),r=o.ADDRESS_PREFIX+t.substring(24);return(0,n.hexStr2byteArray)(r)}function p(e){return l(g(e))}function g(e){const t=u.secp256k1.ProjectivePoint.fromPrivateKey(new Uint8Array(function(e){return(0,n.hexStr2byteArray)((0,a.byteArray2hexStr)(e).padStart(64,"0"))}(e))),r=t.x,o=t.y,s=`04${r.toString(16).padStart(64,"0")}${o.toString(16).padStart(64,"0")}`;return(0,n.hexStr2byteArray)(s)}function f(e,t){const r=u.secp256k1.sign((0,a.byteArray2hexStr)(e),(0,a.byteArray2hexStr)(t)),o=r.r.toString(16),n=r.s.toString(16),s=r.recovery+27;return o.padStart(64,"0")+n.padStart(64,"0")+(0,a.byte2hexStr)(s)}function y(e){const t=(0,a.byteArray2hexStr)(e),r=(0,i.sha256)("0x"+t).replace(/^0x/,"");return(0,n.hexStr2byteArray)(r)}},9193:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.isValidMnemonic=t.wordlists=t.Wordlist=t.Mnemonic=t.id=t.concat=t.ethersHDNodeWallet=t.arrayify=t.joinSignature=t.splitSignature=t.FormatTypes=t.Interface=t.AbiCoder=t.SigningKey=t.Signature=t.recoverAddress=t.toUtf8String=t.toUtf8Bytes=t.sha256=t.keccak256=void 0;const o=r(9321);Object.defineProperty(t,"keccak256",{enumerable:!0,get:function(){return o.keccak256}}),Object.defineProperty(t,"sha256",{enumerable:!0,get:function(){return o.sha256}}),Object.defineProperty(t,"toUtf8Bytes",{enumerable:!0,get:function(){return o.toUtf8Bytes}}),Object.defineProperty(t,"toUtf8String",{enumerable:!0,get:function(){return o.toUtf8String}}),Object.defineProperty(t,"recoverAddress",{enumerable:!0,get:function(){return o.recoverAddress}}),Object.defineProperty(t,"SigningKey",{enumerable:!0,get:function(){return o.SigningKey}}),Object.defineProperty(t,"AbiCoder",{enumerable:!0,get:function(){return o.AbiCoder}}),Object.defineProperty(t,"Signature",{enumerable:!0,get:function(){return o.Signature}}),Object.defineProperty(t,"concat",{enumerable:!0,get:function(){return o.concat}}),Object.defineProperty(t,"id",{enumerable:!0,get:function(){return o.id}}),Object.defineProperty(t,"Mnemonic",{enumerable:!0,get:function(){return o.Mnemonic}}),Object.defineProperty(t,"Wordlist",{enumerable:!0,get:function(){return o.Wordlist}}),Object.defineProperty(t,"wordlists",{enumerable:!0,get:function(){return o.wordlists}}),Object.defineProperty(t,"ethersHDNodeWallet",{enumerable:!0,get:function(){return o.HDNodeWallet}});const n=r(7100);Object.defineProperty(t,"Interface",{enumerable:!0,get:function(){return n.Interface}}),t.splitSignature=e=>o.Signature.from(e),t.joinSignature=e=>o.Signature.from(e).serialized,t.arrayify=e=>(0,o.getBytes)(e),t.FormatTypes={sighash:"sighash",minimal:"minimal",full:"full",json:"json"};const s=o.Mnemonic.isValidMnemonic;t.isValidMnemonic=s,o.computeHmac.register(((e,t,r)=>o.computeHmac._(e,Buffer.from(t),Buffer.from(r))))},6606:(e,t,r)=>{"use strict";var o;Object.defineProperty(t,"__esModule",{value:!0}),t.StructFragment=t.FunctionFragment=t.FallbackFragment=t.ConstructorFragment=t.EventFragment=t.ErrorFragment=t.NamedFragment=t.Fragment=t.ParamType=void 0;const n=r(9321),s=r(9321);function a(e){const t=new Set;return e.forEach((e=>t.add(e))),Object.freeze(t)}const i="constant external internal payable private public pure view",c=a(i.split(" ")),u="constructor error event fallback function receive struct",d=a(u.split(" ")),l="calldata memory storage payable indexed",p=a(l.split(" ")),g=a([u,l,"tuple returns",i].join(" ").split(" ")),f={"(":"OPEN_PAREN",")":"CLOSE_PAREN","[":"OPEN_BRACKET","]":"CLOSE_BRACKET",",":"COMMA","@":"AT"},y=new RegExp("^(\\s*)"),b=new RegExp("^([0-9]+)"),h=new RegExp("^([a-zA-Z$_][a-zA-Z0-9$_]*)"),T=new RegExp("^([a-zA-Z$_][a-zA-Z0-9$_]*)$"),W=new RegExp("^(trcToken|address|bool|bytes([0-9]*)|string|u?int([0-9]*))$");class P{#e;#t;get offset(){return this.#e}get length(){return this.#t.length-this.#e}constructor(e){this.#e=0,this.#t=e.slice()}clone(){return new o(this.#t)}reset(){this.#e=0}#r(e=0,t=0){return new o(this.#t.slice(e,t).map((t=>Object.freeze(Object.assign({},t,{match:t.match-e,linkBack:t.linkBack-e,linkNext:t.linkNext-e})))))}popKeyword(e){const t=this.peek();if("KEYWORD"!==t.type||!e.has(t.text))throw new Error(`expected keyword ${t.text}`);return this.pop().text}popType(e){if(this.peek().type!==e)throw new Error(`expected ${e}; got ${JSON.stringify(this.peek())}`);return this.pop().text}popParen(){const e=this.peek();if("OPEN_PAREN"!==e.type)throw new Error("bad start");const t=this.#r(this.#e+1,e.match+1);return this.#e=e.match+1,t}popParams(){const e=this.peek();if("OPEN_PAREN"!==e.type)throw new Error("bad start");const t=[];for(;this.#e<e.match-1;){const e=this.peek().linkNext;t.push(this.#r(this.#e+1,e)),this.#e=e}return this.#e=e.match+1,t}peek(){if(this.#e>=this.#t.length)throw new Error("out-of-bounds");return this.#t[this.#e]}peekKeyword(e){const t=this.peekType("KEYWORD");return null!=t&&e.has(t)?t:null}peekType(e){if(0===this.length)return null;const t=this.peek();return t.type===e?t.text:null}pop(){const e=this.peek();return this.#e++,e}toString(){const e=[];for(let t=this.#e;t<this.#t.length;t++){const r=this.#t[t];e.push(`${r.type}:${r.text}`)}return`<TokenString ${e.join(" ")}>`}}function m(e){const t=[],r=t=>{const r=a<e.length?JSON.stringify(e[a]):"$EOI";throw new Error(`invalid token ${r} at ${a}: ${t}`)},o=[],s=[];let a=0;for(;a<e.length;){let i=e.substring(a),c=i.match(y);c&&(a+=c[1].length,i=e.substring(a));const u={depth:o.length,linkBack:-1,linkNext:-1,match:-1,type:"",text:"",offset:a,value:-1};t.push(u);const d=f[i[0]]||"";if(d){if(u.type=d,u.text=i[0],a++,"OPEN_PAREN"===d)o.push(t.length-1),s.push(t.length-1);else if("CLOSE_PAREN"==d)0===o.length&&r("no matching open bracket"),u.match=o.pop(),t[u.match].match=t.length-1,u.depth--,u.linkBack=s.pop(),t[u.linkBack].linkNext=t.length-1;else if("COMMA"===d)u.linkBack=s.pop(),t[u.linkBack].linkNext=t.length-1,s.push(t.length-1);else if("OPEN_BRACKET"===d)u.type="BRACKET";else if("CLOSE_BRACKET"===d){let e=t.pop().text;if(t.length>0&&"NUMBER"===t[t.length-1].type){const r=t.pop().text;e=r+e,t[t.length-1].value=(0,n.getNumber)(r)}if(0===t.length||"BRACKET"!==t[t.length-1].type)throw new Error("missing opening bracket");t[t.length-1].text+=e}}else if(c=i.match(h),c){if(u.text=c[1],a+=u.text.length,g.has(u.text)){u.type="KEYWORD";continue}if(u.text.match(W)){u.type="TYPE";continue}u.type="ID"}else{if(c=i.match(b),!c)throw new Error(`unexpected token ${JSON.stringify(i[0])} at position ${a}`);u.text=c[1],u.type="NUMBER",a+=u.text.length}}return new P(t.map((e=>Object.freeze(e))))}function A(e,t){const r=[];for(const o in t.keys())e.has(o)&&r.push(o);if(r.length>1)throw new Error(`conflicting types: ${r.join(", ")}`)}function B(e,t){if(t.peekKeyword(d)){const r=t.pop().text;if(r!==e)throw new Error(`expected ${e}, got ${r}`)}return t.popType("ID")}function C(e,t){const r=new Set;for(;;){const o=e.peekType("KEYWORD");if(null==o||t&&!t.has(o))break;if(e.pop(),r.has(o))throw new Error(`duplicate keywords: ${JSON.stringify(o)}`);r.add(o)}return Object.freeze(r)}function w(e){const t=C(e,c);return A(t,a("constant payable nonpayable".split(" "))),A(t,a("pure view payable nonpayable".split(" "))),t.has("view")?"view":t.has("pure")?"pure":t.has("payable")?"payable":t.has("nonpayable")?"nonpayable":t.has("constant")?"view":"nonpayable"}function E(e,t){return e.popParams().map((e=>N.from(e,t)))}function I(e){if(e.peekType("AT")){if(e.pop(),e.peekType("NUMBER"))return(0,n.getBigInt)(e.pop().text);throw new Error("invalid gas")}return null}function F(e){if(e.length)throw new Error(`unexpected tokens: ${e.toString()}`)}o=P;const M=new RegExp(/^(.*)\[([0-9]*)\]$/);function v(e){const t=e.match(W);if((0,n.assertArgument)(t,"invalid type","type",e),"uint"===e)return"uint256";if("int"===e)return"int256";if(t[2]){const r=parseInt(t[2]);(0,n.assertArgument)(0!==r&&r<=32,"invalid bytes length","type",e)}else if(t[3]){const r=parseInt(t[3]);(0,n.assertArgument)(0!==r&&r<=256&&r%8==0,"invalid numeric width","type",e)}return e}const O={},_=Symbol.for("_ethers_internal"),R="_ParamTypeInternal",S="_ErrorInternal",k="_EventInternal",D="_ConstructorInternal",x="_FallbackInternal",U="_FunctionInternal",z="_StructInternal";class N{name;type;baseType;indexed;components;arrayLength;arrayChildren;constructor(e,t,r,o,s,a,i,c){if((0,n.assertPrivate)(e,O,"ParamType"),Object.defineProperty(this,_,{value:R}),a&&(a=Object.freeze(a.slice())),"array"===o){if(null==i||null==c)throw new Error("")}else if(null!=i||null!=c)throw new Error("");if("tuple"===o){if(null==a)throw new Error("")}else if(null!=a)throw new Error("");(0,n.defineProperties)(this,{name:t,type:r,baseType:o,indexed:s,components:a,arrayLength:i,arrayChildren:c})}format(e){if(null==e&&(e="sighash"),"json"===e){const t={type:"tuple"===this.baseType?"tuple":this.type,name:this.name||void 0};return"boolean"==typeof this.indexed&&(t.indexed=this.indexed),this.isTuple()&&(t.components=this.components.map((t=>JSON.parse(t.format(e))))),JSON.stringify(t)}let t="";return this.isArray()?(t+=this.arrayChildren.format(e),t+=`[${this.arrayLength<0?"":String(this.arrayLength)}]`):this.isTuple()?("sighash"!==e&&(t+=this.type),t+="("+this.components.map((t=>t.format(e))).join("full"===e?", ":",")+")"):t+=this.type,"sighash"!==e&&(!0===this.indexed&&(t+=" indexed"),"full"===e&&this.name&&(t+=" "+this.name)),t}isArray(){return"array"===this.baseType}isTuple(){return"tuple"===this.baseType}isIndexable(){return null!=this.indexed}walk(e,t){if(this.isArray()){if(!Array.isArray(e))throw new Error("invalid array value");if(-1!==this.arrayLength&&e.length!==this.arrayLength)throw new Error("array is wrong length");return e.map((e=>this.arrayChildren?.walk(e,t)))}if(this.isTuple()){if(!Array.isArray(e))throw new Error("invalid tuple value");if(e.length!==this.components.length)throw new Error("array is wrong length");return e.map(((e,r)=>this.components?.[r].walk(e,t)))}return t(this.type,e)}#o(e,t,r,o){if(this.isArray()){if(!Array.isArray(t))throw new Error("invalid array value");if(-1!==this.arrayLength&&t.length!==this.arrayLength)throw new Error("array is wrong length");const n=this.arrayChildren,s=t.slice();return s.forEach(((t,o)=>{n.#o(e,t,r,(e=>{s[o]=e}))})),void o(s)}if(this.isTuple()){const n=this.components;let s;if(Array.isArray(t))s=t.slice();else{if(null==t||"object"!=typeof t)throw new Error("invalid tuple value");s=n.map((e=>{if(!e.name)throw new Error("cannot use object value with unnamed components");if(!(e.name in t))throw new Error(`missing value for component ${e.name}`);return t[e.name]}))}if(s.length!==this.components.length)throw new Error("array is wrong length");return s.forEach(((t,o)=>{n[o].#o(e,t,r,(e=>{s[o]=e}))})),void o(s)}const n=r(this.type,t);n.then?e.push(async function(){o(await n)}()):o(n)}async walkAsync(e,t){const r=[],o=[e];return this.#o(r,e,t,(e=>{o[0]=e})),r.length&&await Promise.all(r),o[0]}static from(e,t){if(N.isParamType(e))return e;if("string"==typeof e)return N.from(m(e),t);if(e instanceof P){let r="",o="",n=null;C(e,a(["tuple"])).has("tuple")||e.peekType("OPEN_PAREN")?(o="tuple",n=e.popParams().map((e=>N.from(e))),r=`tuple(${n.map((e=>e.format())).join(",")})`):(r=v(e.popType("TYPE")),o=r);let s=null,i=null;for(;e.length&&e.peekType("BRACKET");){const t=e.pop();s=new N(O,"",r,o,null,n,i,s),i=t.value,r+=t.text,o="array",n=null}let c=null;if(C(e,p).has("indexed")){if(!t)throw new Error("");c=!0}const u=e.peekType("ID")?e.pop().text:"";if(e.length)throw new Error("leftover tokens");return new N(O,u,r,o,c,n,i,s)}const r=e.name;(0,n.assertArgument)(!r||"string"==typeof r&&r.match(T),"invalid name","obj.name",r);let o=e.indexed;null!=o&&((0,n.assertArgument)(t,"parameter cannot be indexed","obj.indexed",e.indexed),o=!!o);let s=e.type;const i=s.match(M);if(i){const t=parseInt(i[2]||"-1"),n=N.from({type:i[1],components:e.components});return new N(O,r||"",s,"array",o,null,t,n)}if("tuple"===s||s.startsWith("tuple(")||s.startsWith("(")){const t=null!=e.components?e.components.map((e=>N.from(e))):null;return new N(O,r||"",s,"tuple",o,t,null,null)}return s=v(e.type),new N(O,r||"",s,s,o,null,null,null)}static isParamType(e){return e&&e[_]===R}}t.ParamType=N;class j{type;inputs;constructor(e,t,r){(0,n.assertPrivate)(e,O,"Fragment"),r=Object.freeze(r.slice()),(0,n.defineProperties)(this,{type:t,inputs:r})}static from(e){if("string"==typeof e){try{j.from(JSON.parse(e))}catch(e){}return j.from(m(e))}if(e instanceof P)switch(e.peekKeyword(d)){case"constructor":return $.from(e);case"error":return H.from(e);case"event":return G.from(e);case"fallback":case"receive":return K.from(e);case"function":return J.from(e);case"struct":return q.from(e)}else if("object"==typeof e){switch(e.type){case"constructor":return $.from(e);case"error":return H.from(e);case"event":return G.from(e);case"fallback":case"receive":return K.from(e);case"function":return J.from(e);case"struct":return q.from(e)}(0,n.assert)(!1,`unsupported type: ${e.type}`,"UNSUPPORTED_OPERATION",{operation:"Fragment.from"})}(0,n.assertArgument)(!1,"unsupported frgament object","obj",e)}static isConstructor(e){return $.isFragment(e)}static isError(e){return H.isFragment(e)}static isEvent(e){return G.isFragment(e)}static isFunction(e){return J.isFragment(e)}static isStruct(e){return q.isFragment(e)}}t.Fragment=j;class L extends j{name;constructor(e,t,r,o){super(e,t,o),(0,n.assertArgument)("string"==typeof r&&r.match(T),"invalid identifier","name",r),o=Object.freeze(o.slice()),(0,n.defineProperties)(this,{name:r})}}function V(e,t){return"("+t.map((t=>t.format(e))).join("full"===e?", ":",")+")"}t.NamedFragment=L;class H extends L{constructor(e,t,r){super(e,"error",t,r),Object.defineProperty(this,_,{value:S})}get selector(){return(0,s.id)(this.format("sighash")).substring(0,10)}format(e){if(null==e&&(e="sighash"),"json"===e)return JSON.stringify({type:"error",name:this.name,inputs:this.inputs.map((t=>JSON.parse(t.format(e))))});const t=[];return"sighash"!==e&&t.push("error"),t.push(this.name+V(e,this.inputs)),t.join(" ")}static from(e){if(H.isFragment(e))return e;if("string"==typeof e)return H.from(m(e));if(e instanceof P){const t=B("error",e),r=E(e);return F(e),new H(O,t,r)}return new H(O,e.name,e.inputs?e.inputs.map(N.from):[])}static isFragment(e){return e&&e[_]===S}}t.ErrorFragment=H;class G extends L{anonymous;constructor(e,t,r,o){super(e,"event",t,r),Object.defineProperty(this,_,{value:k}),(0,n.defineProperties)(this,{anonymous:o})}get topicHash(){return(0,s.id)(this.format("sighash"))}format(e){if(null==e&&(e="sighash"),"json"===e)return JSON.stringify({type:"event",anonymous:this.anonymous,name:this.name,inputs:this.inputs.map((t=>JSON.parse(t.format(e))))});const t=[];return"sighash"!==e&&t.push("event"),t.push(this.name+V(e,this.inputs)),"sighash"!==e&&this.anonymous&&t.push("anonymous"),t.join(" ")}static getTopicHash(e,t){return t=(t||[]).map((e=>N.from(e))),new G(O,e,t,!1).topicHash}static from(e){if(G.isFragment(e))return e;if("string"==typeof e)return G.from(m(e));if(e instanceof P){const t=B("event",e),r=E(e,!0),o=!!C(e,a(["anonymous"])).has("anonymous");return F(e),new G(O,t,r,o)}return new G(O,e.name,e.inputs?e.inputs.map((e=>N.from(e,!0))):[],!!e.anonymous)}static isFragment(e){return e&&e[_]===k}}t.EventFragment=G;class $ extends j{payable;gas;constructor(e,t,r,o,s){super(e,t,r),Object.defineProperty(this,_,{value:D}),(0,n.defineProperties)(this,{payable:o,gas:s})}format(e){if((0,n.assert)(null!=e&&"sighash"!==e,"cannot format a constructor for sighash","UNSUPPORTED_OPERATION",{operation:"format(sighash)"}),"json"===e)return JSON.stringify({type:"constructor",stateMutability:this.payable?"payable":"undefined",payable:this.payable,gas:null!=this.gas?this.gas:void 0,inputs:this.inputs.map((t=>JSON.parse(t.format(e))))});const t=[`constructor${V(e,this.inputs)}`];return t.push(this.payable?"payable":"nonpayable"),null!=this.gas&&t.push(`@${this.gas.toString()}`),t.join(" ")}static from(e){if($.isFragment(e))return e;if("string"==typeof e)return $.from(m(e));if(e instanceof P){C(e,a(["constructor"]));const t=E(e),r=!!C(e,a(["payable"])).has("payable"),o=I(e);return F(e),new $(O,"constructor",t,r,o)}return new $(O,"constructor",e.inputs?e.inputs.map(N.from):[],!!e.payable,null!=e.gas?e.gas:null)}static isFragment(e){return e&&e[_]===D}}t.ConstructorFragment=$;class K extends j{payable;constructor(e,t,r){super(e,"fallback",t),Object.defineProperty(this,_,{value:x}),(0,n.defineProperties)(this,{payable:r})}format(e){const t=0===this.inputs.length?"receive":"fallback";if("json"===e){const e=this.payable?"payable":"nonpayable";return JSON.stringify({type:t,stateMutability:e})}return`${t}()${this.payable?" payable":""}`}static from(e){if(K.isFragment(e))return e;if("string"==typeof e)return K.from(m(e));if(e instanceof P){const t=e.toString(),r=e.peekKeyword(a(["fallback","receive"]));if((0,n.assertArgument)(r,"type must be fallback or receive","obj",t),"receive"===e.popKeyword(a(["fallback","receive"]))){const t=E(e);return(0,n.assertArgument)(0===t.length,"receive cannot have arguments","obj.inputs",t),C(e,a(["payable"])),F(e),new K(O,[],!0)}let o=E(e);o.length?(0,n.assertArgument)(1===o.length&&"bytes"===o[0].type,"invalid fallback inputs","obj.inputs",o.map((e=>e.format("minimal"))).join(", ")):o=[N.from("bytes")];const s=w(e);if((0,n.assertArgument)("nonpayable"===s||"payable"===s,"fallback cannot be constants","obj.stateMutability",s),C(e,a(["returns"])).has("returns")){const t=E(e);(0,n.assertArgument)(1===t.length&&"bytes"===t[0].type,"invalid fallback outputs","obj.outputs",t.map((e=>e.format("minimal"))).join(", "))}return F(e),new K(O,o,"payable"===s)}if("receive"===e.type)return new K(O,[],!0);if("fallback"===e.type){const t=[N.from("bytes")],r="payable"===e.stateMutability;return new K(O,t,r)}(0,n.assertArgument)(!1,"invalid fallback description","obj",e)}static isFragment(e){return e&&e[_]===x}}t.FallbackFragment=K;class J extends L{constant;outputs;stateMutability;payable;gas;constructor(e,t,r,o,s,a){super(e,"function",t,o),Object.defineProperty(this,_,{value:U}),s=Object.freeze(s.slice());const i="view"===r||"pure"===r,c="payable"===r;(0,n.defineProperties)(this,{constant:i,gas:a,outputs:s,payable:c,stateMutability:r})}get selector(){return(0,s.id)(this.format("sighash")).substring(0,10)}format(e){if(null==e&&(e="sighash"),"json"===e)return JSON.stringify({type:"function",name:this.name,constant:this.constant,stateMutability:"nonpayable"!==this.stateMutability?this.stateMutability:void 0,payable:this.payable,gas:null!=this.gas?this.gas:void 0,inputs:this.inputs.map((t=>JSON.parse(t.format(e)))),outputs:this.outputs.map((t=>JSON.parse(t.format(e))))});const t=[];return"sighash"!==e&&t.push("function"),t.push(this.name+V(e,this.inputs)),"sighash"!==e&&("nonpayable"!==this.stateMutability&&t.push(this.stateMutability),this.outputs&&this.outputs.length&&(t.push("returns"),t.push(V(e,this.outputs))),null!=this.gas&&t.push(`@${this.gas.toString()}`)),t.join(" ")}static getSelector(e,t){return t=(t||[]).map((e=>N.from(e))),new J(O,e,"view",t,[],null).selector}static from(e){if(J.isFragment(e))return e;if("string"==typeof e)return J.from(m(e));if(e instanceof P){const t=B("function",e),r=E(e),o=w(e);let n=[];C(e,a(["returns"])).has("returns")&&(n=E(e));const s=I(e);return F(e),new J(O,t,o,r,n,s)}let t=e.stateMutability;return null==t&&(t="payable","boolean"==typeof e.constant?(t="view",e.constant||(t="payable","boolean"!=typeof e.payable||e.payable||(t="nonpayable"))):"boolean"!=typeof e.payable||e.payable||(t="nonpayable")),new J(O,e.name,t,e.inputs?e.inputs.map(N.from):[],e.outputs?e.outputs.map(N.from):[],null!=e.gas?e.gas:null)}static isFragment(e){return e&&e[_]===U}}t.FunctionFragment=J;class q extends L{constructor(e,t,r){super(e,"struct",t,r),Object.defineProperty(this,_,{value:z})}format(){throw new Error("@TODO")}static from(e){if("string"==typeof e)return q.from(m(e));if(e instanceof P){const t=B("struct",e),r=E(e);return F(e),new q(O,t,r)}return new q(O,e.name,e.inputs?e.inputs.map(N.from):[])}static isFragment(e){return e&&e[_]===z}}t.StructFragment=q},6219:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=r(5584),n=o.__importStar(r(2079)),s=o.__importStar(r(9055)),a=o.__importStar(r(183)),i=o.__importStar(r(9436)),c=o.__importStar(r(7154)),u=o.__importStar(r(9690)),d=o.__importStar(r(8557)),l=o.__importStar(r(9268)),p=o.__importStar(r(9193)),g=r(4903),f=o.__importStar(r(8931)),y={...o.__importStar(r(3331)),address:s,code:u,accounts:n,base58:a,bytes:i,crypto:c,abi:d,message:l,_TypedDataEncoder:g.TypedDataEncoder,transaction:f,ethersUtils:p};t.default=y,o.__exportStar(r(2079),t),o.__exportStar(r(9055),t),o.__exportStar(r(183),t),o.__exportStar(r(9436),t),o.__exportStar(r(7154),t),o.__exportStar(r(9690),t),o.__exportStar(r(8557),t),o.__exportStar(r(9268),t),o.__exportStar(r(9193),t),o.__exportStar(r(4903),t),o.__exportStar(r(8931),t),o.__exportStar(r(3331),t)},7100:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Interface=t.Indexed=t.ErrorDescription=t.TransactionDescription=t.LogDescription=t.Result=t.checkResultErrors=void 0;const o=r(9321),n=r(9321),s=r(9321),a=r(9321),i=r(9321);Object.defineProperty(t,"checkResultErrors",{enumerable:!0,get:function(){return i.checkResultErrors}}),Object.defineProperty(t,"Result",{enumerable:!0,get:function(){return i.Result}});const c=r(6606),u=r(9321);class d{fragment;name;signature;topic;args;constructor(e,t,r){const o=e.name,n=e.format();(0,s.defineProperties)(this,{fragment:e,name:o,signature:n,topic:t,args:r})}}t.LogDescription=d;class l{fragment;name;args;signature;selector;value;constructor(e,t,r,o){const n=e.name,a=e.format();(0,s.defineProperties)(this,{fragment:e,name:n,args:r,signature:a,selector:t,value:o})}}t.TransactionDescription=l;class p{fragment;name;args;signature;selector;constructor(e,t,r){const o=e.name,n=e.format();(0,s.defineProperties)(this,{fragment:e,name:o,args:r,signature:n,selector:t})}}t.ErrorDescription=p;class g{hash;_isIndexed;static isIndexed(e){return!(!e||!e._isIndexed)}constructor(e){(0,s.defineProperties)(this,{hash:e,_isIndexed:!0})}}t.Indexed=g;const f={0:"generic panic",1:"assert(false)",17:"arithmetic overflow",18:"division or modulo by zero",33:"enum overflow",34:"invalid encoded storage byte array accessed",49:"out-of-bounds array access; popping on an empty array",50:"out-of-bounds access of an array or bytesN",65:"out of memory",81:"uninitialized function"},y={"0x08c379a0":{signature:"Error(string)",name:"Error",inputs:["string"],reason:e=>`reverted with reason string ${JSON.stringify(e)}`},"0x4e487b71":{signature:"Panic(uint256)",name:"Panic",inputs:["uint256"],reason:e=>{let t="unknown panic code";return e>=0&&e<=255&&f[e.toString()]&&(t=f[e.toString()]),`reverted with panic code 0x${e.toString(16)} (${t})`}}};class b{fragments;deploy;fallback;receive;#n;#s;#a;#i;constructor(e){let t=[];t="string"==typeof e?JSON.parse(e):e,this.#a=new Map,this.#n=new Map,this.#s=new Map;const r=[];for(const e of t)try{r.push(c.Fragment.from(e))}catch(e){console.log("EE",e)}(0,s.defineProperties)(this,{fragments:Object.freeze(r)});let o=null,n=!1;this.#i=this.getAbiCoder(),this.fragments.forEach(((e,t)=>{let r;switch(e.type){case"constructor":return this.deploy?void console.log("duplicate definition - constructor"):void(0,s.defineProperties)(this,{deploy:e});case"fallback":return void(0===e.inputs.length?n=!0:((0,s.assertArgument)(!o||e.payable!==o.payable,"conflicting fallback fragments",`fragments[${t}]`,e),o=e,n=o.payable));case"function":r=this.#a;break;case"event":r=this.#s;break;case"error":r=this.#n;break;default:return}const a=e.format();r.has(a)||r.set(a,e)})),this.deploy||(0,s.defineProperties)(this,{deploy:c.ConstructorFragment.from("constructor()")}),(0,s.defineProperties)(this,{fallback:o,receive:n})}format(e){const t=e?"minimal":"full";return this.fragments.map((e=>e.format(t)))}formatJson(){const e=this.fragments.map((e=>e.format("json")));return JSON.stringify(e.map((e=>JSON.parse(e))))}getAbiCoder(){return a.AbiCoder.defaultAbiCoder()}#c(e,t,r){if((0,s.isHexString)(e)){const t=e.toLowerCase();for(const e of this.#a.values())if(t===e.selector)return e;return null}if(-1===e.indexOf("(")){const o=[];for(const[t,r]of this.#a)t.split("(")[0]===e&&o.push(r);if(t){const e=t.length>0?t[t.length-1]:null;let r=t.length,n=!0;u.Typed.isTyped(e)&&"overrides"===e.type&&(n=!1,r--);for(let e=o.length-1;e>=0;e--){const t=o[e].inputs.length;t===r||n&&t===r-1||o.splice(e,1)}for(let e=o.length-1;e>=0;e--){const r=o[e].inputs;for(let n=0;n<t.length;n++)if(u.Typed.isTyped(t[n])){if(n>=r.length){if("overrides"===t[n].type)continue;o.splice(e,1);break}if(t[n].type!==r[n].baseType){o.splice(e,1);break}}}}if(1===o.length&&t&&t.length!==o[0].inputs.length){const e=t[t.length-1];(null==e||Array.isArray(e)||"object"!=typeof e)&&o.splice(0,1)}if(0===o.length)return null;if(o.length>1&&r){const t=o.map((e=>JSON.stringify(e.format()))).join(", ");(0,s.assertArgument)(!1,`ambiguous function description (i.e. matches ${t})`,"key",e)}return o[0]}return this.#a.get(c.FunctionFragment.from(e).format())||null}getFunctionName(e){const t=this.#c(e,null,!1);return(0,s.assertArgument)(t,"no matching function","key",e),t.name}hasFunction(e){return!!this.#c(e,null,!1)}getFunction(e,t){return this.#c(e,t||null,!0)}forEachFunction(e){const t=Array.from(this.#a.keys());t.sort(((e,t)=>e.localeCompare(t)));for(let r=0;r<t.length;r++){const o=t[r];e(this.#a.get(o),r)}}#u(e,t,r){if((0,s.isHexString)(e)){const t=e.toLowerCase();for(const e of this.#s.values())if(t===e.topicHash)return e;return null}if(-1===e.indexOf("(")){const o=[];for(const[t,r]of this.#s)t.split("(")[0]===e&&o.push(r);if(t){for(let e=o.length-1;e>=0;e--)o[e].inputs.length<t.length&&o.splice(e,1);for(let e=o.length-1;e>=0;e--){const r=o[e].inputs;for(let n=0;n<t.length;n++)if(u.Typed.isTyped(t[n])&&t[n].type!==r[n].baseType){o.splice(e,1);break}}}if(0===o.length)return null;if(o.length>1&&r){const t=o.map((e=>JSON.stringify(e.format()))).join(", ");(0,s.assertArgument)(!1,`ambiguous event description (i.e. matches ${t})`,"key",e)}return o[0]}return this.#s.get(c.EventFragment.from(e).format())||null}getEventName(e){const t=this.#u(e,null,!1);return(0,s.assertArgument)(t,"no matching event","key",e),t.name}hasEvent(e){return!!this.#u(e,null,!1)}getEvent(e,t){return this.#u(e,t||null,!0)}forEachEvent(e){const t=Array.from(this.#s.keys());t.sort(((e,t)=>e.localeCompare(t)));for(let r=0;r<t.length;r++){const o=t[r];e(this.#s.get(o),r)}}getError(e,t){if((0,s.isHexString)(e)){const t=e.toLowerCase();if(y[t])return c.ErrorFragment.from(y[t].signature);for(const e of this.#n.values())if(t===e.selector)return e;return null}if(-1===e.indexOf("(")){const t=[];for(const[r,o]of this.#n)r.split("(")[0]===e&&t.push(o);if(0===t.length)return"Error"===e?c.ErrorFragment.from("error Error(string)"):"Panic"===e?c.ErrorFragment.from("error Panic(uint256)"):null;if(t.length>1){const r=t.map((e=>JSON.stringify(e.format()))).join(", ");(0,s.assertArgument)(!1,`ambiguous error description (i.e. ${r})`,"name",e)}return t[0]}if("Error(string)"===(e=c.ErrorFragment.from(e).format()))return c.ErrorFragment.from("error Error(string)");if("Panic(uint256)"===e)return c.ErrorFragment.from("error Panic(uint256)");return this.#n.get(e)||null}forEachError(e){const t=Array.from(this.#n.keys());t.sort(((e,t)=>e.localeCompare(t)));for(let r=0;r<t.length;r++){const o=t[r];e(this.#n.get(o),r)}}_decodeParams(e,t){return this.#i.decode(e,t)}_encodeParams(e,t){return this.#i.encode(e,t)}encodeDeploy(e){return this._encodeParams(this.deploy.inputs,e||[])}decodeErrorResult(e,t){if("string"==typeof e){const t=this.getError(e);(0,s.assertArgument)(t,"unknown error","fragment",e),e=t}return(0,s.assertArgument)((0,s.dataSlice)(t,0,4)===e.selector,`data signature does not match error ${e.name}.`,"data",t),this._decodeParams(e.inputs,(0,s.dataSlice)(t,4))}encodeErrorResult(e,t){if("string"==typeof e){const t=this.getError(e);(0,s.assertArgument)(t,"unknown error","fragment",e),e=t}return(0,s.concat)([e.selector,this._encodeParams(e.inputs,t||[])])}decodeFunctionData(e,t){if("string"==typeof e){const t=this.getFunction(e);(0,s.assertArgument)(t,"unknown function","fragment",e),e=t}return(0,s.assertArgument)((0,s.dataSlice)(t,0,4)===e.selector,`data signature does not match function ${e.name}.`,"data",t),this._decodeParams(e.inputs,(0,s.dataSlice)(t,4))}encodeFunctionData(e,t){if("string"==typeof e){const t=this.getFunction(e);(0,s.assertArgument)(t,"unknown function","fragment",e),e=t}return(0,s.concat)([e.selector,this._encodeParams(e.inputs,t||[])])}decodeFunctionResult(e,t){if("string"==typeof e){const t=this.getFunction(e);(0,s.assertArgument)(t,"unknown function","fragment",e),e=t}let r="invalid length for result data";const o=(0,s.getBytesCopy)(t);if(o.length%32==0)try{return this.#i.decode(e.outputs,o)}catch(e){r="could not decode result data"}(0,s.assert)(!1,r,"BAD_DATA",{value:(0,s.hexlify)(o),info:{method:e.name,signature:e.format()}})}makeError(e,t){const r=(0,s.getBytes)(e,"data"),o=a.AbiCoder.getBuiltinCallException("call",t,r);if(o.message.startsWith("execution reverted (unknown custom error)")){const e=(0,s.hexlify)(r.slice(0,4)),t=this.getError(e);if(t)try{const e=this.#i.decode(t.inputs,r.slice(4));o.revert={name:t.name,signature:t.format(),args:e},o.reason=o.revert.signature,o.message=`execution reverted: ${o.reason}`}catch(e){o.message="execution reverted (coult not decode custom error)"}}const n=this.parseTransaction(t);return n&&(o.invocation={method:n.name,signature:n.signature,args:n.args}),o}encodeFunctionResult(e,t){if("string"==typeof e){const t=this.getFunction(e);(0,s.assertArgument)(t,"unknown function","fragment",e),e=t}return(0,s.hexlify)(this.#i.encode(e.outputs,t||[]))}encodeFilterTopics(e,t){if("string"==typeof e){const t=this.getEvent(e);(0,s.assertArgument)(t,"unknown event","eventFragment",e),e=t}(0,s.assert)(t.length<=e.inputs.length,`too many arguments for ${e.format()}`,"UNEXPECTED_ARGUMENT",{count:t.length,expectedCount:e.inputs.length});const r=[];e.anonymous||r.push(e.topicHash);const a=(e,t)=>"string"===e.type?(0,n.id)(t):"bytes"===e.type?(0,o.keccak256)((0,s.hexlify)(t)):("bool"===e.type&&"boolean"==typeof t&&(t=t?"0x01":"0x00"),e.type.match(/^u?int/)&&(t=(0,s.toBeHex)(t)),"address"===e.type&&this.#i.encode(["address"],[t]),(0,s.zeroPadValue)((0,s.hexlify)(t),32));for(t.forEach(((t,o)=>{const n=e.inputs[o];n.indexed?null==t?r.push(null):"array"===n.baseType||"tuple"===n.baseType?(0,s.assertArgument)(!1,"filtering with tuples or arrays not supported","contract."+n.name,t):Array.isArray(t)?r.push(t.map((e=>a(n,e)))):r.push(a(n,t)):(0,s.assertArgument)(null==t,"cannot filter non-indexed parameters; must be null","contract."+n.name,t)}));r.length&&null===r[r.length-1];)r.pop();return r}encodeEventLog(e,t){if("string"==typeof e){const t=this.getEvent(e);(0,s.assertArgument)(t,"unknown event","eventFragment",e),e=t}const r=[],a=[],i=[];return e.anonymous||r.push(e.topicHash),(0,s.assertArgument)(t.length===e.inputs.length,"event arguments/values mismatch","values",t),e.inputs.forEach(((e,s)=>{const c=t[s];if(e.indexed)if("string"===e.type)r.push((0,n.id)(c));else if("bytes"===e.type)r.push((0,o.keccak256)(c));else{if("tuple"===e.baseType||"array"===e.baseType)throw new Error("not implemented");r.push(this.#i.encode([e.type],[c]))}else a.push(e),i.push(c)})),{data:this.#i.encode(a,i),topics:r}}decodeEventLog(e,t,r){if("string"==typeof e){const t=this.getEvent(e);(0,s.assertArgument)(t,"unknown event","eventFragment",e),e=t}if(null!=r&&!e.anonymous){const t=e.topicHash;(0,s.assertArgument)((0,s.isHexString)(r[0],32)&&r[0].toLowerCase()===t,"fragment/topic mismatch","topics[0]",r[0]),r=r.slice(1)}const o=[],n=[],a=[];e.inputs.forEach(((e,t)=>{e.indexed?"string"===e.type||"bytes"===e.type||"tuple"===e.baseType||"array"===e.baseType?(o.push(c.ParamType.from({type:"bytes32",name:e.name})),a.push(!0)):(o.push(e),a.push(!1)):(n.push(e),a.push(!1))}));const u=null!=r?this.#i.decode(o,(0,s.concat)(r)):null,d=this.#i.decode(n,t,!0),l=[],p=[];let f=0,y=0;return e.inputs.forEach(((e,t)=>{let r=null;if(e.indexed)if(null==u)r=new g(null);else if(a[t])r=new g(u[y++]);else try{r=u[y++]}catch(e){r=e}else try{r=d[f++]}catch(e){r=e}l.push(r),p.push(e.name||null)})),i.Result.fromItems(l,p)}parseTransaction(e){const t=(0,s.getBytes)(e.data,"tx.data"),r=(0,s.getBigInt)(null!=e.value?e.value:0,"tx.value"),o=this.getFunction((0,s.hexlify)(t.slice(0,4)));if(!o)return null;const n=this.#i.decode(o.inputs,t.slice(4));return new l(o,o.selector,n,r)}parseCallResult(e){throw new Error("@TODO")}parseLog(e){const t=this.getEvent(e.topics[0]);return!t||t.anonymous?null:new d(t,t.topicHash,this.decodeEventLog(t,e.data,e.topics))}parseError(e){const t=(0,s.hexlify)(e),r=this.getError((0,s.dataSlice)(t,0,4));if(!r)return null;const o=this.#i.decode(r.inputs,(0,s.dataSlice)(t,4));return new p(r,r.selector,o)}static from(e){return e instanceof b?e:"string"==typeof e?new b(JSON.parse(e)):"function"==typeof e.format?new b(e.format("json")):new b(e)}}t.Interface=b},9268:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TRON_MESSAGE_PREFIX=void 0,t.hashMessage=i,t.signMessage=function(e,t){t.match(/^0x/)||(t="0x"+t);const r=new o.SigningKey(t),n=i(e),s=r.sign(n);return(0,o.joinSignature)(s)},t.verifyMessage=function(e,t){t.match(/^0x/)||(t="0x"+t);const r=(0,o.recoverAddress)(i(e),t);return(0,s.getBase58CheckAddress)((0,a.hexStr2byteArray)(r.replace(/^0x/,n.ADDRESS_PREFIX)))};const o=r(9193),n=r(9055),s=r(7154),a=r(9690);function i(e){return"string"==typeof e?e=(0,o.toUtf8Bytes)(e):Array.isArray(e)&&(e=new Uint8Array(e)),(0,o.keccak256)((0,o.concat)([(0,o.toUtf8Bytes)(t.TRON_MESSAGE_PREFIX),(0,o.toUtf8Bytes)(String(e.length)),e]))}t.TRON_MESSAGE_PREFIX="TRON Signed Message:\n"},8931:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.DTriggerSmartContract=t.txCheck=t.txCheckWithArgs=t.txJsonToPbWithArgs=t.txPbToRawDataHex=t.txPbToTxID=t.txJsonToPb=void 0;const o=r(5584),n=o.__importDefault(r(5056));r(5925);const{Transaction:s,Permission:a,Key:i}=globalThis.TronWebProto;r(6556);const{TransferContract:c,FreezeBalanceContract:u,UnfreezeBalanceContract:d,WithdrawBalanceContract:l,FreezeBalanceV2Contract:p,UnfreezeBalanceV2Contract:g,WithdrawExpireUnfreezeContract:f,DelegateResourceContract:y,UnDelegateResourceContract:b}=globalThis.TronWebProto;r(8056);const{TransferAssetContract:h,ParticipateAssetIssueContract:T,AssetIssueContract:W,UpdateAssetContract:P}=globalThis.TronWebProto;r(803);const{TriggerSmartContract:m,ClearABIContract:A,UpdateEnergyLimitContract:B,UpdateSettingContract:C,CreateSmartContract:w,SmartContract:E}=globalThis.TronWebProto;r(906);const{ResourceCode:I}=globalThis.TronWebProto;r(3089);const{WitnessCreateContract:F,VoteWitnessContract:M}=globalThis.TronWebProto;r(8179);const{UpdateBrokerageContract:v}=globalThis.TronWebProto;r(549);const{AccountCreateContract:O,AccountUpdateContract:_,SetAccountIdContract:R,AccountPermissionUpdateContract:S}=globalThis.TronWebProto;r(9362);const{ProposalCreateContract:k,ProposalDeleteContract:D,ProposalApproveContract:x}=globalThis.TronWebProto;r(2983);const{ExchangeCreateContract:U,ExchangeInjectContract:z,ExchangeWithdrawContract:N,ExchangeTransactionContract:j}=globalThis.TronWebProto,L=r(9436),V=r(9690),H=r(9193),G=o.__importDefault(r(5562)),$=r(3331),K=e=>e&&0!==e.length?new Uint8Array(G.default.address.toHex(e).match(/.{1,2}/g).map((e=>parseInt(e,16)))):new Uint8Array([]),J=e=>e&&0!==e.length?new Uint8Array(((0,$.isHex)(e)?e:G.default.toHex(e)).replace(/^0x/,"").match(/.{1,2}/g).map((e=>parseInt(e,16)))):new Uint8Array([]),q=(e,t)=>J(t?G.default.fromUtf8(e).replace(/^0x/,""):e.replace(/^0x/,"")),X=(e,t,r,o)=>{const a=new n.default.Any;a.pack(e.serializeBinary(),"protocol."+r);const i=new s.Contract;i.setType(t),i.setParameter(a),o&&i.setPermissionId(o);const c=new s.raw;c.addContract(i);const u=new s;return u.setRawData(c),u},Y=(e,t,r)=>{switch(e.type){case"TransferContract":return((e,t)=>{const{to_address:r,owner_address:o,amount:n}=e,a=new c;return a.setToAddress(K(r)),a.setOwnerAddress(K(o)),a.setAmount(n),X(a,s.Contract.ContractType.TRANSFERCONTRACT,"TransferContract",t.Permission_id)})(t,r);case"TransferAssetContract":return((e,t)=>{const{to_address:r,owner_address:o,amount:n,asset_name:a}=e,i=new h;return i.setToAddress(K(r)),i.setOwnerAddress(K(o)),i.setAssetName(q(a,t.visible)),i.setAmount(n),X(i,s.Contract.ContractType.TRANSFERASSETCONTRACT,"TransferAssetContract",t.Permission_id)})(t,r);case"ParticipateAssetIssueContract":return((e,t)=>{const r=new T;return r.setToAddress(K(e.to_address)),r.setOwnerAddress(K(e.owner_address)),r.setAssetName(q(e.asset_name,t.visible)),r.setAmount(e.amount),X(r,s.Contract.ContractType.PARTICIPATEASSETISSUECONTRACT,"ParticipateAssetIssueContract",t.Permission_id)})(t,r);case"TriggerSmartContract":return((e,t)=>{const r=new m,{owner_address:o,contract_address:n,parameter:a="",function_selector:i,call_value:c,call_token_value:u,token_id:d,data:l}=e;if(r.setOwnerAddress(K(o)),r.setContractAddress(K(n)),r.setCallValue(c),l)r.setData(J(l));else if(i){const e=((e,t=!0)=>(t?"0x":"")+(0,H.keccak256)(Buffer.from(e,"utf-8")).toString().substring(2))(i).substring(2,10)+a;r.setData(J(e))}return d&&r.setTokenId(d),u&&r.setCallTokenValue(u),X(r,s.Contract.ContractType.TRIGGERSMARTCONTRACT,"TriggerSmartContract",t.Permission_id)})(t,r);case"FreezeBalanceContract":return((e,t)=>{const r=new u,{owner_address:o,frozen_balance:n,frozen_duration:a,resource:i,receiver_address:c}=e;return r.setOwnerAddress(K(o)),r.setFrozenBalance(n),r.setFrozenDuration(a),i&&r.setResource(I[i]),c&&r.setReceiverAddress(K(c)),X(r,s.Contract.ContractType.FREEZEBALANCECONTRACT,"FreezeBalanceContract",t.Permission_id)})(t,r);case"UnfreezeBalanceContract":return((e,t)=>{const r=new d,{owner_address:o,resource:n,receiver_address:a}=e;return r.setOwnerAddress(K(o)),n&&r.setResource(I[n]),a&&r.setReceiverAddress(K(a)),X(r,s.Contract.ContractType.UNFREEZEBALANCECONTRACT,"UnfreezeBalanceContract",t.Permission_id)})(t,r);case"WithdrawBalanceContract":return((e,t)=>{const r=new l,{owner_address:o}=e;return r.setOwnerAddress(K(o)),X(r,s.Contract.ContractType.WITHDRAWBALANCECONTRACT,"WithdrawBalanceContract",t.Permission_id)})(t,r);case"FreezeBalanceV2Contract":return((e,t)=>{const r=new p,{owner_address:o,frozen_balance:n,resource:a}=e;return r.setOwnerAddress(K(o)),r.setFrozenBalance(n),r.setResource(I[a]),X(r,s.Contract.ContractType.FREEZEBALANCEV2CONTRACT,"FreezeBalanceV2Contract",t.Permission_id)})(t,r);case"CancelAllUnfreezeV2Contract":return((e,t)=>{const r=new f,{owner_address:o}=e;return r.setOwnerAddress(K(o)),X(r,s.Contract.ContractType.CANCELALLUNFREEZEV2CONTRACT,"CancelAllUnfreezeV2Contract",t.Permission_id)})(t,r);case"UnfreezeBalanceV2Contract":return((e,t)=>{const r=new g,{owner_address:o,unfreeze_balance:n,resource:a}=e;return r.setOwnerAddress(K(o)),r.setUnfreezeBalance(n),r.setResource(I[a]),X(r,s.Contract.ContractType.UNFREEZEBALANCEV2CONTRACT,"UnfreezeBalanceV2Contract",t.Permission_id)})(t,r);case"DelegateResourceContract":return((e,t)=>{const r=new y,{owner_address:o,receiver_address:n,balance:a,resource:i,lock:c=!1,lock_period:u}=e;return r.setOwnerAddress(K(o)),r.setBalance(a),r.setResource(I[i]),r.setLock(c),r.setLockPeriod(u),r.setReceiverAddress(K(n)),X(r,s.Contract.ContractType.DELEGATERESOURCECONTRACT,"DelegateResourceContract",t.Permission_id)})(t,r);case"UnDelegateResourceContract":return((e,t)=>{const r=new b,{owner_address:o,receiver_address:n,balance:a,resource:i}=e;return r.setOwnerAddress(K(o)),r.setBalance(a),r.setResource(I[i]),r.setReceiverAddress(K(n)),X(r,s.Contract.ContractType.UNDELEGATERESOURCECONTRACT,"UnDelegateResourceContract",t.Permission_id)})(t,r);case"WithdrawExpireUnfreezeContract":return((e,t)=>{const r=new f,{owner_address:o}=e;return r.setOwnerAddress(K(o)),X(r,s.Contract.ContractType.WITHDRAWEXPIREUNFREEZECONTRACT,"WithdrawExpireUnfreezeContract",t.Permission_id)})(t,r);case"WitnessCreateContract":return((e,t)=>{const r=new F,{owner_address:o,url:n}=e;return r.setOwnerAddress(K(o)),r.setUrl(J(n.replace(/^0x/,""))),X(r,s.Contract.ContractType.WITNESSCREATECONTRACT,"WitnessCreateContract",t.Permission_id)})(t,r);case"VoteWitnessContract":return((e,t)=>{const r=new M,{owner_address:o,votes:n}=e;return r.setOwnerAddress(K(o)),n.forEach((e=>{const t=new M.Vote,{vote_address:o,vote_count:n}=e;t.setVoteAddress(K(o));const s=parseInt(n);t.setVoteCount(s),r.addVotes(t)})),X(r,s.Contract.ContractType.VOTEWITNESSCONTRACT,"VoteWitnessContract",t.Permission_id)})(t,r);case"CreateSmartContract":return((e,t)=>{const r=e?.new_contract?{owner_address:e.owner_address,call_token_value:e.call_token_value,token_id:e.token_id,...e.new_contract}:e,{owner_address:o,consume_user_resource_percent:n,origin_energy_limit:a,abi:i,bytecode:c="",parameter:u="",call_value:d,call_token_value:l,token_id:p,name:g}=r;let{origin_address:f}=r;const y=new w;y.setOwnerAddress(K(o)),p&&y.setTokenId(p),l&&y.setCallTokenValue(l);const b=new E;if(i){let e;e="string"==typeof i?JSON.parse(i):i?.entrys||[];const t=new E.ABI,r=e=>{const t=new E.ABI.Entry.Param,{indexed:r,name:o,type:n}=e;return!0===r&&t.setIndexed(!0),t.setName(o),t.setType(n),t},o=e.map((e=>{const{anonymous:t,constant:o,name:n,inputs:s,outputs:a,type:i,payable:c,stateMutability:u}=e,d=new E.ABI.Entry;return d.setAnonymous(t),d.setConstant(o),d.setName(n),s&&d.setInputsList(s.map((e=>r(e)))),a&&d.setOutputsList(a.map((e=>r(e)))),i&&d.setType(E.ABI.Entry.EntryType[i.toUpperCase()]),d.setPayable(c),u&&d.setStatemutability(E.ABI.Entry.StateMutabilityType[u.toUpperCase()]),d}));t.setEntrysList(o),b.setAbi(t)}if(d&&b.setCallValue(d),b.setConsumeUserResourcePercent(n),b.setOriginEnergyLimit(a),f||(f=o),b.setOriginAddress(K(f)),c){const e=c.replace(/^0x/,"")+u.replace(/^0x/,"");b.setBytecode(J(e))}return b.setName(g),y.setNewContract(b),X(y,s.Contract.ContractType.CREATESMARTCONTRACT,"CreateSmartContract",t.Permission_id)})(t,r);case"ClearABIContract":return((e,t)=>{const{contract_address:r,owner_address:o}=e,n=new A;return n.setOwnerAddress(K(o)),n.setContractAddress(K(r)),X(n,s.Contract.ContractType.CLEARABICONTRACT,"ClearABIContract",t.Permission_id)})(t,r);case"UpdateBrokerageContract":return((e,t)=>{const{brokerage:r,owner_address:o}=e,n=new v;return n.setOwnerAddress(K(o)),n.setBrokerage(r),X(n,s.Contract.ContractType.UPDATEBROKERAGECONTRACT,"UpdateBrokerageContract",t.Permission_id)})(t,r);case"AssetIssueContract":return((e,t)=>{const{owner_address:r,name:o,abbr:n,description:a,url:i,total_supply:c,trx_num:u,num:d,start_time:l,end_time:p,precision:g,free_asset_net_limit:f,public_free_asset_net_limit:y,public_free_asset_net_usage:b=0,public_latest_free_net_time:h=0,vote_score:T=0,frozen_supply:P}=e,m=new W;if(m.setOwnerAddress(K(r)),o&&m.setName(J(o.replace(/^0x/,""))),n&&m.setAbbr(J(n.replace(/^0x/,""))),m.setTotalSupply(c),m.setNum(d),m.setEndTime(p),m.setStartTime(l),m.setTrxNum(u),m.setVoteScore(T),g&&m.setPrecision(g),h&&m.setPublicLatestFreeNetTime(h),a&&m.setDescription(J(a.replace(/^0x/,""))),i&&m.setUrl(J(i.replace(/^0x/,""))),m.setPublicFreeAssetNetUsage(b),m.setFreeAssetNetLimit(f),m.setPublicFreeAssetNetLimit(y),P){const e=new W.FrozenSupply;e.setFrozenAmount(P.length?P[0].frozen_amount:P.frozen_amount),e.setFrozenDays(P.length?P[0].frozen_days:P.frozen_days),m.addFrozenSupply(e)}return X(m,s.Contract.ContractType.ASSETISSUECONTRACT,"AssetIssueContract",t.Permission_id)})(t,r);case"AccountCreateContract":return((e,t)=>{const r=new O,{account_address:o,owner_address:n}=e;return r.setOwnerAddress(K(n)),r.setAccountAddress(K(o.replace(/^0x/,""))),X(r,s.Contract.ContractType.ACCOUNTCREATECONTRACT,"AccountCreateContract",t.Permission_id)})(t,r);case"AccountUpdateContract":return((e,t)=>{const r=new _,{account_name:o,owner_address:n}=e;return r.setOwnerAddress(K(n)),r.setAccountName(J(o.replace(/^0x/,""))),X(r,s.Contract.ContractType.ACCOUNTUPDATECONTRACT,"AccountUpdateContract",t.Permission_id)})(t,r);case"SetAccountIdContract":return((e,t)=>{const r=new R,{account_id:o,owner_address:n}=e;return r.setOwnerAddress(K(n)),r.setAccountId(J(o.replace(/^0x/,""))),X(r,s.Contract.ContractType.SETACCOUNTIDCONTRACT,"SetAccountIdContract",t.Permission_id)})(t,r);case"ProposalCreateContract":return((e,t)=>{const r=new k,{owner_address:o,parameters:n}=e;return r.setOwnerAddress(K(o)),n.forEach((e=>{r.getParametersMap().set(e.key,e.value)})),X(r,s.Contract.ContractType.PROPOSALCREATECONTRACT,"ProposalCreateContract",t.Permission_id)})(t,r);case"ProposalDeleteContract":return((e,t)=>{const r=new D,{owner_address:o,proposal_id:n}=e;return r.setOwnerAddress(K(o)),r.setProposalId(n),X(r,s.Contract.ContractType.PROPOSALDELETECONTRACT,"ProposalDeleteContract",t.Permission_id)})(t,r);case"ProposalApproveContract":return((e,t)=>{const r=new x,{owner_address:o,proposal_id:n,is_add_approval:a}=e;return r.setOwnerAddress(K(o)),r.setProposalId(n),r.setIsAddApproval(a),X(r,s.Contract.ContractType.PROPOSALAPPROVECONTRACT,"ProposalApproveContract",t.Permission_id)})(t,r);case"ExchangeCreateContract":return((e,t)=>{const r=new U,{owner_address:o,first_token_id:n,first_token_balance:a,second_token_id:i,second_token_balance:c}=e;return r.setOwnerAddress(K(o)),r.setFirstTokenId(q(n,t.visible)),r.setFirstTokenBalance(a),r.setSecondTokenId(q(i,t.visible)),r.setSecondTokenBalance(c),X(r,s.Contract.ContractType.EXCHANGECREATECONTRACT,"ExchangeCreateContract",t.Permission_id)})(t,r);case"ExchangeInjectContract":return((e,t)=>{const r=new z,{owner_address:o,exchange_id:n,token_id:a,quant:i}=e;return r.setOwnerAddress(K(o)),r.setExchangeId(n),r.setTokenId(q(a,t.visible)),r.setQuant(i),X(r,s.Contract.ContractType.EXCHANGEINJECTCONTRACT,"ExchangeInjectContract",t.Permission_id)})(t,r);case"ExchangeWithdrawContract":return((e,t)=>{const r=new N,{owner_address:o,exchange_id:n,token_id:a,quant:i}=e;return r.setOwnerAddress(K(o)),r.setExchangeId(n),r.setTokenId(q(a,t.visible)),r.setQuant(i),X(r,s.Contract.ContractType.EXCHANGEWITHDRAWCONTRACT,"ExchangeWithdrawContract",t.Permission_id)})(t,r);case"ExchangeTransactionContract":return((e,t)=>{const r=new j,{owner_address:o,exchange_id:n,token_id:a,quant:i,expected:c}=e;return r.setOwnerAddress(K(o)),r.setExchangeId(n),r.setTokenId(q(a,t.visible)),r.setQuant(i),r.setExpected(c),X(r,s.Contract.ContractType.EXCHANGETRANSACTIONCONTRACT,"ExchangeTransactionContract",t.Permission_id)})(t,r);case"UpdateSettingContract":return((e,t)=>{const r=new C,{owner_address:o,contract_address:n,consume_user_resource_percent:a}=e;return r.setOwnerAddress(K(o)),r.setContractAddress(K(n)),r.setConsumeUserResourcePercent(a),X(r,s.Contract.ContractType.UPDATESETTINGCONTRACT,"UpdateSettingContract",t.Permission_id)})(t,r);case"UpdateEnergyLimitContract":return((e,t)=>{const r=new B,{owner_address:o,contract_address:n,origin_energy_limit:a}=e;return r.setOwnerAddress(K(o)),r.setContractAddress(K(n)),r.setOriginEnergyLimit(a),X(r,s.Contract.ContractType.UPDATEENERGYLIMITCONTRACT,"UpdateEnergyLimitContract",t.Permission_id)})(t,r);case"AccountPermissionUpdateContract":return((e,t)=>{const r=new S,{owner_address:o,owner:n,witness:c,actives:u}=e;r.setOwnerAddress(K(o));const d=e=>{const t=new a,{type:r,id:o,permission_name:n,threshold:s,parentId:c,operations:u,keys:d}=e;return t.setType((e=>isNaN(e)?"Active"===e?2:"Witness"===e?1:0:e)(r)),t.setId(o),t.setPermissionName(n),t.setThreshold(s),c&&t.setParentId(c),u&&t.setOperations(J(u)),d&&t.setKeysList(d.map((e=>{const t=new i;return t.setAddress(K(e.address)),t.setWeight(e.weight),t}))),t};return n&&r.setOwner(d(n)),c&&r.setWitness(d(c)),u&&(Array.isArray(u)?r.setActivesList(u.map((e=>d(e)))):r.setActivesList([d(u)])),X(r,s.Contract.ContractType.ACCOUNTPERMISSIONUPDATECONTRACT,"AccountPermissionUpdateContract",t.Permission_id)})(t,r);case"UpdateAssetContract":return((e,t)=>{const r=new P,{owner_address:o,description:n,url:a,new_limit:i,new_public_limit:c}=e;return r.setOwnerAddress(K(o)),n&&r.setDescription(J(n.replace(/^0x/,""))),a&&r.setUrl(J(a.replace(/^0x/,""))),i&&r.setNewLimit(i),c&&r.setNewPublicLimit(c),X(r,s.Contract.ContractType.UPDATEASSETCONTRACT,"UpdateAssetContract",t.Permission_id)})(t,r)}},Z=e=>{const t=e.raw_data,r=t.contract[0],o=r.parameter.value,n={Permission_id:r.Permission_id,visible:e.visible},s=Y(r,o,n),a=s.getRawData();return a.setRefBlockBytes(J(t.ref_block_bytes)),a.setRefBlockHash(J(t.ref_block_hash)),t.data&&a.setData(J(t.data)),t.fee_limit&&a.setFeeLimit(t.fee_limit),t.expiration&&a.setExpiration(t.expiration),t.timestamp&&a.setTimestamp(t.timestamp),s.setRawData(a),s};t.txJsonToPb=Z;const Q=(e,t={},r={})=>{const o=e.raw_data,n=o.contract[0],s=Y(n,t,{Permission_id:t?.Permission_id}),a=s.getRawData();return a.setRefBlockBytes(J(o.ref_block_bytes)),a.setRefBlockHash(J(o.ref_block_hash)),r.data&&a.setData(J(r.data.replace(/^0x/,""))),(r.fee_limit||t.fee_limit)&&a.setFeeLimit(r.fee_limit||t.fee_limit),o.expiration&&a.setExpiration(o.expiration),o.timestamp&&a.setTimestamp(o.timestamp),s.setRawData(a),s};t.txJsonToPbWithArgs=Q;const ee=(e,t)=>{const r=t.getRawData().serializeBinary(),o=(0,L.byteArray2hexStr)(r),n=(0,H.sha256)(r);return o.toLowerCase()===e.raw_data_hex.toLowerCase()&&n.replace(/^0x/,"").toLowerCase()===e.txID.replace(/^0x/,"").toLowerCase()};t.txPbToRawDataHex=e=>(0,L.byteArray2hexStr)(e.getRawData().serializeBinary()),t.txCheck=e=>{const t=Z(e);return ee(e,t)},t.txCheckWithArgs=(e,t,r)=>{const o=Q(e,t,r);return ee(e,o)},t.txPbToTxID=e=>{const t=e.getRawData().serializeBinary();return(0,H.sha256)(t)},t.DTriggerSmartContract=e=>{const[t,r]=(e=>{const t=s.raw.deserializeBinary((0,V.hexStr2byteArray)(e)),r=t.getContractList()[0],o=r.getParameter().getValue();return[{contract:[{parameter:{value:{},type_url:r.getParameter().getTypeUrl()},type:r.getType(),Permission_id:r.getPermissionId()}],data:(0,L.byteArray2hexStr)(t.getData()),fee_limit:t.getFeeLimit(),ref_block_bytes:(0,L.byteArray2hexStr)(t.getRefBlockBytes_asU8()),ref_block_hash:(0,L.byteArray2hexStr)(t.getRefBlockHash_asU8()),expiration:t.getExpiration(),timestamp:t.getTimestamp()},o]})(e),o=m.deserializeBinary(r);return t.contract[0].parameter.value={owner_address:(0,L.byteArray2hexStr)(o.getOwnerAddress_asU8()),contract_address:(0,L.byteArray2hexStr)(o.getContractAddress_asU8()),call_value:o.getCallValue(),data:(0,L.byteArray2hexStr)(o.getData_asU8()),call_token_value:o.getCallTokenValue(),token_id:o.getTokenId()},t}},4903:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TypedDataEncoder=void 0,t.verifyTypedData=function(e,t,r,o){return(0,n.recoverAddress)(W.hash(e,t,r),o)};const o=r(5562),n=r(9321),s=r(9055),a=new Uint8Array(32);a.fill(0);const i=BigInt(-1),c=BigInt(0),u=BigInt(1),d=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),l=(0,n.toBeHex)(u,32),p=(0,n.toBeHex)(c,32),g={name:"string",version:"string",chainId:"uint256",verifyingContract:"address",salt:"bytes32"},f=["name","version","chainId","verifyingContract","salt"];function y(e){return function(t){return(0,n.assertArgument)("string"==typeof t,`invalid domain value for ${JSON.stringify(e)}`,`domain.${e}`,t),t}}const b={name:y("name"),version:y("version"),chainId:function(e){const t=(0,n.getBigInt)(e,"domain.chainId");return(0,n.assertArgument)(t>=0,"invalid chain ID","domain.chainId",e),Number.isSafeInteger(t)?Number(t):(0,n.toQuantity)(t)},verifyingContract:function(e){try{return(t=e,o.TronWeb.address.toHex(t)).toLowerCase()}catch(e){}var t;(0,n.assertArgument)(!1,'invalid domain value "verifyingContract"',"domain.verifyingContract",e)},salt:function(e){const t=(0,n.getBytes)(e,"domain.salt");return(0,n.assertArgument)(32===t.length,'invalid domain value "salt"',"domain.salt",e),(0,n.hexlify)(t)}};function h(e){{const t=e.match(/^(u?)int(\d*)$/);if(t){const r=""===t[1],o=parseInt(t[2]||"256");(0,n.assertArgument)(o%8==0&&0!==o&&o<=256&&(null==t[2]||t[2]===String(o)),"invalid numeric width","type",e);const s=(0,n.mask)(d,r?o-1:o),a=r?(s+u)*i:c;return function(t){const o=(0,n.getBigInt)(t,"value");return(0,n.assertArgument)(o>=a&&o<=s,`value out-of-bounds for ${e}`,"value",o),(0,n.toBeHex)(r?(0,n.toTwos)(o,256):o,32)}}}{const t=e.match(/^bytes(\d+)$/);if(t){const r=parseInt(t[1]);return(0,n.assertArgument)(0!==r&&r<=32&&t[1]===String(r),"invalid bytes width","type",e),function(t){const o=(0,n.getBytes)(t);return(0,n.assertArgument)(o.length===r,`invalid length for ${e}`,"value",t),function(e){const t=(0,n.getBytes)(e),r=t.length%32;return r?(0,n.concat)([t,a.slice(r)]):(0,n.hexlify)(t)}(t)}}}switch(e){case"trcToken":return h("uint256");case"address":return function(e){return(0,n.zeroPadValue)((t=e,o.TronWeb.address.toHex(t).replace(s.ADDRESS_PREFIX_REGEX,"0x")),32);var t};case"bool":return function(e){return e?l:p};case"bytes":return function(e){return(0,n.keccak256)(e)};case"string":return function(e){return(0,n.id)(e)}}return null}function T(e,t){return`${e}(${t.map((({name:e,type:t})=>t+" "+e)).join(",")})`}class W{primaryType;#d;get types(){return JSON.parse(this.#d)}#l;#p;constructor(e){this.#d=JSON.stringify(e),this.#l=new Map,this.#p=new Map;const t=new Map,r=new Map,o=new Map;Object.keys(e).forEach((e=>{t.set(e,new Set),r.set(e,[]),o.set(e,new Set)}));for(const o in e){const s=new Set;for(const a of e[o]){(0,n.assertArgument)(!s.has(a.name),`duplicate variable name ${JSON.stringify(a.name)} in ${JSON.stringify(o)}`,"types",e),s.add(a.name);const i=a.type.match(/^([^\x5b]*)(\x5b|$)/)[1]||null;(0,n.assertArgument)(i!==o,`circular type reference to ${JSON.stringify(i)}`,"types",e),h(i)||((0,n.assertArgument)(r.has(i),`unknown type ${JSON.stringify(i)}`,"types",e),r.get(i).push(o),t.get(o).add(i))}}const s=Array.from(r.keys()).filter((e=>0===r.get(e).length));(0,n.assertArgument)(0!==s.length,"missing primary type","types",e),(0,n.assertArgument)(1===s.length,`ambiguous primary types or unused types: ${s.map((e=>JSON.stringify(e))).join(", ")}`,"types",e),(0,n.defineProperties)(this,{primaryType:s[0]}),function s(a,i){(0,n.assertArgument)(!i.has(a),`circular type reference to ${JSON.stringify(a)}`,"types",e),i.add(a);for(const e of t.get(a))if(r.has(e)){s(e,i);for(const t of i)o.get(t).add(e)}i.delete(a)}(this.primaryType,new Set);for(const[t,r]of o){const o=Array.from(r);o.sort(),this.#l.set(t,T(t,e[t])+o.map((t=>T(t,e[t]))).join(""))}}getEncoder(e){let t=this.#p.get(e);return t||(t=this.#g(e),this.#p.set(e,t)),t}#g(e){{const t=h(e);if(t)return t}const t=e.match(/^(.*)(\x5b(\d*)\x5d)$/);if(t){const e=t[1],r=this.getEncoder(e);return o=>{(0,n.assertArgument)(!t[3]||parseInt(t[3])===o.length,`array length mismatch; expected length ${parseInt(t[3])}`,"value",o);let s=o.map(r);return this.#l.has(e)&&(s=s.map(n.keccak256)),(0,n.keccak256)((0,n.concat)(s))}}const r=this.types[e];if(r){const t=(0,n.id)(this.#l.get(e));return e=>{const o=r.map((({name:t,type:r})=>{const o=this.getEncoder(r)(e[t]);return this.#l.has(r)?(0,n.keccak256)(o):o}));return o.unshift(t),(0,n.concat)(o)}}(0,n.assertArgument)(!1,`unknown type: ${e}`,"type",e)}encodeType(e){const t=this.#l.get(e);return(0,n.assertArgument)(t,`unknown type: ${JSON.stringify(e)}`,"name",e),t}encodeData(e,t){return this.getEncoder(e)(t)}hashStruct(e,t){return(0,n.keccak256)(this.encodeData(e,t))}encode(e){return this.encodeData(this.primaryType,e)}hash(e){return this.hashStruct(this.primaryType,e)}_visit(e,t,r){if(h(e))return r(e,t);const o=e.match(/^(.*)(\x5b(\d*)\x5d)$/);if(o)return(0,n.assertArgument)(!o[3]||parseInt(o[3])===t.length,`array length mismatch; expected length ${parseInt(o[3])}`,"value",t),t.map((e=>this._visit(o[1],e,r)));const s=this.types[e];if(s)return s.reduce(((e,{name:o,type:n})=>(e[o]=this._visit(n,t[o],r),e)),{});(0,n.assertArgument)(!1,`unknown type: ${e}`,"type",e)}visit(e,t){return this._visit(this.primaryType,e,t)}static from(e){return new W(e)}static getPrimaryType(e){return W.from(e).primaryType}static hashStruct(e,t,r){return W.from(t).hashStruct(e,r)}static hashDomain(e){const t=[];for(const r in e){if(null==e[r])continue;const o=g[r];(0,n.assertArgument)(o,`invalid typed-data domain key: ${JSON.stringify(r)}`,"domain",e),t.push({name:r,type:o})}return t.sort(((e,t)=>f.indexOf(e.name)-f.indexOf(t.name))),W.hashStruct("EIP712Domain",{EIP712Domain:t},e)}static encode(e,t,r){return(0,n.concat)(["0x1901",W.hashDomain(e),W.from(t).hash(r)])}static hash(e,t,r){return(0,n.keccak256)(W.encode(e,t,r))}static async resolveNames(e,t,r,o){e=Object.assign({},e);for(const t in e)null==e[t]&&delete e[t];const s={};e.verifyingContract&&!(0,n.isHexString)(e.verifyingContract,20)&&(s[e.verifyingContract]="0x");const a=W.from(t);a.visit(r,((e,t)=>("address"!==e||(0,n.isHexString)(t,20)||(s[t]="0x"),t)));for(const e in s)s[e]=await o(e);return e.verifyingContract&&s[e.verifyingContract]&&(e.verifyingContract=s[e.verifyingContract]),{domain:e,value:r=a.visit(r,((e,t)=>"address"===e&&s[t]?s[t]:t))}}static getPayload(e,t,r){W.hashDomain(e);const o={},s=[];f.forEach((t=>{const r=e[t];null!=r&&(o[t]=b[t](r),s.push({name:t,type:g[t]}))}));const a=W.from(t),i=Object.assign({},t);return(0,n.assertArgument)(null==i.EIP712Domain,"types must not contain EIP712Domain type","types.EIP712Domain",t),i.EIP712Domain=s,a.encode(r),{types:i,domain:o,primaryType:a.primaryType,message:a.visit(r,((e,t)=>{if(e.match(/^bytes(\d*)/))return(0,n.hexlify)((0,n.getBytes)(t));if(e.match(/^u?int/))return(0,n.getBigInt)(t).toString();switch(e){case"trcToken":return(0,n.getBigInt)(t).toString();case"address":return t.toLowerCase();case"bool":return!!t;case"string":return(0,n.assertArgument)("string"==typeof t,"invalid string","value",t),t}(0,n.assertArgument)(!1,"unsupported type","type",e)}))}}}t.TypedDataEncoder=W},3331:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.isValidURL=function(e){return"string"==typeof e&&s.default.isURL(e.toString(),{protocols:["http","https"],require_tld:!1})},t.isObject=i,t.isArray=c,t.isJson=function(e){try{return!!JSON.parse(e)}catch(e){return!1}},t.isBoolean=function(e){return"boolean"==typeof e},t.isBigNumber=function(e){return!!e&&(e instanceof n.BigNumber||e.constructor&&"BigNumber"===e.constructor.name)},t.isString=function(e){return"string"==typeof e||!!e&&e.constructor&&"String"===e.constructor.name},t.isFunction=function(e){return"function"==typeof e},t.isHex=function(e){return"string"==typeof e&&!isNaN(parseInt(e,16))&&/^(0x|)[a-fA-F0-9]+$/.test(e)},t.isInteger=function(e){return null!==e&&Number.isInteger(Number(e))},t.hasProperty=u,t.hasProperties=function(e,...t){return t.length&&!t.map((t=>u(e,t))).includes(!1)},t.mapEvent=function(e){const t={block:e.block_number,timestamp:e.block_timestamp,contract:e.contract_address,name:e.event_name,transaction:e.transaction_id,result:e.result,resourceNode:e.resource_Node||(e._unconfirmed?"fullNode":"solidityNode")};return e._unconfirmed&&(t.unconfirmed=e._unconfirmed),e._fingerprint&&(t.fingerprint=e._fingerprint),t},t.parseEvent=function(e,{inputs:t}){if(!e.result)return e;if(i(e.result))for(let r=0;r<t.length;r++){const o=t[r];"address"==o.type&&o.name in e.result&&(e.result[o.name]=a.ADDRESS_PREFIX+e.result[o.name].substr(2).toLowerCase())}else c(e.result)&&(e.result=e.result.reduce(((e,r,o)=>{const{name:n,type:s}=t[o];return"address"==s&&(r=a.ADDRESS_PREFIX+r.substr(2).toLowerCase()),e[n]=r,e}),{}));return e},t.padLeft=function(e,t,r){let o=e.toString();for(;o.length<r;)o=t+o;return o},t.isNotNullOrUndefined=function(e){return null!=e},t.sleep=async function(e=1e3){return new Promise((t=>setTimeout(t,e)))};const o=r(5584),n=r(2860),s=o.__importDefault(r(7906)),a=r(9055);function i(e){return e===Object(e)&&"[object Array]"!==Object.prototype.toString.call(e)}function c(e){return Array.isArray(e)}function u(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},8938:e=>{"use strict";e.exports=require("axios")},2860:e=>{"use strict";e.exports=require("bignumber.js")},3277:e=>{"use strict";e.exports=require("ethereum-cryptography/secp256k1")},9321:e=>{"use strict";e.exports=require("ethers")},1343:e=>{"use strict";e.exports=require("eventemitter3")},153:e=>{"use strict";e.exports=require("google-protobuf")},5056:e=>{"use strict";e.exports=require("google-protobuf/google/protobuf/any_pb.js")},8064:e=>{"use strict";e.exports=require("semver")},5584:e=>{"use strict";e.exports=require("tslib")},7906:e=>{"use strict";e.exports=require("validator")},5925:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),a=r(5056);n.object.extend(proto,a),n.exportSymbol("TronWebProto.Account",null,s),n.exportSymbol("TronWebProto.Account.AccountResource",null,s),n.exportSymbol("TronWebProto.Account.Frozen",null,s),n.exportSymbol("TronWebProto.AccountId",null,s),n.exportSymbol("TronWebProto.AccountType",null,s),n.exportSymbol("TronWebProto.DelegatedResource",null,s),n.exportSymbol("TronWebProto.Exchange",null,s),n.exportSymbol("TronWebProto.Key",null,s),n.exportSymbol("TronWebProto.MarketOrderDetail",null,s),n.exportSymbol("TronWebProto.Permission",null,s),n.exportSymbol("TronWebProto.Permission.PermissionType",null,s),n.exportSymbol("TronWebProto.Proposal",null,s),n.exportSymbol("TronWebProto.Proposal.State",null,s),n.exportSymbol("TronWebProto.Transaction",null,s),n.exportSymbol("TronWebProto.Transaction.Contract",null,s),n.exportSymbol("TronWebProto.Transaction.Contract.ContractType",null,s),n.exportSymbol("TronWebProto.Transaction.Result",null,s),n.exportSymbol("TronWebProto.Transaction.Result.code",null,s),n.exportSymbol("TronWebProto.Transaction.Result.contractResult",null,s),n.exportSymbol("TronWebProto.Transaction.raw",null,s),n.exportSymbol("TronWebProto.Vote",null,s),n.exportSymbol("TronWebProto.Votes",null,s),n.exportSymbol("TronWebProto.Witness",null,s),n.exportSymbol("TronWebProto.authority",null,s),TronWebProto.AccountId=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AccountId,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountId.displayName="TronWebProto.AccountId"),TronWebProto.Vote=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.Vote,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Vote.displayName="TronWebProto.Vote"),TronWebProto.Proposal=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.Proposal.repeatedFields_,null)},n.inherits(TronWebProto.Proposal,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Proposal.displayName="TronWebProto.Proposal"),TronWebProto.Exchange=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.Exchange,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Exchange.displayName="TronWebProto.Exchange"),TronWebProto.Account=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.Account.repeatedFields_,null)},n.inherits(TronWebProto.Account,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Account.displayName="TronWebProto.Account"),TronWebProto.Account.Frozen=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.Account.Frozen,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Account.Frozen.displayName="TronWebProto.Account.Frozen"),TronWebProto.Account.AccountResource=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.Account.AccountResource,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Account.AccountResource.displayName="TronWebProto.Account.AccountResource"),TronWebProto.Key=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.Key,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Key.displayName="TronWebProto.Key"),TronWebProto.DelegatedResource=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.DelegatedResource,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.DelegatedResource.displayName="TronWebProto.DelegatedResource"),TronWebProto.authority=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.authority,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.authority.displayName="TronWebProto.authority"),TronWebProto.Permission=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.Permission.repeatedFields_,null)},n.inherits(TronWebProto.Permission,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Permission.displayName="TronWebProto.Permission"),TronWebProto.Witness=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.Witness,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Witness.displayName="TronWebProto.Witness"),TronWebProto.Votes=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.Votes.repeatedFields_,null)},n.inherits(TronWebProto.Votes,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Votes.displayName="TronWebProto.Votes"),TronWebProto.MarketOrderDetail=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.MarketOrderDetail,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.MarketOrderDetail.displayName="TronWebProto.MarketOrderDetail"),TronWebProto.Transaction=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.Transaction.repeatedFields_,null)},n.inherits(TronWebProto.Transaction,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Transaction.displayName="TronWebProto.Transaction"),TronWebProto.Transaction.Contract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.Transaction.Contract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Transaction.Contract.displayName="TronWebProto.Transaction.Contract"),TronWebProto.Transaction.Result=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.Transaction.Result.repeatedFields_,null)},n.inherits(TronWebProto.Transaction.Result,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Transaction.Result.displayName="TronWebProto.Transaction.Result"),TronWebProto.Transaction.raw=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.Transaction.raw.repeatedFields_,null)},n.inherits(TronWebProto.Transaction.raw,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.Transaction.raw.displayName="TronWebProto.Transaction.raw"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountId.prototype.toObject=function(e){return TronWebProto.AccountId.toObject(e,this)},TronWebProto.AccountId.toObject=function(e,t){var r={name:t.getName_asB64(),address:t.getAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.AccountId.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountId;return TronWebProto.AccountId.deserializeBinaryFromReader(r,t)},TronWebProto.AccountId.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setName(r);break;case 2:r=t.readBytes(),e.setAddress(r);break;default:t.skipField()}return e},TronWebProto.AccountId.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountId.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountId.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getName_asU8()).length>0&&t.writeBytes(1,r),(r=e.getAddress_asU8()).length>0&&t.writeBytes(2,r)},TronWebProto.AccountId.prototype.getName=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.AccountId.prototype.getName_asB64=function(){return o.Message.bytesAsB64(this.getName())},TronWebProto.AccountId.prototype.getName_asU8=function(){return o.Message.bytesAsU8(this.getName())},TronWebProto.AccountId.prototype.setName=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.AccountId.prototype.getAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.AccountId.prototype.getAddress_asB64=function(){return o.Message.bytesAsB64(this.getAddress())},TronWebProto.AccountId.prototype.getAddress_asU8=function(){return o.Message.bytesAsU8(this.getAddress())},TronWebProto.AccountId.prototype.setAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Vote.prototype.toObject=function(e){return TronWebProto.Vote.toObject(e,this)},TronWebProto.Vote.toObject=function(e,t){var r={voteAddress:t.getVoteAddress_asB64(),voteCount:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Vote.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Vote;return TronWebProto.Vote.deserializeBinaryFromReader(r,t)},TronWebProto.Vote.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setVoteAddress(r);break;case 2:r=t.readInt64(),e.setVoteCount(r);break;default:t.skipField()}return e},TronWebProto.Vote.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Vote.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Vote.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getVoteAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getVoteCount())&&t.writeInt64(2,r)},TronWebProto.Vote.prototype.getVoteAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.Vote.prototype.getVoteAddress_asB64=function(){return o.Message.bytesAsB64(this.getVoteAddress())},TronWebProto.Vote.prototype.getVoteAddress_asU8=function(){return o.Message.bytesAsU8(this.getVoteAddress())},TronWebProto.Vote.prototype.setVoteAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.Vote.prototype.getVoteCount=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.Vote.prototype.setVoteCount=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.Proposal.repeatedFields_=[6],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Proposal.prototype.toObject=function(e){return TronWebProto.Proposal.toObject(e,this)},TronWebProto.Proposal.toObject=function(e,t){var r,n={proposalId:o.Message.getFieldWithDefault(t,1,0),proposerAddress:t.getProposerAddress_asB64(),parametersMap:(r=t.getParametersMap())?r.toObject(e,void 0):[],expirationTime:o.Message.getFieldWithDefault(t,4,0),createTime:o.Message.getFieldWithDefault(t,5,0),approvalsList:t.getApprovalsList_asB64(),state:o.Message.getFieldWithDefault(t,7,0)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.Proposal.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Proposal;return TronWebProto.Proposal.deserializeBinaryFromReader(r,t)},TronWebProto.Proposal.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setProposalId(r);break;case 2:r=t.readBytes(),e.setProposerAddress(r);break;case 3:r=e.getParametersMap(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readInt64,o.BinaryReader.prototype.readInt64,null,0,0)}));break;case 4:r=t.readInt64(),e.setExpirationTime(r);break;case 5:r=t.readInt64(),e.setCreateTime(r);break;case 6:r=t.readBytes(),e.addApprovals(r);break;case 7:r=t.readEnum(),e.setState(r);break;default:t.skipField()}return e},TronWebProto.Proposal.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Proposal.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Proposal.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getProposalId())&&t.writeInt64(1,r),(r=e.getProposerAddress_asU8()).length>0&&t.writeBytes(2,r),(r=e.getParametersMap(!0))&&r.getLength()>0&&r.serializeBinary(3,t,o.BinaryWriter.prototype.writeInt64,o.BinaryWriter.prototype.writeInt64),0!==(r=e.getExpirationTime())&&t.writeInt64(4,r),0!==(r=e.getCreateTime())&&t.writeInt64(5,r),(r=e.getApprovalsList_asU8()).length>0&&t.writeRepeatedBytes(6,r),0!==(r=e.getState())&&t.writeEnum(7,r)},TronWebProto.Proposal.State={PENDING:0,DISAPPROVED:1,APPROVED:2,CANCELED:3},TronWebProto.Proposal.prototype.getProposalId=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.Proposal.prototype.setProposalId=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.Proposal.prototype.getProposerAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.Proposal.prototype.getProposerAddress_asB64=function(){return o.Message.bytesAsB64(this.getProposerAddress())},TronWebProto.Proposal.prototype.getProposerAddress_asU8=function(){return o.Message.bytesAsU8(this.getProposerAddress())},TronWebProto.Proposal.prototype.setProposerAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.Proposal.prototype.getParametersMap=function(e){return o.Message.getMapField(this,3,e,null)},TronWebProto.Proposal.prototype.clearParametersMap=function(){return this.getParametersMap().clear(),this},TronWebProto.Proposal.prototype.getExpirationTime=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.Proposal.prototype.setExpirationTime=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.Proposal.prototype.getCreateTime=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.Proposal.prototype.setCreateTime=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.Proposal.prototype.getApprovalsList=function(){return o.Message.getRepeatedField(this,6)},TronWebProto.Proposal.prototype.getApprovalsList_asB64=function(){return o.Message.bytesListAsB64(this.getApprovalsList())},TronWebProto.Proposal.prototype.getApprovalsList_asU8=function(){return o.Message.bytesListAsU8(this.getApprovalsList())},TronWebProto.Proposal.prototype.setApprovalsList=function(e){return o.Message.setField(this,6,e||[])},TronWebProto.Proposal.prototype.addApprovals=function(e,t){return o.Message.addToRepeatedField(this,6,e,t)},TronWebProto.Proposal.prototype.clearApprovalsList=function(){return this.setApprovalsList([])},TronWebProto.Proposal.prototype.getState=function(){return o.Message.getFieldWithDefault(this,7,0)},TronWebProto.Proposal.prototype.setState=function(e){return o.Message.setProto3EnumField(this,7,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Exchange.prototype.toObject=function(e){return TronWebProto.Exchange.toObject(e,this)},TronWebProto.Exchange.toObject=function(e,t){var r={exchangeId:o.Message.getFieldWithDefault(t,1,0),creatorAddress:t.getCreatorAddress_asB64(),createTime:o.Message.getFieldWithDefault(t,3,0),firstTokenId:t.getFirstTokenId_asB64(),firstTokenBalance:o.Message.getFieldWithDefault(t,7,0),secondTokenId:t.getSecondTokenId_asB64(),secondTokenBalance:o.Message.getFieldWithDefault(t,9,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Exchange.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Exchange;return TronWebProto.Exchange.deserializeBinaryFromReader(r,t)},TronWebProto.Exchange.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setExchangeId(r);break;case 2:r=t.readBytes(),e.setCreatorAddress(r);break;case 3:r=t.readInt64(),e.setCreateTime(r);break;case 6:r=t.readBytes(),e.setFirstTokenId(r);break;case 7:r=t.readInt64(),e.setFirstTokenBalance(r);break;case 8:r=t.readBytes(),e.setSecondTokenId(r);break;case 9:r=t.readInt64(),e.setSecondTokenBalance(r);break;default:t.skipField()}return e},TronWebProto.Exchange.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Exchange.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Exchange.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getExchangeId())&&t.writeInt64(1,r),(r=e.getCreatorAddress_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getCreateTime())&&t.writeInt64(3,r),(r=e.getFirstTokenId_asU8()).length>0&&t.writeBytes(6,r),0!==(r=e.getFirstTokenBalance())&&t.writeInt64(7,r),(r=e.getSecondTokenId_asU8()).length>0&&t.writeBytes(8,r),0!==(r=e.getSecondTokenBalance())&&t.writeInt64(9,r)},TronWebProto.Exchange.prototype.getExchangeId=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.Exchange.prototype.setExchangeId=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.Exchange.prototype.getCreatorAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.Exchange.prototype.getCreatorAddress_asB64=function(){return o.Message.bytesAsB64(this.getCreatorAddress())},TronWebProto.Exchange.prototype.getCreatorAddress_asU8=function(){return o.Message.bytesAsU8(this.getCreatorAddress())},TronWebProto.Exchange.prototype.setCreatorAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.Exchange.prototype.getCreateTime=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.Exchange.prototype.setCreateTime=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.Exchange.prototype.getFirstTokenId=function(){return o.Message.getFieldWithDefault(this,6,"")},TronWebProto.Exchange.prototype.getFirstTokenId_asB64=function(){return o.Message.bytesAsB64(this.getFirstTokenId())},TronWebProto.Exchange.prototype.getFirstTokenId_asU8=function(){return o.Message.bytesAsU8(this.getFirstTokenId())},TronWebProto.Exchange.prototype.setFirstTokenId=function(e){return o.Message.setProto3BytesField(this,6,e)},TronWebProto.Exchange.prototype.getFirstTokenBalance=function(){return o.Message.getFieldWithDefault(this,7,0)},TronWebProto.Exchange.prototype.setFirstTokenBalance=function(e){return o.Message.setProto3IntField(this,7,e)},TronWebProto.Exchange.prototype.getSecondTokenId=function(){return o.Message.getFieldWithDefault(this,8,"")},TronWebProto.Exchange.prototype.getSecondTokenId_asB64=function(){return o.Message.bytesAsB64(this.getSecondTokenId())},TronWebProto.Exchange.prototype.getSecondTokenId_asU8=function(){return o.Message.bytesAsU8(this.getSecondTokenId())},TronWebProto.Exchange.prototype.setSecondTokenId=function(e){return o.Message.setProto3BytesField(this,8,e)},TronWebProto.Exchange.prototype.getSecondTokenBalance=function(){return o.Message.getFieldWithDefault(this,9,0)},TronWebProto.Exchange.prototype.setSecondTokenBalance=function(e){return o.Message.setProto3IntField(this,9,e)},TronWebProto.Account.repeatedFields_=[5,7,16,33],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Account.prototype.toObject=function(e){return TronWebProto.Account.toObject(e,this)},TronWebProto.Account.toObject=function(e,t){var r,n={accountName:t.getAccountName_asB64(),type:o.Message.getFieldWithDefault(t,2,0),address:t.getAddress_asB64(),balance:o.Message.getFieldWithDefault(t,4,0),votesList:o.Message.toObjectList(t.getVotesList(),TronWebProto.Vote.toObject,e),assetMap:(r=t.getAssetMap())?r.toObject(e,void 0):[],assetv2Map:(r=t.getAssetv2Map())?r.toObject(e,void 0):[],frozenList:o.Message.toObjectList(t.getFrozenList(),TronWebProto.Account.Frozen.toObject,e),netUsage:o.Message.getFieldWithDefault(t,8,0),acquiredDelegatedFrozenBalanceForBandwidth:o.Message.getFieldWithDefault(t,41,0),delegatedFrozenBalanceForBandwidth:o.Message.getFieldWithDefault(t,42,0),oldTronPower:o.Message.getFieldWithDefault(t,46,0),tronPower:(r=t.getTronPower())&&TronWebProto.Account.Frozen.toObject(e,r),assetOptimized:o.Message.getBooleanFieldWithDefault(t,60,!1),createTime:o.Message.getFieldWithDefault(t,9,0),latestOprationTime:o.Message.getFieldWithDefault(t,10,0),allowance:o.Message.getFieldWithDefault(t,11,0),latestWithdrawTime:o.Message.getFieldWithDefault(t,12,0),code:t.getCode_asB64(),isWitness:o.Message.getBooleanFieldWithDefault(t,14,!1),isCommittee:o.Message.getBooleanFieldWithDefault(t,15,!1),frozenSupplyList:o.Message.toObjectList(t.getFrozenSupplyList(),TronWebProto.Account.Frozen.toObject,e),assetIssuedName:t.getAssetIssuedName_asB64(),assetIssuedId:t.getAssetIssuedId_asB64(),latestAssetOperationTimeMap:(r=t.getLatestAssetOperationTimeMap())?r.toObject(e,void 0):[],latestAssetOperationTimev2Map:(r=t.getLatestAssetOperationTimev2Map())?r.toObject(e,void 0):[],freeNetUsage:o.Message.getFieldWithDefault(t,19,0),freeAssetNetUsageMap:(r=t.getFreeAssetNetUsageMap())?r.toObject(e,void 0):[],freeAssetNetUsagev2Map:(r=t.getFreeAssetNetUsagev2Map())?r.toObject(e,void 0):[],latestConsumeTime:o.Message.getFieldWithDefault(t,21,0),latestConsumeFreeTime:o.Message.getFieldWithDefault(t,22,0),accountId:t.getAccountId_asB64(),accountResource:(r=t.getAccountResource())&&TronWebProto.Account.AccountResource.toObject(e,r),codehash:t.getCodehash_asB64(),ownerPermission:(r=t.getOwnerPermission())&&TronWebProto.Permission.toObject(e,r),witnessPermission:(r=t.getWitnessPermission())&&TronWebProto.Permission.toObject(e,r),activePermissionList:o.Message.toObjectList(t.getActivePermissionList(),TronWebProto.Permission.toObject,e)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.Account.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Account;return TronWebProto.Account.deserializeBinaryFromReader(r,t)},TronWebProto.Account.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setAccountName(r);break;case 2:r=t.readEnum(),e.setType(r);break;case 3:r=t.readBytes(),e.setAddress(r);break;case 4:r=t.readInt64(),e.setBalance(r);break;case 5:r=new TronWebProto.Vote,t.readMessage(r,TronWebProto.Vote.deserializeBinaryFromReader),e.addVotes(r);break;case 6:r=e.getAssetMap(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readString,o.BinaryReader.prototype.readInt64,null,"",0)}));break;case 56:r=e.getAssetv2Map(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readString,o.BinaryReader.prototype.readInt64,null,"",0)}));break;case 7:r=new TronWebProto.Account.Frozen,t.readMessage(r,TronWebProto.Account.Frozen.deserializeBinaryFromReader),e.addFrozen(r);break;case 8:r=t.readInt64(),e.setNetUsage(r);break;case 41:r=t.readInt64(),e.setAcquiredDelegatedFrozenBalanceForBandwidth(r);break;case 42:r=t.readInt64(),e.setDelegatedFrozenBalanceForBandwidth(r);break;case 46:r=t.readInt64(),e.setOldTronPower(r);break;case 47:r=new TronWebProto.Account.Frozen,t.readMessage(r,TronWebProto.Account.Frozen.deserializeBinaryFromReader),e.setTronPower(r);break;case 60:r=t.readBool(),e.setAssetOptimized(r);break;case 9:r=t.readInt64(),e.setCreateTime(r);break;case 10:r=t.readInt64(),e.setLatestOprationTime(r);break;case 11:r=t.readInt64(),e.setAllowance(r);break;case 12:r=t.readInt64(),e.setLatestWithdrawTime(r);break;case 13:r=t.readBytes(),e.setCode(r);break;case 14:r=t.readBool(),e.setIsWitness(r);break;case 15:r=t.readBool(),e.setIsCommittee(r);break;case 16:r=new TronWebProto.Account.Frozen,t.readMessage(r,TronWebProto.Account.Frozen.deserializeBinaryFromReader),e.addFrozenSupply(r);break;case 17:r=t.readBytes(),e.setAssetIssuedName(r);break;case 57:r=t.readBytes(),e.setAssetIssuedId(r);break;case 18:r=e.getLatestAssetOperationTimeMap(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readString,o.BinaryReader.prototype.readInt64,null,"",0)}));break;case 58:r=e.getLatestAssetOperationTimev2Map(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readString,o.BinaryReader.prototype.readInt64,null,"",0)}));break;case 19:r=t.readInt64(),e.setFreeNetUsage(r);break;case 20:r=e.getFreeAssetNetUsageMap(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readString,o.BinaryReader.prototype.readInt64,null,"",0)}));break;case 59:r=e.getFreeAssetNetUsagev2Map(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readString,o.BinaryReader.prototype.readInt64,null,"",0)}));break;case 21:r=t.readInt64(),e.setLatestConsumeTime(r);break;case 22:r=t.readInt64(),e.setLatestConsumeFreeTime(r);break;case 23:r=t.readBytes(),e.setAccountId(r);break;case 26:r=new TronWebProto.Account.AccountResource,t.readMessage(r,TronWebProto.Account.AccountResource.deserializeBinaryFromReader),e.setAccountResource(r);break;case 30:r=t.readBytes(),e.setCodehash(r);break;case 31:r=new TronWebProto.Permission,t.readMessage(r,TronWebProto.Permission.deserializeBinaryFromReader),e.setOwnerPermission(r);break;case 32:r=new TronWebProto.Permission,t.readMessage(r,TronWebProto.Permission.deserializeBinaryFromReader),e.setWitnessPermission(r);break;case 33:r=new TronWebProto.Permission,t.readMessage(r,TronWebProto.Permission.deserializeBinaryFromReader),e.addActivePermission(r);break;default:t.skipField()}return e},TronWebProto.Account.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Account.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Account.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAccountName_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getType())&&t.writeEnum(2,r),(r=e.getAddress_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getBalance())&&t.writeInt64(4,r),(r=e.getVotesList()).length>0&&t.writeRepeatedMessage(5,r,TronWebProto.Vote.serializeBinaryToWriter),(r=e.getAssetMap(!0))&&r.getLength()>0&&r.serializeBinary(6,t,o.BinaryWriter.prototype.writeString,o.BinaryWriter.prototype.writeInt64),(r=e.getAssetv2Map(!0))&&r.getLength()>0&&r.serializeBinary(56,t,o.BinaryWriter.prototype.writeString,o.BinaryWriter.prototype.writeInt64),(r=e.getFrozenList()).length>0&&t.writeRepeatedMessage(7,r,TronWebProto.Account.Frozen.serializeBinaryToWriter),0!==(r=e.getNetUsage())&&t.writeInt64(8,r),0!==(r=e.getAcquiredDelegatedFrozenBalanceForBandwidth())&&t.writeInt64(41,r),0!==(r=e.getDelegatedFrozenBalanceForBandwidth())&&t.writeInt64(42,r),0!==(r=e.getOldTronPower())&&t.writeInt64(46,r),null!=(r=e.getTronPower())&&t.writeMessage(47,r,TronWebProto.Account.Frozen.serializeBinaryToWriter),(r=e.getAssetOptimized())&&t.writeBool(60,r),0!==(r=e.getCreateTime())&&t.writeInt64(9,r),0!==(r=e.getLatestOprationTime())&&t.writeInt64(10,r),0!==(r=e.getAllowance())&&t.writeInt64(11,r),0!==(r=e.getLatestWithdrawTime())&&t.writeInt64(12,r),(r=e.getCode_asU8()).length>0&&t.writeBytes(13,r),(r=e.getIsWitness())&&t.writeBool(14,r),(r=e.getIsCommittee())&&t.writeBool(15,r),(r=e.getFrozenSupplyList()).length>0&&t.writeRepeatedMessage(16,r,TronWebProto.Account.Frozen.serializeBinaryToWriter),(r=e.getAssetIssuedName_asU8()).length>0&&t.writeBytes(17,r),(r=e.getAssetIssuedId_asU8()).length>0&&t.writeBytes(57,r),(r=e.getLatestAssetOperationTimeMap(!0))&&r.getLength()>0&&r.serializeBinary(18,t,o.BinaryWriter.prototype.writeString,o.BinaryWriter.prototype.writeInt64),(r=e.getLatestAssetOperationTimev2Map(!0))&&r.getLength()>0&&r.serializeBinary(58,t,o.BinaryWriter.prototype.writeString,o.BinaryWriter.prototype.writeInt64),0!==(r=e.getFreeNetUsage())&&t.writeInt64(19,r),(r=e.getFreeAssetNetUsageMap(!0))&&r.getLength()>0&&r.serializeBinary(20,t,o.BinaryWriter.prototype.writeString,o.BinaryWriter.prototype.writeInt64),(r=e.getFreeAssetNetUsagev2Map(!0))&&r.getLength()>0&&r.serializeBinary(59,t,o.BinaryWriter.prototype.writeString,o.BinaryWriter.prototype.writeInt64),0!==(r=e.getLatestConsumeTime())&&t.writeInt64(21,r),0!==(r=e.getLatestConsumeFreeTime())&&t.writeInt64(22,r),(r=e.getAccountId_asU8()).length>0&&t.writeBytes(23,r),null!=(r=e.getAccountResource())&&t.writeMessage(26,r,TronWebProto.Account.AccountResource.serializeBinaryToWriter),(r=e.getCodehash_asU8()).length>0&&t.writeBytes(30,r),null!=(r=e.getOwnerPermission())&&t.writeMessage(31,r,TronWebProto.Permission.serializeBinaryToWriter),null!=(r=e.getWitnessPermission())&&t.writeMessage(32,r,TronWebProto.Permission.serializeBinaryToWriter),(r=e.getActivePermissionList()).length>0&&t.writeRepeatedMessage(33,r,TronWebProto.Permission.serializeBinaryToWriter)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Account.Frozen.prototype.toObject=function(e){return TronWebProto.Account.Frozen.toObject(e,this)},TronWebProto.Account.Frozen.toObject=function(e,t){var r={frozenBalance:o.Message.getFieldWithDefault(t,1,0),expireTime:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Account.Frozen.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Account.Frozen;return TronWebProto.Account.Frozen.deserializeBinaryFromReader(r,t)},TronWebProto.Account.Frozen.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setFrozenBalance(r);break;case 2:r=t.readInt64(),e.setExpireTime(r);break;default:t.skipField()}return e},TronWebProto.Account.Frozen.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Account.Frozen.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Account.Frozen.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getFrozenBalance())&&t.writeInt64(1,r),0!==(r=e.getExpireTime())&&t.writeInt64(2,r)},TronWebProto.Account.Frozen.prototype.getFrozenBalance=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.Account.Frozen.prototype.setFrozenBalance=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.Account.Frozen.prototype.getExpireTime=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.Account.Frozen.prototype.setExpireTime=function(e){return o.Message.setProto3IntField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Account.AccountResource.prototype.toObject=function(e){return TronWebProto.Account.AccountResource.toObject(e,this)},TronWebProto.Account.AccountResource.toObject=function(e,t){var r,n={energyUsage:o.Message.getFieldWithDefault(t,1,0),frozenBalanceForEnergy:(r=t.getFrozenBalanceForEnergy())&&TronWebProto.Account.Frozen.toObject(e,r),latestConsumeTimeForEnergy:o.Message.getFieldWithDefault(t,3,0),acquiredDelegatedFrozenBalanceForEnergy:o.Message.getFieldWithDefault(t,4,0),delegatedFrozenBalanceForEnergy:o.Message.getFieldWithDefault(t,5,0),storageLimit:o.Message.getFieldWithDefault(t,6,0),storageUsage:o.Message.getFieldWithDefault(t,7,0),latestExchangeStorageTime:o.Message.getFieldWithDefault(t,8,0)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.Account.AccountResource.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Account.AccountResource;return TronWebProto.Account.AccountResource.deserializeBinaryFromReader(r,t)},TronWebProto.Account.AccountResource.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setEnergyUsage(r);break;case 2:r=new TronWebProto.Account.Frozen,t.readMessage(r,TronWebProto.Account.Frozen.deserializeBinaryFromReader),e.setFrozenBalanceForEnergy(r);break;case 3:r=t.readInt64(),e.setLatestConsumeTimeForEnergy(r);break;case 4:r=t.readInt64(),e.setAcquiredDelegatedFrozenBalanceForEnergy(r);break;case 5:r=t.readInt64(),e.setDelegatedFrozenBalanceForEnergy(r);break;case 6:r=t.readInt64(),e.setStorageLimit(r);break;case 7:r=t.readInt64(),e.setStorageUsage(r);break;case 8:r=t.readInt64(),e.setLatestExchangeStorageTime(r);break;default:t.skipField()}return e},TronWebProto.Account.AccountResource.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Account.AccountResource.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Account.AccountResource.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getEnergyUsage())&&t.writeInt64(1,r),null!=(r=e.getFrozenBalanceForEnergy())&&t.writeMessage(2,r,TronWebProto.Account.Frozen.serializeBinaryToWriter),0!==(r=e.getLatestConsumeTimeForEnergy())&&t.writeInt64(3,r),0!==(r=e.getAcquiredDelegatedFrozenBalanceForEnergy())&&t.writeInt64(4,r),0!==(r=e.getDelegatedFrozenBalanceForEnergy())&&t.writeInt64(5,r),0!==(r=e.getStorageLimit())&&t.writeInt64(6,r),0!==(r=e.getStorageUsage())&&t.writeInt64(7,r),0!==(r=e.getLatestExchangeStorageTime())&&t.writeInt64(8,r)},TronWebProto.Account.AccountResource.prototype.getEnergyUsage=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.Account.AccountResource.prototype.setEnergyUsage=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.Account.AccountResource.prototype.getFrozenBalanceForEnergy=function(){return o.Message.getWrapperField(this,TronWebProto.Account.Frozen,2)},TronWebProto.Account.AccountResource.prototype.setFrozenBalanceForEnergy=function(e){return o.Message.setWrapperField(this,2,e)},TronWebProto.Account.AccountResource.prototype.clearFrozenBalanceForEnergy=function(){return this.setFrozenBalanceForEnergy(void 0)},TronWebProto.Account.AccountResource.prototype.hasFrozenBalanceForEnergy=function(){return null!=o.Message.getField(this,2)},TronWebProto.Account.AccountResource.prototype.getLatestConsumeTimeForEnergy=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.Account.AccountResource.prototype.setLatestConsumeTimeForEnergy=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.Account.AccountResource.prototype.getAcquiredDelegatedFrozenBalanceForEnergy=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.Account.AccountResource.prototype.setAcquiredDelegatedFrozenBalanceForEnergy=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.Account.AccountResource.prototype.getDelegatedFrozenBalanceForEnergy=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.Account.AccountResource.prototype.setDelegatedFrozenBalanceForEnergy=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.Account.AccountResource.prototype.getStorageLimit=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.Account.AccountResource.prototype.setStorageLimit=function(e){return o.Message.setProto3IntField(this,6,e)},TronWebProto.Account.AccountResource.prototype.getStorageUsage=function(){return o.Message.getFieldWithDefault(this,7,0)},TronWebProto.Account.AccountResource.prototype.setStorageUsage=function(e){return o.Message.setProto3IntField(this,7,e)},TronWebProto.Account.AccountResource.prototype.getLatestExchangeStorageTime=function(){return o.Message.getFieldWithDefault(this,8,0)},TronWebProto.Account.AccountResource.prototype.setLatestExchangeStorageTime=function(e){return o.Message.setProto3IntField(this,8,e)},TronWebProto.Account.prototype.getAccountName=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.Account.prototype.getAccountName_asB64=function(){return o.Message.bytesAsB64(this.getAccountName())},TronWebProto.Account.prototype.getAccountName_asU8=function(){return o.Message.bytesAsU8(this.getAccountName())},TronWebProto.Account.prototype.setAccountName=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.Account.prototype.getType=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.Account.prototype.setType=function(e){return o.Message.setProto3EnumField(this,2,e)},TronWebProto.Account.prototype.getAddress=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.Account.prototype.getAddress_asB64=function(){return o.Message.bytesAsB64(this.getAddress())},TronWebProto.Account.prototype.getAddress_asU8=function(){return o.Message.bytesAsU8(this.getAddress())},TronWebProto.Account.prototype.setAddress=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.Account.prototype.getBalance=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.Account.prototype.setBalance=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.Account.prototype.getVotesList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Vote,5)},TronWebProto.Account.prototype.setVotesList=function(e){return o.Message.setRepeatedWrapperField(this,5,e)},TronWebProto.Account.prototype.addVotes=function(e,t){return o.Message.addToRepeatedWrapperField(this,5,e,TronWebProto.Vote,t)},TronWebProto.Account.prototype.clearVotesList=function(){return this.setVotesList([])},TronWebProto.Account.prototype.getAssetMap=function(e){return o.Message.getMapField(this,6,e,null)},TronWebProto.Account.prototype.clearAssetMap=function(){return this.getAssetMap().clear(),this},TronWebProto.Account.prototype.getAssetv2Map=function(e){return o.Message.getMapField(this,56,e,null)},TronWebProto.Account.prototype.clearAssetv2Map=function(){return this.getAssetv2Map().clear(),this},TronWebProto.Account.prototype.getFrozenList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Account.Frozen,7)},TronWebProto.Account.prototype.setFrozenList=function(e){return o.Message.setRepeatedWrapperField(this,7,e)},TronWebProto.Account.prototype.addFrozen=function(e,t){return o.Message.addToRepeatedWrapperField(this,7,e,TronWebProto.Account.Frozen,t)},TronWebProto.Account.prototype.clearFrozenList=function(){return this.setFrozenList([])},TronWebProto.Account.prototype.getNetUsage=function(){return o.Message.getFieldWithDefault(this,8,0)},TronWebProto.Account.prototype.setNetUsage=function(e){return o.Message.setProto3IntField(this,8,e)},TronWebProto.Account.prototype.getAcquiredDelegatedFrozenBalanceForBandwidth=function(){return o.Message.getFieldWithDefault(this,41,0)},TronWebProto.Account.prototype.setAcquiredDelegatedFrozenBalanceForBandwidth=function(e){return o.Message.setProto3IntField(this,41,e)},TronWebProto.Account.prototype.getDelegatedFrozenBalanceForBandwidth=function(){return o.Message.getFieldWithDefault(this,42,0)},TronWebProto.Account.prototype.setDelegatedFrozenBalanceForBandwidth=function(e){return o.Message.setProto3IntField(this,42,e)},TronWebProto.Account.prototype.getOldTronPower=function(){return o.Message.getFieldWithDefault(this,46,0)},TronWebProto.Account.prototype.setOldTronPower=function(e){return o.Message.setProto3IntField(this,46,e)},TronWebProto.Account.prototype.getTronPower=function(){return o.Message.getWrapperField(this,TronWebProto.Account.Frozen,47)},TronWebProto.Account.prototype.setTronPower=function(e){return o.Message.setWrapperField(this,47,e)},TronWebProto.Account.prototype.clearTronPower=function(){return this.setTronPower(void 0)},TronWebProto.Account.prototype.hasTronPower=function(){return null!=o.Message.getField(this,47)},TronWebProto.Account.prototype.getAssetOptimized=function(){return o.Message.getBooleanFieldWithDefault(this,60,!1)},TronWebProto.Account.prototype.setAssetOptimized=function(e){return o.Message.setProto3BooleanField(this,60,e)},TronWebProto.Account.prototype.getCreateTime=function(){return o.Message.getFieldWithDefault(this,9,0)},TronWebProto.Account.prototype.setCreateTime=function(e){return o.Message.setProto3IntField(this,9,e)},TronWebProto.Account.prototype.getLatestOprationTime=function(){return o.Message.getFieldWithDefault(this,10,0)},TronWebProto.Account.prototype.setLatestOprationTime=function(e){return o.Message.setProto3IntField(this,10,e)},TronWebProto.Account.prototype.getAllowance=function(){return o.Message.getFieldWithDefault(this,11,0)},TronWebProto.Account.prototype.setAllowance=function(e){return o.Message.setProto3IntField(this,11,e)},TronWebProto.Account.prototype.getLatestWithdrawTime=function(){return o.Message.getFieldWithDefault(this,12,0)},TronWebProto.Account.prototype.setLatestWithdrawTime=function(e){return o.Message.setProto3IntField(this,12,e)},TronWebProto.Account.prototype.getCode=function(){return o.Message.getFieldWithDefault(this,13,"")},TronWebProto.Account.prototype.getCode_asB64=function(){return o.Message.bytesAsB64(this.getCode())},TronWebProto.Account.prototype.getCode_asU8=function(){return o.Message.bytesAsU8(this.getCode())},TronWebProto.Account.prototype.setCode=function(e){return o.Message.setProto3BytesField(this,13,e)},TronWebProto.Account.prototype.getIsWitness=function(){return o.Message.getBooleanFieldWithDefault(this,14,!1)},TronWebProto.Account.prototype.setIsWitness=function(e){return o.Message.setProto3BooleanField(this,14,e)},TronWebProto.Account.prototype.getIsCommittee=function(){return o.Message.getBooleanFieldWithDefault(this,15,!1)},TronWebProto.Account.prototype.setIsCommittee=function(e){return o.Message.setProto3BooleanField(this,15,e)},TronWebProto.Account.prototype.getFrozenSupplyList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Account.Frozen,16)},TronWebProto.Account.prototype.setFrozenSupplyList=function(e){return o.Message.setRepeatedWrapperField(this,16,e)},TronWebProto.Account.prototype.addFrozenSupply=function(e,t){return o.Message.addToRepeatedWrapperField(this,16,e,TronWebProto.Account.Frozen,t)},TronWebProto.Account.prototype.clearFrozenSupplyList=function(){return this.setFrozenSupplyList([])},TronWebProto.Account.prototype.getAssetIssuedName=function(){return o.Message.getFieldWithDefault(this,17,"")},TronWebProto.Account.prototype.getAssetIssuedName_asB64=function(){return o.Message.bytesAsB64(this.getAssetIssuedName())},TronWebProto.Account.prototype.getAssetIssuedName_asU8=function(){return o.Message.bytesAsU8(this.getAssetIssuedName())},TronWebProto.Account.prototype.setAssetIssuedName=function(e){return o.Message.setProto3BytesField(this,17,e)},TronWebProto.Account.prototype.getAssetIssuedId=function(){return o.Message.getFieldWithDefault(this,57,"")},TronWebProto.Account.prototype.getAssetIssuedId_asB64=function(){return o.Message.bytesAsB64(this.getAssetIssuedId())},TronWebProto.Account.prototype.getAssetIssuedId_asU8=function(){return o.Message.bytesAsU8(this.getAssetIssuedId())},TronWebProto.Account.prototype.setAssetIssuedId=function(e){return o.Message.setProto3BytesField(this,57,e)},TronWebProto.Account.prototype.getLatestAssetOperationTimeMap=function(e){return o.Message.getMapField(this,18,e,null)},TronWebProto.Account.prototype.clearLatestAssetOperationTimeMap=function(){return this.getLatestAssetOperationTimeMap().clear(),this},TronWebProto.Account.prototype.getLatestAssetOperationTimev2Map=function(e){return o.Message.getMapField(this,58,e,null)},TronWebProto.Account.prototype.clearLatestAssetOperationTimev2Map=function(){return this.getLatestAssetOperationTimev2Map().clear(),this},TronWebProto.Account.prototype.getFreeNetUsage=function(){return o.Message.getFieldWithDefault(this,19,0)},TronWebProto.Account.prototype.setFreeNetUsage=function(e){return o.Message.setProto3IntField(this,19,e)},TronWebProto.Account.prototype.getFreeAssetNetUsageMap=function(e){return o.Message.getMapField(this,20,e,null)},TronWebProto.Account.prototype.clearFreeAssetNetUsageMap=function(){return this.getFreeAssetNetUsageMap().clear(),this},TronWebProto.Account.prototype.getFreeAssetNetUsagev2Map=function(e){return o.Message.getMapField(this,59,e,null)},TronWebProto.Account.prototype.clearFreeAssetNetUsagev2Map=function(){return this.getFreeAssetNetUsagev2Map().clear(),this},TronWebProto.Account.prototype.getLatestConsumeTime=function(){return o.Message.getFieldWithDefault(this,21,0)},TronWebProto.Account.prototype.setLatestConsumeTime=function(e){return o.Message.setProto3IntField(this,21,e)},TronWebProto.Account.prototype.getLatestConsumeFreeTime=function(){return o.Message.getFieldWithDefault(this,22,0)},TronWebProto.Account.prototype.setLatestConsumeFreeTime=function(e){return o.Message.setProto3IntField(this,22,e)},TronWebProto.Account.prototype.getAccountId=function(){return o.Message.getFieldWithDefault(this,23,"")},TronWebProto.Account.prototype.getAccountId_asB64=function(){return o.Message.bytesAsB64(this.getAccountId())},TronWebProto.Account.prototype.getAccountId_asU8=function(){return o.Message.bytesAsU8(this.getAccountId())},TronWebProto.Account.prototype.setAccountId=function(e){return o.Message.setProto3BytesField(this,23,e)},TronWebProto.Account.prototype.getAccountResource=function(){return o.Message.getWrapperField(this,TronWebProto.Account.AccountResource,26)},TronWebProto.Account.prototype.setAccountResource=function(e){return o.Message.setWrapperField(this,26,e)},TronWebProto.Account.prototype.clearAccountResource=function(){return this.setAccountResource(void 0)},TronWebProto.Account.prototype.hasAccountResource=function(){return null!=o.Message.getField(this,26)},TronWebProto.Account.prototype.getCodehash=function(){return o.Message.getFieldWithDefault(this,30,"")},TronWebProto.Account.prototype.getCodehash_asB64=function(){return o.Message.bytesAsB64(this.getCodehash())},TronWebProto.Account.prototype.getCodehash_asU8=function(){return o.Message.bytesAsU8(this.getCodehash())},TronWebProto.Account.prototype.setCodehash=function(e){return o.Message.setProto3BytesField(this,30,e)},TronWebProto.Account.prototype.getOwnerPermission=function(){return o.Message.getWrapperField(this,TronWebProto.Permission,31)},TronWebProto.Account.prototype.setOwnerPermission=function(e){return o.Message.setWrapperField(this,31,e)},TronWebProto.Account.prototype.clearOwnerPermission=function(){return this.setOwnerPermission(void 0)},TronWebProto.Account.prototype.hasOwnerPermission=function(){return null!=o.Message.getField(this,31)},TronWebProto.Account.prototype.getWitnessPermission=function(){return o.Message.getWrapperField(this,TronWebProto.Permission,32)},TronWebProto.Account.prototype.setWitnessPermission=function(e){return o.Message.setWrapperField(this,32,e)},TronWebProto.Account.prototype.clearWitnessPermission=function(){return this.setWitnessPermission(void 0)},TronWebProto.Account.prototype.hasWitnessPermission=function(){return null!=o.Message.getField(this,32)},TronWebProto.Account.prototype.getActivePermissionList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Permission,33)},TronWebProto.Account.prototype.setActivePermissionList=function(e){return o.Message.setRepeatedWrapperField(this,33,e)},TronWebProto.Account.prototype.addActivePermission=function(e,t){return o.Message.addToRepeatedWrapperField(this,33,e,TronWebProto.Permission,t)},TronWebProto.Account.prototype.clearActivePermissionList=function(){return this.setActivePermissionList([])},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Key.prototype.toObject=function(e){return TronWebProto.Key.toObject(e,this)},TronWebProto.Key.toObject=function(e,t){var r={address:t.getAddress_asB64(),weight:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Key.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Key;return TronWebProto.Key.deserializeBinaryFromReader(r,t)},TronWebProto.Key.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setAddress(r);break;case 2:r=t.readInt64(),e.setWeight(r);break;default:t.skipField()}return e},TronWebProto.Key.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Key.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Key.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getWeight())&&t.writeInt64(2,r)},TronWebProto.Key.prototype.getAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.Key.prototype.getAddress_asB64=function(){return o.Message.bytesAsB64(this.getAddress())},TronWebProto.Key.prototype.getAddress_asU8=function(){return o.Message.bytesAsU8(this.getAddress())},TronWebProto.Key.prototype.setAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.Key.prototype.getWeight=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.Key.prototype.setWeight=function(e){return o.Message.setProto3IntField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.DelegatedResource.prototype.toObject=function(e){return TronWebProto.DelegatedResource.toObject(e,this)},TronWebProto.DelegatedResource.toObject=function(e,t){var r={from:t.getFrom_asB64(),to:t.getTo_asB64(),frozenBalanceForBandwidth:o.Message.getFieldWithDefault(t,3,0),frozenBalanceForEnergy:o.Message.getFieldWithDefault(t,4,0),expireTimeForBandwidth:o.Message.getFieldWithDefault(t,5,0),expireTimeForEnergy:o.Message.getFieldWithDefault(t,6,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.DelegatedResource.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.DelegatedResource;return TronWebProto.DelegatedResource.deserializeBinaryFromReader(r,t)},TronWebProto.DelegatedResource.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setFrom(r);break;case 2:r=t.readBytes(),e.setTo(r);break;case 3:r=t.readInt64(),e.setFrozenBalanceForBandwidth(r);break;case 4:r=t.readInt64(),e.setFrozenBalanceForEnergy(r);break;case 5:r=t.readInt64(),e.setExpireTimeForBandwidth(r);break;case 6:r=t.readInt64(),e.setExpireTimeForEnergy(r);break;default:t.skipField()}return e},TronWebProto.DelegatedResource.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.DelegatedResource.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.DelegatedResource.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getFrom_asU8()).length>0&&t.writeBytes(1,r),(r=e.getTo_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getFrozenBalanceForBandwidth())&&t.writeInt64(3,r),0!==(r=e.getFrozenBalanceForEnergy())&&t.writeInt64(4,r),0!==(r=e.getExpireTimeForBandwidth())&&t.writeInt64(5,r),0!==(r=e.getExpireTimeForEnergy())&&t.writeInt64(6,r)},TronWebProto.DelegatedResource.prototype.getFrom=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.DelegatedResource.prototype.getFrom_asB64=function(){return o.Message.bytesAsB64(this.getFrom())},TronWebProto.DelegatedResource.prototype.getFrom_asU8=function(){return o.Message.bytesAsU8(this.getFrom())},TronWebProto.DelegatedResource.prototype.setFrom=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.DelegatedResource.prototype.getTo=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.DelegatedResource.prototype.getTo_asB64=function(){return o.Message.bytesAsB64(this.getTo())},TronWebProto.DelegatedResource.prototype.getTo_asU8=function(){return o.Message.bytesAsU8(this.getTo())},TronWebProto.DelegatedResource.prototype.setTo=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.DelegatedResource.prototype.getFrozenBalanceForBandwidth=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.DelegatedResource.prototype.setFrozenBalanceForBandwidth=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.DelegatedResource.prototype.getFrozenBalanceForEnergy=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.DelegatedResource.prototype.setFrozenBalanceForEnergy=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.DelegatedResource.prototype.getExpireTimeForBandwidth=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.DelegatedResource.prototype.setExpireTimeForBandwidth=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.DelegatedResource.prototype.getExpireTimeForEnergy=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.DelegatedResource.prototype.setExpireTimeForEnergy=function(e){return o.Message.setProto3IntField(this,6,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.authority.prototype.toObject=function(e){return TronWebProto.authority.toObject(e,this)},TronWebProto.authority.toObject=function(e,t){var r,o={account:(r=t.getAccount())&&TronWebProto.AccountId.toObject(e,r),permissionName:t.getPermissionName_asB64()};return e&&(o.$jspbMessageInstance=t),o}),TronWebProto.authority.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.authority;return TronWebProto.authority.deserializeBinaryFromReader(r,t)},TronWebProto.authority.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new TronWebProto.AccountId;t.readMessage(r,TronWebProto.AccountId.deserializeBinaryFromReader),e.setAccount(r);break;case 2:r=t.readBytes(),e.setPermissionName(r);break;default:t.skipField()}return e},TronWebProto.authority.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.authority.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.authority.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getAccount())&&t.writeMessage(1,r,TronWebProto.AccountId.serializeBinaryToWriter),(r=e.getPermissionName_asU8()).length>0&&t.writeBytes(2,r)},TronWebProto.authority.prototype.getAccount=function(){return o.Message.getWrapperField(this,TronWebProto.AccountId,1)},TronWebProto.authority.prototype.setAccount=function(e){return o.Message.setWrapperField(this,1,e)},TronWebProto.authority.prototype.clearAccount=function(){return this.setAccount(void 0)},TronWebProto.authority.prototype.hasAccount=function(){return null!=o.Message.getField(this,1)},TronWebProto.authority.prototype.getPermissionName=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.authority.prototype.getPermissionName_asB64=function(){return o.Message.bytesAsB64(this.getPermissionName())},TronWebProto.authority.prototype.getPermissionName_asU8=function(){return o.Message.bytesAsU8(this.getPermissionName())},TronWebProto.authority.prototype.setPermissionName=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.Permission.repeatedFields_=[7],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Permission.prototype.toObject=function(e){return TronWebProto.Permission.toObject(e,this)},TronWebProto.Permission.toObject=function(e,t){var r={type:o.Message.getFieldWithDefault(t,1,0),id:o.Message.getFieldWithDefault(t,2,0),permissionName:o.Message.getFieldWithDefault(t,3,""),threshold:o.Message.getFieldWithDefault(t,4,0),parentId:o.Message.getFieldWithDefault(t,5,0),operations:t.getOperations_asB64(),keysList:o.Message.toObjectList(t.getKeysList(),TronWebProto.Key.toObject,e)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Permission.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Permission;return TronWebProto.Permission.deserializeBinaryFromReader(r,t)},TronWebProto.Permission.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readEnum();e.setType(r);break;case 2:r=t.readInt32(),e.setId(r);break;case 3:r=t.readString(),e.setPermissionName(r);break;case 4:r=t.readInt64(),e.setThreshold(r);break;case 5:r=t.readInt32(),e.setParentId(r);break;case 6:r=t.readBytes(),e.setOperations(r);break;case 7:r=new TronWebProto.Key,t.readMessage(r,TronWebProto.Key.deserializeBinaryFromReader),e.addKeys(r);break;default:t.skipField()}return e},TronWebProto.Permission.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Permission.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Permission.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getType())&&t.writeEnum(1,r),0!==(r=e.getId())&&t.writeInt32(2,r),(r=e.getPermissionName()).length>0&&t.writeString(3,r),0!==(r=e.getThreshold())&&t.writeInt64(4,r),0!==(r=e.getParentId())&&t.writeInt32(5,r),(r=e.getOperations_asU8()).length>0&&t.writeBytes(6,r),(r=e.getKeysList()).length>0&&t.writeRepeatedMessage(7,r,TronWebProto.Key.serializeBinaryToWriter)},TronWebProto.Permission.PermissionType={OWNER:0,WITNESS:1,ACTIVE:2},TronWebProto.Permission.prototype.getType=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.Permission.prototype.setType=function(e){return o.Message.setProto3EnumField(this,1,e)},TronWebProto.Permission.prototype.getId=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.Permission.prototype.setId=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.Permission.prototype.getPermissionName=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.Permission.prototype.setPermissionName=function(e){return o.Message.setProto3StringField(this,3,e)},TronWebProto.Permission.prototype.getThreshold=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.Permission.prototype.setThreshold=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.Permission.prototype.getParentId=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.Permission.prototype.setParentId=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.Permission.prototype.getOperations=function(){return o.Message.getFieldWithDefault(this,6,"")},TronWebProto.Permission.prototype.getOperations_asB64=function(){return o.Message.bytesAsB64(this.getOperations())},TronWebProto.Permission.prototype.getOperations_asU8=function(){return o.Message.bytesAsU8(this.getOperations())},TronWebProto.Permission.prototype.setOperations=function(e){return o.Message.setProto3BytesField(this,6,e)},TronWebProto.Permission.prototype.getKeysList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Key,7)},TronWebProto.Permission.prototype.setKeysList=function(e){return o.Message.setRepeatedWrapperField(this,7,e)},TronWebProto.Permission.prototype.addKeys=function(e,t){return o.Message.addToRepeatedWrapperField(this,7,e,TronWebProto.Key,t)},TronWebProto.Permission.prototype.clearKeysList=function(){return this.setKeysList([])},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Witness.prototype.toObject=function(e){return TronWebProto.Witness.toObject(e,this)},TronWebProto.Witness.toObject=function(e,t){var r={address:t.getAddress_asB64(),votecount:o.Message.getFieldWithDefault(t,2,0),pubkey:t.getPubkey_asB64(),url:o.Message.getFieldWithDefault(t,4,""),totalproduced:o.Message.getFieldWithDefault(t,5,0),totalmissed:o.Message.getFieldWithDefault(t,6,0),latestblocknum:o.Message.getFieldWithDefault(t,7,0),latestslotnum:o.Message.getFieldWithDefault(t,8,0),isjobs:o.Message.getBooleanFieldWithDefault(t,9,!1)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Witness.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Witness;return TronWebProto.Witness.deserializeBinaryFromReader(r,t)},TronWebProto.Witness.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setAddress(r);break;case 2:r=t.readInt64(),e.setVotecount(r);break;case 3:r=t.readBytes(),e.setPubkey(r);break;case 4:r=t.readString(),e.setUrl(r);break;case 5:r=t.readInt64(),e.setTotalproduced(r);break;case 6:r=t.readInt64(),e.setTotalmissed(r);break;case 7:r=t.readInt64(),e.setLatestblocknum(r);break;case 8:r=t.readInt64(),e.setLatestslotnum(r);break;case 9:r=t.readBool(),e.setIsjobs(r);break;default:t.skipField()}return e},TronWebProto.Witness.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Witness.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Witness.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getVotecount())&&t.writeInt64(2,r),(r=e.getPubkey_asU8()).length>0&&t.writeBytes(3,r),(r=e.getUrl()).length>0&&t.writeString(4,r),0!==(r=e.getTotalproduced())&&t.writeInt64(5,r),0!==(r=e.getTotalmissed())&&t.writeInt64(6,r),0!==(r=e.getLatestblocknum())&&t.writeInt64(7,r),0!==(r=e.getLatestslotnum())&&t.writeInt64(8,r),(r=e.getIsjobs())&&t.writeBool(9,r)},TronWebProto.Witness.prototype.getAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.Witness.prototype.getAddress_asB64=function(){return o.Message.bytesAsB64(this.getAddress())},TronWebProto.Witness.prototype.getAddress_asU8=function(){return o.Message.bytesAsU8(this.getAddress())},TronWebProto.Witness.prototype.setAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.Witness.prototype.getVotecount=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.Witness.prototype.setVotecount=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.Witness.prototype.getPubkey=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.Witness.prototype.getPubkey_asB64=function(){return o.Message.bytesAsB64(this.getPubkey())},TronWebProto.Witness.prototype.getPubkey_asU8=function(){return o.Message.bytesAsU8(this.getPubkey())},TronWebProto.Witness.prototype.setPubkey=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.Witness.prototype.getUrl=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.Witness.prototype.setUrl=function(e){return o.Message.setProto3StringField(this,4,e)},TronWebProto.Witness.prototype.getTotalproduced=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.Witness.prototype.setTotalproduced=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.Witness.prototype.getTotalmissed=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.Witness.prototype.setTotalmissed=function(e){return o.Message.setProto3IntField(this,6,e)},TronWebProto.Witness.prototype.getLatestblocknum=function(){return o.Message.getFieldWithDefault(this,7,0)},TronWebProto.Witness.prototype.setLatestblocknum=function(e){return o.Message.setProto3IntField(this,7,e)},TronWebProto.Witness.prototype.getLatestslotnum=function(){return o.Message.getFieldWithDefault(this,8,0)},TronWebProto.Witness.prototype.setLatestslotnum=function(e){return o.Message.setProto3IntField(this,8,e)},TronWebProto.Witness.prototype.getIsjobs=function(){return o.Message.getBooleanFieldWithDefault(this,9,!1)},TronWebProto.Witness.prototype.setIsjobs=function(e){return o.Message.setProto3BooleanField(this,9,e)},TronWebProto.Votes.repeatedFields_=[2,3],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Votes.prototype.toObject=function(e){return TronWebProto.Votes.toObject(e,this)},TronWebProto.Votes.toObject=function(e,t){var r={address:t.getAddress_asB64(),oldVotesList:o.Message.toObjectList(t.getOldVotesList(),TronWebProto.Vote.toObject,e),newVotesList:o.Message.toObjectList(t.getNewVotesList(),TronWebProto.Vote.toObject,e)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Votes.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Votes;return TronWebProto.Votes.deserializeBinaryFromReader(r,t)},TronWebProto.Votes.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setAddress(r);break;case 2:r=new TronWebProto.Vote,t.readMessage(r,TronWebProto.Vote.deserializeBinaryFromReader),e.addOldVotes(r);break;case 3:r=new TronWebProto.Vote,t.readMessage(r,TronWebProto.Vote.deserializeBinaryFromReader),e.addNewVotes(r);break;default:t.skipField()}return e},TronWebProto.Votes.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Votes.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Votes.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getOldVotesList()).length>0&&t.writeRepeatedMessage(2,r,TronWebProto.Vote.serializeBinaryToWriter),(r=e.getNewVotesList()).length>0&&t.writeRepeatedMessage(3,r,TronWebProto.Vote.serializeBinaryToWriter)},TronWebProto.Votes.prototype.getAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.Votes.prototype.getAddress_asB64=function(){return o.Message.bytesAsB64(this.getAddress())},TronWebProto.Votes.prototype.getAddress_asU8=function(){return o.Message.bytesAsU8(this.getAddress())},TronWebProto.Votes.prototype.setAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.Votes.prototype.getOldVotesList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Vote,2)},TronWebProto.Votes.prototype.setOldVotesList=function(e){return o.Message.setRepeatedWrapperField(this,2,e)},TronWebProto.Votes.prototype.addOldVotes=function(e,t){return o.Message.addToRepeatedWrapperField(this,2,e,TronWebProto.Vote,t)},TronWebProto.Votes.prototype.clearOldVotesList=function(){return this.setOldVotesList([])},TronWebProto.Votes.prototype.getNewVotesList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Vote,3)},TronWebProto.Votes.prototype.setNewVotesList=function(e){return o.Message.setRepeatedWrapperField(this,3,e)},TronWebProto.Votes.prototype.addNewVotes=function(e,t){return o.Message.addToRepeatedWrapperField(this,3,e,TronWebProto.Vote,t)},TronWebProto.Votes.prototype.clearNewVotesList=function(){return this.setNewVotesList([])},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.MarketOrderDetail.prototype.toObject=function(e){return TronWebProto.MarketOrderDetail.toObject(e,this)},TronWebProto.MarketOrderDetail.toObject=function(e,t){var r={makerorderid:t.getMakerorderid_asB64(),takerorderid:t.getTakerorderid_asB64(),fillsellquantity:o.Message.getFieldWithDefault(t,3,0),fillbuyquantity:o.Message.getFieldWithDefault(t,4,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.MarketOrderDetail.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.MarketOrderDetail;return TronWebProto.MarketOrderDetail.deserializeBinaryFromReader(r,t)},TronWebProto.MarketOrderDetail.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setMakerorderid(r);break;case 2:r=t.readBytes(),e.setTakerorderid(r);break;case 3:r=t.readInt64(),e.setFillsellquantity(r);break;case 4:r=t.readInt64(),e.setFillbuyquantity(r);break;default:t.skipField()}return e},TronWebProto.MarketOrderDetail.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.MarketOrderDetail.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.MarketOrderDetail.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getMakerorderid_asU8()).length>0&&t.writeBytes(1,r),(r=e.getTakerorderid_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getFillsellquantity())&&t.writeInt64(3,r),0!==(r=e.getFillbuyquantity())&&t.writeInt64(4,r)},TronWebProto.MarketOrderDetail.prototype.getMakerorderid=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.MarketOrderDetail.prototype.getMakerorderid_asB64=function(){return o.Message.bytesAsB64(this.getMakerorderid())},TronWebProto.MarketOrderDetail.prototype.getMakerorderid_asU8=function(){return o.Message.bytesAsU8(this.getMakerorderid())},TronWebProto.MarketOrderDetail.prototype.setMakerorderid=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.MarketOrderDetail.prototype.getTakerorderid=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.MarketOrderDetail.prototype.getTakerorderid_asB64=function(){return o.Message.bytesAsB64(this.getTakerorderid())},TronWebProto.MarketOrderDetail.prototype.getTakerorderid_asU8=function(){return o.Message.bytesAsU8(this.getTakerorderid())},TronWebProto.MarketOrderDetail.prototype.setTakerorderid=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.MarketOrderDetail.prototype.getFillsellquantity=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.MarketOrderDetail.prototype.setFillsellquantity=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.MarketOrderDetail.prototype.getFillbuyquantity=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.MarketOrderDetail.prototype.setFillbuyquantity=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.Transaction.repeatedFields_=[2,5],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Transaction.prototype.toObject=function(e){return TronWebProto.Transaction.toObject(e,this)},TronWebProto.Transaction.toObject=function(e,t){var r,n={rawData:(r=t.getRawData())&&TronWebProto.Transaction.raw.toObject(e,r),signatureList:t.getSignatureList_asB64(),retList:o.Message.toObjectList(t.getRetList(),TronWebProto.Transaction.Result.toObject,e)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.Transaction.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Transaction;return TronWebProto.Transaction.deserializeBinaryFromReader(r,t)},TronWebProto.Transaction.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new TronWebProto.Transaction.raw;t.readMessage(r,TronWebProto.Transaction.raw.deserializeBinaryFromReader),e.setRawData(r);break;case 2:r=t.readBytes(),e.addSignature(r);break;case 5:r=new TronWebProto.Transaction.Result,t.readMessage(r,TronWebProto.Transaction.Result.deserializeBinaryFromReader),e.addRet(r);break;default:t.skipField()}return e},TronWebProto.Transaction.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Transaction.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Transaction.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getRawData())&&t.writeMessage(1,r,TronWebProto.Transaction.raw.serializeBinaryToWriter),(r=e.getSignatureList_asU8()).length>0&&t.writeRepeatedBytes(2,r),(r=e.getRetList()).length>0&&t.writeRepeatedMessage(5,r,TronWebProto.Transaction.Result.serializeBinaryToWriter)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Transaction.Contract.prototype.toObject=function(e){return TronWebProto.Transaction.Contract.toObject(e,this)},TronWebProto.Transaction.Contract.toObject=function(e,t){var r,n={type:o.Message.getFieldWithDefault(t,1,0),parameter:(r=t.getParameter())&&a.Any.toObject(e,r),provider:t.getProvider_asB64(),contractname:t.getContractname_asB64(),permissionId:o.Message.getFieldWithDefault(t,5,0)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.Transaction.Contract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Transaction.Contract;return TronWebProto.Transaction.Contract.deserializeBinaryFromReader(r,t)},TronWebProto.Transaction.Contract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readEnum();e.setType(r);break;case 2:r=new a.Any,t.readMessage(r,a.Any.deserializeBinaryFromReader),e.setParameter(r);break;case 3:r=t.readBytes(),e.setProvider(r);break;case 4:r=t.readBytes(),e.setContractname(r);break;case 5:r=t.readInt32(),e.setPermissionId(r);break;default:t.skipField()}return e},TronWebProto.Transaction.Contract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Transaction.Contract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Transaction.Contract.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getType())&&t.writeEnum(1,r),null!=(r=e.getParameter())&&t.writeMessage(2,r,a.Any.serializeBinaryToWriter),(r=e.getProvider_asU8()).length>0&&t.writeBytes(3,r),(r=e.getContractname_asU8()).length>0&&t.writeBytes(4,r),0!==(r=e.getPermissionId())&&t.writeInt32(5,r)},TronWebProto.Transaction.Contract.ContractType={ACCOUNTCREATECONTRACT:0,TRANSFERCONTRACT:1,TRANSFERASSETCONTRACT:2,VOTEASSETCONTRACT:3,VOTEWITNESSCONTRACT:4,WITNESSCREATECONTRACT:5,ASSETISSUECONTRACT:6,WITNESSUPDATECONTRACT:8,PARTICIPATEASSETISSUECONTRACT:9,ACCOUNTUPDATECONTRACT:10,FREEZEBALANCECONTRACT:11,UNFREEZEBALANCECONTRACT:12,WITHDRAWBALANCECONTRACT:13,UNFREEZEASSETCONTRACT:14,UPDATEASSETCONTRACT:15,PROPOSALCREATECONTRACT:16,PROPOSALAPPROVECONTRACT:17,PROPOSALDELETECONTRACT:18,SETACCOUNTIDCONTRACT:19,CUSTOMCONTRACT:20,CREATESMARTCONTRACT:30,TRIGGERSMARTCONTRACT:31,GETCONTRACT:32,UPDATESETTINGCONTRACT:33,EXCHANGECREATECONTRACT:41,EXCHANGEINJECTCONTRACT:42,EXCHANGEWITHDRAWCONTRACT:43,EXCHANGETRANSACTIONCONTRACT:44,UPDATEENERGYLIMITCONTRACT:45,ACCOUNTPERMISSIONUPDATECONTRACT:46,CLEARABICONTRACT:48,UPDATEBROKERAGECONTRACT:49,SHIELDEDTRANSFERCONTRACT:51,MARKETSELLASSETCONTRACT:52,MARKETCANCELORDERCONTRACT:53,FREEZEBALANCEV2CONTRACT:54,UNFREEZEBALANCEV2CONTRACT:55,WITHDRAWEXPIREUNFREEZECONTRACT:56,DELEGATERESOURCECONTRACT:57,UNDELEGATERESOURCECONTRACT:58,CANCELALLUNFREEZEV2CONTRACT:59},TronWebProto.Transaction.Contract.prototype.getType=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.Transaction.Contract.prototype.setType=function(e){return o.Message.setProto3EnumField(this,1,e)},TronWebProto.Transaction.Contract.prototype.getParameter=function(){return o.Message.getWrapperField(this,a.Any,2)},TronWebProto.Transaction.Contract.prototype.setParameter=function(e){return o.Message.setWrapperField(this,2,e)},TronWebProto.Transaction.Contract.prototype.clearParameter=function(){return this.setParameter(void 0)},TronWebProto.Transaction.Contract.prototype.hasParameter=function(){return null!=o.Message.getField(this,2)},TronWebProto.Transaction.Contract.prototype.getProvider=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.Transaction.Contract.prototype.getProvider_asB64=function(){return o.Message.bytesAsB64(this.getProvider())},TronWebProto.Transaction.Contract.prototype.getProvider_asU8=function(){return o.Message.bytesAsU8(this.getProvider())},TronWebProto.Transaction.Contract.prototype.setProvider=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.Transaction.Contract.prototype.getContractname=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.Transaction.Contract.prototype.getContractname_asB64=function(){return o.Message.bytesAsB64(this.getContractname())},TronWebProto.Transaction.Contract.prototype.getContractname_asU8=function(){return o.Message.bytesAsU8(this.getContractname())},TronWebProto.Transaction.Contract.prototype.setContractname=function(e){return o.Message.setProto3BytesField(this,4,e)},TronWebProto.Transaction.Contract.prototype.getPermissionId=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.Transaction.Contract.prototype.setPermissionId=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.Transaction.Result.repeatedFields_=[26],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Transaction.Result.prototype.toObject=function(e){return TronWebProto.Transaction.Result.toObject(e,this)},TronWebProto.Transaction.Result.toObject=function(e,t){var r={fee:o.Message.getFieldWithDefault(t,1,0),ret:o.Message.getFieldWithDefault(t,2,0),contractret:o.Message.getFieldWithDefault(t,3,0),assetissueid:o.Message.getFieldWithDefault(t,14,""),withdrawAmount:o.Message.getFieldWithDefault(t,15,0),unfreezeAmount:o.Message.getFieldWithDefault(t,16,0),exchangeReceivedAmount:o.Message.getFieldWithDefault(t,18,0),exchangeInjectAnotherAmount:o.Message.getFieldWithDefault(t,19,0),exchangeWithdrawAnotherAmount:o.Message.getFieldWithDefault(t,20,0),exchangeId:o.Message.getFieldWithDefault(t,21,0),shieldedTransactionFee:o.Message.getFieldWithDefault(t,22,0),orderid:t.getOrderid_asB64(),orderdetailsList:o.Message.toObjectList(t.getOrderdetailsList(),TronWebProto.MarketOrderDetail.toObject,e)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Transaction.Result.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Transaction.Result;return TronWebProto.Transaction.Result.deserializeBinaryFromReader(r,t)},TronWebProto.Transaction.Result.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setFee(r);break;case 2:r=t.readEnum(),e.setRet(r);break;case 3:r=t.readEnum(),e.setContractret(r);break;case 14:r=t.readString(),e.setAssetissueid(r);break;case 15:r=t.readInt64(),e.setWithdrawAmount(r);break;case 16:r=t.readInt64(),e.setUnfreezeAmount(r);break;case 18:r=t.readInt64(),e.setExchangeReceivedAmount(r);break;case 19:r=t.readInt64(),e.setExchangeInjectAnotherAmount(r);break;case 20:r=t.readInt64(),e.setExchangeWithdrawAnotherAmount(r);break;case 21:r=t.readInt64(),e.setExchangeId(r);break;case 22:r=t.readInt64(),e.setShieldedTransactionFee(r);break;case 25:r=t.readBytes(),e.setOrderid(r);break;case 26:r=new TronWebProto.MarketOrderDetail,t.readMessage(r,TronWebProto.MarketOrderDetail.deserializeBinaryFromReader),e.addOrderdetails(r);break;default:t.skipField()}return e},TronWebProto.Transaction.Result.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Transaction.Result.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Transaction.Result.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getFee())&&t.writeInt64(1,r),0!==(r=e.getRet())&&t.writeEnum(2,r),0!==(r=e.getContractret())&&t.writeEnum(3,r),(r=e.getAssetissueid()).length>0&&t.writeString(14,r),0!==(r=e.getWithdrawAmount())&&t.writeInt64(15,r),0!==(r=e.getUnfreezeAmount())&&t.writeInt64(16,r),0!==(r=e.getExchangeReceivedAmount())&&t.writeInt64(18,r),0!==(r=e.getExchangeInjectAnotherAmount())&&t.writeInt64(19,r),0!==(r=e.getExchangeWithdrawAnotherAmount())&&t.writeInt64(20,r),0!==(r=e.getExchangeId())&&t.writeInt64(21,r),0!==(r=e.getShieldedTransactionFee())&&t.writeInt64(22,r),(r=e.getOrderid_asU8()).length>0&&t.writeBytes(25,r),(r=e.getOrderdetailsList()).length>0&&t.writeRepeatedMessage(26,r,TronWebProto.MarketOrderDetail.serializeBinaryToWriter)},TronWebProto.Transaction.Result.code={SUCESS:0,FAILED:1},TronWebProto.Transaction.Result.contractResult={DEFAULT:0,SUCCESS:1,REVERT:2,BAD_JUMP_DESTINATION:3,OUT_OF_MEMORY:4,PRECOMPILED_CONTRACT:5,STACK_TOO_SMALL:6,STACK_TOO_LARGE:7,ILLEGAL_OPERATION:8,STACK_OVERFLOW:9,OUT_OF_ENERGY:10,OUT_OF_TIME:11,JVM_STACK_OVER_FLOW:12,UNKNOWN:13,TRANSFER_FAILED:14,INVALID_CODE:15},TronWebProto.Transaction.Result.prototype.getFee=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.Transaction.Result.prototype.setFee=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.Transaction.Result.prototype.getRet=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.Transaction.Result.prototype.setRet=function(e){return o.Message.setProto3EnumField(this,2,e)},TronWebProto.Transaction.Result.prototype.getContractret=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.Transaction.Result.prototype.setContractret=function(e){return o.Message.setProto3EnumField(this,3,e)},TronWebProto.Transaction.Result.prototype.getAssetissueid=function(){return o.Message.getFieldWithDefault(this,14,"")},TronWebProto.Transaction.Result.prototype.setAssetissueid=function(e){return o.Message.setProto3StringField(this,14,e)},TronWebProto.Transaction.Result.prototype.getWithdrawAmount=function(){return o.Message.getFieldWithDefault(this,15,0)},TronWebProto.Transaction.Result.prototype.setWithdrawAmount=function(e){return o.Message.setProto3IntField(this,15,e)},TronWebProto.Transaction.Result.prototype.getUnfreezeAmount=function(){return o.Message.getFieldWithDefault(this,16,0)},TronWebProto.Transaction.Result.prototype.setUnfreezeAmount=function(e){return o.Message.setProto3IntField(this,16,e)},TronWebProto.Transaction.Result.prototype.getExchangeReceivedAmount=function(){return o.Message.getFieldWithDefault(this,18,0)},TronWebProto.Transaction.Result.prototype.setExchangeReceivedAmount=function(e){return o.Message.setProto3IntField(this,18,e)},TronWebProto.Transaction.Result.prototype.getExchangeInjectAnotherAmount=function(){return o.Message.getFieldWithDefault(this,19,0)},TronWebProto.Transaction.Result.prototype.setExchangeInjectAnotherAmount=function(e){return o.Message.setProto3IntField(this,19,e)},TronWebProto.Transaction.Result.prototype.getExchangeWithdrawAnotherAmount=function(){return o.Message.getFieldWithDefault(this,20,0)},TronWebProto.Transaction.Result.prototype.setExchangeWithdrawAnotherAmount=function(e){return o.Message.setProto3IntField(this,20,e)},TronWebProto.Transaction.Result.prototype.getExchangeId=function(){return o.Message.getFieldWithDefault(this,21,0)},TronWebProto.Transaction.Result.prototype.setExchangeId=function(e){return o.Message.setProto3IntField(this,21,e)},TronWebProto.Transaction.Result.prototype.getShieldedTransactionFee=function(){return o.Message.getFieldWithDefault(this,22,0)},TronWebProto.Transaction.Result.prototype.setShieldedTransactionFee=function(e){return o.Message.setProto3IntField(this,22,e)},TronWebProto.Transaction.Result.prototype.getOrderid=function(){return o.Message.getFieldWithDefault(this,25,"")},TronWebProto.Transaction.Result.prototype.getOrderid_asB64=function(){return o.Message.bytesAsB64(this.getOrderid())},TronWebProto.Transaction.Result.prototype.getOrderid_asU8=function(){return o.Message.bytesAsU8(this.getOrderid())},TronWebProto.Transaction.Result.prototype.setOrderid=function(e){return o.Message.setProto3BytesField(this,25,e)},TronWebProto.Transaction.Result.prototype.getOrderdetailsList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.MarketOrderDetail,26)},TronWebProto.Transaction.Result.prototype.setOrderdetailsList=function(e){return o.Message.setRepeatedWrapperField(this,26,e)},TronWebProto.Transaction.Result.prototype.addOrderdetails=function(e,t){return o.Message.addToRepeatedWrapperField(this,26,e,TronWebProto.MarketOrderDetail,t)},TronWebProto.Transaction.Result.prototype.clearOrderdetailsList=function(){return this.setOrderdetailsList([])},TronWebProto.Transaction.raw.repeatedFields_=[9,11],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.Transaction.raw.prototype.toObject=function(e){return TronWebProto.Transaction.raw.toObject(e,this)},TronWebProto.Transaction.raw.toObject=function(e,t){var r={refBlockBytes:t.getRefBlockBytes_asB64(),refBlockNum:o.Message.getFieldWithDefault(t,3,0),refBlockHash:t.getRefBlockHash_asB64(),expiration:o.Message.getFieldWithDefault(t,8,0),authsList:o.Message.toObjectList(t.getAuthsList(),TronWebProto.authority.toObject,e),data:t.getData_asB64(),contractList:o.Message.toObjectList(t.getContractList(),TronWebProto.Transaction.Contract.toObject,e),scripts:t.getScripts_asB64(),timestamp:o.Message.getFieldWithDefault(t,14,0),feeLimit:o.Message.getFieldWithDefault(t,18,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.Transaction.raw.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.Transaction.raw;return TronWebProto.Transaction.raw.deserializeBinaryFromReader(r,t)},TronWebProto.Transaction.raw.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setRefBlockBytes(r);break;case 3:r=t.readInt64(),e.setRefBlockNum(r);break;case 4:r=t.readBytes(),e.setRefBlockHash(r);break;case 8:r=t.readInt64(),e.setExpiration(r);break;case 9:r=new TronWebProto.authority,t.readMessage(r,TronWebProto.authority.deserializeBinaryFromReader),e.addAuths(r);break;case 10:r=t.readBytes(),e.setData(r);break;case 11:r=new TronWebProto.Transaction.Contract,t.readMessage(r,TronWebProto.Transaction.Contract.deserializeBinaryFromReader),e.addContract(r);break;case 12:r=t.readBytes(),e.setScripts(r);break;case 14:r=t.readInt64(),e.setTimestamp(r);break;case 18:r=t.readInt64(),e.setFeeLimit(r);break;default:t.skipField()}return e},TronWebProto.Transaction.raw.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.Transaction.raw.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.Transaction.raw.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getRefBlockBytes_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getRefBlockNum())&&t.writeInt64(3,r),(r=e.getRefBlockHash_asU8()).length>0&&t.writeBytes(4,r),0!==(r=e.getExpiration())&&t.writeInt64(8,r),(r=e.getAuthsList()).length>0&&t.writeRepeatedMessage(9,r,TronWebProto.authority.serializeBinaryToWriter),(r=e.getData_asU8()).length>0&&t.writeBytes(10,r),(r=e.getContractList()).length>0&&t.writeRepeatedMessage(11,r,TronWebProto.Transaction.Contract.serializeBinaryToWriter),(r=e.getScripts_asU8()).length>0&&t.writeBytes(12,r),0!==(r=e.getTimestamp())&&t.writeInt64(14,r),0!==(r=e.getFeeLimit())&&t.writeInt64(18,r)},TronWebProto.Transaction.raw.prototype.getRefBlockBytes=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.Transaction.raw.prototype.getRefBlockBytes_asB64=function(){return o.Message.bytesAsB64(this.getRefBlockBytes())},TronWebProto.Transaction.raw.prototype.getRefBlockBytes_asU8=function(){return o.Message.bytesAsU8(this.getRefBlockBytes())},TronWebProto.Transaction.raw.prototype.setRefBlockBytes=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.Transaction.raw.prototype.getRefBlockNum=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.Transaction.raw.prototype.setRefBlockNum=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.Transaction.raw.prototype.getRefBlockHash=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.Transaction.raw.prototype.getRefBlockHash_asB64=function(){return o.Message.bytesAsB64(this.getRefBlockHash())},TronWebProto.Transaction.raw.prototype.getRefBlockHash_asU8=function(){return o.Message.bytesAsU8(this.getRefBlockHash())},TronWebProto.Transaction.raw.prototype.setRefBlockHash=function(e){return o.Message.setProto3BytesField(this,4,e)},TronWebProto.Transaction.raw.prototype.getExpiration=function(){return o.Message.getFieldWithDefault(this,8,0)},TronWebProto.Transaction.raw.prototype.setExpiration=function(e){return o.Message.setProto3IntField(this,8,e)},TronWebProto.Transaction.raw.prototype.getAuthsList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.authority,9)},TronWebProto.Transaction.raw.prototype.setAuthsList=function(e){return o.Message.setRepeatedWrapperField(this,9,e)},TronWebProto.Transaction.raw.prototype.addAuths=function(e,t){return o.Message.addToRepeatedWrapperField(this,9,e,TronWebProto.authority,t)},TronWebProto.Transaction.raw.prototype.clearAuthsList=function(){return this.setAuthsList([])},TronWebProto.Transaction.raw.prototype.getData=function(){return o.Message.getFieldWithDefault(this,10,"")},TronWebProto.Transaction.raw.prototype.getData_asB64=function(){return o.Message.bytesAsB64(this.getData())},TronWebProto.Transaction.raw.prototype.getData_asU8=function(){return o.Message.bytesAsU8(this.getData())},TronWebProto.Transaction.raw.prototype.setData=function(e){return o.Message.setProto3BytesField(this,10,e)},TronWebProto.Transaction.raw.prototype.getContractList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Transaction.Contract,11)},TronWebProto.Transaction.raw.prototype.setContractList=function(e){return o.Message.setRepeatedWrapperField(this,11,e)},TronWebProto.Transaction.raw.prototype.addContract=function(e,t){return o.Message.addToRepeatedWrapperField(this,11,e,TronWebProto.Transaction.Contract,t)},TronWebProto.Transaction.raw.prototype.clearContractList=function(){return this.setContractList([])},TronWebProto.Transaction.raw.prototype.getScripts=function(){return o.Message.getFieldWithDefault(this,12,"")},TronWebProto.Transaction.raw.prototype.getScripts_asB64=function(){return o.Message.bytesAsB64(this.getScripts())},TronWebProto.Transaction.raw.prototype.getScripts_asU8=function(){return o.Message.bytesAsU8(this.getScripts())},TronWebProto.Transaction.raw.prototype.setScripts=function(e){return o.Message.setProto3BytesField(this,12,e)},TronWebProto.Transaction.raw.prototype.getTimestamp=function(){return o.Message.getFieldWithDefault(this,14,0)},TronWebProto.Transaction.raw.prototype.setTimestamp=function(e){return o.Message.setProto3IntField(this,14,e)},TronWebProto.Transaction.raw.prototype.getFeeLimit=function(){return o.Message.getFieldWithDefault(this,18,0)},TronWebProto.Transaction.raw.prototype.setFeeLimit=function(e){return o.Message.setProto3IntField(this,18,e)},TronWebProto.Transaction.prototype.getRawData=function(){return o.Message.getWrapperField(this,TronWebProto.Transaction.raw,1)},TronWebProto.Transaction.prototype.setRawData=function(e){return o.Message.setWrapperField(this,1,e)},TronWebProto.Transaction.prototype.clearRawData=function(){return this.setRawData(void 0)},TronWebProto.Transaction.prototype.hasRawData=function(){return null!=o.Message.getField(this,1)},TronWebProto.Transaction.prototype.getSignatureList=function(){return o.Message.getRepeatedField(this,2)},TronWebProto.Transaction.prototype.getSignatureList_asB64=function(){return o.Message.bytesListAsB64(this.getSignatureList())},TronWebProto.Transaction.prototype.getSignatureList_asU8=function(){return o.Message.bytesListAsU8(this.getSignatureList())},TronWebProto.Transaction.prototype.setSignatureList=function(e){return o.Message.setField(this,2,e||[])},TronWebProto.Transaction.prototype.addSignature=function(e,t){return o.Message.addToRepeatedField(this,2,e,t)},TronWebProto.Transaction.prototype.clearSignatureList=function(){return this.setSignatureList([])},TronWebProto.Transaction.prototype.getRetList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.Transaction.Result,5)},TronWebProto.Transaction.prototype.setRetList=function(e){return o.Message.setRepeatedWrapperField(this,5,e)},TronWebProto.Transaction.prototype.addRet=function(e,t){return o.Message.addToRepeatedWrapperField(this,5,e,TronWebProto.Transaction.Result,t)},TronWebProto.Transaction.prototype.clearRetList=function(){return this.setRetList([])},TronWebProto.AccountType={NORMAL:0,ASSETISSUE:1,CONTRACT:2},n.object.extend(t,TronWebProto)},549:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),a=r(5925);n.object.extend(proto,a),n.exportSymbol("TronWebProto.AccountCreateContract",null,s),n.exportSymbol("TronWebProto.AccountPermissionUpdateContract",null,s),n.exportSymbol("TronWebProto.AccountUpdateContract",null,s),n.exportSymbol("TronWebProto.SetAccountIdContract",null,s),TronWebProto.AccountCreateContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AccountCreateContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountCreateContract.displayName="TronWebProto.AccountCreateContract"),TronWebProto.AccountUpdateContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AccountUpdateContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountUpdateContract.displayName="TronWebProto.AccountUpdateContract"),TronWebProto.SetAccountIdContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.SetAccountIdContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.SetAccountIdContract.displayName="TronWebProto.SetAccountIdContract"),TronWebProto.AccountPermissionUpdateContract=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.AccountPermissionUpdateContract.repeatedFields_,null)},n.inherits(TronWebProto.AccountPermissionUpdateContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountPermissionUpdateContract.displayName="TronWebProto.AccountPermissionUpdateContract"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountCreateContract.prototype.toObject=function(e){return TronWebProto.AccountCreateContract.toObject(e,this)},TronWebProto.AccountCreateContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),accountAddress:t.getAccountAddress_asB64(),type:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.AccountCreateContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountCreateContract;return TronWebProto.AccountCreateContract.deserializeBinaryFromReader(r,t)},TronWebProto.AccountCreateContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setAccountAddress(r);break;case 3:r=t.readEnum(),e.setType(r);break;default:t.skipField()}return e},TronWebProto.AccountCreateContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountCreateContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountCreateContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getAccountAddress_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getType())&&t.writeEnum(3,r)},TronWebProto.AccountCreateContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.AccountCreateContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.AccountCreateContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.AccountCreateContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.AccountCreateContract.prototype.getAccountAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.AccountCreateContract.prototype.getAccountAddress_asB64=function(){return o.Message.bytesAsB64(this.getAccountAddress())},TronWebProto.AccountCreateContract.prototype.getAccountAddress_asU8=function(){return o.Message.bytesAsU8(this.getAccountAddress())},TronWebProto.AccountCreateContract.prototype.setAccountAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.AccountCreateContract.prototype.getType=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.AccountCreateContract.prototype.setType=function(e){return o.Message.setProto3EnumField(this,3,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountUpdateContract.prototype.toObject=function(e){return TronWebProto.AccountUpdateContract.toObject(e,this)},TronWebProto.AccountUpdateContract.toObject=function(e,t){var r={accountName:t.getAccountName_asB64(),ownerAddress:t.getOwnerAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.AccountUpdateContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountUpdateContract;return TronWebProto.AccountUpdateContract.deserializeBinaryFromReader(r,t)},TronWebProto.AccountUpdateContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setAccountName(r);break;case 2:r=t.readBytes(),e.setOwnerAddress(r);break;default:t.skipField()}return e},TronWebProto.AccountUpdateContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountUpdateContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountUpdateContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAccountName_asU8()).length>0&&t.writeBytes(1,r),(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(2,r)},TronWebProto.AccountUpdateContract.prototype.getAccountName=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.AccountUpdateContract.prototype.getAccountName_asB64=function(){return o.Message.bytesAsB64(this.getAccountName())},TronWebProto.AccountUpdateContract.prototype.getAccountName_asU8=function(){return o.Message.bytesAsU8(this.getAccountName())},TronWebProto.AccountUpdateContract.prototype.setAccountName=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.AccountUpdateContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.AccountUpdateContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.AccountUpdateContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.AccountUpdateContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.SetAccountIdContract.prototype.toObject=function(e){return TronWebProto.SetAccountIdContract.toObject(e,this)},TronWebProto.SetAccountIdContract.toObject=function(e,t){var r={accountId:t.getAccountId_asB64(),ownerAddress:t.getOwnerAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.SetAccountIdContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.SetAccountIdContract;return TronWebProto.SetAccountIdContract.deserializeBinaryFromReader(r,t)},TronWebProto.SetAccountIdContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setAccountId(r);break;case 2:r=t.readBytes(),e.setOwnerAddress(r);break;default:t.skipField()}return e},TronWebProto.SetAccountIdContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.SetAccountIdContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.SetAccountIdContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAccountId_asU8()).length>0&&t.writeBytes(1,r),(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(2,r)},TronWebProto.SetAccountIdContract.prototype.getAccountId=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.SetAccountIdContract.prototype.getAccountId_asB64=function(){return o.Message.bytesAsB64(this.getAccountId())},TronWebProto.SetAccountIdContract.prototype.getAccountId_asU8=function(){return o.Message.bytesAsU8(this.getAccountId())},TronWebProto.SetAccountIdContract.prototype.setAccountId=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.SetAccountIdContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.SetAccountIdContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.SetAccountIdContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.SetAccountIdContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.AccountPermissionUpdateContract.repeatedFields_=[4],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountPermissionUpdateContract.prototype.toObject=function(e){return TronWebProto.AccountPermissionUpdateContract.toObject(e,this)},TronWebProto.AccountPermissionUpdateContract.toObject=function(e,t){var r,n={ownerAddress:t.getOwnerAddress_asB64(),owner:(r=t.getOwner())&&a.Permission.toObject(e,r),witness:(r=t.getWitness())&&a.Permission.toObject(e,r),activesList:o.Message.toObjectList(t.getActivesList(),a.Permission.toObject,e)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.AccountPermissionUpdateContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountPermissionUpdateContract;return TronWebProto.AccountPermissionUpdateContract.deserializeBinaryFromReader(r,t)},TronWebProto.AccountPermissionUpdateContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=new a.Permission,t.readMessage(r,a.Permission.deserializeBinaryFromReader),e.setOwner(r);break;case 3:r=new a.Permission,t.readMessage(r,a.Permission.deserializeBinaryFromReader),e.setWitness(r);break;case 4:r=new a.Permission,t.readMessage(r,a.Permission.deserializeBinaryFromReader),e.addActives(r);break;default:t.skipField()}return e},TronWebProto.AccountPermissionUpdateContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountPermissionUpdateContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountPermissionUpdateContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),null!=(r=e.getOwner())&&t.writeMessage(2,r,a.Permission.serializeBinaryToWriter),null!=(r=e.getWitness())&&t.writeMessage(3,r,a.Permission.serializeBinaryToWriter),(r=e.getActivesList()).length>0&&t.writeRepeatedMessage(4,r,a.Permission.serializeBinaryToWriter)},TronWebProto.AccountPermissionUpdateContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.AccountPermissionUpdateContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.AccountPermissionUpdateContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.AccountPermissionUpdateContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.AccountPermissionUpdateContract.prototype.getOwner=function(){return o.Message.getWrapperField(this,a.Permission,2)},TronWebProto.AccountPermissionUpdateContract.prototype.setOwner=function(e){return o.Message.setWrapperField(this,2,e)},TronWebProto.AccountPermissionUpdateContract.prototype.clearOwner=function(){return this.setOwner(void 0)},TronWebProto.AccountPermissionUpdateContract.prototype.hasOwner=function(){return null!=o.Message.getField(this,2)},TronWebProto.AccountPermissionUpdateContract.prototype.getWitness=function(){return o.Message.getWrapperField(this,a.Permission,3)},TronWebProto.AccountPermissionUpdateContract.prototype.setWitness=function(e){return o.Message.setWrapperField(this,3,e)},TronWebProto.AccountPermissionUpdateContract.prototype.clearWitness=function(){return this.setWitness(void 0)},TronWebProto.AccountPermissionUpdateContract.prototype.hasWitness=function(){return null!=o.Message.getField(this,3)},TronWebProto.AccountPermissionUpdateContract.prototype.getActivesList=function(){return o.Message.getRepeatedWrapperField(this,a.Permission,4)},TronWebProto.AccountPermissionUpdateContract.prototype.setActivesList=function(e){return o.Message.setRepeatedWrapperField(this,4,e)},TronWebProto.AccountPermissionUpdateContract.prototype.addActives=function(e,t){return o.Message.addToRepeatedWrapperField(this,4,e,TronWebProto.Permission,t)},TronWebProto.AccountPermissionUpdateContract.prototype.clearActivesList=function(){return this.setActivesList([])},n.object.extend(t,TronWebProto)},8056:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();n.exportSymbol("TronWebProto.AssetIssueContract",null,s),n.exportSymbol("TronWebProto.AssetIssueContract.FrozenSupply",null,s),n.exportSymbol("TronWebProto.ParticipateAssetIssueContract",null,s),n.exportSymbol("TronWebProto.TransferAssetContract",null,s),n.exportSymbol("TronWebProto.UnfreezeAssetContract",null,s),n.exportSymbol("TronWebProto.UpdateAssetContract",null,s),TronWebProto.AssetIssueContract=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.AssetIssueContract.repeatedFields_,null)},n.inherits(TronWebProto.AssetIssueContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AssetIssueContract.displayName="TronWebProto.AssetIssueContract"),TronWebProto.AssetIssueContract.FrozenSupply=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AssetIssueContract.FrozenSupply,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AssetIssueContract.FrozenSupply.displayName="TronWebProto.AssetIssueContract.FrozenSupply"),TronWebProto.TransferAssetContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.TransferAssetContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.TransferAssetContract.displayName="TronWebProto.TransferAssetContract"),TronWebProto.UnfreezeAssetContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UnfreezeAssetContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UnfreezeAssetContract.displayName="TronWebProto.UnfreezeAssetContract"),TronWebProto.UpdateAssetContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UpdateAssetContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UpdateAssetContract.displayName="TronWebProto.UpdateAssetContract"),TronWebProto.ParticipateAssetIssueContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ParticipateAssetIssueContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ParticipateAssetIssueContract.displayName="TronWebProto.ParticipateAssetIssueContract"),TronWebProto.AssetIssueContract.repeatedFields_=[5],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AssetIssueContract.prototype.toObject=function(e){return TronWebProto.AssetIssueContract.toObject(e,this)},TronWebProto.AssetIssueContract.toObject=function(e,t){var r={id:o.Message.getFieldWithDefault(t,41,""),ownerAddress:t.getOwnerAddress_asB64(),name:t.getName_asB64(),abbr:t.getAbbr_asB64(),totalSupply:o.Message.getFieldWithDefault(t,4,0),frozenSupplyList:o.Message.toObjectList(t.getFrozenSupplyList(),TronWebProto.AssetIssueContract.FrozenSupply.toObject,e),trxNum:o.Message.getFieldWithDefault(t,6,0),precision:o.Message.getFieldWithDefault(t,7,0),num:o.Message.getFieldWithDefault(t,8,0),startTime:o.Message.getFieldWithDefault(t,9,0),endTime:o.Message.getFieldWithDefault(t,10,0),order:o.Message.getFieldWithDefault(t,11,0),voteScore:o.Message.getFieldWithDefault(t,16,0),description:t.getDescription_asB64(),url:t.getUrl_asB64(),freeAssetNetLimit:o.Message.getFieldWithDefault(t,22,0),publicFreeAssetNetLimit:o.Message.getFieldWithDefault(t,23,0),publicFreeAssetNetUsage:o.Message.getFieldWithDefault(t,24,0),publicLatestFreeNetTime:o.Message.getFieldWithDefault(t,25,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.AssetIssueContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AssetIssueContract;return TronWebProto.AssetIssueContract.deserializeBinaryFromReader(r,t)},TronWebProto.AssetIssueContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 41:var r=t.readString();e.setId(r);break;case 1:r=t.readBytes(),e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setName(r);break;case 3:r=t.readBytes(),e.setAbbr(r);break;case 4:r=t.readInt64(),e.setTotalSupply(r);break;case 5:r=new TronWebProto.AssetIssueContract.FrozenSupply,t.readMessage(r,TronWebProto.AssetIssueContract.FrozenSupply.deserializeBinaryFromReader),e.addFrozenSupply(r);break;case 6:r=t.readInt32(),e.setTrxNum(r);break;case 7:r=t.readInt32(),e.setPrecision(r);break;case 8:r=t.readInt32(),e.setNum(r);break;case 9:r=t.readInt64(),e.setStartTime(r);break;case 10:r=t.readInt64(),e.setEndTime(r);break;case 11:r=t.readInt64(),e.setOrder(r);break;case 16:r=t.readInt32(),e.setVoteScore(r);break;case 20:r=t.readBytes(),e.setDescription(r);break;case 21:r=t.readBytes(),e.setUrl(r);break;case 22:r=t.readInt64(),e.setFreeAssetNetLimit(r);break;case 23:r=t.readInt64(),e.setPublicFreeAssetNetLimit(r);break;case 24:r=t.readInt64(),e.setPublicFreeAssetNetUsage(r);break;case 25:r=t.readInt64(),e.setPublicLatestFreeNetTime(r);break;default:t.skipField()}return e},TronWebProto.AssetIssueContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AssetIssueContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AssetIssueContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getId()).length>0&&t.writeString(41,r),(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getName_asU8()).length>0&&t.writeBytes(2,r),(r=e.getAbbr_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getTotalSupply())&&t.writeInt64(4,r),(r=e.getFrozenSupplyList()).length>0&&t.writeRepeatedMessage(5,r,TronWebProto.AssetIssueContract.FrozenSupply.serializeBinaryToWriter),0!==(r=e.getTrxNum())&&t.writeInt32(6,r),0!==(r=e.getPrecision())&&t.writeInt32(7,r),0!==(r=e.getNum())&&t.writeInt32(8,r),0!==(r=e.getStartTime())&&t.writeInt64(9,r),0!==(r=e.getEndTime())&&t.writeInt64(10,r),0!==(r=e.getOrder())&&t.writeInt64(11,r),0!==(r=e.getVoteScore())&&t.writeInt32(16,r),(r=e.getDescription_asU8()).length>0&&t.writeBytes(20,r),(r=e.getUrl_asU8()).length>0&&t.writeBytes(21,r),0!==(r=e.getFreeAssetNetLimit())&&t.writeInt64(22,r),0!==(r=e.getPublicFreeAssetNetLimit())&&t.writeInt64(23,r),0!==(r=e.getPublicFreeAssetNetUsage())&&t.writeInt64(24,r),0!==(r=e.getPublicLatestFreeNetTime())&&t.writeInt64(25,r)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AssetIssueContract.FrozenSupply.prototype.toObject=function(e){return TronWebProto.AssetIssueContract.FrozenSupply.toObject(e,this)},TronWebProto.AssetIssueContract.FrozenSupply.toObject=function(e,t){var r={frozenAmount:o.Message.getFieldWithDefault(t,1,0),frozenDays:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.AssetIssueContract.FrozenSupply.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AssetIssueContract.FrozenSupply;return TronWebProto.AssetIssueContract.FrozenSupply.deserializeBinaryFromReader(r,t)},TronWebProto.AssetIssueContract.FrozenSupply.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setFrozenAmount(r);break;case 2:r=t.readInt64(),e.setFrozenDays(r);break;default:t.skipField()}return e},TronWebProto.AssetIssueContract.FrozenSupply.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AssetIssueContract.FrozenSupply.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AssetIssueContract.FrozenSupply.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getFrozenAmount())&&t.writeInt64(1,r),0!==(r=e.getFrozenDays())&&t.writeInt64(2,r)},TronWebProto.AssetIssueContract.FrozenSupply.prototype.getFrozenAmount=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.AssetIssueContract.FrozenSupply.prototype.setFrozenAmount=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.AssetIssueContract.FrozenSupply.prototype.getFrozenDays=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.AssetIssueContract.FrozenSupply.prototype.setFrozenDays=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.AssetIssueContract.prototype.getId=function(){return o.Message.getFieldWithDefault(this,41,"")},TronWebProto.AssetIssueContract.prototype.setId=function(e){return o.Message.setProto3StringField(this,41,e)},TronWebProto.AssetIssueContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.AssetIssueContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.AssetIssueContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.AssetIssueContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.AssetIssueContract.prototype.getName=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.AssetIssueContract.prototype.getName_asB64=function(){return o.Message.bytesAsB64(this.getName())},TronWebProto.AssetIssueContract.prototype.getName_asU8=function(){return o.Message.bytesAsU8(this.getName())},TronWebProto.AssetIssueContract.prototype.setName=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.AssetIssueContract.prototype.getAbbr=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.AssetIssueContract.prototype.getAbbr_asB64=function(){return o.Message.bytesAsB64(this.getAbbr())},TronWebProto.AssetIssueContract.prototype.getAbbr_asU8=function(){return o.Message.bytesAsU8(this.getAbbr())},TronWebProto.AssetIssueContract.prototype.setAbbr=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.AssetIssueContract.prototype.getTotalSupply=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.AssetIssueContract.prototype.setTotalSupply=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.AssetIssueContract.prototype.getFrozenSupplyList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.AssetIssueContract.FrozenSupply,5)},TronWebProto.AssetIssueContract.prototype.setFrozenSupplyList=function(e){return o.Message.setRepeatedWrapperField(this,5,e)},TronWebProto.AssetIssueContract.prototype.addFrozenSupply=function(e,t){return o.Message.addToRepeatedWrapperField(this,5,e,TronWebProto.AssetIssueContract.FrozenSupply,t)},TronWebProto.AssetIssueContract.prototype.clearFrozenSupplyList=function(){return this.setFrozenSupplyList([])},TronWebProto.AssetIssueContract.prototype.getTrxNum=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.AssetIssueContract.prototype.setTrxNum=function(e){return o.Message.setProto3IntField(this,6,e)},TronWebProto.AssetIssueContract.prototype.getPrecision=function(){return o.Message.getFieldWithDefault(this,7,0)},TronWebProto.AssetIssueContract.prototype.setPrecision=function(e){return o.Message.setProto3IntField(this,7,e)},TronWebProto.AssetIssueContract.prototype.getNum=function(){return o.Message.getFieldWithDefault(this,8,0)},TronWebProto.AssetIssueContract.prototype.setNum=function(e){return o.Message.setProto3IntField(this,8,e)},TronWebProto.AssetIssueContract.prototype.getStartTime=function(){return o.Message.getFieldWithDefault(this,9,0)},TronWebProto.AssetIssueContract.prototype.setStartTime=function(e){return o.Message.setProto3IntField(this,9,e)},TronWebProto.AssetIssueContract.prototype.getEndTime=function(){return o.Message.getFieldWithDefault(this,10,0)},TronWebProto.AssetIssueContract.prototype.setEndTime=function(e){return o.Message.setProto3IntField(this,10,e)},TronWebProto.AssetIssueContract.prototype.getOrder=function(){return o.Message.getFieldWithDefault(this,11,0)},TronWebProto.AssetIssueContract.prototype.setOrder=function(e){return o.Message.setProto3IntField(this,11,e)},TronWebProto.AssetIssueContract.prototype.getVoteScore=function(){return o.Message.getFieldWithDefault(this,16,0)},TronWebProto.AssetIssueContract.prototype.setVoteScore=function(e){return o.Message.setProto3IntField(this,16,e)},TronWebProto.AssetIssueContract.prototype.getDescription=function(){return o.Message.getFieldWithDefault(this,20,"")},TronWebProto.AssetIssueContract.prototype.getDescription_asB64=function(){return o.Message.bytesAsB64(this.getDescription())},TronWebProto.AssetIssueContract.prototype.getDescription_asU8=function(){return o.Message.bytesAsU8(this.getDescription())},TronWebProto.AssetIssueContract.prototype.setDescription=function(e){return o.Message.setProto3BytesField(this,20,e)},TronWebProto.AssetIssueContract.prototype.getUrl=function(){return o.Message.getFieldWithDefault(this,21,"")},TronWebProto.AssetIssueContract.prototype.getUrl_asB64=function(){return o.Message.bytesAsB64(this.getUrl())},TronWebProto.AssetIssueContract.prototype.getUrl_asU8=function(){return o.Message.bytesAsU8(this.getUrl())},TronWebProto.AssetIssueContract.prototype.setUrl=function(e){return o.Message.setProto3BytesField(this,21,e)},TronWebProto.AssetIssueContract.prototype.getFreeAssetNetLimit=function(){return o.Message.getFieldWithDefault(this,22,0)},TronWebProto.AssetIssueContract.prototype.setFreeAssetNetLimit=function(e){return o.Message.setProto3IntField(this,22,e)},TronWebProto.AssetIssueContract.prototype.getPublicFreeAssetNetLimit=function(){return o.Message.getFieldWithDefault(this,23,0)},TronWebProto.AssetIssueContract.prototype.setPublicFreeAssetNetLimit=function(e){return o.Message.setProto3IntField(this,23,e)},TronWebProto.AssetIssueContract.prototype.getPublicFreeAssetNetUsage=function(){return o.Message.getFieldWithDefault(this,24,0)},TronWebProto.AssetIssueContract.prototype.setPublicFreeAssetNetUsage=function(e){return o.Message.setProto3IntField(this,24,e)},TronWebProto.AssetIssueContract.prototype.getPublicLatestFreeNetTime=function(){return o.Message.getFieldWithDefault(this,25,0)},TronWebProto.AssetIssueContract.prototype.setPublicLatestFreeNetTime=function(e){return o.Message.setProto3IntField(this,25,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.TransferAssetContract.prototype.toObject=function(e){return TronWebProto.TransferAssetContract.toObject(e,this)},TronWebProto.TransferAssetContract.toObject=function(e,t){var r={assetName:t.getAssetName_asB64(),ownerAddress:t.getOwnerAddress_asB64(),toAddress:t.getToAddress_asB64(),amount:o.Message.getFieldWithDefault(t,4,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.TransferAssetContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.TransferAssetContract;return TronWebProto.TransferAssetContract.deserializeBinaryFromReader(r,t)},TronWebProto.TransferAssetContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setAssetName(r);break;case 2:r=t.readBytes(),e.setOwnerAddress(r);break;case 3:r=t.readBytes(),e.setToAddress(r);break;case 4:r=t.readInt64(),e.setAmount(r);break;default:t.skipField()}return e},TronWebProto.TransferAssetContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.TransferAssetContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.TransferAssetContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAssetName_asU8()).length>0&&t.writeBytes(1,r),(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(2,r),(r=e.getToAddress_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getAmount())&&t.writeInt64(4,r)},TronWebProto.TransferAssetContract.prototype.getAssetName=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.TransferAssetContract.prototype.getAssetName_asB64=function(){return o.Message.bytesAsB64(this.getAssetName())},TronWebProto.TransferAssetContract.prototype.getAssetName_asU8=function(){return o.Message.bytesAsU8(this.getAssetName())},TronWebProto.TransferAssetContract.prototype.setAssetName=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.TransferAssetContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.TransferAssetContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.TransferAssetContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.TransferAssetContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.TransferAssetContract.prototype.getToAddress=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.TransferAssetContract.prototype.getToAddress_asB64=function(){return o.Message.bytesAsB64(this.getToAddress())},TronWebProto.TransferAssetContract.prototype.getToAddress_asU8=function(){return o.Message.bytesAsU8(this.getToAddress())},TronWebProto.TransferAssetContract.prototype.setToAddress=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.TransferAssetContract.prototype.getAmount=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.TransferAssetContract.prototype.setAmount=function(e){return o.Message.setProto3IntField(this,4,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UnfreezeAssetContract.prototype.toObject=function(e){return TronWebProto.UnfreezeAssetContract.toObject(e,this)},TronWebProto.UnfreezeAssetContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UnfreezeAssetContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UnfreezeAssetContract;return TronWebProto.UnfreezeAssetContract.deserializeBinaryFromReader(r,t)},TronWebProto.UnfreezeAssetContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=t.readBytes();e.setOwnerAddress(r)}else t.skipField();return e},TronWebProto.UnfreezeAssetContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UnfreezeAssetContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UnfreezeAssetContract.serializeBinaryToWriter=function(e,t){var r;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r)},TronWebProto.UnfreezeAssetContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UnfreezeAssetContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UnfreezeAssetContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UnfreezeAssetContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UpdateAssetContract.prototype.toObject=function(e){return TronWebProto.UpdateAssetContract.toObject(e,this)},TronWebProto.UpdateAssetContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),description:t.getDescription_asB64(),url:t.getUrl_asB64(),newLimit:o.Message.getFieldWithDefault(t,4,0),newPublicLimit:o.Message.getFieldWithDefault(t,5,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UpdateAssetContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UpdateAssetContract;return TronWebProto.UpdateAssetContract.deserializeBinaryFromReader(r,t)},TronWebProto.UpdateAssetContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setDescription(r);break;case 3:r=t.readBytes(),e.setUrl(r);break;case 4:r=t.readInt64(),e.setNewLimit(r);break;case 5:r=t.readInt64(),e.setNewPublicLimit(r);break;default:t.skipField()}return e},TronWebProto.UpdateAssetContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UpdateAssetContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UpdateAssetContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getDescription_asU8()).length>0&&t.writeBytes(2,r),(r=e.getUrl_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getNewLimit())&&t.writeInt64(4,r),0!==(r=e.getNewPublicLimit())&&t.writeInt64(5,r)},TronWebProto.UpdateAssetContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UpdateAssetContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UpdateAssetContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UpdateAssetContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.UpdateAssetContract.prototype.getDescription=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.UpdateAssetContract.prototype.getDescription_asB64=function(){return o.Message.bytesAsB64(this.getDescription())},TronWebProto.UpdateAssetContract.prototype.getDescription_asU8=function(){return o.Message.bytesAsU8(this.getDescription())},TronWebProto.UpdateAssetContract.prototype.setDescription=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.UpdateAssetContract.prototype.getUrl=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.UpdateAssetContract.prototype.getUrl_asB64=function(){return o.Message.bytesAsB64(this.getUrl())},TronWebProto.UpdateAssetContract.prototype.getUrl_asU8=function(){return o.Message.bytesAsU8(this.getUrl())},TronWebProto.UpdateAssetContract.prototype.setUrl=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.UpdateAssetContract.prototype.getNewLimit=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.UpdateAssetContract.prototype.setNewLimit=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.UpdateAssetContract.prototype.getNewPublicLimit=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.UpdateAssetContract.prototype.setNewPublicLimit=function(e){return o.Message.setProto3IntField(this,5,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ParticipateAssetIssueContract.prototype.toObject=function(e){return TronWebProto.ParticipateAssetIssueContract.toObject(e,this)},TronWebProto.ParticipateAssetIssueContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),toAddress:t.getToAddress_asB64(),assetName:t.getAssetName_asB64(),amount:o.Message.getFieldWithDefault(t,4,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ParticipateAssetIssueContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ParticipateAssetIssueContract;return TronWebProto.ParticipateAssetIssueContract.deserializeBinaryFromReader(r,t)},TronWebProto.ParticipateAssetIssueContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setToAddress(r);break;case 3:r=t.readBytes(),e.setAssetName(r);break;case 4:r=t.readInt64(),e.setAmount(r);break;default:t.skipField()}return e},TronWebProto.ParticipateAssetIssueContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ParticipateAssetIssueContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ParticipateAssetIssueContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getToAddress_asU8()).length>0&&t.writeBytes(2,r),(r=e.getAssetName_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getAmount())&&t.writeInt64(4,r)},TronWebProto.ParticipateAssetIssueContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ParticipateAssetIssueContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ParticipateAssetIssueContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ParticipateAssetIssueContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ParticipateAssetIssueContract.prototype.getToAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.ParticipateAssetIssueContract.prototype.getToAddress_asB64=function(){return o.Message.bytesAsB64(this.getToAddress())},TronWebProto.ParticipateAssetIssueContract.prototype.getToAddress_asU8=function(){return o.Message.bytesAsU8(this.getToAddress())},TronWebProto.ParticipateAssetIssueContract.prototype.setToAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.ParticipateAssetIssueContract.prototype.getAssetName=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.ParticipateAssetIssueContract.prototype.getAssetName_asB64=function(){return o.Message.bytesAsB64(this.getAssetName())},TronWebProto.ParticipateAssetIssueContract.prototype.getAssetName_asU8=function(){return o.Message.bytesAsU8(this.getAssetName())},TronWebProto.ParticipateAssetIssueContract.prototype.setAssetName=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.ParticipateAssetIssueContract.prototype.getAmount=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.ParticipateAssetIssueContract.prototype.setAmount=function(e){return o.Message.setProto3IntField(this,4,e)},n.object.extend(t,TronWebProto)},6556:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),a=r(906);n.object.extend(proto,a),n.exportSymbol("TronWebProto.AccountBalanceRequest",null,s),n.exportSymbol("TronWebProto.AccountBalanceResponse",null,s),n.exportSymbol("TronWebProto.AccountIdentifier",null,s),n.exportSymbol("TronWebProto.AccountTrace",null,s),n.exportSymbol("TronWebProto.BlockBalanceTrace",null,s),n.exportSymbol("TronWebProto.BlockBalanceTrace.BlockIdentifier",null,s),n.exportSymbol("TronWebProto.CancelAllUnfreezeV2Contract",null,s),n.exportSymbol("TronWebProto.DelegateResourceContract",null,s),n.exportSymbol("TronWebProto.FreezeBalanceContract",null,s),n.exportSymbol("TronWebProto.FreezeBalanceV2Contract",null,s),n.exportSymbol("TronWebProto.TransactionBalanceTrace",null,s),n.exportSymbol("TronWebProto.TransactionBalanceTrace.Operation",null,s),n.exportSymbol("TronWebProto.TransferContract",null,s),n.exportSymbol("TronWebProto.UnDelegateResourceContract",null,s),n.exportSymbol("TronWebProto.UnfreezeBalanceContract",null,s),n.exportSymbol("TronWebProto.UnfreezeBalanceV2Contract",null,s),n.exportSymbol("TronWebProto.WithdrawBalanceContract",null,s),n.exportSymbol("TronWebProto.WithdrawExpireUnfreezeContract",null,s),TronWebProto.FreezeBalanceContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.FreezeBalanceContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.FreezeBalanceContract.displayName="TronWebProto.FreezeBalanceContract"),TronWebProto.UnfreezeBalanceContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UnfreezeBalanceContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UnfreezeBalanceContract.displayName="TronWebProto.UnfreezeBalanceContract"),TronWebProto.WithdrawBalanceContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.WithdrawBalanceContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.WithdrawBalanceContract.displayName="TronWebProto.WithdrawBalanceContract"),TronWebProto.TransferContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.TransferContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.TransferContract.displayName="TronWebProto.TransferContract"),TronWebProto.TransactionBalanceTrace=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.TransactionBalanceTrace.repeatedFields_,null)},n.inherits(TronWebProto.TransactionBalanceTrace,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.TransactionBalanceTrace.displayName="TronWebProto.TransactionBalanceTrace"),TronWebProto.TransactionBalanceTrace.Operation=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.TransactionBalanceTrace.Operation,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.TransactionBalanceTrace.Operation.displayName="TronWebProto.TransactionBalanceTrace.Operation"),TronWebProto.BlockBalanceTrace=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.BlockBalanceTrace.repeatedFields_,null)},n.inherits(TronWebProto.BlockBalanceTrace,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.BlockBalanceTrace.displayName="TronWebProto.BlockBalanceTrace"),TronWebProto.BlockBalanceTrace.BlockIdentifier=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.BlockBalanceTrace.BlockIdentifier,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.BlockBalanceTrace.BlockIdentifier.displayName="TronWebProto.BlockBalanceTrace.BlockIdentifier"),TronWebProto.AccountTrace=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AccountTrace,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountTrace.displayName="TronWebProto.AccountTrace"),TronWebProto.AccountIdentifier=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AccountIdentifier,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountIdentifier.displayName="TronWebProto.AccountIdentifier"),TronWebProto.AccountBalanceRequest=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AccountBalanceRequest,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountBalanceRequest.displayName="TronWebProto.AccountBalanceRequest"),TronWebProto.AccountBalanceResponse=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.AccountBalanceResponse,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.AccountBalanceResponse.displayName="TronWebProto.AccountBalanceResponse"),TronWebProto.FreezeBalanceV2Contract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.FreezeBalanceV2Contract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.FreezeBalanceV2Contract.displayName="TronWebProto.FreezeBalanceV2Contract"),TronWebProto.UnfreezeBalanceV2Contract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UnfreezeBalanceV2Contract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UnfreezeBalanceV2Contract.displayName="TronWebProto.UnfreezeBalanceV2Contract"),TronWebProto.WithdrawExpireUnfreezeContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.WithdrawExpireUnfreezeContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.WithdrawExpireUnfreezeContract.displayName="TronWebProto.WithdrawExpireUnfreezeContract"),TronWebProto.DelegateResourceContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.DelegateResourceContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.DelegateResourceContract.displayName="TronWebProto.DelegateResourceContract"),TronWebProto.UnDelegateResourceContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UnDelegateResourceContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UnDelegateResourceContract.displayName="TronWebProto.UnDelegateResourceContract"),TronWebProto.CancelAllUnfreezeV2Contract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.CancelAllUnfreezeV2Contract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.CancelAllUnfreezeV2Contract.displayName="TronWebProto.CancelAllUnfreezeV2Contract"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.FreezeBalanceContract.prototype.toObject=function(e){return TronWebProto.FreezeBalanceContract.toObject(e,this)},TronWebProto.FreezeBalanceContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),frozenBalance:o.Message.getFieldWithDefault(t,2,0),frozenDuration:o.Message.getFieldWithDefault(t,3,0),resource:o.Message.getFieldWithDefault(t,10,0),receiverAddress:t.getReceiverAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.FreezeBalanceContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.FreezeBalanceContract;return TronWebProto.FreezeBalanceContract.deserializeBinaryFromReader(r,t)},TronWebProto.FreezeBalanceContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setFrozenBalance(r);break;case 3:r=t.readInt64(),e.setFrozenDuration(r);break;case 10:r=t.readEnum(),e.setResource(r);break;case 15:r=t.readBytes(),e.setReceiverAddress(r);break;default:t.skipField()}return e},TronWebProto.FreezeBalanceContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.FreezeBalanceContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.FreezeBalanceContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getFrozenBalance())&&t.writeInt64(2,r),0!==(r=e.getFrozenDuration())&&t.writeInt64(3,r),0!==(r=e.getResource())&&t.writeEnum(10,r),(r=e.getReceiverAddress_asU8()).length>0&&t.writeBytes(15,r)},TronWebProto.FreezeBalanceContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.FreezeBalanceContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.FreezeBalanceContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.FreezeBalanceContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.FreezeBalanceContract.prototype.getFrozenBalance=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.FreezeBalanceContract.prototype.setFrozenBalance=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.FreezeBalanceContract.prototype.getFrozenDuration=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.FreezeBalanceContract.prototype.setFrozenDuration=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.FreezeBalanceContract.prototype.getResource=function(){return o.Message.getFieldWithDefault(this,10,0)},TronWebProto.FreezeBalanceContract.prototype.setResource=function(e){return o.Message.setProto3EnumField(this,10,e)},TronWebProto.FreezeBalanceContract.prototype.getReceiverAddress=function(){return o.Message.getFieldWithDefault(this,15,"")},TronWebProto.FreezeBalanceContract.prototype.getReceiverAddress_asB64=function(){return o.Message.bytesAsB64(this.getReceiverAddress())},TronWebProto.FreezeBalanceContract.prototype.getReceiverAddress_asU8=function(){return o.Message.bytesAsU8(this.getReceiverAddress())},TronWebProto.FreezeBalanceContract.prototype.setReceiverAddress=function(e){return o.Message.setProto3BytesField(this,15,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UnfreezeBalanceContract.prototype.toObject=function(e){return TronWebProto.UnfreezeBalanceContract.toObject(e,this)},TronWebProto.UnfreezeBalanceContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),resource:o.Message.getFieldWithDefault(t,10,0),receiverAddress:t.getReceiverAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UnfreezeBalanceContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UnfreezeBalanceContract;return TronWebProto.UnfreezeBalanceContract.deserializeBinaryFromReader(r,t)},TronWebProto.UnfreezeBalanceContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 10:r=t.readEnum(),e.setResource(r);break;case 15:r=t.readBytes(),e.setReceiverAddress(r);break;default:t.skipField()}return e},TronWebProto.UnfreezeBalanceContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UnfreezeBalanceContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UnfreezeBalanceContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getResource())&&t.writeEnum(10,r),(r=e.getReceiverAddress_asU8()).length>0&&t.writeBytes(15,r)},TronWebProto.UnfreezeBalanceContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UnfreezeBalanceContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UnfreezeBalanceContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UnfreezeBalanceContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.UnfreezeBalanceContract.prototype.getResource=function(){return o.Message.getFieldWithDefault(this,10,0)},TronWebProto.UnfreezeBalanceContract.prototype.setResource=function(e){return o.Message.setProto3EnumField(this,10,e)},TronWebProto.UnfreezeBalanceContract.prototype.getReceiverAddress=function(){return o.Message.getFieldWithDefault(this,15,"")},TronWebProto.UnfreezeBalanceContract.prototype.getReceiverAddress_asB64=function(){return o.Message.bytesAsB64(this.getReceiverAddress())},TronWebProto.UnfreezeBalanceContract.prototype.getReceiverAddress_asU8=function(){return o.Message.bytesAsU8(this.getReceiverAddress())},TronWebProto.UnfreezeBalanceContract.prototype.setReceiverAddress=function(e){return o.Message.setProto3BytesField(this,15,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.WithdrawBalanceContract.prototype.toObject=function(e){return TronWebProto.WithdrawBalanceContract.toObject(e,this)},TronWebProto.WithdrawBalanceContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.WithdrawBalanceContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.WithdrawBalanceContract;return TronWebProto.WithdrawBalanceContract.deserializeBinaryFromReader(r,t)},TronWebProto.WithdrawBalanceContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=t.readBytes();e.setOwnerAddress(r)}else t.skipField();return e},TronWebProto.WithdrawBalanceContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.WithdrawBalanceContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.WithdrawBalanceContract.serializeBinaryToWriter=function(e,t){var r;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r)},TronWebProto.WithdrawBalanceContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.WithdrawBalanceContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.WithdrawBalanceContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.WithdrawBalanceContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.TransferContract.prototype.toObject=function(e){return TronWebProto.TransferContract.toObject(e,this)},TronWebProto.TransferContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),toAddress:t.getToAddress_asB64(),amount:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.TransferContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.TransferContract;return TronWebProto.TransferContract.deserializeBinaryFromReader(r,t)},TronWebProto.TransferContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setToAddress(r);break;case 3:r=t.readInt64(),e.setAmount(r);break;default:t.skipField()}return e},TronWebProto.TransferContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.TransferContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.TransferContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getToAddress_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getAmount())&&t.writeInt64(3,r)},TronWebProto.TransferContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.TransferContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.TransferContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.TransferContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.TransferContract.prototype.getToAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.TransferContract.prototype.getToAddress_asB64=function(){return o.Message.bytesAsB64(this.getToAddress())},TronWebProto.TransferContract.prototype.getToAddress_asU8=function(){return o.Message.bytesAsU8(this.getToAddress())},TronWebProto.TransferContract.prototype.setToAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.TransferContract.prototype.getAmount=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.TransferContract.prototype.setAmount=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.TransactionBalanceTrace.repeatedFields_=[2],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.TransactionBalanceTrace.prototype.toObject=function(e){return TronWebProto.TransactionBalanceTrace.toObject(e,this)},TronWebProto.TransactionBalanceTrace.toObject=function(e,t){var r={transactionIdentifier:t.getTransactionIdentifier_asB64(),operationList:o.Message.toObjectList(t.getOperationList(),TronWebProto.TransactionBalanceTrace.Operation.toObject,e),type:o.Message.getFieldWithDefault(t,3,""),status:o.Message.getFieldWithDefault(t,4,"")};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.TransactionBalanceTrace.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.TransactionBalanceTrace;return TronWebProto.TransactionBalanceTrace.deserializeBinaryFromReader(r,t)},TronWebProto.TransactionBalanceTrace.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setTransactionIdentifier(r);break;case 2:r=new TronWebProto.TransactionBalanceTrace.Operation,t.readMessage(r,TronWebProto.TransactionBalanceTrace.Operation.deserializeBinaryFromReader),e.addOperation(r);break;case 3:r=t.readString(),e.setType(r);break;case 4:r=t.readString(),e.setStatus(r);break;default:t.skipField()}return e},TronWebProto.TransactionBalanceTrace.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.TransactionBalanceTrace.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.TransactionBalanceTrace.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getTransactionIdentifier_asU8()).length>0&&t.writeBytes(1,r),(r=e.getOperationList()).length>0&&t.writeRepeatedMessage(2,r,TronWebProto.TransactionBalanceTrace.Operation.serializeBinaryToWriter),(r=e.getType()).length>0&&t.writeString(3,r),(r=e.getStatus()).length>0&&t.writeString(4,r)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.TransactionBalanceTrace.Operation.prototype.toObject=function(e){return TronWebProto.TransactionBalanceTrace.Operation.toObject(e,this)},TronWebProto.TransactionBalanceTrace.Operation.toObject=function(e,t){var r={operationIdentifier:o.Message.getFieldWithDefault(t,1,0),address:t.getAddress_asB64(),amount:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.TransactionBalanceTrace.Operation.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.TransactionBalanceTrace.Operation;return TronWebProto.TransactionBalanceTrace.Operation.deserializeBinaryFromReader(r,t)},TronWebProto.TransactionBalanceTrace.Operation.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setOperationIdentifier(r);break;case 2:r=t.readBytes(),e.setAddress(r);break;case 3:r=t.readInt64(),e.setAmount(r);break;default:t.skipField()}return e},TronWebProto.TransactionBalanceTrace.Operation.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.TransactionBalanceTrace.Operation.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.TransactionBalanceTrace.Operation.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getOperationIdentifier())&&t.writeInt64(1,r),(r=e.getAddress_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getAmount())&&t.writeInt64(3,r)},TronWebProto.TransactionBalanceTrace.Operation.prototype.getOperationIdentifier=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.TransactionBalanceTrace.Operation.prototype.setOperationIdentifier=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.TransactionBalanceTrace.Operation.prototype.getAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.TransactionBalanceTrace.Operation.prototype.getAddress_asB64=function(){return o.Message.bytesAsB64(this.getAddress())},TronWebProto.TransactionBalanceTrace.Operation.prototype.getAddress_asU8=function(){return o.Message.bytesAsU8(this.getAddress())},TronWebProto.TransactionBalanceTrace.Operation.prototype.setAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.TransactionBalanceTrace.Operation.prototype.getAmount=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.TransactionBalanceTrace.Operation.prototype.setAmount=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.TransactionBalanceTrace.prototype.getTransactionIdentifier=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.TransactionBalanceTrace.prototype.getTransactionIdentifier_asB64=function(){return o.Message.bytesAsB64(this.getTransactionIdentifier())},TronWebProto.TransactionBalanceTrace.prototype.getTransactionIdentifier_asU8=function(){return o.Message.bytesAsU8(this.getTransactionIdentifier())},TronWebProto.TransactionBalanceTrace.prototype.setTransactionIdentifier=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.TransactionBalanceTrace.prototype.getOperationList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.TransactionBalanceTrace.Operation,2)},TronWebProto.TransactionBalanceTrace.prototype.setOperationList=function(e){return o.Message.setRepeatedWrapperField(this,2,e)},TronWebProto.TransactionBalanceTrace.prototype.addOperation=function(e,t){return o.Message.addToRepeatedWrapperField(this,2,e,TronWebProto.TransactionBalanceTrace.Operation,t)},TronWebProto.TransactionBalanceTrace.prototype.clearOperationList=function(){return this.setOperationList([])},TronWebProto.TransactionBalanceTrace.prototype.getType=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.TransactionBalanceTrace.prototype.setType=function(e){return o.Message.setProto3StringField(this,3,e)},TronWebProto.TransactionBalanceTrace.prototype.getStatus=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.TransactionBalanceTrace.prototype.setStatus=function(e){return o.Message.setProto3StringField(this,4,e)},TronWebProto.BlockBalanceTrace.repeatedFields_=[3],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.BlockBalanceTrace.prototype.toObject=function(e){return TronWebProto.BlockBalanceTrace.toObject(e,this)},TronWebProto.BlockBalanceTrace.toObject=function(e,t){var r,n={blockIdentifier:(r=t.getBlockIdentifier())&&TronWebProto.BlockBalanceTrace.BlockIdentifier.toObject(e,r),timestamp:o.Message.getFieldWithDefault(t,2,0),transactionBalanceTraceList:o.Message.toObjectList(t.getTransactionBalanceTraceList(),TronWebProto.TransactionBalanceTrace.toObject,e)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.BlockBalanceTrace.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.BlockBalanceTrace;return TronWebProto.BlockBalanceTrace.deserializeBinaryFromReader(r,t)},TronWebProto.BlockBalanceTrace.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new TronWebProto.BlockBalanceTrace.BlockIdentifier;t.readMessage(r,TronWebProto.BlockBalanceTrace.BlockIdentifier.deserializeBinaryFromReader),e.setBlockIdentifier(r);break;case 2:r=t.readInt64(),e.setTimestamp(r);break;case 3:r=new TronWebProto.TransactionBalanceTrace,t.readMessage(r,TronWebProto.TransactionBalanceTrace.deserializeBinaryFromReader),e.addTransactionBalanceTrace(r);break;default:t.skipField()}return e},TronWebProto.BlockBalanceTrace.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.BlockBalanceTrace.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.BlockBalanceTrace.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getBlockIdentifier())&&t.writeMessage(1,r,TronWebProto.BlockBalanceTrace.BlockIdentifier.serializeBinaryToWriter),0!==(r=e.getTimestamp())&&t.writeInt64(2,r),(r=e.getTransactionBalanceTraceList()).length>0&&t.writeRepeatedMessage(3,r,TronWebProto.TransactionBalanceTrace.serializeBinaryToWriter)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.toObject=function(e){return TronWebProto.BlockBalanceTrace.BlockIdentifier.toObject(e,this)},TronWebProto.BlockBalanceTrace.BlockIdentifier.toObject=function(e,t){var r={hash:t.getHash_asB64(),number:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.BlockBalanceTrace.BlockIdentifier.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.BlockBalanceTrace.BlockIdentifier;return TronWebProto.BlockBalanceTrace.BlockIdentifier.deserializeBinaryFromReader(r,t)},TronWebProto.BlockBalanceTrace.BlockIdentifier.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setHash(r);break;case 2:r=t.readInt64(),e.setNumber(r);break;default:t.skipField()}return e},TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.BlockBalanceTrace.BlockIdentifier.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.BlockBalanceTrace.BlockIdentifier.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getHash_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getNumber())&&t.writeInt64(2,r)},TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.getHash=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.getHash_asB64=function(){return o.Message.bytesAsB64(this.getHash())},TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.getHash_asU8=function(){return o.Message.bytesAsU8(this.getHash())},TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.setHash=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.getNumber=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.BlockBalanceTrace.BlockIdentifier.prototype.setNumber=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.BlockBalanceTrace.prototype.getBlockIdentifier=function(){return o.Message.getWrapperField(this,TronWebProto.BlockBalanceTrace.BlockIdentifier,1)},TronWebProto.BlockBalanceTrace.prototype.setBlockIdentifier=function(e){return o.Message.setWrapperField(this,1,e)},TronWebProto.BlockBalanceTrace.prototype.clearBlockIdentifier=function(){return this.setBlockIdentifier(void 0)},TronWebProto.BlockBalanceTrace.prototype.hasBlockIdentifier=function(){return null!=o.Message.getField(this,1)},TronWebProto.BlockBalanceTrace.prototype.getTimestamp=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.BlockBalanceTrace.prototype.setTimestamp=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.BlockBalanceTrace.prototype.getTransactionBalanceTraceList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.TransactionBalanceTrace,3)},TronWebProto.BlockBalanceTrace.prototype.setTransactionBalanceTraceList=function(e){return o.Message.setRepeatedWrapperField(this,3,e)},TronWebProto.BlockBalanceTrace.prototype.addTransactionBalanceTrace=function(e,t){return o.Message.addToRepeatedWrapperField(this,3,e,TronWebProto.TransactionBalanceTrace,t)},TronWebProto.BlockBalanceTrace.prototype.clearTransactionBalanceTraceList=function(){return this.setTransactionBalanceTraceList([])},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountTrace.prototype.toObject=function(e){return TronWebProto.AccountTrace.toObject(e,this)},TronWebProto.AccountTrace.toObject=function(e,t){var r={balance:o.Message.getFieldWithDefault(t,1,0),placeholder:o.Message.getFieldWithDefault(t,99,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.AccountTrace.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountTrace;return TronWebProto.AccountTrace.deserializeBinaryFromReader(r,t)},TronWebProto.AccountTrace.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setBalance(r);break;case 99:r=t.readInt64(),e.setPlaceholder(r);break;default:t.skipField()}return e},TronWebProto.AccountTrace.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountTrace.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountTrace.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getBalance())&&t.writeInt64(1,r),0!==(r=e.getPlaceholder())&&t.writeInt64(99,r)},TronWebProto.AccountTrace.prototype.getBalance=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.AccountTrace.prototype.setBalance=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.AccountTrace.prototype.getPlaceholder=function(){return o.Message.getFieldWithDefault(this,99,0)},TronWebProto.AccountTrace.prototype.setPlaceholder=function(e){return o.Message.setProto3IntField(this,99,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountIdentifier.prototype.toObject=function(e){return TronWebProto.AccountIdentifier.toObject(e,this)},TronWebProto.AccountIdentifier.toObject=function(e,t){var r={address:t.getAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.AccountIdentifier.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountIdentifier;return TronWebProto.AccountIdentifier.deserializeBinaryFromReader(r,t)},TronWebProto.AccountIdentifier.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=t.readBytes();e.setAddress(r)}else t.skipField();return e},TronWebProto.AccountIdentifier.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountIdentifier.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountIdentifier.serializeBinaryToWriter=function(e,t){var r;(r=e.getAddress_asU8()).length>0&&t.writeBytes(1,r)},TronWebProto.AccountIdentifier.prototype.getAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.AccountIdentifier.prototype.getAddress_asB64=function(){return o.Message.bytesAsB64(this.getAddress())},TronWebProto.AccountIdentifier.prototype.getAddress_asU8=function(){return o.Message.bytesAsU8(this.getAddress())},TronWebProto.AccountIdentifier.prototype.setAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountBalanceRequest.prototype.toObject=function(e){return TronWebProto.AccountBalanceRequest.toObject(e,this)},TronWebProto.AccountBalanceRequest.toObject=function(e,t){var r,o={accountIdentifier:(r=t.getAccountIdentifier())&&TronWebProto.AccountIdentifier.toObject(e,r),blockIdentifier:(r=t.getBlockIdentifier())&&TronWebProto.BlockBalanceTrace.BlockIdentifier.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),TronWebProto.AccountBalanceRequest.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountBalanceRequest;return TronWebProto.AccountBalanceRequest.deserializeBinaryFromReader(r,t)},TronWebProto.AccountBalanceRequest.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new TronWebProto.AccountIdentifier;t.readMessage(r,TronWebProto.AccountIdentifier.deserializeBinaryFromReader),e.setAccountIdentifier(r);break;case 2:r=new TronWebProto.BlockBalanceTrace.BlockIdentifier,t.readMessage(r,TronWebProto.BlockBalanceTrace.BlockIdentifier.deserializeBinaryFromReader),e.setBlockIdentifier(r);break;default:t.skipField()}return e},TronWebProto.AccountBalanceRequest.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountBalanceRequest.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountBalanceRequest.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getAccountIdentifier())&&t.writeMessage(1,r,TronWebProto.AccountIdentifier.serializeBinaryToWriter),null!=(r=e.getBlockIdentifier())&&t.writeMessage(2,r,TronWebProto.BlockBalanceTrace.BlockIdentifier.serializeBinaryToWriter)},TronWebProto.AccountBalanceRequest.prototype.getAccountIdentifier=function(){return o.Message.getWrapperField(this,TronWebProto.AccountIdentifier,1)},TronWebProto.AccountBalanceRequest.prototype.setAccountIdentifier=function(e){return o.Message.setWrapperField(this,1,e)},TronWebProto.AccountBalanceRequest.prototype.clearAccountIdentifier=function(){return this.setAccountIdentifier(void 0)},TronWebProto.AccountBalanceRequest.prototype.hasAccountIdentifier=function(){return null!=o.Message.getField(this,1)},TronWebProto.AccountBalanceRequest.prototype.getBlockIdentifier=function(){return o.Message.getWrapperField(this,TronWebProto.BlockBalanceTrace.BlockIdentifier,2)},TronWebProto.AccountBalanceRequest.prototype.setBlockIdentifier=function(e){return o.Message.setWrapperField(this,2,e)},TronWebProto.AccountBalanceRequest.prototype.clearBlockIdentifier=function(){return this.setBlockIdentifier(void 0)},TronWebProto.AccountBalanceRequest.prototype.hasBlockIdentifier=function(){return null!=o.Message.getField(this,2)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.AccountBalanceResponse.prototype.toObject=function(e){return TronWebProto.AccountBalanceResponse.toObject(e,this)},TronWebProto.AccountBalanceResponse.toObject=function(e,t){var r,n={balance:o.Message.getFieldWithDefault(t,1,0),blockIdentifier:(r=t.getBlockIdentifier())&&TronWebProto.BlockBalanceTrace.BlockIdentifier.toObject(e,r)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.AccountBalanceResponse.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.AccountBalanceResponse;return TronWebProto.AccountBalanceResponse.deserializeBinaryFromReader(r,t)},TronWebProto.AccountBalanceResponse.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setBalance(r);break;case 2:r=new TronWebProto.BlockBalanceTrace.BlockIdentifier,t.readMessage(r,TronWebProto.BlockBalanceTrace.BlockIdentifier.deserializeBinaryFromReader),e.setBlockIdentifier(r);break;default:t.skipField()}return e},TronWebProto.AccountBalanceResponse.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.AccountBalanceResponse.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.AccountBalanceResponse.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getBalance())&&t.writeInt64(1,r),null!=(r=e.getBlockIdentifier())&&t.writeMessage(2,r,TronWebProto.BlockBalanceTrace.BlockIdentifier.serializeBinaryToWriter)},TronWebProto.AccountBalanceResponse.prototype.getBalance=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.AccountBalanceResponse.prototype.setBalance=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.AccountBalanceResponse.prototype.getBlockIdentifier=function(){return o.Message.getWrapperField(this,TronWebProto.BlockBalanceTrace.BlockIdentifier,2)},TronWebProto.AccountBalanceResponse.prototype.setBlockIdentifier=function(e){return o.Message.setWrapperField(this,2,e)},TronWebProto.AccountBalanceResponse.prototype.clearBlockIdentifier=function(){return this.setBlockIdentifier(void 0)},TronWebProto.AccountBalanceResponse.prototype.hasBlockIdentifier=function(){return null!=o.Message.getField(this,2)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.FreezeBalanceV2Contract.prototype.toObject=function(e){return TronWebProto.FreezeBalanceV2Contract.toObject(e,this)},TronWebProto.FreezeBalanceV2Contract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),frozenBalance:o.Message.getFieldWithDefault(t,2,0),resource:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.FreezeBalanceV2Contract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.FreezeBalanceV2Contract;return TronWebProto.FreezeBalanceV2Contract.deserializeBinaryFromReader(r,t)},TronWebProto.FreezeBalanceV2Contract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setFrozenBalance(r);break;case 3:r=t.readEnum(),e.setResource(r);break;default:t.skipField()}return e},TronWebProto.FreezeBalanceV2Contract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.FreezeBalanceV2Contract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.FreezeBalanceV2Contract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getFrozenBalance())&&t.writeInt64(2,r),0!==(r=e.getResource())&&t.writeEnum(3,r)},TronWebProto.FreezeBalanceV2Contract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.FreezeBalanceV2Contract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.FreezeBalanceV2Contract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.FreezeBalanceV2Contract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.FreezeBalanceV2Contract.prototype.getFrozenBalance=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.FreezeBalanceV2Contract.prototype.setFrozenBalance=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.FreezeBalanceV2Contract.prototype.getResource=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.FreezeBalanceV2Contract.prototype.setResource=function(e){return o.Message.setProto3EnumField(this,3,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UnfreezeBalanceV2Contract.prototype.toObject=function(e){return TronWebProto.UnfreezeBalanceV2Contract.toObject(e,this)},TronWebProto.UnfreezeBalanceV2Contract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),unfreezeBalance:o.Message.getFieldWithDefault(t,2,0),resource:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UnfreezeBalanceV2Contract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UnfreezeBalanceV2Contract;return TronWebProto.UnfreezeBalanceV2Contract.deserializeBinaryFromReader(r,t)},TronWebProto.UnfreezeBalanceV2Contract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setUnfreezeBalance(r);break;case 3:r=t.readEnum(),e.setResource(r);break;default:t.skipField()}return e},TronWebProto.UnfreezeBalanceV2Contract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UnfreezeBalanceV2Contract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UnfreezeBalanceV2Contract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getUnfreezeBalance())&&t.writeInt64(2,r),0!==(r=e.getResource())&&t.writeEnum(3,r)},TronWebProto.UnfreezeBalanceV2Contract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UnfreezeBalanceV2Contract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UnfreezeBalanceV2Contract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UnfreezeBalanceV2Contract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.UnfreezeBalanceV2Contract.prototype.getUnfreezeBalance=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.UnfreezeBalanceV2Contract.prototype.setUnfreezeBalance=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.UnfreezeBalanceV2Contract.prototype.getResource=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.UnfreezeBalanceV2Contract.prototype.setResource=function(e){return o.Message.setProto3EnumField(this,3,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.WithdrawExpireUnfreezeContract.prototype.toObject=function(e){return TronWebProto.WithdrawExpireUnfreezeContract.toObject(e,this)},TronWebProto.WithdrawExpireUnfreezeContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.WithdrawExpireUnfreezeContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.WithdrawExpireUnfreezeContract;return TronWebProto.WithdrawExpireUnfreezeContract.deserializeBinaryFromReader(r,t)},TronWebProto.WithdrawExpireUnfreezeContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=t.readBytes();e.setOwnerAddress(r)}else t.skipField();return e},TronWebProto.WithdrawExpireUnfreezeContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.WithdrawExpireUnfreezeContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.WithdrawExpireUnfreezeContract.serializeBinaryToWriter=function(e,t){var r;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r)},TronWebProto.WithdrawExpireUnfreezeContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.WithdrawExpireUnfreezeContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.WithdrawExpireUnfreezeContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.WithdrawExpireUnfreezeContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.DelegateResourceContract.prototype.toObject=function(e){return TronWebProto.DelegateResourceContract.toObject(e,this)},TronWebProto.DelegateResourceContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),resource:o.Message.getFieldWithDefault(t,2,0),balance:o.Message.getFieldWithDefault(t,3,0),receiverAddress:t.getReceiverAddress_asB64(),lock:o.Message.getBooleanFieldWithDefault(t,5,!1),lockPeriod:o.Message.getFieldWithDefault(t,6,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.DelegateResourceContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.DelegateResourceContract;return TronWebProto.DelegateResourceContract.deserializeBinaryFromReader(r,t)},TronWebProto.DelegateResourceContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readEnum(),e.setResource(r);break;case 3:r=t.readInt64(),e.setBalance(r);break;case 4:r=t.readBytes(),e.setReceiverAddress(r);break;case 5:r=t.readBool(),e.setLock(r);break;case 6:r=t.readInt64(),e.setLockPeriod(r);break;default:t.skipField()}return e},TronWebProto.DelegateResourceContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.DelegateResourceContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.DelegateResourceContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getResource())&&t.writeEnum(2,r),0!==(r=e.getBalance())&&t.writeInt64(3,r),(r=e.getReceiverAddress_asU8()).length>0&&t.writeBytes(4,r),(r=e.getLock())&&t.writeBool(5,r),0!==(r=e.getLockPeriod())&&t.writeInt64(6,r)},TronWebProto.DelegateResourceContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.DelegateResourceContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.DelegateResourceContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.DelegateResourceContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.DelegateResourceContract.prototype.getResource=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.DelegateResourceContract.prototype.setResource=function(e){return o.Message.setProto3EnumField(this,2,e)},TronWebProto.DelegateResourceContract.prototype.getBalance=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.DelegateResourceContract.prototype.setBalance=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.DelegateResourceContract.prototype.getReceiverAddress=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.DelegateResourceContract.prototype.getReceiverAddress_asB64=function(){return o.Message.bytesAsB64(this.getReceiverAddress())},TronWebProto.DelegateResourceContract.prototype.getReceiverAddress_asU8=function(){return o.Message.bytesAsU8(this.getReceiverAddress())},TronWebProto.DelegateResourceContract.prototype.setReceiverAddress=function(e){return o.Message.setProto3BytesField(this,4,e)},TronWebProto.DelegateResourceContract.prototype.getLock=function(){return o.Message.getBooleanFieldWithDefault(this,5,!1)},TronWebProto.DelegateResourceContract.prototype.setLock=function(e){return o.Message.setProto3BooleanField(this,5,e)},TronWebProto.DelegateResourceContract.prototype.getLockPeriod=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.DelegateResourceContract.prototype.setLockPeriod=function(e){return o.Message.setProto3IntField(this,6,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UnDelegateResourceContract.prototype.toObject=function(e){return TronWebProto.UnDelegateResourceContract.toObject(e,this)},TronWebProto.UnDelegateResourceContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),resource:o.Message.getFieldWithDefault(t,2,0),balance:o.Message.getFieldWithDefault(t,3,0),receiverAddress:t.getReceiverAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UnDelegateResourceContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UnDelegateResourceContract;return TronWebProto.UnDelegateResourceContract.deserializeBinaryFromReader(r,t)},TronWebProto.UnDelegateResourceContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readEnum(),e.setResource(r);break;case 3:r=t.readInt64(),e.setBalance(r);break;case 4:r=t.readBytes(),e.setReceiverAddress(r);break;default:t.skipField()}return e},TronWebProto.UnDelegateResourceContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UnDelegateResourceContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UnDelegateResourceContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getResource())&&t.writeEnum(2,r),0!==(r=e.getBalance())&&t.writeInt64(3,r),(r=e.getReceiverAddress_asU8()).length>0&&t.writeBytes(4,r)},TronWebProto.UnDelegateResourceContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UnDelegateResourceContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UnDelegateResourceContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UnDelegateResourceContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.UnDelegateResourceContract.prototype.getResource=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.UnDelegateResourceContract.prototype.setResource=function(e){return o.Message.setProto3EnumField(this,2,e)},TronWebProto.UnDelegateResourceContract.prototype.getBalance=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.UnDelegateResourceContract.prototype.setBalance=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.UnDelegateResourceContract.prototype.getReceiverAddress=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.UnDelegateResourceContract.prototype.getReceiverAddress_asB64=function(){return o.Message.bytesAsB64(this.getReceiverAddress())},TronWebProto.UnDelegateResourceContract.prototype.getReceiverAddress_asU8=function(){return o.Message.bytesAsU8(this.getReceiverAddress())},TronWebProto.UnDelegateResourceContract.prototype.setReceiverAddress=function(e){return o.Message.setProto3BytesField(this,4,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.CancelAllUnfreezeV2Contract.prototype.toObject=function(e){return TronWebProto.CancelAllUnfreezeV2Contract.toObject(e,this)},TronWebProto.CancelAllUnfreezeV2Contract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.CancelAllUnfreezeV2Contract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.CancelAllUnfreezeV2Contract;return TronWebProto.CancelAllUnfreezeV2Contract.deserializeBinaryFromReader(r,t)},TronWebProto.CancelAllUnfreezeV2Contract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=t.readBytes();e.setOwnerAddress(r)}else t.skipField();return e},TronWebProto.CancelAllUnfreezeV2Contract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.CancelAllUnfreezeV2Contract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.CancelAllUnfreezeV2Contract.serializeBinaryToWriter=function(e,t){var r;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r)},TronWebProto.CancelAllUnfreezeV2Contract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.CancelAllUnfreezeV2Contract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.CancelAllUnfreezeV2Contract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.CancelAllUnfreezeV2Contract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},n.object.extend(t,TronWebProto)},906:(e,t,r)=>{var o=r(153),n="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==n&&n||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();o.exportSymbol("TronWebProto.ResourceCode",null,n),TronWebProto.ResourceCode={BANDWIDTH:0,ENERGY:1,TRON_POWER:2},o.object.extend(t,TronWebProto)},2983:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();n.exportSymbol("TronWebProto.ExchangeCreateContract",null,s),n.exportSymbol("TronWebProto.ExchangeInjectContract",null,s),n.exportSymbol("TronWebProto.ExchangeTransactionContract",null,s),n.exportSymbol("TronWebProto.ExchangeWithdrawContract",null,s),TronWebProto.ExchangeCreateContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ExchangeCreateContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ExchangeCreateContract.displayName="TronWebProto.ExchangeCreateContract"),TronWebProto.ExchangeInjectContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ExchangeInjectContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ExchangeInjectContract.displayName="TronWebProto.ExchangeInjectContract"),TronWebProto.ExchangeWithdrawContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ExchangeWithdrawContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ExchangeWithdrawContract.displayName="TronWebProto.ExchangeWithdrawContract"),TronWebProto.ExchangeTransactionContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ExchangeTransactionContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ExchangeTransactionContract.displayName="TronWebProto.ExchangeTransactionContract"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ExchangeCreateContract.prototype.toObject=function(e){return TronWebProto.ExchangeCreateContract.toObject(e,this)},TronWebProto.ExchangeCreateContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),firstTokenId:t.getFirstTokenId_asB64(),firstTokenBalance:o.Message.getFieldWithDefault(t,3,0),secondTokenId:t.getSecondTokenId_asB64(),secondTokenBalance:o.Message.getFieldWithDefault(t,5,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ExchangeCreateContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ExchangeCreateContract;return TronWebProto.ExchangeCreateContract.deserializeBinaryFromReader(r,t)},TronWebProto.ExchangeCreateContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setFirstTokenId(r);break;case 3:r=t.readInt64(),e.setFirstTokenBalance(r);break;case 4:r=t.readBytes(),e.setSecondTokenId(r);break;case 5:r=t.readInt64(),e.setSecondTokenBalance(r);break;default:t.skipField()}return e},TronWebProto.ExchangeCreateContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ExchangeCreateContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ExchangeCreateContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getFirstTokenId_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getFirstTokenBalance())&&t.writeInt64(3,r),(r=e.getSecondTokenId_asU8()).length>0&&t.writeBytes(4,r),0!==(r=e.getSecondTokenBalance())&&t.writeInt64(5,r)},TronWebProto.ExchangeCreateContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ExchangeCreateContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ExchangeCreateContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ExchangeCreateContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ExchangeCreateContract.prototype.getFirstTokenId=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.ExchangeCreateContract.prototype.getFirstTokenId_asB64=function(){return o.Message.bytesAsB64(this.getFirstTokenId())},TronWebProto.ExchangeCreateContract.prototype.getFirstTokenId_asU8=function(){return o.Message.bytesAsU8(this.getFirstTokenId())},TronWebProto.ExchangeCreateContract.prototype.setFirstTokenId=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.ExchangeCreateContract.prototype.getFirstTokenBalance=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.ExchangeCreateContract.prototype.setFirstTokenBalance=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.ExchangeCreateContract.prototype.getSecondTokenId=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.ExchangeCreateContract.prototype.getSecondTokenId_asB64=function(){return o.Message.bytesAsB64(this.getSecondTokenId())},TronWebProto.ExchangeCreateContract.prototype.getSecondTokenId_asU8=function(){return o.Message.bytesAsU8(this.getSecondTokenId())},TronWebProto.ExchangeCreateContract.prototype.setSecondTokenId=function(e){return o.Message.setProto3BytesField(this,4,e)},TronWebProto.ExchangeCreateContract.prototype.getSecondTokenBalance=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.ExchangeCreateContract.prototype.setSecondTokenBalance=function(e){return o.Message.setProto3IntField(this,5,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ExchangeInjectContract.prototype.toObject=function(e){return TronWebProto.ExchangeInjectContract.toObject(e,this)},TronWebProto.ExchangeInjectContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),exchangeId:o.Message.getFieldWithDefault(t,2,0),tokenId:t.getTokenId_asB64(),quant:o.Message.getFieldWithDefault(t,4,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ExchangeInjectContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ExchangeInjectContract;return TronWebProto.ExchangeInjectContract.deserializeBinaryFromReader(r,t)},TronWebProto.ExchangeInjectContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setExchangeId(r);break;case 3:r=t.readBytes(),e.setTokenId(r);break;case 4:r=t.readInt64(),e.setQuant(r);break;default:t.skipField()}return e},TronWebProto.ExchangeInjectContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ExchangeInjectContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ExchangeInjectContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getExchangeId())&&t.writeInt64(2,r),(r=e.getTokenId_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getQuant())&&t.writeInt64(4,r)},TronWebProto.ExchangeInjectContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ExchangeInjectContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ExchangeInjectContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ExchangeInjectContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ExchangeInjectContract.prototype.getExchangeId=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.ExchangeInjectContract.prototype.setExchangeId=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.ExchangeInjectContract.prototype.getTokenId=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.ExchangeInjectContract.prototype.getTokenId_asB64=function(){return o.Message.bytesAsB64(this.getTokenId())},TronWebProto.ExchangeInjectContract.prototype.getTokenId_asU8=function(){return o.Message.bytesAsU8(this.getTokenId())},TronWebProto.ExchangeInjectContract.prototype.setTokenId=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.ExchangeInjectContract.prototype.getQuant=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.ExchangeInjectContract.prototype.setQuant=function(e){return o.Message.setProto3IntField(this,4,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ExchangeWithdrawContract.prototype.toObject=function(e){return TronWebProto.ExchangeWithdrawContract.toObject(e,this)},TronWebProto.ExchangeWithdrawContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),exchangeId:o.Message.getFieldWithDefault(t,2,0),tokenId:t.getTokenId_asB64(),quant:o.Message.getFieldWithDefault(t,4,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ExchangeWithdrawContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ExchangeWithdrawContract;return TronWebProto.ExchangeWithdrawContract.deserializeBinaryFromReader(r,t)},TronWebProto.ExchangeWithdrawContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setExchangeId(r);break;case 3:r=t.readBytes(),e.setTokenId(r);break;case 4:r=t.readInt64(),e.setQuant(r);break;default:t.skipField()}return e},TronWebProto.ExchangeWithdrawContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ExchangeWithdrawContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ExchangeWithdrawContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getExchangeId())&&t.writeInt64(2,r),(r=e.getTokenId_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getQuant())&&t.writeInt64(4,r)},TronWebProto.ExchangeWithdrawContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ExchangeWithdrawContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ExchangeWithdrawContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ExchangeWithdrawContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ExchangeWithdrawContract.prototype.getExchangeId=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.ExchangeWithdrawContract.prototype.setExchangeId=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.ExchangeWithdrawContract.prototype.getTokenId=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.ExchangeWithdrawContract.prototype.getTokenId_asB64=function(){return o.Message.bytesAsB64(this.getTokenId())},TronWebProto.ExchangeWithdrawContract.prototype.getTokenId_asU8=function(){return o.Message.bytesAsU8(this.getTokenId())},TronWebProto.ExchangeWithdrawContract.prototype.setTokenId=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.ExchangeWithdrawContract.prototype.getQuant=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.ExchangeWithdrawContract.prototype.setQuant=function(e){return o.Message.setProto3IntField(this,4,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ExchangeTransactionContract.prototype.toObject=function(e){return TronWebProto.ExchangeTransactionContract.toObject(e,this)},TronWebProto.ExchangeTransactionContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),exchangeId:o.Message.getFieldWithDefault(t,2,0),tokenId:t.getTokenId_asB64(),quant:o.Message.getFieldWithDefault(t,4,0),expected:o.Message.getFieldWithDefault(t,5,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ExchangeTransactionContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ExchangeTransactionContract;return TronWebProto.ExchangeTransactionContract.deserializeBinaryFromReader(r,t)},TronWebProto.ExchangeTransactionContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setExchangeId(r);break;case 3:r=t.readBytes(),e.setTokenId(r);break;case 4:r=t.readInt64(),e.setQuant(r);break;case 5:r=t.readInt64(),e.setExpected(r);break;default:t.skipField()}return e},TronWebProto.ExchangeTransactionContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ExchangeTransactionContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ExchangeTransactionContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getExchangeId())&&t.writeInt64(2,r),(r=e.getTokenId_asU8()).length>0&&t.writeBytes(3,r),0!==(r=e.getQuant())&&t.writeInt64(4,r),0!==(r=e.getExpected())&&t.writeInt64(5,r)},TronWebProto.ExchangeTransactionContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ExchangeTransactionContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ExchangeTransactionContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ExchangeTransactionContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ExchangeTransactionContract.prototype.getExchangeId=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.ExchangeTransactionContract.prototype.setExchangeId=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.ExchangeTransactionContract.prototype.getTokenId=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.ExchangeTransactionContract.prototype.getTokenId_asB64=function(){return o.Message.bytesAsB64(this.getTokenId())},TronWebProto.ExchangeTransactionContract.prototype.getTokenId_asU8=function(){return o.Message.bytesAsU8(this.getTokenId())},TronWebProto.ExchangeTransactionContract.prototype.setTokenId=function(e){return o.Message.setProto3BytesField(this,3,e)},TronWebProto.ExchangeTransactionContract.prototype.getQuant=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.ExchangeTransactionContract.prototype.setQuant=function(e){return o.Message.setProto3IntField(this,4,e)},TronWebProto.ExchangeTransactionContract.prototype.getExpected=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.ExchangeTransactionContract.prototype.setExpected=function(e){return o.Message.setProto3IntField(this,5,e)},n.object.extend(t,TronWebProto)},9362:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();n.exportSymbol("TronWebProto.ProposalApproveContract",null,s),n.exportSymbol("TronWebProto.ProposalCreateContract",null,s),n.exportSymbol("TronWebProto.ProposalDeleteContract",null,s),TronWebProto.ProposalApproveContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ProposalApproveContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ProposalApproveContract.displayName="TronWebProto.ProposalApproveContract"),TronWebProto.ProposalCreateContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ProposalCreateContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ProposalCreateContract.displayName="TronWebProto.ProposalCreateContract"),TronWebProto.ProposalDeleteContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ProposalDeleteContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ProposalDeleteContract.displayName="TronWebProto.ProposalDeleteContract"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ProposalApproveContract.prototype.toObject=function(e){return TronWebProto.ProposalApproveContract.toObject(e,this)},TronWebProto.ProposalApproveContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),proposalId:o.Message.getFieldWithDefault(t,2,0),isAddApproval:o.Message.getBooleanFieldWithDefault(t,3,!1)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ProposalApproveContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ProposalApproveContract;return TronWebProto.ProposalApproveContract.deserializeBinaryFromReader(r,t)},TronWebProto.ProposalApproveContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setProposalId(r);break;case 3:r=t.readBool(),e.setIsAddApproval(r);break;default:t.skipField()}return e},TronWebProto.ProposalApproveContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ProposalApproveContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ProposalApproveContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getProposalId())&&t.writeInt64(2,r),(r=e.getIsAddApproval())&&t.writeBool(3,r)},TronWebProto.ProposalApproveContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ProposalApproveContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ProposalApproveContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ProposalApproveContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ProposalApproveContract.prototype.getProposalId=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.ProposalApproveContract.prototype.setProposalId=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.ProposalApproveContract.prototype.getIsAddApproval=function(){return o.Message.getBooleanFieldWithDefault(this,3,!1)},TronWebProto.ProposalApproveContract.prototype.setIsAddApproval=function(e){return o.Message.setProto3BooleanField(this,3,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ProposalCreateContract.prototype.toObject=function(e){return TronWebProto.ProposalCreateContract.toObject(e,this)},TronWebProto.ProposalCreateContract.toObject=function(e,t){var r,o={ownerAddress:t.getOwnerAddress_asB64(),parametersMap:(r=t.getParametersMap())?r.toObject(e,void 0):[]};return e&&(o.$jspbMessageInstance=t),o}),TronWebProto.ProposalCreateContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ProposalCreateContract;return TronWebProto.ProposalCreateContract.deserializeBinaryFromReader(r,t)},TronWebProto.ProposalCreateContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=e.getParametersMap(),t.readMessage(r,(function(e,t){o.Map.deserializeBinary(e,t,o.BinaryReader.prototype.readInt64,o.BinaryReader.prototype.readInt64,null,0,0)}));break;default:t.skipField()}return e},TronWebProto.ProposalCreateContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ProposalCreateContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ProposalCreateContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getParametersMap(!0))&&r.getLength()>0&&r.serializeBinary(2,t,o.BinaryWriter.prototype.writeInt64,o.BinaryWriter.prototype.writeInt64)},TronWebProto.ProposalCreateContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ProposalCreateContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ProposalCreateContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ProposalCreateContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ProposalCreateContract.prototype.getParametersMap=function(e){return o.Message.getMapField(this,2,e,null)},TronWebProto.ProposalCreateContract.prototype.clearParametersMap=function(){return this.getParametersMap().clear(),this},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ProposalDeleteContract.prototype.toObject=function(e){return TronWebProto.ProposalDeleteContract.toObject(e,this)},TronWebProto.ProposalDeleteContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),proposalId:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ProposalDeleteContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ProposalDeleteContract;return TronWebProto.ProposalDeleteContract.deserializeBinaryFromReader(r,t)},TronWebProto.ProposalDeleteContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setProposalId(r);break;default:t.skipField()}return e},TronWebProto.ProposalDeleteContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ProposalDeleteContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ProposalDeleteContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getProposalId())&&t.writeInt64(2,r)},TronWebProto.ProposalDeleteContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ProposalDeleteContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ProposalDeleteContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ProposalDeleteContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ProposalDeleteContract.prototype.getProposalId=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.ProposalDeleteContract.prototype.setProposalId=function(e){return o.Message.setProto3IntField(this,2,e)},n.object.extend(t,TronWebProto)},803:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")(),a=r(5925);n.object.extend(proto,a),n.exportSymbol("TronWebProto.ClearABIContract",null,s),n.exportSymbol("TronWebProto.ContractState",null,s),n.exportSymbol("TronWebProto.CreateSmartContract",null,s),n.exportSymbol("TronWebProto.SmartContract",null,s),n.exportSymbol("TronWebProto.SmartContract.ABI",null,s),n.exportSymbol("TronWebProto.SmartContract.ABI.Entry",null,s),n.exportSymbol("TronWebProto.SmartContract.ABI.Entry.EntryType",null,s),n.exportSymbol("TronWebProto.SmartContract.ABI.Entry.Param",null,s),n.exportSymbol("TronWebProto.SmartContract.ABI.Entry.StateMutabilityType",null,s),n.exportSymbol("TronWebProto.SmartContractDataWrapper",null,s),n.exportSymbol("TronWebProto.TriggerSmartContract",null,s),n.exportSymbol("TronWebProto.UpdateEnergyLimitContract",null,s),n.exportSymbol("TronWebProto.UpdateSettingContract",null,s),TronWebProto.SmartContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.SmartContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.SmartContract.displayName="TronWebProto.SmartContract"),TronWebProto.SmartContract.ABI=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.SmartContract.ABI.repeatedFields_,null)},n.inherits(TronWebProto.SmartContract.ABI,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.SmartContract.ABI.displayName="TronWebProto.SmartContract.ABI"),TronWebProto.SmartContract.ABI.Entry=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.SmartContract.ABI.Entry.repeatedFields_,null)},n.inherits(TronWebProto.SmartContract.ABI.Entry,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.SmartContract.ABI.Entry.displayName="TronWebProto.SmartContract.ABI.Entry"),TronWebProto.SmartContract.ABI.Entry.Param=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.SmartContract.ABI.Entry.Param,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.SmartContract.ABI.Entry.Param.displayName="TronWebProto.SmartContract.ABI.Entry.Param"),TronWebProto.ContractState=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ContractState,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ContractState.displayName="TronWebProto.ContractState"),TronWebProto.CreateSmartContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.CreateSmartContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.CreateSmartContract.displayName="TronWebProto.CreateSmartContract"),TronWebProto.TriggerSmartContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.TriggerSmartContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.TriggerSmartContract.displayName="TronWebProto.TriggerSmartContract"),TronWebProto.ClearABIContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.ClearABIContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.ClearABIContract.displayName="TronWebProto.ClearABIContract"),TronWebProto.UpdateSettingContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UpdateSettingContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UpdateSettingContract.displayName="TronWebProto.UpdateSettingContract"),TronWebProto.UpdateEnergyLimitContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UpdateEnergyLimitContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UpdateEnergyLimitContract.displayName="TronWebProto.UpdateEnergyLimitContract"),TronWebProto.SmartContractDataWrapper=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.SmartContractDataWrapper,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.SmartContractDataWrapper.displayName="TronWebProto.SmartContractDataWrapper"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.SmartContract.prototype.toObject=function(e){return TronWebProto.SmartContract.toObject(e,this)},TronWebProto.SmartContract.toObject=function(e,t){var r,n={originAddress:t.getOriginAddress_asB64(),contractAddress:t.getContractAddress_asB64(),abi:(r=t.getAbi())&&TronWebProto.SmartContract.ABI.toObject(e,r),bytecode:t.getBytecode_asB64(),callValue:o.Message.getFieldWithDefault(t,5,0),consumeUserResourcePercent:o.Message.getFieldWithDefault(t,6,0),name:o.Message.getFieldWithDefault(t,7,""),originEnergyLimit:o.Message.getFieldWithDefault(t,8,0),codeHash:t.getCodeHash_asB64(),trxHash:t.getTrxHash_asB64(),version:o.Message.getFieldWithDefault(t,11,0)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.SmartContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.SmartContract;return TronWebProto.SmartContract.deserializeBinaryFromReader(r,t)},TronWebProto.SmartContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOriginAddress(r);break;case 2:r=t.readBytes(),e.setContractAddress(r);break;case 3:r=new TronWebProto.SmartContract.ABI,t.readMessage(r,TronWebProto.SmartContract.ABI.deserializeBinaryFromReader),e.setAbi(r);break;case 4:r=t.readBytes(),e.setBytecode(r);break;case 5:r=t.readInt64(),e.setCallValue(r);break;case 6:r=t.readInt64(),e.setConsumeUserResourcePercent(r);break;case 7:r=t.readString(),e.setName(r);break;case 8:r=t.readInt64(),e.setOriginEnergyLimit(r);break;case 9:r=t.readBytes(),e.setCodeHash(r);break;case 10:r=t.readBytes(),e.setTrxHash(r);break;case 11:r=t.readInt32(),e.setVersion(r);break;default:t.skipField()}return e},TronWebProto.SmartContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.SmartContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.SmartContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOriginAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getContractAddress_asU8()).length>0&&t.writeBytes(2,r),null!=(r=e.getAbi())&&t.writeMessage(3,r,TronWebProto.SmartContract.ABI.serializeBinaryToWriter),(r=e.getBytecode_asU8()).length>0&&t.writeBytes(4,r),0!==(r=e.getCallValue())&&t.writeInt64(5,r),0!==(r=e.getConsumeUserResourcePercent())&&t.writeInt64(6,r),(r=e.getName()).length>0&&t.writeString(7,r),0!==(r=e.getOriginEnergyLimit())&&t.writeInt64(8,r),(r=e.getCodeHash_asU8()).length>0&&t.writeBytes(9,r),(r=e.getTrxHash_asU8()).length>0&&t.writeBytes(10,r),0!==(r=e.getVersion())&&t.writeInt32(11,r)},TronWebProto.SmartContract.ABI.repeatedFields_=[1],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.SmartContract.ABI.prototype.toObject=function(e){return TronWebProto.SmartContract.ABI.toObject(e,this)},TronWebProto.SmartContract.ABI.toObject=function(e,t){var r={entrysList:o.Message.toObjectList(t.getEntrysList(),TronWebProto.SmartContract.ABI.Entry.toObject,e)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.SmartContract.ABI.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.SmartContract.ABI;return TronWebProto.SmartContract.ABI.deserializeBinaryFromReader(r,t)},TronWebProto.SmartContract.ABI.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)if(1===t.getFieldNumber()){var r=new TronWebProto.SmartContract.ABI.Entry;t.readMessage(r,TronWebProto.SmartContract.ABI.Entry.deserializeBinaryFromReader),e.addEntrys(r)}else t.skipField();return e},TronWebProto.SmartContract.ABI.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.SmartContract.ABI.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.SmartContract.ABI.serializeBinaryToWriter=function(e,t){var r;(r=e.getEntrysList()).length>0&&t.writeRepeatedMessage(1,r,TronWebProto.SmartContract.ABI.Entry.serializeBinaryToWriter)},TronWebProto.SmartContract.ABI.Entry.repeatedFields_=[4,5],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.SmartContract.ABI.Entry.prototype.toObject=function(e){return TronWebProto.SmartContract.ABI.Entry.toObject(e,this)},TronWebProto.SmartContract.ABI.Entry.toObject=function(e,t){var r={anonymous:o.Message.getBooleanFieldWithDefault(t,1,!1),constant:o.Message.getBooleanFieldWithDefault(t,2,!1),name:o.Message.getFieldWithDefault(t,3,""),inputsList:o.Message.toObjectList(t.getInputsList(),TronWebProto.SmartContract.ABI.Entry.Param.toObject,e),outputsList:o.Message.toObjectList(t.getOutputsList(),TronWebProto.SmartContract.ABI.Entry.Param.toObject,e),type:o.Message.getFieldWithDefault(t,6,0),payable:o.Message.getBooleanFieldWithDefault(t,7,!1),statemutability:o.Message.getFieldWithDefault(t,8,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.SmartContract.ABI.Entry.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.SmartContract.ABI.Entry;return TronWebProto.SmartContract.ABI.Entry.deserializeBinaryFromReader(r,t)},TronWebProto.SmartContract.ABI.Entry.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBool();e.setAnonymous(r);break;case 2:r=t.readBool(),e.setConstant(r);break;case 3:r=t.readString(),e.setName(r);break;case 4:r=new TronWebProto.SmartContract.ABI.Entry.Param,t.readMessage(r,TronWebProto.SmartContract.ABI.Entry.Param.deserializeBinaryFromReader),e.addInputs(r);break;case 5:r=new TronWebProto.SmartContract.ABI.Entry.Param,t.readMessage(r,TronWebProto.SmartContract.ABI.Entry.Param.deserializeBinaryFromReader),e.addOutputs(r);break;case 6:r=t.readEnum(),e.setType(r);break;case 7:r=t.readBool(),e.setPayable(r);break;case 8:r=t.readEnum(),e.setStatemutability(r);break;default:t.skipField()}return e},TronWebProto.SmartContract.ABI.Entry.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.SmartContract.ABI.Entry.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.SmartContract.ABI.Entry.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getAnonymous())&&t.writeBool(1,r),(r=e.getConstant())&&t.writeBool(2,r),(r=e.getName()).length>0&&t.writeString(3,r),(r=e.getInputsList()).length>0&&t.writeRepeatedMessage(4,r,TronWebProto.SmartContract.ABI.Entry.Param.serializeBinaryToWriter),(r=e.getOutputsList()).length>0&&t.writeRepeatedMessage(5,r,TronWebProto.SmartContract.ABI.Entry.Param.serializeBinaryToWriter),0!==(r=e.getType())&&t.writeEnum(6,r),(r=e.getPayable())&&t.writeBool(7,r),0!==(r=e.getStatemutability())&&t.writeEnum(8,r)},TronWebProto.SmartContract.ABI.Entry.EntryType={UNKNOWNENTRYTYPE:0,CONSTRUCTOR:1,FUNCTION:2,EVENT:3,FALLBACK:4,RECEIVE:5,ERROR:6},TronWebProto.SmartContract.ABI.Entry.StateMutabilityType={UNKNOWNMUTABILITYTYPE:0,PURE:1,VIEW:2,NONPAYABLE:3,PAYABLE:4},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.SmartContract.ABI.Entry.Param.prototype.toObject=function(e){return TronWebProto.SmartContract.ABI.Entry.Param.toObject(e,this)},TronWebProto.SmartContract.ABI.Entry.Param.toObject=function(e,t){var r={indexed:o.Message.getBooleanFieldWithDefault(t,1,!1),name:o.Message.getFieldWithDefault(t,2,""),type:o.Message.getFieldWithDefault(t,3,"")};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.SmartContract.ABI.Entry.Param.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.SmartContract.ABI.Entry.Param;return TronWebProto.SmartContract.ABI.Entry.Param.deserializeBinaryFromReader(r,t)},TronWebProto.SmartContract.ABI.Entry.Param.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBool();e.setIndexed(r);break;case 2:r=t.readString(),e.setName(r);break;case 3:r=t.readString(),e.setType(r);break;default:t.skipField()}return e},TronWebProto.SmartContract.ABI.Entry.Param.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.SmartContract.ABI.Entry.Param.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.SmartContract.ABI.Entry.Param.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getIndexed())&&t.writeBool(1,r),(r=e.getName()).length>0&&t.writeString(2,r),(r=e.getType()).length>0&&t.writeString(3,r)},TronWebProto.SmartContract.ABI.Entry.Param.prototype.getIndexed=function(){return o.Message.getBooleanFieldWithDefault(this,1,!1)},TronWebProto.SmartContract.ABI.Entry.Param.prototype.setIndexed=function(e){return o.Message.setProto3BooleanField(this,1,e)},TronWebProto.SmartContract.ABI.Entry.Param.prototype.getName=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.SmartContract.ABI.Entry.Param.prototype.setName=function(e){return o.Message.setProto3StringField(this,2,e)},TronWebProto.SmartContract.ABI.Entry.Param.prototype.getType=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.SmartContract.ABI.Entry.Param.prototype.setType=function(e){return o.Message.setProto3StringField(this,3,e)},TronWebProto.SmartContract.ABI.Entry.prototype.getAnonymous=function(){return o.Message.getBooleanFieldWithDefault(this,1,!1)},TronWebProto.SmartContract.ABI.Entry.prototype.setAnonymous=function(e){return o.Message.setProto3BooleanField(this,1,e)},TronWebProto.SmartContract.ABI.Entry.prototype.getConstant=function(){return o.Message.getBooleanFieldWithDefault(this,2,!1)},TronWebProto.SmartContract.ABI.Entry.prototype.setConstant=function(e){return o.Message.setProto3BooleanField(this,2,e)},TronWebProto.SmartContract.ABI.Entry.prototype.getName=function(){return o.Message.getFieldWithDefault(this,3,"")},TronWebProto.SmartContract.ABI.Entry.prototype.setName=function(e){return o.Message.setProto3StringField(this,3,e)},TronWebProto.SmartContract.ABI.Entry.prototype.getInputsList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.SmartContract.ABI.Entry.Param,4)},TronWebProto.SmartContract.ABI.Entry.prototype.setInputsList=function(e){return o.Message.setRepeatedWrapperField(this,4,e)},TronWebProto.SmartContract.ABI.Entry.prototype.addInputs=function(e,t){return o.Message.addToRepeatedWrapperField(this,4,e,TronWebProto.SmartContract.ABI.Entry.Param,t)},TronWebProto.SmartContract.ABI.Entry.prototype.clearInputsList=function(){return this.setInputsList([])},TronWebProto.SmartContract.ABI.Entry.prototype.getOutputsList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.SmartContract.ABI.Entry.Param,5)},TronWebProto.SmartContract.ABI.Entry.prototype.setOutputsList=function(e){return o.Message.setRepeatedWrapperField(this,5,e)},TronWebProto.SmartContract.ABI.Entry.prototype.addOutputs=function(e,t){return o.Message.addToRepeatedWrapperField(this,5,e,TronWebProto.SmartContract.ABI.Entry.Param,t)},TronWebProto.SmartContract.ABI.Entry.prototype.clearOutputsList=function(){return this.setOutputsList([])},TronWebProto.SmartContract.ABI.Entry.prototype.getType=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.SmartContract.ABI.Entry.prototype.setType=function(e){return o.Message.setProto3EnumField(this,6,e)},TronWebProto.SmartContract.ABI.Entry.prototype.getPayable=function(){return o.Message.getBooleanFieldWithDefault(this,7,!1)},TronWebProto.SmartContract.ABI.Entry.prototype.setPayable=function(e){return o.Message.setProto3BooleanField(this,7,e)},TronWebProto.SmartContract.ABI.Entry.prototype.getStatemutability=function(){return o.Message.getFieldWithDefault(this,8,0)},TronWebProto.SmartContract.ABI.Entry.prototype.setStatemutability=function(e){return o.Message.setProto3EnumField(this,8,e)},TronWebProto.SmartContract.ABI.prototype.getEntrysList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.SmartContract.ABI.Entry,1)},TronWebProto.SmartContract.ABI.prototype.setEntrysList=function(e){return o.Message.setRepeatedWrapperField(this,1,e)},TronWebProto.SmartContract.ABI.prototype.addEntrys=function(e,t){return o.Message.addToRepeatedWrapperField(this,1,e,TronWebProto.SmartContract.ABI.Entry,t)},TronWebProto.SmartContract.ABI.prototype.clearEntrysList=function(){return this.setEntrysList([])},TronWebProto.SmartContract.prototype.getOriginAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.SmartContract.prototype.getOriginAddress_asB64=function(){return o.Message.bytesAsB64(this.getOriginAddress())},TronWebProto.SmartContract.prototype.getOriginAddress_asU8=function(){return o.Message.bytesAsU8(this.getOriginAddress())},TronWebProto.SmartContract.prototype.setOriginAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.SmartContract.prototype.getContractAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.SmartContract.prototype.getContractAddress_asB64=function(){return o.Message.bytesAsB64(this.getContractAddress())},TronWebProto.SmartContract.prototype.getContractAddress_asU8=function(){return o.Message.bytesAsU8(this.getContractAddress())},TronWebProto.SmartContract.prototype.setContractAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.SmartContract.prototype.getAbi=function(){return o.Message.getWrapperField(this,TronWebProto.SmartContract.ABI,3)},TronWebProto.SmartContract.prototype.setAbi=function(e){return o.Message.setWrapperField(this,3,e)},TronWebProto.SmartContract.prototype.clearAbi=function(){return this.setAbi(void 0)},TronWebProto.SmartContract.prototype.hasAbi=function(){return null!=o.Message.getField(this,3)},TronWebProto.SmartContract.prototype.getBytecode=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.SmartContract.prototype.getBytecode_asB64=function(){return o.Message.bytesAsB64(this.getBytecode())},TronWebProto.SmartContract.prototype.getBytecode_asU8=function(){return o.Message.bytesAsU8(this.getBytecode())},TronWebProto.SmartContract.prototype.setBytecode=function(e){return o.Message.setProto3BytesField(this,4,e)},TronWebProto.SmartContract.prototype.getCallValue=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.SmartContract.prototype.setCallValue=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.SmartContract.prototype.getConsumeUserResourcePercent=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.SmartContract.prototype.setConsumeUserResourcePercent=function(e){return o.Message.setProto3IntField(this,6,e)},TronWebProto.SmartContract.prototype.getName=function(){return o.Message.getFieldWithDefault(this,7,"")},TronWebProto.SmartContract.prototype.setName=function(e){return o.Message.setProto3StringField(this,7,e)},TronWebProto.SmartContract.prototype.getOriginEnergyLimit=function(){return o.Message.getFieldWithDefault(this,8,0)},TronWebProto.SmartContract.prototype.setOriginEnergyLimit=function(e){return o.Message.setProto3IntField(this,8,e)},TronWebProto.SmartContract.prototype.getCodeHash=function(){return o.Message.getFieldWithDefault(this,9,"")},TronWebProto.SmartContract.prototype.getCodeHash_asB64=function(){return o.Message.bytesAsB64(this.getCodeHash())},TronWebProto.SmartContract.prototype.getCodeHash_asU8=function(){return o.Message.bytesAsU8(this.getCodeHash())},TronWebProto.SmartContract.prototype.setCodeHash=function(e){return o.Message.setProto3BytesField(this,9,e)},TronWebProto.SmartContract.prototype.getTrxHash=function(){return o.Message.getFieldWithDefault(this,10,"")},TronWebProto.SmartContract.prototype.getTrxHash_asB64=function(){return o.Message.bytesAsB64(this.getTrxHash())},TronWebProto.SmartContract.prototype.getTrxHash_asU8=function(){return o.Message.bytesAsU8(this.getTrxHash())},TronWebProto.SmartContract.prototype.setTrxHash=function(e){return o.Message.setProto3BytesField(this,10,e)},TronWebProto.SmartContract.prototype.getVersion=function(){return o.Message.getFieldWithDefault(this,11,0)},TronWebProto.SmartContract.prototype.setVersion=function(e){return o.Message.setProto3IntField(this,11,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ContractState.prototype.toObject=function(e){return TronWebProto.ContractState.toObject(e,this)},TronWebProto.ContractState.toObject=function(e,t){var r={energyUsage:o.Message.getFieldWithDefault(t,1,0),energyFactor:o.Message.getFieldWithDefault(t,2,0),updateCycle:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ContractState.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ContractState;return TronWebProto.ContractState.deserializeBinaryFromReader(r,t)},TronWebProto.ContractState.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readInt64();e.setEnergyUsage(r);break;case 2:r=t.readInt64(),e.setEnergyFactor(r);break;case 3:r=t.readInt64(),e.setUpdateCycle(r);break;default:t.skipField()}return e},TronWebProto.ContractState.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ContractState.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ContractState.serializeBinaryToWriter=function(e,t){var r=void 0;0!==(r=e.getEnergyUsage())&&t.writeInt64(1,r),0!==(r=e.getEnergyFactor())&&t.writeInt64(2,r),0!==(r=e.getUpdateCycle())&&t.writeInt64(3,r)},TronWebProto.ContractState.prototype.getEnergyUsage=function(){return o.Message.getFieldWithDefault(this,1,0)},TronWebProto.ContractState.prototype.setEnergyUsage=function(e){return o.Message.setProto3IntField(this,1,e)},TronWebProto.ContractState.prototype.getEnergyFactor=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.ContractState.prototype.setEnergyFactor=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.ContractState.prototype.getUpdateCycle=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.ContractState.prototype.setUpdateCycle=function(e){return o.Message.setProto3IntField(this,3,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.CreateSmartContract.prototype.toObject=function(e){return TronWebProto.CreateSmartContract.toObject(e,this)},TronWebProto.CreateSmartContract.toObject=function(e,t){var r,n={ownerAddress:t.getOwnerAddress_asB64(),newContract:(r=t.getNewContract())&&TronWebProto.SmartContract.toObject(e,r),callTokenValue:o.Message.getFieldWithDefault(t,3,0),tokenId:o.Message.getFieldWithDefault(t,4,0)};return e&&(n.$jspbMessageInstance=t),n}),TronWebProto.CreateSmartContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.CreateSmartContract;return TronWebProto.CreateSmartContract.deserializeBinaryFromReader(r,t)},TronWebProto.CreateSmartContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=new TronWebProto.SmartContract,t.readMessage(r,TronWebProto.SmartContract.deserializeBinaryFromReader),e.setNewContract(r);break;case 3:r=t.readInt64(),e.setCallTokenValue(r);break;case 4:r=t.readInt64(),e.setTokenId(r);break;default:t.skipField()}return e},TronWebProto.CreateSmartContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.CreateSmartContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.CreateSmartContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),null!=(r=e.getNewContract())&&t.writeMessage(2,r,TronWebProto.SmartContract.serializeBinaryToWriter),0!==(r=e.getCallTokenValue())&&t.writeInt64(3,r),0!==(r=e.getTokenId())&&t.writeInt64(4,r)},TronWebProto.CreateSmartContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.CreateSmartContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.CreateSmartContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.CreateSmartContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.CreateSmartContract.prototype.getNewContract=function(){return o.Message.getWrapperField(this,TronWebProto.SmartContract,2)},TronWebProto.CreateSmartContract.prototype.setNewContract=function(e){return o.Message.setWrapperField(this,2,e)},TronWebProto.CreateSmartContract.prototype.clearNewContract=function(){return this.setNewContract(void 0)},TronWebProto.CreateSmartContract.prototype.hasNewContract=function(){return null!=o.Message.getField(this,2)},TronWebProto.CreateSmartContract.prototype.getCallTokenValue=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.CreateSmartContract.prototype.setCallTokenValue=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.CreateSmartContract.prototype.getTokenId=function(){return o.Message.getFieldWithDefault(this,4,0)},TronWebProto.CreateSmartContract.prototype.setTokenId=function(e){return o.Message.setProto3IntField(this,4,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.TriggerSmartContract.prototype.toObject=function(e){return TronWebProto.TriggerSmartContract.toObject(e,this)},TronWebProto.TriggerSmartContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),contractAddress:t.getContractAddress_asB64(),callValue:o.Message.getFieldWithDefault(t,3,0),data:t.getData_asB64(),callTokenValue:o.Message.getFieldWithDefault(t,5,0),tokenId:o.Message.getFieldWithDefault(t,6,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.TriggerSmartContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.TriggerSmartContract;return TronWebProto.TriggerSmartContract.deserializeBinaryFromReader(r,t)},TronWebProto.TriggerSmartContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setContractAddress(r);break;case 3:r=t.readInt64(),e.setCallValue(r);break;case 4:r=t.readBytes(),e.setData(r);break;case 5:r=t.readInt64(),e.setCallTokenValue(r);break;case 6:r=t.readInt64(),e.setTokenId(r);break;default:t.skipField()}return e},TronWebProto.TriggerSmartContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.TriggerSmartContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.TriggerSmartContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getContractAddress_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getCallValue())&&t.writeInt64(3,r),(r=e.getData_asU8()).length>0&&t.writeBytes(4,r),0!==(r=e.getCallTokenValue())&&t.writeInt64(5,r),0!==(r=e.getTokenId())&&t.writeInt64(6,r)},TronWebProto.TriggerSmartContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.TriggerSmartContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.TriggerSmartContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.TriggerSmartContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.TriggerSmartContract.prototype.getContractAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.TriggerSmartContract.prototype.getContractAddress_asB64=function(){return o.Message.bytesAsB64(this.getContractAddress())},TronWebProto.TriggerSmartContract.prototype.getContractAddress_asU8=function(){return o.Message.bytesAsU8(this.getContractAddress())},TronWebProto.TriggerSmartContract.prototype.setContractAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.TriggerSmartContract.prototype.getCallValue=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.TriggerSmartContract.prototype.setCallValue=function(e){return o.Message.setProto3IntField(this,3,e)},TronWebProto.TriggerSmartContract.prototype.getData=function(){return o.Message.getFieldWithDefault(this,4,"")},TronWebProto.TriggerSmartContract.prototype.getData_asB64=function(){return o.Message.bytesAsB64(this.getData())},TronWebProto.TriggerSmartContract.prototype.getData_asU8=function(){return o.Message.bytesAsU8(this.getData())},TronWebProto.TriggerSmartContract.prototype.setData=function(e){return o.Message.setProto3BytesField(this,4,e)},TronWebProto.TriggerSmartContract.prototype.getCallTokenValue=function(){return o.Message.getFieldWithDefault(this,5,0)},TronWebProto.TriggerSmartContract.prototype.setCallTokenValue=function(e){return o.Message.setProto3IntField(this,5,e)},TronWebProto.TriggerSmartContract.prototype.getTokenId=function(){return o.Message.getFieldWithDefault(this,6,0)},TronWebProto.TriggerSmartContract.prototype.setTokenId=function(e){return o.Message.setProto3IntField(this,6,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.ClearABIContract.prototype.toObject=function(e){return TronWebProto.ClearABIContract.toObject(e,this)},TronWebProto.ClearABIContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),contractAddress:t.getContractAddress_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.ClearABIContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.ClearABIContract;return TronWebProto.ClearABIContract.deserializeBinaryFromReader(r,t)},TronWebProto.ClearABIContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setContractAddress(r);break;default:t.skipField()}return e},TronWebProto.ClearABIContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.ClearABIContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.ClearABIContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getContractAddress_asU8()).length>0&&t.writeBytes(2,r)},TronWebProto.ClearABIContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.ClearABIContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.ClearABIContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.ClearABIContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.ClearABIContract.prototype.getContractAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.ClearABIContract.prototype.getContractAddress_asB64=function(){return o.Message.bytesAsB64(this.getContractAddress())},TronWebProto.ClearABIContract.prototype.getContractAddress_asU8=function(){return o.Message.bytesAsU8(this.getContractAddress())},TronWebProto.ClearABIContract.prototype.setContractAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UpdateSettingContract.prototype.toObject=function(e){return TronWebProto.UpdateSettingContract.toObject(e,this)},TronWebProto.UpdateSettingContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),contractAddress:t.getContractAddress_asB64(),consumeUserResourcePercent:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UpdateSettingContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UpdateSettingContract;return TronWebProto.UpdateSettingContract.deserializeBinaryFromReader(r,t)},TronWebProto.UpdateSettingContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setContractAddress(r);break;case 3:r=t.readInt64(),e.setConsumeUserResourcePercent(r);break;default:t.skipField()}return e},TronWebProto.UpdateSettingContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UpdateSettingContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UpdateSettingContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getContractAddress_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getConsumeUserResourcePercent())&&t.writeInt64(3,r)},TronWebProto.UpdateSettingContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UpdateSettingContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UpdateSettingContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UpdateSettingContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.UpdateSettingContract.prototype.getContractAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.UpdateSettingContract.prototype.getContractAddress_asB64=function(){return o.Message.bytesAsB64(this.getContractAddress())},TronWebProto.UpdateSettingContract.prototype.getContractAddress_asU8=function(){return o.Message.bytesAsU8(this.getContractAddress())},TronWebProto.UpdateSettingContract.prototype.setContractAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.UpdateSettingContract.prototype.getConsumeUserResourcePercent=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.UpdateSettingContract.prototype.setConsumeUserResourcePercent=function(e){return o.Message.setProto3IntField(this,3,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UpdateEnergyLimitContract.prototype.toObject=function(e){return TronWebProto.UpdateEnergyLimitContract.toObject(e,this)},TronWebProto.UpdateEnergyLimitContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),contractAddress:t.getContractAddress_asB64(),originEnergyLimit:o.Message.getFieldWithDefault(t,3,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UpdateEnergyLimitContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UpdateEnergyLimitContract;return TronWebProto.UpdateEnergyLimitContract.deserializeBinaryFromReader(r,t)},TronWebProto.UpdateEnergyLimitContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setContractAddress(r);break;case 3:r=t.readInt64(),e.setOriginEnergyLimit(r);break;default:t.skipField()}return e},TronWebProto.UpdateEnergyLimitContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UpdateEnergyLimitContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UpdateEnergyLimitContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getContractAddress_asU8()).length>0&&t.writeBytes(2,r),0!==(r=e.getOriginEnergyLimit())&&t.writeInt64(3,r)},TronWebProto.UpdateEnergyLimitContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UpdateEnergyLimitContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UpdateEnergyLimitContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UpdateEnergyLimitContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.UpdateEnergyLimitContract.prototype.getContractAddress=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.UpdateEnergyLimitContract.prototype.getContractAddress_asB64=function(){return o.Message.bytesAsB64(this.getContractAddress())},TronWebProto.UpdateEnergyLimitContract.prototype.getContractAddress_asU8=function(){return o.Message.bytesAsU8(this.getContractAddress())},TronWebProto.UpdateEnergyLimitContract.prototype.setContractAddress=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.UpdateEnergyLimitContract.prototype.getOriginEnergyLimit=function(){return o.Message.getFieldWithDefault(this,3,0)},TronWebProto.UpdateEnergyLimitContract.prototype.setOriginEnergyLimit=function(e){return o.Message.setProto3IntField(this,3,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.SmartContractDataWrapper.prototype.toObject=function(e){return TronWebProto.SmartContractDataWrapper.toObject(e,this)},TronWebProto.SmartContractDataWrapper.toObject=function(e,t){var r,o={smartContract:(r=t.getSmartContract())&&TronWebProto.SmartContract.toObject(e,r),runtimecode:t.getRuntimecode_asB64(),contractState:(r=t.getContractState())&&TronWebProto.ContractState.toObject(e,r)};return e&&(o.$jspbMessageInstance=t),o}),TronWebProto.SmartContractDataWrapper.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.SmartContractDataWrapper;return TronWebProto.SmartContractDataWrapper.deserializeBinaryFromReader(r,t)},TronWebProto.SmartContractDataWrapper.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=new TronWebProto.SmartContract;t.readMessage(r,TronWebProto.SmartContract.deserializeBinaryFromReader),e.setSmartContract(r);break;case 2:r=t.readBytes(),e.setRuntimecode(r);break;case 3:r=new TronWebProto.ContractState,t.readMessage(r,TronWebProto.ContractState.deserializeBinaryFromReader),e.setContractState(r);break;default:t.skipField()}return e},TronWebProto.SmartContractDataWrapper.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.SmartContractDataWrapper.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.SmartContractDataWrapper.serializeBinaryToWriter=function(e,t){var r=void 0;null!=(r=e.getSmartContract())&&t.writeMessage(1,r,TronWebProto.SmartContract.serializeBinaryToWriter),(r=e.getRuntimecode_asU8()).length>0&&t.writeBytes(2,r),null!=(r=e.getContractState())&&t.writeMessage(3,r,TronWebProto.ContractState.serializeBinaryToWriter)},TronWebProto.SmartContractDataWrapper.prototype.getSmartContract=function(){return o.Message.getWrapperField(this,TronWebProto.SmartContract,1)},TronWebProto.SmartContractDataWrapper.prototype.setSmartContract=function(e){return o.Message.setWrapperField(this,1,e)},TronWebProto.SmartContractDataWrapper.prototype.clearSmartContract=function(){return this.setSmartContract(void 0)},TronWebProto.SmartContractDataWrapper.prototype.hasSmartContract=function(){return null!=o.Message.getField(this,1)},TronWebProto.SmartContractDataWrapper.prototype.getRuntimecode=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.SmartContractDataWrapper.prototype.getRuntimecode_asB64=function(){return o.Message.bytesAsB64(this.getRuntimecode())},TronWebProto.SmartContractDataWrapper.prototype.getRuntimecode_asU8=function(){return o.Message.bytesAsU8(this.getRuntimecode())},TronWebProto.SmartContractDataWrapper.prototype.setRuntimecode=function(e){return o.Message.setProto3BytesField(this,2,e)},TronWebProto.SmartContractDataWrapper.prototype.getContractState=function(){return o.Message.getWrapperField(this,TronWebProto.ContractState,3)},TronWebProto.SmartContractDataWrapper.prototype.setContractState=function(e){return o.Message.setWrapperField(this,3,e)},TronWebProto.SmartContractDataWrapper.prototype.clearContractState=function(){return this.setContractState(void 0)},TronWebProto.SmartContractDataWrapper.prototype.hasContractState=function(){return null!=o.Message.getField(this,3)},n.object.extend(t,TronWebProto)},8179:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();n.exportSymbol("TronWebProto.BuyStorageBytesContract",null,s),n.exportSymbol("TronWebProto.BuyStorageContract",null,s),n.exportSymbol("TronWebProto.SellStorageContract",null,s),n.exportSymbol("TronWebProto.UpdateBrokerageContract",null,s),TronWebProto.BuyStorageBytesContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.BuyStorageBytesContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.BuyStorageBytesContract.displayName="TronWebProto.BuyStorageBytesContract"),TronWebProto.BuyStorageContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.BuyStorageContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.BuyStorageContract.displayName="TronWebProto.BuyStorageContract"),TronWebProto.SellStorageContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.SellStorageContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.SellStorageContract.displayName="TronWebProto.SellStorageContract"),TronWebProto.UpdateBrokerageContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.UpdateBrokerageContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.UpdateBrokerageContract.displayName="TronWebProto.UpdateBrokerageContract"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.BuyStorageBytesContract.prototype.toObject=function(e){return TronWebProto.BuyStorageBytesContract.toObject(e,this)},TronWebProto.BuyStorageBytesContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),bytes:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.BuyStorageBytesContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.BuyStorageBytesContract;return TronWebProto.BuyStorageBytesContract.deserializeBinaryFromReader(r,t)},TronWebProto.BuyStorageBytesContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setBytes(r);break;default:t.skipField()}return e},TronWebProto.BuyStorageBytesContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.BuyStorageBytesContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.BuyStorageBytesContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getBytes())&&t.writeInt64(2,r)},TronWebProto.BuyStorageBytesContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.BuyStorageBytesContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.BuyStorageBytesContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.BuyStorageBytesContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.BuyStorageBytesContract.prototype.getBytes=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.BuyStorageBytesContract.prototype.setBytes=function(e){return o.Message.setProto3IntField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.BuyStorageContract.prototype.toObject=function(e){return TronWebProto.BuyStorageContract.toObject(e,this)},TronWebProto.BuyStorageContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),quant:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.BuyStorageContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.BuyStorageContract;return TronWebProto.BuyStorageContract.deserializeBinaryFromReader(r,t)},TronWebProto.BuyStorageContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setQuant(r);break;default:t.skipField()}return e},TronWebProto.BuyStorageContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.BuyStorageContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.BuyStorageContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getQuant())&&t.writeInt64(2,r)},TronWebProto.BuyStorageContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.BuyStorageContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.BuyStorageContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.BuyStorageContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.BuyStorageContract.prototype.getQuant=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.BuyStorageContract.prototype.setQuant=function(e){return o.Message.setProto3IntField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.SellStorageContract.prototype.toObject=function(e){return TronWebProto.SellStorageContract.toObject(e,this)},TronWebProto.SellStorageContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),storageBytes:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.SellStorageContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.SellStorageContract;return TronWebProto.SellStorageContract.deserializeBinaryFromReader(r,t)},TronWebProto.SellStorageContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt64(),e.setStorageBytes(r);break;default:t.skipField()}return e},TronWebProto.SellStorageContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.SellStorageContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.SellStorageContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getStorageBytes())&&t.writeInt64(2,r)},TronWebProto.SellStorageContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.SellStorageContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.SellStorageContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.SellStorageContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.SellStorageContract.prototype.getStorageBytes=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.SellStorageContract.prototype.setStorageBytes=function(e){return o.Message.setProto3IntField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.UpdateBrokerageContract.prototype.toObject=function(e){return TronWebProto.UpdateBrokerageContract.toObject(e,this)},TronWebProto.UpdateBrokerageContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),brokerage:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.UpdateBrokerageContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.UpdateBrokerageContract;return TronWebProto.UpdateBrokerageContract.deserializeBinaryFromReader(r,t)},TronWebProto.UpdateBrokerageContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readInt32(),e.setBrokerage(r);break;default:t.skipField()}return e},TronWebProto.UpdateBrokerageContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.UpdateBrokerageContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.UpdateBrokerageContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getBrokerage())&&t.writeInt32(2,r)},TronWebProto.UpdateBrokerageContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.UpdateBrokerageContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.UpdateBrokerageContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.UpdateBrokerageContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.UpdateBrokerageContract.prototype.getBrokerage=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.UpdateBrokerageContract.prototype.setBrokerage=function(e){return o.Message.setProto3IntField(this,2,e)},n.object.extend(t,TronWebProto)},3089:(e,t,r)=>{var o=r(153),n=o,s="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof window&&window||void 0!==s&&s||"undefined"!=typeof self&&self||function(){return this}.call(null)||Function("return this")();n.exportSymbol("TronWebProto.VoteWitnessContract",null,s),n.exportSymbol("TronWebProto.VoteWitnessContract.Vote",null,s),n.exportSymbol("TronWebProto.WitnessCreateContract",null,s),n.exportSymbol("TronWebProto.WitnessUpdateContract",null,s),TronWebProto.WitnessCreateContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.WitnessCreateContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.WitnessCreateContract.displayName="TronWebProto.WitnessCreateContract"),TronWebProto.WitnessUpdateContract=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.WitnessUpdateContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.WitnessUpdateContract.displayName="TronWebProto.WitnessUpdateContract"),TronWebProto.VoteWitnessContract=function(e){o.Message.initialize(this,e,0,-1,TronWebProto.VoteWitnessContract.repeatedFields_,null)},n.inherits(TronWebProto.VoteWitnessContract,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.VoteWitnessContract.displayName="TronWebProto.VoteWitnessContract"),TronWebProto.VoteWitnessContract.Vote=function(e){o.Message.initialize(this,e,0,-1,null,null)},n.inherits(TronWebProto.VoteWitnessContract.Vote,o.Message),n.DEBUG&&!COMPILED&&(TronWebProto.VoteWitnessContract.Vote.displayName="TronWebProto.VoteWitnessContract.Vote"),o.Message.GENERATE_TO_OBJECT&&(TronWebProto.WitnessCreateContract.prototype.toObject=function(e){return TronWebProto.WitnessCreateContract.toObject(e,this)},TronWebProto.WitnessCreateContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),url:t.getUrl_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.WitnessCreateContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.WitnessCreateContract;return TronWebProto.WitnessCreateContract.deserializeBinaryFromReader(r,t)},TronWebProto.WitnessCreateContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=t.readBytes(),e.setUrl(r);break;default:t.skipField()}return e},TronWebProto.WitnessCreateContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.WitnessCreateContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.WitnessCreateContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getUrl_asU8()).length>0&&t.writeBytes(2,r)},TronWebProto.WitnessCreateContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.WitnessCreateContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.WitnessCreateContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.WitnessCreateContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.WitnessCreateContract.prototype.getUrl=function(){return o.Message.getFieldWithDefault(this,2,"")},TronWebProto.WitnessCreateContract.prototype.getUrl_asB64=function(){return o.Message.bytesAsB64(this.getUrl())},TronWebProto.WitnessCreateContract.prototype.getUrl_asU8=function(){return o.Message.bytesAsU8(this.getUrl())},TronWebProto.WitnessCreateContract.prototype.setUrl=function(e){return o.Message.setProto3BytesField(this,2,e)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.WitnessUpdateContract.prototype.toObject=function(e){return TronWebProto.WitnessUpdateContract.toObject(e,this)},TronWebProto.WitnessUpdateContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),updateUrl:t.getUpdateUrl_asB64()};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.WitnessUpdateContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.WitnessUpdateContract;return TronWebProto.WitnessUpdateContract.deserializeBinaryFromReader(r,t)},TronWebProto.WitnessUpdateContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 12:r=t.readBytes(),e.setUpdateUrl(r);break;default:t.skipField()}return e},TronWebProto.WitnessUpdateContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.WitnessUpdateContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.WitnessUpdateContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getUpdateUrl_asU8()).length>0&&t.writeBytes(12,r)},TronWebProto.WitnessUpdateContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.WitnessUpdateContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.WitnessUpdateContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.WitnessUpdateContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.WitnessUpdateContract.prototype.getUpdateUrl=function(){return o.Message.getFieldWithDefault(this,12,"")},TronWebProto.WitnessUpdateContract.prototype.getUpdateUrl_asB64=function(){return o.Message.bytesAsB64(this.getUpdateUrl())},TronWebProto.WitnessUpdateContract.prototype.getUpdateUrl_asU8=function(){return o.Message.bytesAsU8(this.getUpdateUrl())},TronWebProto.WitnessUpdateContract.prototype.setUpdateUrl=function(e){return o.Message.setProto3BytesField(this,12,e)},TronWebProto.VoteWitnessContract.repeatedFields_=[2],o.Message.GENERATE_TO_OBJECT&&(TronWebProto.VoteWitnessContract.prototype.toObject=function(e){return TronWebProto.VoteWitnessContract.toObject(e,this)},TronWebProto.VoteWitnessContract.toObject=function(e,t){var r={ownerAddress:t.getOwnerAddress_asB64(),votesList:o.Message.toObjectList(t.getVotesList(),TronWebProto.VoteWitnessContract.Vote.toObject,e),support:o.Message.getBooleanFieldWithDefault(t,3,!1)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.VoteWitnessContract.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.VoteWitnessContract;return TronWebProto.VoteWitnessContract.deserializeBinaryFromReader(r,t)},TronWebProto.VoteWitnessContract.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setOwnerAddress(r);break;case 2:r=new TronWebProto.VoteWitnessContract.Vote,t.readMessage(r,TronWebProto.VoteWitnessContract.Vote.deserializeBinaryFromReader),e.addVotes(r);break;case 3:r=t.readBool(),e.setSupport(r);break;default:t.skipField()}return e},TronWebProto.VoteWitnessContract.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.VoteWitnessContract.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.VoteWitnessContract.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getOwnerAddress_asU8()).length>0&&t.writeBytes(1,r),(r=e.getVotesList()).length>0&&t.writeRepeatedMessage(2,r,TronWebProto.VoteWitnessContract.Vote.serializeBinaryToWriter),(r=e.getSupport())&&t.writeBool(3,r)},o.Message.GENERATE_TO_OBJECT&&(TronWebProto.VoteWitnessContract.Vote.prototype.toObject=function(e){return TronWebProto.VoteWitnessContract.Vote.toObject(e,this)},TronWebProto.VoteWitnessContract.Vote.toObject=function(e,t){var r={voteAddress:t.getVoteAddress_asB64(),voteCount:o.Message.getFieldWithDefault(t,2,0)};return e&&(r.$jspbMessageInstance=t),r}),TronWebProto.VoteWitnessContract.Vote.deserializeBinary=function(e){var t=new o.BinaryReader(e),r=new TronWebProto.VoteWitnessContract.Vote;return TronWebProto.VoteWitnessContract.Vote.deserializeBinaryFromReader(r,t)},TronWebProto.VoteWitnessContract.Vote.deserializeBinaryFromReader=function(e,t){for(;t.nextField()&&!t.isEndGroup();)switch(t.getFieldNumber()){case 1:var r=t.readBytes();e.setVoteAddress(r);break;case 2:r=t.readInt64(),e.setVoteCount(r);break;default:t.skipField()}return e},TronWebProto.VoteWitnessContract.Vote.prototype.serializeBinary=function(){var e=new o.BinaryWriter;return TronWebProto.VoteWitnessContract.Vote.serializeBinaryToWriter(this,e),e.getResultBuffer()},TronWebProto.VoteWitnessContract.Vote.serializeBinaryToWriter=function(e,t){var r=void 0;(r=e.getVoteAddress_asU8()).length>0&&t.writeBytes(1,r),0!==(r=e.getVoteCount())&&t.writeInt64(2,r)},TronWebProto.VoteWitnessContract.Vote.prototype.getVoteAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.VoteWitnessContract.Vote.prototype.getVoteAddress_asB64=function(){return o.Message.bytesAsB64(this.getVoteAddress())},TronWebProto.VoteWitnessContract.Vote.prototype.getVoteAddress_asU8=function(){return o.Message.bytesAsU8(this.getVoteAddress())},TronWebProto.VoteWitnessContract.Vote.prototype.setVoteAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.VoteWitnessContract.Vote.prototype.getVoteCount=function(){return o.Message.getFieldWithDefault(this,2,0)},TronWebProto.VoteWitnessContract.Vote.prototype.setVoteCount=function(e){return o.Message.setProto3IntField(this,2,e)},TronWebProto.VoteWitnessContract.prototype.getOwnerAddress=function(){return o.Message.getFieldWithDefault(this,1,"")},TronWebProto.VoteWitnessContract.prototype.getOwnerAddress_asB64=function(){return o.Message.bytesAsB64(this.getOwnerAddress())},TronWebProto.VoteWitnessContract.prototype.getOwnerAddress_asU8=function(){return o.Message.bytesAsU8(this.getOwnerAddress())},TronWebProto.VoteWitnessContract.prototype.setOwnerAddress=function(e){return o.Message.setProto3BytesField(this,1,e)},TronWebProto.VoteWitnessContract.prototype.getVotesList=function(){return o.Message.getRepeatedWrapperField(this,TronWebProto.VoteWitnessContract.Vote,2)},TronWebProto.VoteWitnessContract.prototype.setVotesList=function(e){return o.Message.setRepeatedWrapperField(this,2,e)},TronWebProto.VoteWitnessContract.prototype.addVotes=function(e,t){return o.Message.addToRepeatedWrapperField(this,2,e,TronWebProto.VoteWitnessContract.Vote,t)},TronWebProto.VoteWitnessContract.prototype.clearVotesList=function(){return this.setVotesList([])},TronWebProto.VoteWitnessContract.prototype.getSupport=function(){return o.Message.getBooleanFieldWithDefault(this,3,!1)},TronWebProto.VoteWitnessContract.prototype.setSupport=function(e){return o.Message.setProto3BooleanField(this,3,e)},n.object.extend(t,TronWebProto)}},t={};function r(o){var n=t[o];if(void 0!==n)return n.exports;var s=t[o]={exports:{}};return e[o](s,s.exports,r),s.exports}var o={};(()=>{"use strict";var e=o;const t=r(5584),n=t.__importDefault(r(6219));n.default;const s=r(2860),a=r(4612),i=r(2862),c=r(983),u=r(5884),d=r(3569),l=r(8050),p=r(5562),g=t.__importStar(r(751));e.default={utils:n.default,BigNumber:s.BigNumber,providers:a.providers,TransactionBuilder:i.TransactionBuilder,Trx:c.Trx,Contract:u.Contract,Event:d.Event,Plugin:l.Plugin,TronWeb:p.TronWeb,Types:g}})(),module.exports=o.default})();
//# sourceMappingURL=TronWeb.node.js.map