<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Mailtemplate extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 07 July, 2016
	 * This controller to manage mail template.
	 * Created saravana kumar.
	 * @see http://ihyip.com/
	 * Last Updated: 07 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		// admin login only
		if($session->get('admin_login')) {
		
			// form validation library
			// $this->load->library('form_validation');
			$this->isSubadmin();

			

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}

	}

	
	private function isSubadmin() {
        $session = session();
        $this->router = service('router');
		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	private function isCookie($values) {
		$session = session();
		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_extra')
		);
		$this->data['module_name'] = 'settings';
		
		$this->data['mail_temp_data'] = $this->common_model->getMailTemplates();

		echo view('admin/settings/mail',$this->data);

	}

	public function add($id='') {
$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		// if($id) {
		
			$this->data['breadcrumbs'] = array();

			$this->data['breadcrumbs'][] = array(
				'text' => lang('language_lang.text_home'),
				'href' => base_url('admin')
			);
			$this->data['breadcrumbs'][] = array(
				'text' => lang('language_lang.text_extra')
			);
			
			
			$this->data['module_name'] = 'settings';
			$this->data['action'] =  'admin/mailtemplate/add';

			
			$this->data['mailtemp_list'] = $this->common_model->GetResults('mailtemplates');

			if($id) {
				$myencrypt = new MyEncrypt;
				$templateid = $myencrypt->decode($id);
				$condition = "templateid = '".$templateid."'";
				$this->data['mail_temp_data'] = $this->common_model->GetRow('mail_template',$condition);
			}
			

			if($this->request->getPost()) {

				$validation->setRules([
                'email' => ['label' => lang('language_lang.lbl_mail_from'), 'rules' => 'trim|required'],
                'name' => ['label' => lang('language_lang.lbl_mail_fromname'), 'rules' => 'trim|required'],
                'subject' => ['label' => lang('language_lang.lbl_mail_subject'), 'rules' => 'trim|required'],
                'message' => ['label' => lang('language_lang.lbl_mail_message'), 'rules' => 'trim|required'],
				]);

				// $this->form_validation->set_rules('email', lang('language_lang.lbl_mail_from'), 'trim|required');
				// $this->form_validation->set_rules('name', lang('language_lang.lbl_mail_fromname'), 'trim|required');
				// $this->form_validation->set_rules('subject', lang('language_lang.lbl_mail_subject'), 'trim|required');
				// $this->form_validation->set_rules('message', lang('language_lang.lbl_mail_message'), 'trim|required');
				

				// check form validate
				if ($validation->withRequest($this->request)->run() == TRUE) {
					

					$myencrypt = new MyEncrypt;
					$templateid = $myencrypt->decode($this->request->getPost('mail_id'));
					
					$mailtemplatedata = array(
						"from_mail"	=>	$this->request->getPost('email'),
						"from_name"	=>	$this->request->getPost('name'),
						"subject"	=>	$this->request->getPost('subject'),
						"message"	=>	$this->request->getPost('message'),
						"status"	=>	($this->request->getPost('status')) ? '1' : '0'
					);

			
					$update_status = $this->db->table('mail_template')->where('templateid',$templateid)->update($mailtemplatedata);
					
					if($update_status) {
						$session->setFlashData('success_message', lang('language_lang.mail_template_success_message'));
						return redirect()->to('admin/mailtemplate');
						
					} else {
						$session->setFlashData('error_message', lang('language_lang.mail_template_error_message'));
						return redirect()->to('admin/mailtemplate');
					}
					
				} else {
					$session->setFlashData('error_message', lang('language_lang.mail_template_error_message'));
				}
			} 
			echo view('admin/settings/addmail',$this->data);
		// } else {
		// 	return redirect()->to('admin/mailtemplate');
		// }

	}
	

	// install mailtemplate gateway
	public function install() {
       $session = session();
		if($this->request->getPost()) {
			$myencrypt = new MyEncrypt;
			$templateid = $myencrypt->decode($this->request->getPost('id'));

			$mailtemplatedata = array(
				"status"	=>	'1',
			);

		
			$update_status = $this->db->table('mail_template')->where('templateid',$templateid)->update($mailtemplatedata);

			if($update_status){
				$session->setFlashData('success_message', lang('language_lang.mail_template_install'));
				echo 1;
			} else {
				$session->setFlashData('error_message', lang('language_lang.mail_template_error_install'));
				echo 0;
			}

		}
	}

	// uninstall mailtemplate gateway
	public function uninstall() {
        $session = session();
		if($this->request->getPost()) {
			$myencrypt = new MyEncrypt;
			$templateid = $myencrypt->decode($this->request->getPost('id'));

			$mailtemplatedata = array(
				"status"	=>	'0',
			);
			$update_status = $this->db->table('mail_template')->where('templateid',$templateid)->update($mailtemplatedata);

			if($update_status){
				$session->setFlashData('success_message', lang('language_lang.mail_template_uninstall'));
				echo 1;
			} else {
				$session->setFlashData('error_message', lang('language_lang.mail_template_error_uninstall'));
				echo 0;
			}

		}
	}
	

}

