<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php
		use App\Libraries\MyEncrypt;
		$session = session();
		$validation = \Config\Services::validation();

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>

</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left" id="icon-bck"></i> <span class="text-semibold"><?php echo lang('language_lang.lang_page_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.lang_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a href="<?php echo base_url('admin/langsettings/add');?>" class="icon-plus-circle2"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>

					<!-- <div class="panel-body">
						The <code>Responsive</code> extension for DataTables can be applied to a DataTable in one of two ways; with a specific <code>class name</code> on the table, or using the DataTables initialisation options. This method shows the latter, with the <code>responsive</code> option being set to the boolean value <code>true</code>. The <code>responsive</code> option can be given as a boolean value, or as an object with configuration options.
					</div> -->

					<table class="table datatable-responsive-row-control table-hover">
						<col width="20%">
  						<col width="20%">
  						<col width="20%">
  						<col width="20%">
  						<col width="20%">
						<thead>
							<tr>
								<th></th>
								<th><?php echo lang('language_lang.label_lang_name');?></th>
								<th class="text-center"><?php echo lang('language_lang.label_country_flag');?></th>
								<th class="text-center"><?php echo lang('language_lang.label_lang_default');?></th>
								<th class="text-center"><?php echo lang('language_lang.label_lang_status');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($lang_data) {
								
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($lang_data as $row) {
									
									if($row->language_status=='1'){
										$label_status = 'label-success';
										$status = lang('language_lang.active');
									} else {
										$label_status = 'label-danger';
										$status = lang('language_lang.in_active');
									}
									
							?>
							<tr>
								<td></td>
								<td><?php echo ucfirst($row->language_name);?></td>
								<td class="text-center"><img src="<?php echo base_url('assets/images/flags/'.strtolower($row->language_code).'.png');?>"></td>
								
								<td class="text-center">
									<?php 
										$lang_ency_value = $myencrypt->encode($row->language_id);
										if($row->language_default) { 
											echo '<i class="icon-star-full2"></i>'; 
										} elseif($row->language_status=='1') { ?>
											<a class="default lang_default" data-popup="tooltip" title="<?php echo lang('language_lang.click_to_default');?>" onclick="makeDefault('<?php echo $lang_ency_value;?>')"><i class="icon-star-empty3"></i></a> 
										<?php	
										} 
									?>
								</td>
								
								<td class="text-center"><span class="label <?php echo $label_status;?>"><?php echo $status;?></span></td>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right">
												<li><a href="<?php echo base_url('admin/langsettings/add/'.$myencrypt->encode($row->language_id));?>"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
												<li><a href="javascript:void(0)" onclick="confirmdelete('<?php echo $myencrypt->encode($row->language_id);?>')"><i class="fa fa-remove"></i> <?php echo lang('language_lang.delete');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
					
				</div>
				<!-- /basic responsive configuration -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	(function($) {

	    $(document).ready(function() {
			$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>
            
            $('#icon-bck').on('click',function() {
				window.history.back();
			});
		});

	})(jQuery);
	function makeDefault(valus) {
		swal({
            title: "<?php echo lang('language_lang.lbl_default_language');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
				var valus1 =  valus;
				jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/langsettings/makedefaults');?>',
		            data: {'id':valus1},
		            success : function(resp)
		            {
		                if(resp==1)
		                    window.location.href = "<?php echo base_url('admin/langsettings');?>";
		                else
		                    console.log('fail');
		            }
		        });
		    }
		});
	}

	function confirmdelete(value) {
		swal({
            title: "<?php echo lang('language_lang.delete_language');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url('admin/langsettings/delete/');?>"+'/'+value;
            }
        });
    }
	</script>

</body>
</html>
