<!doctype html>
<html lang="en" class="w-[640px]">
   <head>
   <?php echo view('user/layout/head');?>
   <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.3/themes/base/jquery-ui.css">
   </head>
   <style>
     .pagination {
      display: flex;
      justify-content: center;
      margin-top: 20px;
      }
      .pagination-btn {
      background: #007bff;
      color: white;
      border: none;
      padding: 10px 20px;
      border-radius: 5px;
      cursor: pointer;
      margin: 0 5px;
      }
      .pagination-btn:disabled {
      background: #6c757d;
      cursor: not-allowed;
      }
      #pageInfo {
      align-self: center;
      margin: 0 10px;
      }
      .form-control
      {
        background:#e9e9ed !important;
        color:#000 !important;
      }
      .modal-backdrop { --bs-backdrop-zindex:none;}
    </style>
   <body class="section-overflow">
      <!--banner start -->
      <section class="banner-bg overall-bg ">
         <div class="container">
         <?php echo view('user/layout/header');?>
         </div>
         <section class="dash-wrap referral">
            <div class="container">
              
               <?php 
                     use App\Libraries\MyEncrypt;
                     use App\Helpers\site_helper;
                     use App\Helpers\form_helper;
                     $this->db = db_connect();
                     $this->session = session();
                     $this->common_model = model('CommonModel');
                     helper('form_helper');
                     
                     
                     $id = 'NyYmemh5aXA=';
                             
                     $myencrypt = new MyEncrypt;
                     $coinid = $myencrypt->decode($id);
                     $user=$this->session->get('uusersid');
                     $buy_bal=curbalance($this->session->get('uusersid'),$coinid);
                     $bal=str_replace(",","", $buy_bal);
                     
                     ?>

                        <div class="team-profit-content">
                           <div class="row">
                           
                              <div class="col-6">
                                 <div class="team-list">
                                    <p class="fw-light text-white-50 mb-0">Today Earnings</p>
                                    <h4 class="fw-bold text-white">  <?php echo number_format($earnings,4); ?> USDT</h4></h4>
                                 </div>
                              </div>
                              <div class="col-6">
                                 <div class="team-list">
                                    <p class="fw-light text-white-50 mb-0">Total Earnings</p>
                                    <h4 class="fw-bold text-white"><?php echo  number_format($expense,4); ?> USDT</h4></h4>
                                 </div>
                              </div>
                           </div>
                        </div>

                        
                     <div class="row" style="margin-top:15px;margin-bottom:15px">
                        <div class="col-12">
                           <div class="quantify-header d-flex align-items-center text-white justify-content-between">
                              <div class="trade-content ms-2">
                                 <h6 class="text-white fw-semibold aleo mb-0 align-items-center">
                                 <span id="total_count"> <?php echo $total_count;?> </span> Records
                              </div>
                              <div class="repeat-icon d-flex align-items-center">
                                 <a data-bs-toggle="modal" data-bs-target="#staticBackdrop1" data-bs-whatever="@fat" class="text-decoration-none">
                                 <i class="fa fa-filter" id="balance_load" ></i>
                                 </a>
                              </div>
                           </div>
                        </div>
                     </div>

                     <div class="modal fade" id="staticBackdrop1" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" style="display: none;" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                           <div class="modal-content" style="border-radius:30px;padding: 11px;" >
                              <div class="modal-header" style="padding-top: 11px;margin-bottom:-15px;">
                                 <p class="modal-title" id="staticBackdropLabel" style="padding-left:170px;"><b>Records Filter</b></p>
                                 <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                              </div>
                              <div class="modal-body">
                                 <div class="row col-lg-12 mt-3">
                                    <div class="form-check form-check-right mb-3" style="font-size: 14px;">
                                       <div class="form-group">
                                          <label class="btn btn-default">Start Date</label>
                                          <input type="text" name="start_date" id="start_date" class="form-control " required>
                                       </div>
                                       <div class="form-group">
                                          <label class="btn btn-default">End Date</label>
                                          <input type="text" name="end_date" id="end_date" class="form-control " required>
                                       </div>
                                       <div id="date_err" style="color:red;font-size:12px;font-weight:bold;"></div>
                                    </div>
                                 </div>
                              </div>
                              <div class="modal-footer" >
                                 <button  type="button" class="btn btn-secondary" name="button"  id="confirm">Search</button>
                                 <button  type="button" class="btn btn-secondary" name="button"  id="reset">Reset</button>
                              </div>
                           </div>
                        </div>
                     </div>

                     <div class="profit-content" id="myItems">
                        <?php 
                           $i=0;
                           if ($records) 
                           {
                            foreach ($records as $value) 
                            {
                           
                           
                                
                               $type=str_replace('_',' ',$value->type);
                               $type=ucwords($type);
                             $i++;
                             ?>
                        <div class="items-owner-box">
                           <div class="items-owner style-two">
                              <div class="items-owner-title">
                                 <h5 style="margin-top:10px;"><?php echo $type;?> </h5>
                                 <br>
                                 <span><?php echo $value->date;?></span>
                              </div>
                              <div class="item-price">
                                 <label class="btn btn-success">+ <?php echo number_format($value->amount,4);?></label>
                              </div>
                              <div class="description">
                                 <span style="color:#fff;"><?php echo $value->description;?> </span>
                              </div>
                           </div>
                        </div>
                        <?php } }?>
                     </div>
                     <div class="pagination">
                        <button id="prevPage" class="pagination-btn" onclick="changePage('prev')">« Previous</button>
                        <span id="pageInfo" class="text-white"></span>
                        <button id="nextPage" class="pagination-btn" onclick="changePage('next')">Next »</button>
                     </div>
            
            </div>
         </section>
         <!--footer start -->
         <?php echo view('user/layout/footer');?>
         <!--footer end -->
      </section>
  
      <?php echo view('user/layout/footer-script');?>
      <script>
         AOS.init({
         });
      </script>
    
            <script src="<?php echo base_url();?>/styles/new_style/js/notify.js"></script>
      <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
      <script src="https://code.jquery.com/ui/1.13.3/jquery-ui.js"></script>
      <script>
         $( function() {
                $( "#start_date").datepicker({
                    dateFormat: 'yy-mm-dd'
                });
                  $( "#end_date").datepicker({
                    dateFormat: 'yy-mm-dd'
                });
            } );
         
         let currentPage = 1;
         const itemsPerPage = 10; // Number of items per page
         let totalPages =1;
         let start_date='';
         let end_date='';
         
         document.addEventListener('DOMContentLoaded', function() {
         loadPage(currentPage,start_date,end_date);
         });
         
         
         
         function loadPage(page,start_date,end_date)
         {
           var uusersid='<?php echo $this->session->get('uusersid');?>';
           $.ajax({
           'method': 'POST',
           'url': '<?php echo base_url("/rewardhistory_records");?>',
           data:{'uusersid':uusersid,"page":page,"itemsPerPage":itemsPerPage,"start_date":start_date,"end_date":end_date},
           success:function(data)
           {
         // alert('ok');
            var data= JSON.parse(data);
            console.log(data.totalPages);
            const myItems = document.getElementById('myItems');
            myItems.innerHTML = '';
         
            if (data.items.length === 0) {
                myItems.innerHTML = `<div class="faq_accordian mb-3">
                        <div class="accordion" style="margin:10px;text-align:center;color:red;"> No Records Found</div></div>`;
            }
            else
            {
             var value="<?php if(!empty($value->date)) {  echo date('d-M-Y',strtotime($value->date)); } else { echo "";} ?>";
         
            data.items.forEach(item => {
                myItems.innerHTML += `
                   <div class="items-owner-box">
                     <div class="items-owner style-two">
                      
                       <div class="items-owner-title">
                         <h5 style="margin-top:10px;">${item.type}</h5>
                         <br>
                         <span>${item.date}</span>
                       </div>
                       <div class="item-price">
                         ${item.amount}
                       </div>
                       <div class="description">
                           <span style="color:#fff;">${item.description}</span>
                       </div>
                      
                     </div>
                     
                   </div>
                
                `; });
            }
         
         totalPages=data.totalPages;
         start_date=start_date;
         end_date=end_date;
         
         
         document.getElementById('total_count').innerHTML=data.totalitems;
         document.getElementById('prevPage').disabled = !data.hasPrev;
            document.getElementById('nextPage').disabled = !data.hasNext;
            document.getElementById('pageInfo').innerText = `Page ${page} of ${data.totalPages}`;
         }
         })
         
         
         
         }
         
         function changePage(direction) {
         
         if (direction === 'prev' && currentPage > 1) {
         currentPage--;
         } else if (direction === 'next' && currentPage < totalPages) {
         currentPage++;
         }
         
         loadPage(currentPage,start_date,end_date);
         }
         
         
         $('#confirm').click(function(){
         $("#date_err").html("");
         var start_date=$("#start_date").val();
         var end_date=$("#end_date").val();
         
         if(start_date!='' && end_date=='')
         {
         $("#date_err").html("Start and End date Must Required");
         }
         else if(start_date=='' && end_date!='')
         {
         $("#date_err").html("Start and End date Must Required");
         }
         else
         {
         
         $('#staticBackdrop1').modal('hide');
         let currentPage = 1;
         loadPage(currentPage,start_date,end_date);
         }
         
         });
         
         $('#reset').click(function(){
         let currentPage = 1;
         $("#start_date").val('');
         $("#end_date").val('');
         
         $('#staticBackdrop1').modal('hide');
         
         loadPage(currentPage);
         });
      </script>
       
   </body>
</html>
