<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Binance WebSocket Example</title>
    <meta http-equiv="refresh" content="30">
</head>
<body>
    <h1>Trading Pairs</h1>
    <ul id="tradingPairs"></ul>
<script>
        const requiredPairs = ['1INCH','ADA','AAVE','ATOM','ALGO','AION','AVAX','AKRO','ANT','APE','BAT','BTC','BCH','BNB','BTCST','BAKE','BOME','BONK','CRV','COMP','CAKE','COS','DOGE','DASH','DOT','ETH','EOS','ETC','FTM','FTT','FIL','GALA','GRT','GMT','HBAR','HOT','IOTA','ICP','IOST','JST','KAVA','KSM','LTC','LINK','LIT','LUNA','MANA','MATIC','MDX','NEO','NOT','OMG','ONT','PEPE','QTUM','REEF','RSR','SUN','SHIB','SLP','SOL','SUSHI','SXP','TRX','THETA','TFUEL','UNI','VET','WRX','XRP','XMR','XEM','XLM','XTZ','YFI','YFII','ZEC','ZEN'].map(pair => pair + 'USDT');
        const tradingPairsList = document.getElementById('tradingPairs');
        const socket = new WebSocket('wss://stream.binance.com:9443/ws');
        const pairsData = {};

        socket.onopen = () => {
            const params = {
                method: "SUBSCRIBE",
                params: ["!ticker@arr"],
                id: 1
            };
            socket.send(JSON.stringify(params));
        };

        socket.onmessage = (event) => {
            const data = JSON.parse(event.data);
            data.forEach(ticker => {
                if (requiredPairs.includes(ticker.s)) {
                    const symbol = ticker.s;
                    const lastPrice = parseFloat(ticker.c);
                    const openPrice = parseFloat(ticker.o);
                    const highPrice = parseFloat(ticker.h); // Assuming 'h' for high price
                    const closePrice = parseFloat(ticker.c);
                    const priceChangePercentage = ((lastPrice - openPrice) / openPrice * 100).toFixed(2);
                    pairsData[symbol] = {
                        symbol,
                        lastPrice,
                        openPrice,
                        highPrice,
                        closePrice,
                        priceChangePercentage
                    };
                }
            });

            // Display the pairs
            tradingPairsList.innerHTML = '';
            Object.values(pairsData).forEach(pair => {
                const listItem = document.createElement('li');
                listItem.textContent = `Trading pair: ${pair.symbol}, Last price: ${pair.lastPrice},Open price: ${pair.openPrice}, High price: ${pair.highPrice}, Close price: ${pair.closePrice}, Price change percentage: ${pair.priceChangePercentage}%`;
                tradingPairsList.appendChild(listItem);
            });

            // Send data to the server to save in trading_pairs.json
            fetch('/save-trading-pairs.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(Object.values(pairsData)),
            }).then(response => response.json()).then(data => {
                console.log('Success:', data);
            }).catch((error) => {
                console.error('Error:', error);
            });
        };

        socket.onerror = (error) => {
            console.error('WebSocket Error:', error);
        };

        socket.onclose = () => {
            console.log('WebSocket connection closed');
        };
    </script>
</body>
</html>