<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class ApiBinding extends BaseController {

    public function __construct() {
		$this->common_model = model('CommonModel');
		helper('site_helper');		
		$session = \Config\Services::session();

		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}
		
	}

	private function isCookie($values) {
		$this->common_model = model('CommonModel');
		helper('site_helper');		
		$session = \Config\Services::session();

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

    public function index()
    {
        $this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' =>  base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings')
		
		);
		$this->data['module_name'] = 'settings';
        $this->data['exchange_list'] = $this->db->query('select * from api_exchange_list')->getResult();
    
        echo view('admin/apibinding_list',$this->data);

    }


    public function changeStatus($id) {
		$session = session();
        $this->db = db_connect();
			$myencrypt = new MyEncrypt;
			$id = $myencrypt->decode($id);
		
			$cur_up_data = array(
				"status" => '0'
			);
			$update_status = $this->db->table('api_exchange_list')->where('id',$id)->update($cur_up_data);

			if($update_status){
				$session->setFlashData('success_message', 'Coin status updated successfully');
                return redirect()->to('admin/apibinding');
			} else {
				$session->setFlashData('error_message', 'Coin status updated failed');
				return redirect()->to('admin/apibinding');
			}

		
	}
	public function changeActiveStatus($id) {
        $session = session();
        $this->db = db_connect();
			$myencrypt = new MyEncrypt;
			$id = $myencrypt->decode($id);
			
			$cur_up_data = array(
				"status" => '1'
			);
			
			$update_status = $this->db->table('api_exchange_list')->where('id',$id)->update($cur_up_data);

			if($update_status){
				$session->setFlashData('success_message', 'Coin status updated successfully');
				return redirect()->to('admin/apibinding');
			} else {
				$session->setFlashData('error_message', 'Coin status updated failed');
			    return redirect()->to('admin/apibinding');
			}

		
	}

	public function ipchange()
	{

		$session = session();
        $this->db = db_connect();
		if($this->request->getPost('ip_address') != '')
		{
            $data = array(
				'ip_address' => $this->request->getPost('ip_address')
			);

			$update_status = $this->db->table('api_exchange_list')->where('id',$this->request->getPost('id'))->update($data);

			if($update_status)
			{
				$session->setFlashData('success_message','Ip address updated successfully');
				return redirect()->to('admin/apibinding');
			}
			else
			{
				$session->setFlashData('error_message','Ip address updated failed');
				return redirect()->to('admin/apibinding');
			}
		}
	}

}