<?php 
namespace App\Libraries;
use App\ThirdParty\fpdf18\fpdf;
 include_once APPPATH.'ThirdParty/fpdf18/fpdf.php';


class PDF extends FPDF
{
// Load data

protected $B = 0;
protected $I = 0;
protected $U = 0;
protected $HREF = '';




function LoadData($file)
{
    // Read file lines
    $lines = $file;
    $data = array();
    foreach($lines as $line)
    {
        $data[] =$line;
    }
    return $data;
}

public function Header()
{
        $this->db = \Config\Database::connect();

    $data=$this->db->query("select * from site_controls where site_key='site_logo'");
    $logo=$data->getResult();


   
    // Logo
    $this->Image(base_url('/content/site/'.$logo[0]->site_value));
    // Arial bold 15
    $this->SetFont('Arial','B',15);
    // Move to the right
    $this->Cell(80);
    // Title
    //$this->Cell(30,10,'Title',1,0,'C');
    // Line break
    $this->Ln(20);
}






function Footer()
{
    // Position at 1.5 cm from bottom
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','I',8);
    // Page number
    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
}

function FancyTable($header, $data,$ftype='')
{
    // Colors, line width and bold font
    $this->SetFillColor(255,0,0);
    $this->SetTextColor(255);
    $this->SetDrawColor(128,0,0);
    $this->SetLineWidth(.3);
    $this->SetFont('','B');
    // Header

    if($ftype)
    {
        $w = array(32, 32, 32, 32,35,30);
    }
    else
    {
        $w = array(45, 35, 35, 25,35);   
    }

    for($i=0;$i<count($header);$i++)
        $this->Cell($w[$i],7,$header[$i],1,0,'C',true);
    $this->Ln();
    // Color and font restoration
    $this->SetFillColor(224,235,255);
    $this->SetTextColor(0);
    $this->SetFont('');
    // Data
    $fill = false;
    foreach($data as $row)
    {
        $this->Cell($w[0],6,$row[0],'LR',0,'L',$fill);
        $this->Cell($w[1],6,$row[1],'LR',0,'L',$fill);
        $this->Cell($w[2],6,$row[2],'LR',0,'L',$fill);
        $this->Cell($w[3],6,$row[3],'LR',0,'C',$fill);
        $this->Cell($w[4],6,$row[4],'LR',0,'R',$fill);

        if($ftype)
        {
           $this->Cell($w[5],6,$row[5],'LR',0,'R',$fill);
        }    
        $this->Ln();
        $fill = !$fill;
    }
    // Closing line
    $this->Cell(array_sum($w),0,'','T');
}

}