<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php $this->load->view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/bootstrap_select.min.js"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/datatables.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/extensions/responsive.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/select2.min.js"></script>

	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/datatables_responsive.js"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/jgrowl.min.js"></script>

    <!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/bootbox.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/sweet_alert.min.js"></script>
    
    <style type="text/css">
	    .icons-list a[data-action="reload1"]:after {
		  content: '\e9fb';
		}
		.btns {
			padding: 5px;
		}
	</style>
</head>

<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php $this->load->view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php $this->load->view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<?php $this->load->view('admin/'.$module_name.'_header'); ?>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">
				
				
					<!-- Basic responsive configuration -->
					<div class="panel panel-flat">
					
						<div class="panel-heading">
							<h5 class="panel-title"><?php echo $page_title; ?></h5>
						
							<div class="heading-elements">
								<ul class="icons-list">
			                		<li><a data-action="collapse"></a></li>
			                		<li><a data-action="reload"></a></li>
			                		<li><a data-action="close"></a></li>
			                	</ul>
		                	</div>

						</div>
						<?php $currency_info = defaultcurrency();?>
						<table class="table datatable-responsive table-hover">
							<col width="14%">
	  						<col width="12%">
	  						<col width="15%">
	  						<col width="18%">
	  						<col width="13%">
	  						<col width="15%">
	  						<!-- <col width="10%"> -->
							<thead>
								<tr>
									<th class=""><?php echo $this->lang->line('lbl_date');?></th>
									<th class=""><?php echo $this->lang->line('lbl_transaction_id');?></th>
									<th class=""><?php echo $this->lang->line('lbl_user_name');?></th>
									<th class=""><?php echo $this->lang->line('lbl_description');?></th>
									<th class=""><?php echo $this->lang->line('lbl_amount'). ' (<b>'.strtoupper($currency_info->currency_unit).'</b>)';?></th>
									<th class=""><?php echo $this->lang->line('lbl_payment_gateway');?></th>
									<!-- <th class=""><?php echo $this->lang->line('lbl_options');?></th> -->
								</tr>
							</thead>
							<tbody>
							<?php 
								if($history) {
									
									$row_count = count($history);
									$this->load->library('MyEncrypt');
									$myencrypt = new MyEncrypt;
									foreach ($history as $row) {
										$condition = "payment_key in('status') AND payment_id = '".$row->payment_id."'";
										$payment = $this->finance_model->PaymentName($condition);
										
								?>
								<tr>
									<td class=""><?php echo date('Y-m-d H:i:s', strtotime($row->date));?></td>
									<td class=""><?php echo $row->transactionid;?></td>
									<td class=""><?php echo $row->username;?></td>
									<td class=""><?php echo ucfirst($row->description);?></td>
									<td class=""><?php echo $currency_info->currency_symbol."".number_format($row->amount, $currency_info->deimal_point, '.', '').' '.strtoupper($currency_info->currency_unit);?></td>
									<td class=""><?php echo (isset($payment->payment_name)) ? ucfirst($payment->payment_name) : '----';?></td>
									<!-- <td class="text-center">
	                                	<a class="btns" data-popup="tooltip" title="<?php echo $this->lang->line('lbl_approve_withdraw');?>"  href="javascript:void(0)" onClick="payouts('<?php echo $myencrypt->encode($row->historyid);?>')" ><i class="fa fa-thumbs-up"></i></a>
	                                	<a class="btns" data-popup="tooltip" title="<?php echo $this->lang->line('lbl_cancel_withdraw');?>"  href="javascript:void(0)" onClick="cancelpayouts('<?php echo $myencrypt->encode($row->historyid);?>')" ><i class="fa fa-thumbs-down"></i></a>
	                                </td> -->
								</tr>
							<?php 

									}
								}  else { 

							?>
								<?php } ?>
							</tbody>
						</table>
					</div>
				
				
			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {

	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;


	    	<?php if($this->session->flashdata('error_message')) { ?>
				$.jGrowl("<?php echo $this->session->flashdata('error_message');?>", {
		            header: '<?php echo $this->lang->line("error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($this->session->flashdata('success_message')) { ?>
                $.jGrowl("<?php echo $this->session->flashdata('success_message');?>", {
		            header: '<?php echo $this->lang->line("success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

            $('#icon-bck').on('click',function() {
				window.history.back();
			});
			    
		});

	})(jQuery);

	
	
	</script>

</body>
</html>
