<?php
   use App\Libraries\MyEncrypt;
   use App\Models\CommonModel;
   $session = session();
   $validation =  \Config\Services::validation();
   $this->db = db_connect();
   
   $CommonModel = model('CommonModel');
   $header_data = $CommonModel->GetSiteSettings('site');
   if(!$header_data){
   	$header_data = $CommonModel->defaultlangSettingall('site');
   }
   foreach ($header_data as $row) 
   {
   	$headers[$row->site_key] = $row->site_value;
   }
   ?>
<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title><?php echo $headers['site_meta_title'];?></title>
      <!--Basic Bootstrap-->
      <link href="<?php echo base_url();?>/styles/web_style/css/bootstrap.min.css" rel="stylesheet" type="text/css">
      <!--Font icons-->
      <link href="<?php echo base_url();?>/styles/web_style/css/all.css"  rel="stylesheet" type="text/css">
      <!--Carousel Slider-->
      <link href="<?php echo base_url();?>/styles/web_style/css/owl.carousel.min.css" rel="stylesheet" type="text/css">
      <link href="<?php echo base_url();?>/styles/web_style/css/owl.theme.default.min.css" rel="stylesheet" type="text/css">
      <!--fonts-->
      <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">
      <!--Theme CSS -->
      <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>/styles/web_style/css/style.css">
      <style>
         .user-box {
         position: relative;
         margin-bottom: 30px;
         }
         .user-box input {
         display: block;
         width: 100%;
         padding: 15px 10px;
         font-size: 12px;
         font-weight: 400;
         line-height: 1.5;
         color: #fff;
         background-color: #2e2d2c;
         background-clip: padding-box;
         border: 0;
         -webkit-appearance: none;
         -moz-appearance: none;
         appearance: none;
         border-radius: 10px;
         transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
         }
         .user-box input:focus ~ label,
         .user-box input:valid ~ label {
         transform: translateY(-20px);
         font-size: 14px;
         color: #333;
         }
         .password-toggle-icon {
         position: absolute;
         top: 68%;
         right: 10px;
         color:#fff;
         transform: translateY(-50%);
         cursor: pointer;
         }
         .password-toggle-icon i {
         font-size: 18px;
         line-height: 1;
         color: #fff;
         transition: color 0.3s ease-in-out;
         margin-bottom: 20px;
         }
         .password-toggle-icon i:hover {
         color: gold;
         }
         .help-block 
         {
         color:red;
         font-size:12px;
         font-weight:bold;
         }
         p.frgtpwd1 {
         background:#8DC540 !important
         }
         p.frgtpwd1 i {
         background:#8DC540 !important;
         color:#fff !important
         }
         p.frgtpwd {
         font-size: 13px;
         color: #fff;
         text-align: left;
         line-height: 24px;
         margin: 0 0 1em 0;
         background: #22313F;
         border-radius: 2px;
         padding:10px 39px 10px 10px;
         font-weight: 600;
         position: relative;
         }
         p.frgtpwd i {
         position: absolute;
         top: 0;
         right: 0;
         padding:15px 8px 8px 8px;
         font-size: 14px;
         background: #F5AB35;
         color: #22313F;
         height: 100%;
         }
         p.frgtpwdred {
         background:#EB5055 !important
         }
         p.frgtpwdred i {
         background:#EB5055 !important
         }
         .alert-success {
         color: #0f5132;
         background-color: #d1e7dd;
         border-color: #badbcc;
         font-size: 12px;
         }
      </style>
   </head>
   <body class="reg-overflow">
      <!---header---->
      <section class=" pb-1 banner-bg login-page">
         <div class="container">
            <div class="innerpages-bg relative h-full m-auto md:w-full ">
               <div class="row bg-black">
               <div class="col-3">
                     <div class="header-arrow">
                        <a href="<?php echo base_url();?>/login"><img src="<?php echo base_url();?>/styles/web_style/images/header-arrow.png" alt=""></a> 
                     </div>
                  </div>
                  <div class="col-9">
                     <div class="reg-logo">
                        <img src="<?php echo base_url();?>/styles/web_style/images/login-logo.png" alt="" style="width:80%;">
                     </div>
                  </div>
               </div>
               <div class="login-scroller">
                  <div class="reg-page">
                     <div class="row">
                        <div class="col-lg-12">
                           <div class="title py-2 text-center">
                              <h2 class="fw-bold text-primary mb-3 ">Forgot Password</h2>
                              <p class="text-white">Please provide your information below and submit for verification. Upon completion, a TAC (Transaction Authorization Code) will be sent for verification.</p>
                           </div>
                        </div>
                     </div>
                     <form class="steps-validation create-user" id="reset" method="post" action="<?php echo base_url();?>/reset">
                        <div class="form-page">
                           <div class="row">
                              <?php 
                                 $session = \Config\Services::session();
                                 
                                 if($session->getFlashData('success_message')) {?>
                              <p class="frgtpwd frgtpwd1"><i class="fa fa-thumbs-up"></i><?php echo $session->getFlashData('success_message');?></p>
                              <?php } elseif ($session->getFlashData('error_message')) { ?>
                              <p class="frgtpwd frgtpwd1 frgtpwdred"><i class="fa fa-thumbs-down"></i><?php echo $session->getFlashData('error_message');?></p>
                              <?php } else { }?>
                              <div class="col-sm-12">
                                 <div class="mb-3 form-block form-group ">
                                    <input type="text" class="form-control" placeholder="Enter Email ID" name="username" id="username">
                                 </div>
                                 <div class="form-btn-bg position-relative" >
                                    <div class="form-button ">
                                       <button class="btn btn-primary" type="submit">
                                          <iconify-icon icon="ep:d-arrow-right"></iconify-icon>
                                       </button>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                  </div>
                  </form>
                  <!--Modal: modalPush-->
                  <div class="copy-rights text-center ">
                     <span class="text-white"> 2024 <a href="" class="text-decoration-none"> @revotech </a> All Rights Reserved</span>
                  </div>
               </div>
            </div>
         </div>
         </div>
      </section>
      <script src="<?php echo base_url();?>/styles/web_style/js/jquery.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/bootstrap.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/script.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/iconify-icon.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/owl.carousel.min.js"></script>
      <script src="http://code.jquery.com/jquery-1.11.3.min.js"></script>
      <script type="text/javascript" src="<?php echo base_url();?>/assets/js/formValidation1.js"></script>
      <script type="text/javascript" src="<?php echo base_url();?>/assets/js/bootstrap.js"></script>
      <script type="text/javascript">
         jQuery.noConflict();
         (function( $ ) {
         
           $('.create-user').formValidation({
             framework: 'bootstrap',
             excluded: [':disabled'],
         
             fields: {
               username: {
               validators: {
               notEmpty: {
               message: 'Email ID is required'
               },
            regexp: {
                           regexp: /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/,
                           message: '<?php echo "Email Address is Invalid"; ?>'
                     },
         
               }
               }
           }
         })
         
         })(jQuery);
      </script>
   </body>
</html>
