<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Loghistory extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 03 October, 2016
	 * This controller to manage log history.
	 * Created karthiga.
	 * @see http://zhyip.com/
	 * Last Updated: 03 October, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();

		// admin login only
		if($this->session->userdata('admin_login')) {
		
			// form validation library
			$this->load->library('form_validation');
			$this->isSubadmin();

			

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set_userdata('last_page', current_url());
				redirect('admin/login');
			}
		}

	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}

	private function isSubadmin() {

		if($this->session->userdata('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($this->session->userdata('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				redirect('admin');
			}
		}
	}

	public function index()
	{
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_extra')
		);
		$this->data['module_name'] = 'settings';
		
		$condition = "uusers_id = '1'";
		$this->data['log_data'] = $this->common_model->GetResults('uusers_online',$condition);
        $this->data['user_stat'] = '1';


		$this->load->view('admin/loghistory',$this->data);

	}

	public function loglist($id){

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_extra')
		);
		$this->data['module_name'] = 'settings';

		if($id == 'admin'){
			$user_condition = "user_type = 'admin'";
			$this->data['log_data'] = $this->common_model->GetResults('uusers_online',$user_condition);
           }elseif ($id == 'subadmin') {
           	$user_condition = "user_type = 'subadmin'";
			$this->data['log_data'] = $this->common_model->GetResults('uusers_online',$user_condition);
           }
           else{
           	$user_condition = "user_type = 'users'";
			$this->data['log_data'] = $this->common_model->GetResults('uusers_online',$user_condition);
           }

           $this->data['user_stat'] = $id;

		$this->load->view('admin/loghistory',$this->data);



	}

}

